/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import org.jboss.mx.util.RunnableScheduler;

public abstract class SchedulableRunnable
implements Comparable,
Runnable {
    private long id = SchedulableRunnable.getNextId();
    private long nextRun;
    private RunnableScheduler scheduler;
    private boolean running;
    private boolean reschedule;
    private static long nextId = 0L;

    public long getNextRun() {
        return this.nextRun;
    }

    public synchronized void setNextRun(long nextRun) {
        if (this.scheduler != null) {
            this.scheduler.remove(this);
        }
        this.nextRun = nextRun;
        if (!this.running && this.scheduler != null) {
            this.scheduler.add(this);
        } else {
            this.reschedule = true;
        }
    }

    public synchronized RunnableScheduler setScheduler(RunnableScheduler scheduler) {
        if (this.scheduler == scheduler) {
            return this.scheduler;
        }
        RunnableScheduler result = this.scheduler;
        if (this.scheduler != null) {
            this.scheduler.remove(this);
        }
        this.scheduler = scheduler;
        if (scheduler == null) {
            this.reschedule = false;
        } else if (!this.running) {
            scheduler.add(this);
        } else {
            this.reschedule = true;
        }
        return result;
    }

    public abstract void doRun();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        this.startRun();
        try {
            this.doRun();
            Object var2_1 = null;
            this.endRun();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.endRun();
            throw throwable;
        }
    }

    public int compareTo(Object o) {
        SchedulableRunnable other = (SchedulableRunnable)o;
        long temp = this.nextRun - other.nextRun;
        if (temp < 0L) {
            return -1;
        }
        if (temp > 0L) {
            return 1;
        }
        temp = this.id - other.id;
        if (temp < 0L) {
            return -1;
        }
        if (temp > 0L) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    private synchronized void startRun() {
        this.running = true;
    }

    private synchronized void endRun() {
        this.running = false;
        if (this.reschedule) {
            this.scheduler.add(this);
        }
        this.reschedule = false;
    }

    private static synchronized long getNextId() {
        return nextId++;
    }
}

