/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import java.util.Stack;

public class ThreadPool {
    private Stack pool = new Stack();
    private int maxSize = 10;
    private boolean active = false;
    private boolean daemon = true;

    public void setMaximumSize(int size) {
        this.maxSize = size;
    }

    public int getMaximumSize() {
        return this.maxSize;
    }

    public void setActive(boolean status) {
        this.active = status;
        if (!this.active) {
            while (this.pool.size() > 0) {
                ((Worker)this.pool.pop()).die();
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setDaemonThreads(boolean value) {
        this.daemon = value;
    }

    public boolean getDaemonThreads() {
        return this.daemon;
    }

    public synchronized void run(Runnable work) {
        if (this.pool.size() == 0) {
            new Worker(work);
        } else {
            Worker worker = (Worker)this.pool.pop();
            worker.run(work);
        }
    }

    private synchronized void returnWorker(Worker worker) {
        if (this.pool.size() < this.maxSize) {
            this.pool.push(worker);
        } else {
            worker.die();
        }
    }

    class Worker
    extends Thread {
        boolean running = true;
        Runnable work;

        Worker(Runnable work) {
            this.work = work;
            this.setDaemon(ThreadPool.this.daemon);
            this.start();
        }

        public synchronized void die() {
            this.running = false;
            this.notify();
        }

        public synchronized void run(Runnable work) {
            if (this.work != null) {
                throw new IllegalStateException("Worker already has work to do.");
            }
            this.work = work;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (ThreadPool.this.active && this.running) {
                if (this.work != null) {
                    try {
                        this.work.run();
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    this.work = null;
                }
                ThreadPool.this.returnWorker(this);
                Worker worker = this;
                synchronized (worker) {
                    while (this.running && this.work == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ignored) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

