/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import org.jboss.invocation.InvocationStatistics;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.EJBMBean;
import org.jboss.management.j2ee.EntityBean;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.MessageDrivenBean;
import org.jboss.management.j2ee.StatefulSessionBean;
import org.jboss.management.j2ee.StatelessSessionBean;
import org.jboss.management.j2ee.statistics.CountStatisticImpl;
import org.jboss.management.j2ee.statistics.EJBStatsImpl;
import org.jboss.management.j2ee.statistics.TimeStatisticImpl;

public abstract class EJB
extends J2EEManagedObject
implements EJBMBean {
    public static final int ENTITY_BEAN = 0;
    public static final int STATEFUL_SESSION_BEAN = 1;
    public static final int STATELESS_SESSION_BEAN = 2;
    public static final int MESSAGE_DRIVEN_BEAN = 3;
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$management$j2ee$EJB == null ? (class$org$jboss$management$j2ee$EJB = EJB.class$("org.jboss.management.j2ee.EJB")) : class$org$jboss$management$j2ee$EJB));
    protected ObjectName ejbContainerName;
    static /* synthetic */ Class class$org$jboss$management$j2ee$EJB;

    public static ObjectName create(MBeanServer mbeanServer, ObjectName ejbModuleName, ObjectName ejbContainerName, int ejbType, String jndiName) {
        try {
            J2EEManagedObject ejb = null;
            switch (ejbType) {
                case 0: {
                    ejb = new EntityBean(jndiName, ejbModuleName, ejbContainerName);
                    break;
                }
                case 1: {
                    ejb = new StatefulSessionBean(jndiName, ejbModuleName, ejbContainerName);
                    break;
                }
                case 2: {
                    ejb = new StatelessSessionBean(jndiName, ejbModuleName, ejbContainerName);
                    break;
                }
                case 3: {
                    ejb = new MessageDrivenBean(jndiName, ejbModuleName, ejbContainerName);
                }
            }
            ObjectName jsr77Name = ejb.getObjectName();
            mbeanServer.registerMBean(ejb, jsr77Name);
            log.debug((Object)("Created JSR-77 EJB: " + jsr77Name));
            return jsr77Name;
        }
        catch (Exception e) {
            log.debug((Object)("Could not create JSR-77 EJB: " + jndiName), (Throwable)e);
            return null;
        }
    }

    public static void destroy(MBeanServer mbeanServer, ObjectName jsr77Name) {
        try {
            mbeanServer.unregisterMBean(jsr77Name);
            log.debug((Object)("Destroyed JSR-77 EJB: " + jsr77Name));
        }
        catch (InstanceNotFoundException ignore) {
        }
        catch (Exception e) {
            log.debug((Object)("Could not destroy JSR-77 EJB: " + jsr77Name), (Throwable)e);
        }
    }

    public EJB(String ejbType, String ejbName, ObjectName ejbModuleName, ObjectName ejbContainerName) throws MalformedObjectNameException, InvalidParentException {
        super(ejbType, ejbName, ejbModuleName);
        this.ejbContainerName = ejbContainerName;
    }

    public abstract Stats getStats();

    public abstract void resetStats();

    public String toString() {
        return "EJB { " + super.toString() + " } []";
    }

    protected void updateCommonStats(EJBStatsImpl stats) {
        try {
            ObjectName containerName = this.getContainerName();
            CountStatisticImpl createCount = (CountStatisticImpl)stats.getCreateCount();
            Long creates = (Long)this.server.getAttribute(containerName, "CreateCount");
            createCount.set(creates);
            CountStatisticImpl removeCount = (CountStatisticImpl)stats.getRemoveCount();
            Long removes = (Long)this.server.getAttribute(containerName, "RemoveCount");
            removeCount.set(removes);
            InvocationStatistics times = (InvocationStatistics)this.server.getAttribute(containerName, "InvokeStats");
            HashMap timesMap = new HashMap(times.getStats());
            Iterator iter = timesMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Method m = (Method)entry.getKey();
                InvocationStatistics.TimeStatistic stat = (InvocationStatistics.TimeStatistic)entry.getValue();
                TimeStatisticImpl tstat = new TimeStatisticImpl(m.getName(), "MILLISECOND", "The timing information for the given method");
                tstat.set(stat.count, stat.minTime, stat.maxTime, stat.totalTime);
                stats.addStatistic(m.getName(), tstat);
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to retrieve stats", (Throwable)e);
        }
    }

    protected ObjectName getContainerName() {
        return this.ejbContainerName;
    }

    protected ObjectName getContainerCacheName() {
        ObjectName cacheName = null;
        try {
            Hashtable<String, String> props = this.ejbContainerName.getKeyPropertyList();
            props.put("plugin", "cache");
            cacheName = new ObjectName(this.ejbContainerName.getDomain(), props);
        }
        catch (MalformedObjectNameException e) {}
        return cacheName;
    }

    protected ObjectName getContainerPoolName() {
        ObjectName poolName = null;
        try {
            Hashtable<String, String> props = this.ejbContainerName.getKeyPropertyList();
            props.put("plugin", "pool");
            poolName = new ObjectName(this.ejbContainerName.getDomain(), props);
        }
        catch (MalformedObjectNameException e) {}
        return poolName;
    }

    protected Hashtable getParentKeys(ObjectName pParent) {
        Hashtable<String, String> lReturn = new Hashtable<String, String>();
        Hashtable<String, String> lProperties = pParent.getKeyPropertyList();
        lReturn.put("EJBModule", lProperties.get("name"));
        lReturn.put("J2EEApplication", lProperties.get("J2EEApplication"));
        lReturn.put("J2EEServer", lProperties.get("J2EEServer"));
        return lReturn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

