/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.security.InvalidParameterException;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.jboss.management.j2ee.J2EEManagedObject;

public class StateManagement
implements NotificationListener {
    public static final int CREATED = 5;
    public static final int DESTROYED = 6;
    public static final String STARTING_EVENT = "j2ee.state.starting";
    public static final String RUNNING_EVENT = "j2ee.state.running";
    public static final String STOPPING_EVENT = "j2ee.state.stoping";
    public static final String STOPPED_EVENT = "j2ee.state.stopped";
    public static final String FAILED_EVENT = "j2ee.state.failed";
    public static final String CREATED_EVENT = "j2ee.object.created";
    public static final String DESTROYED_EVENT = "j2ee.object.deleted";
    public static final String[] stateTypes = new String[]{"j2ee.state.starting", "j2ee.state.running", "j2ee.state.stoping", "j2ee.state.stopped", "j2ee.state.failed", "j2ee.object.created", "j2ee.object.deleted"};
    private long startTime = -1L;
    private int state = 3;
    private J2EEManagedObject managedObject;

    public static int convertJBossState(int theState) {
        int jsr77State = -1;
        switch (theState) {
            case 2: {
                jsr77State = 0;
                break;
            }
            case 3: {
                jsr77State = 1;
                break;
            }
            case 1: {
                jsr77State = 2;
                break;
            }
            case 0: {
                jsr77State = 3;
                break;
            }
            case 4: {
                jsr77State = 4;
                break;
            }
            case 6: {
                jsr77State = 5;
                break;
            }
            case 5: {
                jsr77State = 6;
                break;
            }
            default: {
                jsr77State = -1;
            }
        }
        return jsr77State;
    }

    public static int convertJSR77State(int theState) {
        int jbossState = -1;
        switch (theState) {
            case 0: {
                jbossState = 2;
                break;
            }
            case 1: {
                jbossState = 3;
                break;
            }
            case 2: {
                jbossState = 1;
                break;
            }
            case 3: {
                jbossState = 0;
                break;
            }
            case 4: {
                jbossState = 4;
                break;
            }
            case 5: {
                jbossState = 6;
                break;
            }
            case 6: {
                jbossState = 5;
            }
        }
        return jbossState;
    }

    public StateManagement(J2EEManagedObject managedObject) {
        if (managedObject == null) {
            throw new InvalidParameterException("managedObject must not be null");
        }
        this.managedObject = managedObject;
        this.startTime = System.currentTimeMillis();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long pTime) {
        this.startTime = pTime;
    }

    public int getState() {
        return this.state;
    }

    public String getStateString() {
        String stateName = stateTypes[this.state];
        return stateName;
    }

    public void setState(int newState) {
        if (this.state > 0 && this.state < stateTypes.length && newState != this.state) {
            this.state = newState;
            String type = stateTypes[this.state];
            this.managedObject.sendNotification(type, "State changed");
        }
    }

    public void handleNotification(Notification msg, Object handback) {
        AttributeChangeNotification change;
        String attrName;
        if (msg instanceof AttributeChangeNotification && "State".equals(attrName = (change = (AttributeChangeNotification)msg).getAttributeName())) {
            int newState = (Integer)change.getNewValue();
            long eventTime = -1L;
            if (newState == 3) {
                eventTime = change.getTimeStamp();
            }
            if (newState == 3) {
                this.setStartTime(eventTime);
            }
            int jsr77State = StateManagement.convertJBossState(newState);
            this.setState(jsr77State);
        }
    }

    public String toString() {
        return "StateManagement [ State: " + this.state + ", Start Time: " + this.startTime + " ]";
    }
}

