/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee.statistics;

import javax.management.ObjectName;
import javax.management.j2ee.statistics.JCAConnectionStats;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.TimeStatistic;
import org.jboss.management.j2ee.statistics.StatsBase;
import org.jboss.management.j2ee.statistics.TimeStatisticImpl;

public class JCAConnectionStatsImpl
extends StatsBase
implements JCAConnectionStats {
    private ObjectName cfName;
    private ObjectName mcfName;

    public JCAConnectionStatsImpl(ObjectName cfName, ObjectName mcfName) {
        this(cfName, mcfName, null, null);
    }

    public JCAConnectionStatsImpl(ObjectName cfName, ObjectName mcfName, TimeStatistic waitTime, TimeStatistic useTime) {
        if (waitTime == null) {
            waitTime = new TimeStatisticImpl("WaitTime", "MILLISECOND", "Time spent waiting for a connection to be available");
        }
        if (useTime == null) {
            useTime = new TimeStatisticImpl("UseTime", "MILLISECOND", "Time spent using the connection");
        }
        super.addStatistic("WaitTime", (Statistic)waitTime);
        super.addStatistic("UseTime", (Statistic)useTime);
        this.cfName = cfName;
        this.mcfName = mcfName;
    }

    public ObjectName getConnectionFactory() {
        return this.cfName;
    }

    public ObjectName getManagedConnectionFactory() {
        return this.mcfName;
    }

    public TimeStatistic getWaitTime() {
        TimeStatistic ts = (TimeStatistic)this.getStatistic("WaitTime");
        return ts;
    }

    public TimeStatistic getUseTime() {
        TimeStatistic ts = (TimeStatistic)this.getStatistic("UseTime");
        return ts;
    }
}

