/*
 * Decompiled with CFR 0.152.
 */
package org.jboss;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;

public final class Version {
    public static final String VERSION_MAJOR = "version.major";
    public static final String VERSION_MINOR = "version.minor";
    public static final String VERSION_REVISION = "version.revision";
    public static final String VERSION_TAG = "version.tag";
    public static final String VERSION_NAME = "version.name";
    public static final String BUILD_NUMBER = "build.number";
    public static final String BUILD_ID = "build.id";
    public static final String BUILD_DATE = "build.day";
    private static Version instance = null;
    private Properties props = this.loadProperties();
    static /* synthetic */ Class class$org$jboss$Version;

    private Version() {
    }

    public static Version getInstance() {
        if (instance == null) {
            instance = new Version();
        }
        return instance;
    }

    public Map getProperties() {
        return Collections.unmodifiableMap(this.props);
    }

    public String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public int getMajor() {
        return this.getIntProperty(VERSION_MAJOR);
    }

    public int getMinor() {
        return this.getIntProperty(VERSION_MINOR);
    }

    public int getRevision() {
        return this.getIntProperty(VERSION_REVISION);
    }

    public String getTag() {
        return this.props.getProperty(VERSION_TAG);
    }

    public String getName() {
        return this.props.getProperty(VERSION_NAME);
    }

    public String getBuildID() {
        return this.props.getProperty(BUILD_ID);
    }

    public String getBuildNumber() {
        return this.props.getProperty(BUILD_NUMBER);
    }

    public String getBuildDate() {
        return this.props.getProperty(BUILD_DATE);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getMajor()).append(".");
        buff.append(this.getMinor()).append(".");
        buff.append(this.getRevision()).append(this.getTag());
        buff.append("(").append(this.getBuildID()).append(")");
        return buff.toString();
    }

    private int getIntProperty(String name) {
        try {
            return Integer.valueOf(this.props.getProperty(name));
        }
        catch (Exception e) {
            return -1;
        }
    }

    private long getLongProperty(String name) {
        try {
            return Long.valueOf(this.props.getProperty(name));
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private Properties loadProperties() {
        this.props = new Properties();
        try {
            InputStream in = (class$org$jboss$Version == null ? (class$org$jboss$Version = Version.class$("org.jboss.Version")) : class$org$jboss$Version).getResourceAsStream("/org/jboss/version.properties");
            this.props.load(in);
            in.close();
        }
        catch (IOException e) {
            throw new Error("Missing version.properties");
        }
        return this.props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

