/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.net.URL;
import java.util.Comparator;
import org.jboss.util.NullArgumentException;

public class DeploymentSorter
implements Comparator {
    public static final String[] DEFAULT_SUFFIX_ORDER = new String[]{"sar", "service.xml", "rar", "jar", "war", "wsr", "ear", "zip"};
    protected String[] suffixOrder;

    public DeploymentSorter(String[] suffixOrder) {
        if (suffixOrder == null) {
            throw new NullArgumentException("suffixOrder");
        }
        this.suffixOrder = suffixOrder;
    }

    public DeploymentSorter() {
        this(DEFAULT_SUFFIX_ORDER);
    }

    public int compare(Object o1, Object o2) {
        return this.getExtensionIndex((URL)o1) - this.getExtensionIndex((URL)o2);
    }

    public int getExtensionIndex(URL url) {
        String path = url.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        int i = 0;
        while (i < this.suffixOrder.length) {
            if (path.endsWith(this.suffixOrder[i])) break;
            ++i;
        }
        return i;
    }
}

