/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.deployment.Deployer;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.DeploymentInfoComparator;
import org.jboss.deployment.DeploymentSorter;
import org.jboss.deployment.MainDeployerMBean;
import org.jboss.deployment.SubDeployer;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.Counter;
import org.jboss.util.file.JarUtils;
import org.jboss.util.stream.Streams;

public class MainDeployer
extends ServiceMBeanSupport
implements Deployer,
MainDeployerMBean {
    private final LinkedList deployers = new LinkedList();
    private final Map deploymentMap = new HashMap();
    private final ArrayList deploymentList = new ArrayList();
    private final List waitingDeployments = new ArrayList();
    private final Counter id = Counter.makeSynchronized((Counter)new Counter(0));
    private final Comparator sorter = new DeploymentSorter();
    private final Comparator infoSorter = new DeploymentInfoComparator(this.sorter);
    private boolean copyFiles = true;
    private File tempDir;
    private String tempDirString;
    private String homeDirString;
    private String nativePrefix;
    private String nativeSuffix;

    public MainDeployer() {
        String localCopy = System.getProperty("jboss.deploy.localcopy");
        if (localCopy != null && (localCopy.equalsIgnoreCase("false") || localCopy.equalsIgnoreCase("no") || localCopy.equalsIgnoreCase("off"))) {
            this.log.debug((Object)"Disabling local copies of file: urls");
            this.copyFiles = false;
        }
    }

    public Collection listDeployed() {
        ArrayList arrayList = this.deploymentList;
        synchronized (arrayList) {
            ArrayList arrayList2 = new ArrayList(this.deploymentList);
            return arrayList2;
        }
    }

    public Collection listWaitingForDeployer() {
        List list = this.waitingDeployments;
        synchronized (list) {
            ArrayList arrayList = new ArrayList(this.waitingDeployments);
            return arrayList;
        }
    }

    public void addDeployer(SubDeployer deployer) {
        this.log.info((Object)("Adding deployer: " + deployer));
        LinkedList linkedList = this.deployers;
        synchronized (linkedList) {
            this.deployers.addFirst(deployer);
        }
        List list = this.waitingDeployments;
        synchronized (list) {
            ArrayList copy = new ArrayList(this.waitingDeployments);
            this.waitingDeployments.clear();
            Iterator i = copy.iterator();
            while (i.hasNext()) {
                try {
                    this.deploy((DeploymentInfo)i.next());
                }
                catch (DeploymentException e) {
                    this.log.error((Object)"DeploymentException while trying to deploy a package with a new deployer", (Throwable)((Object)e));
                }
            }
        }
    }

    public void removeDeployer(SubDeployer deployer) {
        this.log.info((Object)("Removing deployer: " + deployer));
        LinkedList linkedList = this.deployers;
        synchronized (linkedList) {
            this.deployers.remove(deployer);
        }
        ArrayList copy = null;
        ArrayList arrayList = this.deploymentList;
        synchronized (arrayList) {
            copy = new ArrayList(this.deploymentList);
        }
        Iterator i = copy.iterator();
        while (i.hasNext()) {
            DeploymentInfo di = (DeploymentInfo)i.next();
            if (di.deployer != deployer) continue;
            this.undeploy(di);
            di.deployer = null;
            List list = this.waitingDeployments;
            synchronized (list) {
                this.waitingDeployments.add(di);
            }
        }
    }

    public Collection listDeployers() {
        LinkedList linkedList = this.deployers;
        synchronized (linkedList) {
            ArrayList arrayList = new ArrayList(this.deployers);
            return arrayList;
        }
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? MainDeployerMBean.OBJECT_NAME : name;
    }

    protected void createService() throws Exception {
        ServerConfig config = ServerConfigLocator.locate();
        this.homeDirString = config.getHomeDir().toURL().toString();
        File basedir = config.getServerTempDir();
        this.tempDir = new File(basedir, "deploy");
        this.tempDirString = this.tempDir.toURL().toString();
    }

    public void shutdown() {
        int deployCounter = 0;
        ArrayList copyDeployments = new ArrayList(this.deploymentList);
        ListIterator i = copyDeployments.listIterator(copyDeployments.size());
        while (i.hasPrevious()) {
            try {
                this.undeploy((DeploymentInfo)i.previous());
                ++deployCounter;
            }
            catch (Exception e) {
                this.log.info((Object)"exception trying to undeploy during shutdown", (Throwable)e);
            }
        }
        this.log.info((Object)("Undeployed " + deployCounter + " deployed packages"));
    }

    public void undeploy(URL url) {
        try {
            DeploymentInfo sdi = this.getDeployment(url);
            if (sdi != null) {
                this.undeploy(sdi);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Couldn't undeploy url " + url), (Throwable)e);
        }
    }

    public void undeploy(String urlspec) throws MalformedURLException {
        this.undeploy(new URL(urlspec));
    }

    public void undeploy(DeploymentInfo di) {
        this.log.info((Object)("Undeploying " + di.url));
        this.stop(di);
        this.destroy(di);
        Notification lNotification = new Notification("Undeployment", this, 0L);
        lNotification.setUserData(di.url);
        this.sendNotification(lNotification);
    }

    private void stop(DeploymentInfo di) {
        try {
            if (di.deployer != null) {
                di.deployer.stop(di);
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Undeployment failed: " + di.url), t);
        }
        Iterator subs = di.subDeployments.iterator();
        while (subs.hasNext()) {
            DeploymentInfo sub = (DeploymentInfo)subs.next();
            this.log.debug((Object)("Stopping sub deployment: " + sub.url));
            this.stop(sub);
        }
    }

    private void destroy(DeploymentInfo di) {
        Object sub;
        try {
            if (di.deployer != null) {
                di.deployer.destroy(di);
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Undeployment failed: " + di.url), t);
        }
        Iterator subs = di.subDeployments.iterator();
        while (subs.hasNext()) {
            sub = (DeploymentInfo)subs.next();
            this.log.debug((Object)("Destroying sub deployment: " + ((DeploymentInfo)sub).url));
            this.destroy((DeploymentInfo)sub);
        }
        try {
            sub = this.deploymentList;
            synchronized (sub) {
                this.deploymentMap.remove(di.url);
                if (this.deploymentList.lastIndexOf(di) != -1) {
                    this.deploymentList.remove(this.deploymentList.lastIndexOf(di));
                }
            }
            List list = this.waitingDeployments;
            synchronized (list) {
                this.waitingDeployments.remove(di);
            }
            di.cleanup(this.log);
            this.log.info((Object)("Undeployed " + di.url));
        }
        catch (Throwable t) {
            this.log.error((Object)("Undeployment cleanup failed: " + di.url), t);
        }
    }

    public void deploy(String urlspec) throws MalformedURLException {
        URL url;
        try {
            url = new URL(urlspec);
        }
        catch (MalformedURLException e) {
            File file = new File(urlspec);
            url = file.toURL();
        }
        this.deploy(url);
    }

    public void deploy(URL url) {
        DeploymentInfo sdi = this.getDeployment(url);
        try {
            if (sdi == null) {
                sdi = new DeploymentInfo(url, null);
                this.deploy(sdi);
            }
        }
        catch (DeploymentException e) {
            this.log.error((Object)("Couldn't deploy URL " + url), (Throwable)((Object)e));
        }
    }

    public void deploy(DeploymentInfo deployment) throws DeploymentException {
        if (this.isDeployed(deployment.url)) {
            return;
        }
        this.log.info((Object)("Starting deployment of package: " + deployment.url));
        if (this.init(deployment)) {
            Notification lNotification = new Notification("Deployment", this, 0L);
            lNotification.setUserData(deployment.url);
            this.sendNotification(lNotification);
            this.create(deployment);
            this.start(deployment);
            this.log.info((Object)("Successfully completed deployment of package: " + deployment.url));
        } else {
            this.log.info((Object)("Deployment of package: " + deployment.url + " is waiting for an appropriate deployer."));
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean init(DeploymentInfo deployment) throws DeploymentException {
        block22: {
            block19: {
                block21: {
                    block18: {
                        this.log.debug((Object)("Starting deployment (init step) of package at: " + deployment.url));
                        try {
                            try {
                                if (deployment.localUrl == null) {
                                    this.makeLocalCopy(deployment);
                                    deployment.createClassLoaders(this.getServer());
                                }
                                this.findDeployer(deployment);
                                if (deployment.deployer == null) {
                                    var2_2 = this.waitingDeployments;
                                    synchronized (var2_2) {
                                        this.waitingDeployments.add(deployment);
                                    }
                                    var3_5 = false;
                                    var5_7 = null;
                                    break block18;
                                }
                                deployment.deployer.init(deployment);
                                this.parseManifestLibraries(deployment);
                                this.log.debug((Object)("found " + deployment.subDeployments.size() + " subpackages of " + deployment.url));
                                sortedSubs = new ArrayList<E>(deployment.subDeployments);
                                Collections.sort(sortedSubs, this.infoSorter);
                                lt = sortedSubs.listIterator();
                                while (lt.hasNext()) {
                                    this.init((DeploymentInfo)lt.next());
                                }
                                break block19;
                            }
                            catch (Exception e) {
                                throw new DeploymentException("exception in init of " + deployment.url, e);
                            }
                        }
                        catch (Throwable var4_16) {
                            var5_9 = null;
                            try {
                                url = deployment.localUrl == null ? deployment.url : deployment.localUrl;
                                lastModified = -1L;
                                lastModified = url.getProtocol().equals("file") != false ? new File(url.getFile()).lastModified() : url.openConnection().getLastModified();
                                deployment.lastModified = lastModified;
                                deployment.lastDeployed = System.currentTimeMillis();
                            }
                            catch (IOException ignore) {
                                deployment.lastModified = System.currentTimeMillis();
                                deployment.lastDeployed = System.currentTimeMillis();
                            }
                            var6_12 = this.deploymentList;
                            synchronized (var6_12) {
                                this.deploymentMap.put(deployment.url, deployment);
                                if (this.inLocalCopyDir(deployment.url) != false) throw var4_16;
                                this.deploymentList.add(deployment);
                                this.log.debug((Object)("Watching new file: " + deployment.url));
                                throw var4_16;
                            }
                        }
                    }
                    ** try [egrp 3[TRYBLOCK] [3 : 256->340)] { 
lbl55:
                    // 1 sources

                    url = deployment.localUrl == null ? deployment.url : deployment.localUrl;
                    lastModified = -1L;
                    lastModified = url.getProtocol().equals("file") != false ? new File(url.getFile()).lastModified() : url.openConnection().getLastModified();
                    deployment.lastModified = lastModified;
                    deployment.lastDeployed = System.currentTimeMillis();
                    break block21;
lbl61:
                    // 1 sources

                    catch (IOException ignore) {
                        deployment.lastModified = System.currentTimeMillis();
                        deployment.lastDeployed = System.currentTimeMillis();
                    }
                }
                var6_10 = this.deploymentList;
                synchronized (var6_10) {
                    this.deploymentMap.put(deployment.url, deployment);
                    if (this.inLocalCopyDir(deployment.url) != false) return var3_5;
                    this.deploymentList.add(deployment);
                    this.log.debug((Object)("Watching new file: " + deployment.url));
                    return var3_5;
                }
            }
            var5_8 = null;
            ** try [egrp 3[TRYBLOCK] [3 : 256->340)] { 
lbl77:
            // 1 sources

            url = deployment.localUrl == null ? deployment.url : deployment.localUrl;
            lastModified = -1L;
            lastModified = url.getProtocol().equals("file") != false ? new File(url.getFile()).lastModified() : url.openConnection().getLastModified();
            deployment.lastModified = lastModified;
            deployment.lastDeployed = System.currentTimeMillis();
            break block22;
lbl83:
            // 1 sources

            catch (IOException ignore) {
                deployment.lastModified = System.currentTimeMillis();
                deployment.lastDeployed = System.currentTimeMillis();
            }
        }
        var6_11 = this.deploymentList;
        synchronized (var6_11) {
            this.deploymentMap.put(deployment.url, deployment);
            if (this.inLocalCopyDir(deployment.url) != false) return true;
            this.deploymentList.add(deployment);
            this.log.debug((Object)("Watching new file: " + deployment.url));
            return true;
        }
    }

    private void create(DeploymentInfo deployment) throws DeploymentException {
        this.log.debug((Object)("create step for deployment " + deployment.url));
        try {
            ArrayList sortedSubs = new ArrayList(deployment.subDeployments);
            Collections.sort(sortedSubs, this.infoSorter);
            ListIterator lt = sortedSubs.listIterator();
            while (lt.hasNext()) {
                this.create((DeploymentInfo)lt.next());
            }
            if (deployment.deployer != null) {
                deployment.deployer.create(deployment);
            }
            deployment.status = "Created";
            this.log.debug((Object)("Done with create step of deploying " + deployment.shortName));
        }
        catch (Throwable t) {
            this.log.error((Object)("could not create deployment :" + deployment.url), t);
            deployment.status = "Deployment FAILED reason: " + t.getMessage();
            if (t instanceof DeploymentException) {
                throw (DeploymentException)((Object)t);
            }
            throw new DeploymentException("Could not create deployment: " + deployment.url, t);
        }
    }

    private void start(DeploymentInfo deployment) throws DeploymentException {
        this.log.debug((Object)("start step for deployment " + deployment.url));
        try {
            ArrayList sortedSubs = new ArrayList(deployment.subDeployments);
            Collections.sort(sortedSubs, this.infoSorter);
            ListIterator lt = sortedSubs.listIterator();
            while (lt.hasNext()) {
                this.start((DeploymentInfo)lt.next());
            }
            if (deployment.deployer != null) {
                deployment.deployer.start(deployment);
            }
            deployment.status = "Deployed";
            this.log.debug((Object)("Final (start) deployment step successfully completed on package: " + deployment.shortName));
        }
        catch (Throwable t) {
            this.log.error((Object)("could not start deployment :" + deployment.url), t);
            deployment.status = "Deployment FAILED reason: " + t.getMessage();
            if (t instanceof DeploymentException) {
                throw (DeploymentException)((Object)t);
            }
            throw new DeploymentException("Could not create deployment: " + deployment.url, t);
        }
    }

    private void findDeployer(DeploymentInfo sdi) {
        sdi.deployer = null;
        LinkedList linkedList = this.deployers;
        synchronized (linkedList) {
            Iterator iterator = this.deployers.iterator();
            while (iterator.hasNext()) {
                SubDeployer deployer = (SubDeployer)iterator.next();
                if (!deployer.accepts(sdi)) continue;
                sdi.deployer = deployer;
                this.log.debug((Object)("using deployer " + deployer));
                return;
            }
        }
        this.log.debug((Object)("No deployer found for url: " + sdi.url));
    }

    private void parseManifestLibraries(DeploymentInfo sdi) throws DeploymentException {
        String classPath = null;
        Manifest mf = sdi.getManifest();
        if (mf != null) {
            Attributes mainAttributes = mf.getMainAttributes();
            classPath = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
        }
        if (classPath != null) {
            ArrayList tmp = new ArrayList();
            StringTokenizer st = new StringTokenizer(classPath);
            this.log.debug((Object)("resolveLibraries: " + classPath));
            while (st.hasMoreTokens()) {
                URL lib = null;
                String tk = st.nextToken();
                DeploymentInfo sub = null;
                this.log.debug((Object)("new manifest entry for sdi at " + sdi.shortName + " entry is " + tk));
                try {
                    if (sdi.isDirectory) {
                        File parentDir = new File(sdi.url.getPath()).getParentFile();
                        lib = new File(parentDir, tk).toURL();
                    } else {
                        lib = new URL(sdi.url, tk);
                    }
                    if (this.isDeployed(lib)) continue;
                    sub = new DeploymentInfo(lib, sdi);
                    this.deploy(sub);
                }
                catch (Exception ignore) {
                    this.log.warn((Object)("The manifest entry in " + sdi.url + " references URL " + lib + " which could not be opened, entry ignored"));
                }
            }
        }
    }

    private void makeLocalCopy(DeploymentInfo sdi) throws DeploymentException {
        try {
            if (sdi.url.getProtocol().equals("file") && (!this.copyFiles || sdi.isDirectory)) {
                sdi.localUrl = sdi.url;
                return;
            }
            if (this.inLocalCopyDir(sdi.url)) {
                sdi.localUrl = sdi.url;
                return;
            }
            String sdiPath = sdi.url.toString();
            sdiPath = sdiPath.startsWith(this.homeDirString) ? sdiPath.substring(this.homeDirString.length()) : sdi.url.getFile();
            StringBuffer path = new StringBuffer(sdiPath);
            int i = path.length() - 1;
            while (i > -1) {
                if (path.charAt(i) == ':') {
                    path.deleteCharAt(i);
                }
                --i;
            }
            String shortName = DeploymentInfo.getShortName(path.toString());
            path.append("/").append(this.id.increment()).append(".").append(shortName);
            String fullPath = path.toString();
            sdi.localUrl = new File(this.tempDir, fullPath).toURL();
            this.copy(sdi.url, sdi.localUrl);
        }
        catch (Exception e) {
            this.log.error((Object)("Could not make local copy for " + sdi.url), (Throwable)e);
            this.log.error((Object)"if you have just upgraded jboss versions, please delete everything in the $JBOSS_HOME/tmp/deploy and try again");
        }
    }

    private boolean inLocalCopyDir(URL url) {
        int i = 0;
        String urlTest = url.toString();
        while (urlTest.startsWith("njar:", i)) {
            i += "njar:".length();
        }
        return urlTest.startsWith(this.tempDirString, i);
    }

    protected void copy(URL _src, URL _dest) throws IOException {
        File srcFile;
        if (!_dest.getProtocol().equals("file")) {
            throw new IllegalArgumentException("only file: protocol is allowed as destination!");
        }
        File file = new File(_dest.getFile());
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (_src.getProtocol().equals("file") && (srcFile = new File(_src.getFile())).isDirectory()) {
            this.log.debug((Object)("Making zip copy of: " + srcFile));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            JarUtils.jar((OutputStream)out, (File[])srcFile.listFiles());
            ((OutputStream)out).close();
            return;
        }
        BufferedInputStream in = new BufferedInputStream(_src.openStream());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        Streams.copy((InputStream)in, (OutputStream)out);
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        ((InputStream)in).close();
    }

    public boolean isDeployed(String url) throws MalformedURLException {
        return this.isDeployed(new URL(url));
    }

    public boolean isDeployed(URL url) {
        DeploymentInfo di = this.getDeployment(url);
        if (di == null) {
            return false;
        }
        return "Deployed".equals(di.status);
    }

    public DeploymentInfo getDeployment(URL url) {
        ArrayList arrayList = this.deploymentList;
        synchronized (arrayList) {
            DeploymentInfo deploymentInfo = (DeploymentInfo)this.deploymentMap.get(url);
            return deploymentInfo;
        }
    }

    public URL getWatchUrl(URL url) {
        DeploymentInfo info = this.getDeployment(url);
        return info == null ? null : info.watch;
    }
}

