/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.MainDeployerMBean;
import org.jboss.deployment.SARDeployerMBean;
import org.jboss.deployment.SubDeployer;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.jmx.MBeanProxy;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SARDeployer
extends SubDeployerSupport
implements SubDeployer,
SARDeployerMBean {
    private ServiceControllerMBean serviceController;
    private MainDeployerMBean mainDeployer;
    private File dataDir;
    private URL installURL;
    private URL libraryURL;
    static /* synthetic */ Class class$org$jboss$deployment$MainDeployerMBean;
    static /* synthetic */ Class class$org$jboss$system$ServiceControllerMBean;

    public boolean accepts(DeploymentInfo di) {
        String urlStr = di.url.toString();
        return urlStr.endsWith("sar") || urlStr.endsWith("sar/") || urlStr.endsWith("service.xml");
    }

    public void init(DeploymentInfo di) throws DeploymentException {
        boolean debug = this.log.isDebugEnabled();
        try {
            if (di.url.getProtocol().startsWith("http")) {
                di.watch = di.url;
            } else if (di.url.getProtocol().startsWith("file")) {
                File file = new File(di.url.getFile());
                di.watch = !file.isDirectory() ? di.url : new URL(di.url, "META-INF/jboss-service.xml");
            }
            this.parseDocument(di);
            this.parseXMLClasspath(di);
            NodeList lds = di.document.getElementsByTagName("local-directory");
            if (debug) {
                this.log.debug((Object)("about to copy " + lds.getLength() + " local directories"));
            }
            int i = 0;
            while (i < lds.getLength()) {
                Element ld = (Element)lds.item(i);
                String path = ld.getAttribute("path");
                if (debug) {
                    this.log.debug((Object)("about to copy local directory at " + path));
                }
                if (debug) {
                    this.log.debug((Object)("copying from " + di.localUrl + path + " -> " + this.dataDir));
                }
                this.inflateJar(di.localUrl, this.dataDir, path);
                ++i;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Problem in init", (Throwable)e);
            throw new DeploymentException(e);
        }
        this.processNestedDeployments(di);
    }

    public void create(DeploymentInfo di) throws DeploymentException {
        try {
            this.log.debug((Object)("Deploying SAR, create step: url " + di.url));
            List mbeans = di.mbeans;
            mbeans.clear();
            mbeans.addAll(this.serviceController.install(di.document.getDocumentElement()));
            Iterator iter = di.mbeans.iterator();
            while (iter.hasNext()) {
                ObjectName service = (ObjectName)iter.next();
                this.serviceController.create(service);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("create operation failed for package " + di.url), (Throwable)e);
            this.destroy(di);
            throw new DeploymentException(e);
        }
    }

    public void start(DeploymentInfo di) throws DeploymentException {
        this.log.debug((Object)("Deploying SAR, start step: url " + di.url));
        try {
            Iterator iter = di.mbeans.iterator();
            while (iter.hasNext()) {
                ObjectName service = (ObjectName)iter.next();
                this.serviceController.start(service);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("start operation failed on package " + di.url), (Throwable)e);
            this.stop(di);
            this.destroy(di);
            throw new DeploymentException(e);
        }
    }

    protected void parseXMLClasspath(DeploymentInfo di) throws DeploymentException {
        boolean debug = this.log.isDebugEnabled();
        HashSet<URL> classpath = new HashSet<URL>();
        NodeList classpaths = di.document.getElementsByTagName("classpath");
        int i = 0;
        while (i < classpaths.getLength()) {
            int j;
            File[] jars;
            File dir;
            URL fileURL;
            Element classpathElement = (Element)classpaths.item(i);
            if (debug) {
                this.log.debug((Object)("Found classpath element: " + classpathElement));
            }
            String codebase = "";
            String archives = "";
            if (classpathElement != null) {
                codebase = classpathElement.getAttribute("codebase").trim();
                if (debug) {
                    this.log.debug((Object)("Setting up classpath from raw codebase: " + codebase));
                }
                if ("".equals(codebase) || ".".equals(codebase)) {
                    codebase = new File(di.url.getProtocol() + "://" + di.url.getFile()).getParent();
                }
                if (!codebase.startsWith("http:") && !codebase.startsWith("file:")) {
                    try {
                        codebase = new URL(this.installURL, codebase).toString();
                    }
                    catch (MalformedURLException e) {
                        throw new DeploymentException(e);
                    }
                }
                if (codebase.startsWith("file:") && !codebase.endsWith("/")) {
                    codebase = codebase + "/";
                } else if (codebase.startsWith("http:") && !codebase.endsWith("/")) {
                    codebase = codebase + "/";
                }
                if (debug) {
                    this.log.debug((Object)("codebase is " + codebase));
                }
                archives = classpathElement.getAttribute("archives").trim();
                if (debug) {
                    this.log.debug((Object)("archives are " + archives));
                }
            }
            if (codebase.startsWith("file:") && archives.equals("*")) {
                try {
                    fileURL = new URL(codebase);
                    dir = new File(fileURL.getFile());
                    jars = dir.listFiles(new FileFilter(){

                        public boolean accept(File pathname) {
                            String name2 = pathname.getName();
                            return name2.endsWith(".jar") || name2.endsWith(".zip");
                        }
                    });
                    j = 0;
                    while (jars != null && j < jars.length) {
                        classpath.add(jars[j].getCanonicalFile().toURL());
                        ++j;
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)"problem listing files in directory", (Throwable)e);
                    throw new DeploymentException("problem listing files in directory", e);
                }
            } else if (codebase.startsWith("file:") && archives.equals("")) {
                try {
                    fileURL = new URL(codebase);
                    dir = new File(fileURL.getFile());
                    classpath.add(dir.getCanonicalFile().toURL());
                }
                catch (Exception e) {
                    this.log.error((Object)"Failed to add classpath dir", (Throwable)e);
                    throw new DeploymentException("Failed to add classpath dir", e);
                }
            } else if (!archives.equals("")) {
                if (codebase.equals("")) {
                    codebase = this.libraryURL.toString();
                }
                if (archives.equals("*")) {
                    if (!codebase.startsWith("file:") && archives.equals("*")) {
                        throw new DeploymentException("No wildcard permitted in non-file URL deployment you must specify individual jars");
                    }
                    try {
                        fileURL = new URL(codebase);
                        dir = new File(fileURL.getFile());
                        jars = dir.listFiles(new FileFilter(){

                            public boolean accept(File pathname) {
                                String name2 = pathname.getName();
                                return name2.endsWith(".jar") || name2.endsWith(".zip");
                            }
                        });
                        j = 0;
                        while (jars != null && j < jars.length) {
                            classpath.add(jars[j].getCanonicalFile().toURL());
                            ++j;
                        }
                    }
                    catch (Exception e) {
                        this.log.error((Object)"problem listing files in directory", (Throwable)e);
                        throw new DeploymentException("problem listing files in directory", e);
                    }
                } else {
                    StringTokenizer jars2 = new StringTokenizer(archives, ",");
                    while (jars2.hasMoreTokens()) {
                        try {
                            String archive = codebase + jars2.nextToken().trim();
                            URL archiveURL = new URL(archive);
                            classpath.add(archiveURL);
                        }
                        catch (MalformedURLException mfue) {
                            this.log.error((Object)"couldn't resolve package reference: ", (Throwable)mfue);
                        }
                    }
                }
            } else {
                throw new DeploymentException("A classpath entry was declared but no non-file codebase and no jars specified. Please fix jboss-service.xml in your configuration");
            }
            ++i;
        }
        Iterator jars = classpath.iterator();
        URL neededUrl = null;
        while (jars.hasNext()) {
            neededUrl = (URL)jars.next();
            try {
                DeploymentInfo sub = new DeploymentInfo(neededUrl, null);
                this.mainDeployer.deploy(sub);
            }
            catch (Exception e) {
                this.log.error((Object)"operation failed", (Throwable)e);
            }
            if (!debug) continue;
            this.log.debug((Object)("deployed classes for " + neededUrl));
        }
    }

    public void stop(DeploymentInfo di) {
        this.log.debug((Object)("undeploying document " + di.url));
        List services = di.mbeans;
        int lastService = services.size();
        ListIterator i = services.listIterator(lastService);
        while (i.hasPrevious()) {
            ObjectName name = (ObjectName)i.previous();
            this.log.debug((Object)("stopping mbean " + name));
            try {
                this.serviceController.stop(name);
            }
            catch (Exception e) {
                this.log.error((Object)("Could not stop mbean: " + name), (Throwable)e);
            }
        }
    }

    public void destroy(DeploymentInfo di) {
        List services = di.mbeans;
        int lastService = services.size();
        ListIterator i = services.listIterator(lastService);
        while (i.hasPrevious()) {
            ObjectName name = (ObjectName)i.previous();
            this.log.debug((Object)("destroying mbean " + name));
            try {
                this.serviceController.destroy(name);
            }
            catch (Exception e) {
                this.log.error((Object)("Could not destroy mbean: " + name), (Throwable)e);
            }
        }
        ListIterator i2 = services.listIterator(lastService);
        while (i2.hasPrevious()) {
            ObjectName name = (ObjectName)i2.previous();
            this.log.debug((Object)("removing mbean " + name));
            try {
                this.serviceController.remove(name);
            }
            catch (Exception e) {
                this.log.error((Object)("Could not remove mbean: " + name), (Throwable)e);
            }
        }
    }

    protected void startService() throws Exception {
        super.startService();
        this.mainDeployer = (MainDeployerMBean)MBeanProxy.create((Class)(class$org$jboss$deployment$MainDeployerMBean == null ? (class$org$jboss$deployment$MainDeployerMBean = SARDeployer.class$("org.jboss.deployment.MainDeployerMBean")) : class$org$jboss$deployment$MainDeployerMBean), (ObjectName)MainDeployerMBean.OBJECT_NAME, (MBeanServer)this.server);
        this.serviceController = (ServiceControllerMBean)MBeanProxy.create((Class)(class$org$jboss$system$ServiceControllerMBean == null ? (class$org$jboss$system$ServiceControllerMBean = SARDeployer.class$("org.jboss.system.ServiceControllerMBean")) : class$org$jboss$system$ServiceControllerMBean), (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)this.server);
        ServerConfig config = ServerConfigLocator.locate();
        this.dataDir = config.getServerDataDir();
        this.installURL = config.getHomeURL();
        this.libraryURL = config.getLibraryURL();
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        super.preRegister(server, name);
        this.log.debug((Object)"ServiceDeployer preregistered with mbean server");
        return name == null ? SARDeployerMBean.OBJECT_NAME : name;
    }

    protected void parseDocument(DeploymentInfo di) throws DeploymentException {
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputStream stream = null;
            stream = di.isXML ? di.localUrl.openStream() : di.localCl.getResourceAsStream("META-INF/jboss-service.xml");
            if (stream == null) {
                throw new DeploymentException("Failed to find META-INF/jboss-service.xml");
            }
            InputSource is = new InputSource(stream);
            di.document = parser.parse(is);
        }
        catch (Exception e) {
            throw new DeploymentException("Exception getting document", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void inflateJar(URL url, File destDir, String path) throws DeploymentException, IOException {
        String filename = url.getFile();
        JarFile jarFile = new JarFile(filename);
        try {
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                Object var15_14;
                File outFile;
                JarEntry entry = e.nextElement();
                String name = entry.getName();
                if (path != null && !name.startsWith(path) || (outFile = new File(destDir, name)).exists()) continue;
                if (entry.isDirectory()) {
                    outFile.mkdirs();
                    continue;
                }
                InputStream in = jarFile.getInputStream(entry);
                FileOutputStream out = new FileOutputStream(outFile);
                try {
                    int read;
                    byte[] buffer = new byte[1024];
                    while ((read = in.read(buffer)) > 0) {
                        void var13_13;
                        ((OutputStream)out).write(buffer, 0, (int)var13_13);
                    }
                    var15_14 = null;
                }
                catch (Throwable throwable) {
                    var15_14 = null;
                    in.close();
                    ((OutputStream)out).close();
                    throw throwable;
                }
                in.close();
                ((OutputStream)out).close();
                {
                }
            }
            Object var17_16 = null;
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            jarFile.close();
            throw throwable;
        }
        jarFile.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

