/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import java.util.Date;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.log4j.NDC;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBean;
import org.jboss.util.Classes;

public class ServiceMBeanSupport
extends NotificationBroadcasterSupport
implements ServiceMBean,
MBeanRegistration {
    protected Logger log = Logger.getLogger(this.getClass());
    protected MBeanServer server;
    protected ObjectName serviceName;
    private int state;
    private int id = 0;

    public ServiceMBeanSupport() {
        this.log.trace((Object)"Constructing");
    }

    public String getName() {
        return Classes.stripPackageName(this.getClass());
    }

    public ObjectName getServiceName() {
        return this.serviceName;
    }

    public MBeanServer getServer() {
        return this.server;
    }

    public int getState() {
        return this.state;
    }

    public String getStateString() {
        return ServiceMBean.states[this.state];
    }

    public Logger getLog() {
        return this.log;
    }

    public void create() throws Exception {
        NDC.push((String)this.getName());
        this.log.info((Object)"Creating");
        try {
            try {
                this.createService();
            }
            catch (Exception e) {
                this.log.error((Object)"Initialization failed", (Throwable)e);
                throw e;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            NDC.pop();
            throw throwable;
        }
        NDC.pop();
        this.log.info((Object)"Created");
    }

    public void start() throws Exception {
        if (this.getState() != 0 && this.getState() != 4) {
            return;
        }
        this.state = 2;
        this.sendNotification(new AttributeChangeNotification(this, this.id++, new Date().getTime(), this.getName() + " starting", "State", "java.lang.Integer", new Integer(0), new Integer(2)));
        this.log.info((Object)"Starting");
        NDC.push((String)this.getName());
        try {
            try {
                this.startService();
            }
            catch (Exception e) {
                this.state = 4;
                this.sendNotification(new AttributeChangeNotification(this, this.id++, new Date().getTime(), this.getName() + " failed", "State", "java.lang.Integer", new Integer(2), new Integer(4)));
                this.log.error((Object)"Starting failed", (Throwable)e);
                throw e;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            NDC.pop();
            throw throwable;
        }
        NDC.pop();
        this.state = 3;
        this.sendNotification(new AttributeChangeNotification(this, this.id++, new Date().getTime(), this.getName() + " started", "State", "java.lang.Integer", new Integer(2), new Integer(3)));
        this.log.info((Object)"Started");
    }

    public void stop() {
        if (this.getState() != 3) {
            return;
        }
        this.state = 1;
        this.sendNotification(new AttributeChangeNotification(this, this.id++, new Date().getTime(), this.getName() + " stopping", "State", "java.lang.Integer", new Integer(3), new Integer(1)));
        this.log.info((Object)"Stopping");
        NDC.push((String)this.getName());
        try {
            try {
                this.stopService();
            }
            catch (Throwable e) {
                this.state = 4;
                this.sendNotification(new AttributeChangeNotification(this, this.id++, new Date().getTime(), this.getName() + " failed", "State", "java.lang.Integer", new Integer(1), new Integer(4)));
                this.log.error((Object)"Stopping failed", e);
                Object var3_2 = null;
                NDC.pop();
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            NDC.pop();
            throw throwable;
        }
        NDC.pop();
        this.state = 0;
        this.sendNotification(new AttributeChangeNotification(this, this.id++, new Date().getTime(), this.getName() + " stopped", "State", "java.lang.Integer", new Integer(1), new Integer(0)));
        this.log.info((Object)"Stopped");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroy() {
        block5: {
            if (this.getState() != 0) {
                this.stop();
            }
            this.log.info((Object)"Destroying");
            NDC.push((String)this.getName());
            try {
                try {
                    this.destroyService();
                }
                catch (Throwable t) {
                    this.log.error((Object)"Destroying failed", t);
                    Object var3_2 = null;
                    NDC.pop();
                    break block5;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                NDC.pop();
                throw throwable;
            }
            NDC.pop();
        }
        this.log.info((Object)"Destroyed");
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.serviceName = this.getObjectName(server, name);
        return this.serviceName;
    }

    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            this.log.info((Object)"Registration is not done -> destroy");
            this.stop();
        }
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        this.stop();
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name;
    }

    protected void createService() throws Exception {
    }

    protected void startService() throws Exception {
    }

    protected void stopService() throws Exception {
    }

    protected void destroyService() throws Exception {
    }
}

