/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentState;
import org.jboss.deployment.SubDeployer;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.jboss.util.file.Files;
import org.w3c.dom.Document;

public class DeploymentInfo {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$deployment$DeploymentInfo == null ? (class$org$jboss$deployment$DeploymentInfo = DeploymentInfo.class$("org.jboss.deployment.DeploymentInfo")) : class$org$jboss$deployment$DeploymentInfo));
    public Date date = new Date();
    public URL url;
    public URL localUrl;
    public URL watch;
    public String shortName;
    public long lastDeployed = 0L;
    public long lastModified = 0L;
    public String status;
    public DeploymentState state = DeploymentState.CONSTRUCTED;
    public SubDeployer deployer;
    public UnifiedClassLoader ucl;
    public URLClassLoader localCl;
    public final Collection classpath = new ArrayList();
    public final List mbeans = new ArrayList();
    public final Set subDeployments = new HashSet();
    public DeploymentInfo parent = null;
    public String webContext;
    public Manifest manifest;
    public Document document;
    public Object metaData;
    public boolean isXML;
    public boolean isScript;
    public boolean isDirectory;
    public ObjectName deployedObject;
    public LoaderRepositoryFactory.LoaderRepositoryConfig repositoryConfig;
    private MBeanServer server;
    static /* synthetic */ Class class$org$jboss$deployment$DeploymentInfo;

    public DeploymentInfo(URL url, DeploymentInfo parent, MBeanServer server) throws DeploymentException {
        this.server = server;
        this.url = url;
        this.watch = url;
        this.parent = parent;
        if (url.getProtocol().startsWith("file") && new File(url.getFile()).isDirectory()) {
            this.isDirectory = true;
        }
        if (!this.isDirectory) {
            try {
                url.openStream().close();
            }
            catch (Exception e) {
                throw new DeploymentException("url " + url + " could not be opened, does it exist?");
            }
        }
        if (parent != null) {
            parent.subDeployments.add(this);
            this.repositoryConfig = this.getTopRepositoryConfig();
        }
        this.shortName = DeploymentInfo.getShortName(url.getFile());
        this.isXML = this.shortName.toLowerCase().endsWith("xml");
        this.isScript = this.shortName.toLowerCase().endsWith("bsh");
    }

    public void createClassLoaders() throws Exception {
        if (this.localCl == null) {
            this.localCl = new URLClassLoader(new URL[]{this.localUrl});
        }
        URL origUrl = this.url;
        DeploymentInfo current = this;
        while (current.parent != null) {
            current = current.parent;
        }
        origUrl = current.url;
        this.repositoryConfig = current.repositoryConfig;
        if (this.parent == null) {
            if (this.repositoryConfig == null) {
                this.repositoryConfig = new LoaderRepositoryFactory.LoaderRepositoryConfig();
            }
            LoaderRepositoryFactory.createLoaderRepository((MBeanServer)this.server, (LoaderRepositoryFactory.LoaderRepositoryConfig)this.repositoryConfig);
            log.debug((Object)("createLoaderRepository from config: " + this.repositoryConfig));
            Object[] args = new Object[]{this.localUrl, origUrl, Boolean.TRUE};
            String[] sig = new String[]{"java.net.URL", "java.net.URL", "boolean"};
            this.ucl = (UnifiedClassLoader)this.server.invoke(this.repositoryConfig.repositoryName, "newClassLoader", args, sig);
        } else {
            LoaderRepositoryFactory.createLoaderRepository((MBeanServer)this.server, (LoaderRepositoryFactory.LoaderRepositoryConfig)this.repositoryConfig);
            this.ucl = this.parent.ucl;
            this.ucl.addURL(this.localUrl);
        }
    }

    public void setRepositoryInfo(LoaderRepositoryFactory.LoaderRepositoryConfig config) throws Exception {
        if (this.parent != null) {
            log.warn((Object)("Only the root deployment can set the loader repository, ingoring config=" + config));
            return;
        }
        this.repositoryConfig = config;
        if (this.ucl != null) {
            this.ucl.unregister();
            LoaderRepositoryFactory.createLoaderRepository((MBeanServer)this.server, (LoaderRepositoryFactory.LoaderRepositoryConfig)this.repositoryConfig);
            log.debug((Object)("createLoaderRepository from config: " + this.repositoryConfig));
            Object[] args = new Object[]{this.localUrl, this.url, Boolean.TRUE};
            String[] sig = new String[]{"java.net.URL", "java.net.URL", "boolean"};
            this.ucl = (UnifiedClassLoader)this.server.invoke(this.repositoryConfig.repositoryName, "newClassLoader", args, sig);
        }
    }

    public void addLibraryJar(URL libJar) {
        DeploymentInfo current = this;
        while (current.parent != null) {
            current = current.parent;
        }
        current.ucl.addURL(libJar);
    }

    public LoaderRepositoryFactory.LoaderRepositoryConfig getTopRepositoryConfig() {
        LoaderRepositoryFactory.LoaderRepositoryConfig topConfig = this.repositoryConfig;
        DeploymentInfo info = this;
        while (info.parent != null) {
            info = info.parent;
            topConfig = info.repositoryConfig;
        }
        return topConfig;
    }

    public Manifest getManifest() {
        try {
            if (this.manifest == null) {
                File file = new File(this.localUrl.getFile());
                if (file.isDirectory()) {
                    FileInputStream fis = new FileInputStream(new File(file, "META-INF/MANIFEST.MF"));
                    this.manifest = new Manifest(fis);
                    fis.close();
                } else {
                    this.manifest = new JarFile(file).getManifest();
                }
            }
            return this.manifest;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public void cleanup() {
        if (this.ucl != null) {
            this.ucl.unregister();
        }
        this.ucl = null;
        LoaderRepositoryFactory.destroyLoaderRepository((MBeanServer)this.server, (ObjectName)this.repositoryConfig.repositoryName);
        this.subDeployments.clear();
        this.mbeans.clear();
        if (this.localUrl == null || this.localUrl.equals(this.url)) {
            log.warn((Object)("Not deleting localUrl, it is null or not a copy: " + this.localUrl));
        } else if (Files.deleteContaining((String)this.localUrl.getFile())) {
            log.info((Object)("Cleaned Deployment: " + this.localUrl));
        } else {
            log.warn((Object)("Could not delete directory " + this.localUrl + " restart will delete it"));
        }
        this.localUrl = null;
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof DeploymentInfo) {
            return ((DeploymentInfo)other).url.equals(this.url);
        }
        return false;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(super.toString());
        s.append(" { url=" + this.url + " }\n");
        s.append("  deployer: " + this.deployer + "\n");
        s.append("  status: " + this.status + "\n");
        s.append("  state: " + this.state + "\n");
        s.append("  watch: " + this.watch + "\n");
        s.append("  lastDeployed: " + this.lastDeployed + "\n");
        s.append("  lastModified: " + this.lastModified + "\n");
        s.append("  mbeans:\n");
        Iterator i = this.mbeans.iterator();
        while (i.hasNext()) {
            ObjectName o = (ObjectName)i.next();
            try {
                String state = (String)this.server.getAttribute(o, "StateString");
                s.append("    " + o + " state: " + state + "\n");
            }
            catch (Exception e) {
                s.append("    " + o + " (state not available)\n");
            }
        }
        return s.toString();
    }

    public static String getShortName(String name) {
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        name = name.substring(name.lastIndexOf("/") + 1);
        return name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

