/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.InputStream;
import java.util.Hashtable;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class JBossEntityResolver
implements EntityResolver {
    private static Hashtable dtds = new Hashtable();
    private boolean hasDTD = false;

    public static void registerDTD(String publicId, String dtdFileName) {
        dtds.put(publicId, dtdFileName);
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        this.hasDTD = false;
        String dtd = null;
        if (publicId != null) {
            dtd = (String)dtds.get(publicId);
        }
        if (dtd != null) {
            this.hasDTD = true;
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                String dtdResource = "org/jboss/metadata/" + dtd;
                InputStream dtdStream = loader.getResourceAsStream(dtdResource);
                InputSource aInputSource = new InputSource(dtdStream);
                return aInputSource;
            }
            catch (Exception ignore) {
            }
        }
        return null;
    }

    public boolean hasDTD() {
        return this.hasDTD;
    }

    static {
        JBossEntityResolver.registerDTD("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN", "ejb-jar.dtd");
        JBossEntityResolver.registerDTD("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN", "ejb-jar_2_0.dtd");
        JBossEntityResolver.registerDTD("-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN", "application_1_2.dtd");
        JBossEntityResolver.registerDTD("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN", "application_1_3.dtd");
        JBossEntityResolver.registerDTD("-//Sun Microsystems, Inc.//DTD Connector 1.0//EN", "connector_1_0.dtd");
        JBossEntityResolver.registerDTD("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "web-app_2_2.dtd");
        JBossEntityResolver.registerDTD("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "web-app_2_3.dtd");
        JBossEntityResolver.registerDTD("-//JBoss//DTD J2EE Application 1.3//EN", "jboss-app_3_0.dtd");
        JBossEntityResolver.registerDTD("-//JBoss//DTD J2EE Application 1.3V2//EN", "jboss-app_3_2.dtd");
        JBossEntityResolver.registerDTD("-//JBoss//DTD JAWS//EN", "jaws.dtd");
        JBossEntityResolver.registerDTD("-//JBoss//DTD JAWS 2.4//EN", "jaws_2_4.dtd");
        JBossEntityResolver.registerDTD("-//JBoss//DTD JAWS 3.0//EN", "jaws_3_0.dtd");
        JBossEntityResolver.registerDTD("-//JBoss//DTD JBOSS//EN", "jboss.dtd");
        JBossEntityResolver.registerDTD("-//JBoss//DTD JBOSS 2.4//EN", "jboss_2_4.dtd");
        JBossEntityResolver.registerDTD("-//JBoss//DTD JBOSS 3.0//EN", "jboss_3_0.dtd");
        JBossEntityResolver.registerDTD("-//JBoss//DTD JBOSS 3.2//EN", "jboss_3_2.dtd");
        JBossEntityResolver.registerDTD("-//JBoss//DTD JBOSSCMP-JDBC 3.0//EN", "jbosscmp-jdbc_3_0.dtd");
        JBossEntityResolver.registerDTD("-//JBoss//DTD JBOSSCMP-JDBC 3.2//EN", "jbosscmp-jdbc_3_2.dtd");
        JBossEntityResolver.registerDTD("-//JBoss//DTD Web Application 2.2//EN", "jboss-web.dtd");
        JBossEntityResolver.registerDTD("-//JBoss//DTD Web Application 2.3//EN", "jboss-web_3_0.dtd");
        JBossEntityResolver.registerDTD("-//JBoss//DTD Web Application 2.3V2//EN", "jboss-web_3_2.dtd");
        JBossEntityResolver.registerDTD("-//JBoss//DTD MBean Service 3.2//EN", "jboss-service_3_2.dtd");
    }
}

