/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.MainDeployerMBean;
import org.jboss.deployment.SubDeployer;
import org.jboss.deployment.SubDeployerMBean;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.file.JarUtils;
import org.jboss.util.property.PropertyContainer;
import org.jboss.util.stream.Streams;

public abstract class SubDeployerSupport
extends ServiceMBeanSupport
implements SubDeployer,
SubDeployerMBean {
    protected static final String nativeSuffix;
    protected static final String nativePrefix;
    protected MainDeployerMBean mainDeployer;
    protected File tempDeployDir;
    private File tempNativeDir;
    protected static final ClassConfiguration CONFIGURATION;
    static /* synthetic */ Class class$org$jboss$deployment$MainDeployerMBean;
    static /* synthetic */ Class class$org$jboss$deployment$SubDeployerSupport;

    protected void createService() throws Exception {
        ServerConfig config = ServerConfigLocator.locate();
        File basedir = config.getServerTempDir();
        this.tempNativeDir = new File(basedir, "native");
        this.tempDeployDir = new File(basedir, "deploy");
        this.mainDeployer = (MainDeployerMBean)MBeanProxyExt.create((Class)(class$org$jboss$deployment$MainDeployerMBean == null ? (class$org$jboss$deployment$MainDeployerMBean = SubDeployerSupport.class$("org.jboss.deployment.MainDeployerMBean")) : class$org$jboss$deployment$MainDeployerMBean), (ObjectName)MainDeployerMBean.OBJECT_NAME, (MBeanServer)this.server);
    }

    protected void startService() throws Exception {
        this.mainDeployer.addDeployer(this);
    }

    protected void stopService() throws Exception {
        this.mainDeployer.removeDeployer(this);
    }

    protected void destroyService() throws Exception {
        this.mainDeployer = null;
        this.tempNativeDir = null;
    }

    public void init(DeploymentInfo di) throws DeploymentException {
        this.processNestedDeployments(di);
        Notification msg = new Notification("org.jboss.deployment.SubDeployer.init", this, this.getNextNotificationSequenceNumber());
        msg.setUserData(di);
        this.sendNotification(msg);
    }

    public void create(DeploymentInfo di) throws DeploymentException {
        Notification msg = new Notification("org.jboss.deployment.SubDeployer.create", this, this.getNextNotificationSequenceNumber());
        msg.setUserData(di);
        this.sendNotification(msg);
    }

    public void start(DeploymentInfo di) throws DeploymentException {
        Notification msg = new Notification("org.jboss.deployment.SubDeployer.start", this, this.getNextNotificationSequenceNumber());
        msg.setUserData(di);
        this.sendNotification(msg);
    }

    public void stop(DeploymentInfo di) throws DeploymentException {
        Notification msg = new Notification("org.jboss.deployment.SubDeployer.stop", this, this.getNextNotificationSequenceNumber());
        msg.setUserData(di);
        this.sendNotification(msg);
    }

    public void destroy(DeploymentInfo di) throws DeploymentException {
        Notification msg = new Notification("org.jboss.deployment.SubDeployer.destroy", this, this.getNextNotificationSequenceNumber());
        msg.setUserData(di);
        this.sendNotification(msg);
    }

    protected void processNestedDeployments(DeploymentInfo di) throws DeploymentException {
        this.log.debug((Object)("looking for nested deployments in : " + di.url));
        if (di.isXML) {
            return;
        }
        if (di.isDirectory) {
            File f = new File(di.url.getFile());
            if (!f.isDirectory()) {
                throw new DeploymentException("Deploy file incorrectly reported as a directory: " + di.url);
            }
            this.addDeployableFiles(di, f);
        } else {
            try {
                URL nestedURL = JarUtils.extractNestedJar((URL)di.localUrl, (File)this.tempDeployDir);
                JarFile jarFile = new JarFile(nestedURL.getFile());
                this.addDeployableJar(di, jarFile);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to add deployable jar: " + di.localUrl), (Throwable)e);
                return;
            }
        }
    }

    protected boolean isDeployable(String name, URL url) {
        return name.endsWith(".jar") || name.endsWith(".sar") || name.endsWith(".ear") || name.endsWith(".rar") || name.endsWith(".zip") || name.endsWith(".wsr") || name.endsWith(".war") || name.endsWith(".bsh") || name.endsWith("-ds.xml") || name.endsWith("-service.xml") && url.getPath().indexOf("META-INF") == -1 || name.endsWith(nativeSuffix) && name.startsWith(nativePrefix);
    }

    protected void addDeployableFiles(DeploymentInfo di, File dir) throws DeploymentException {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            block5: {
                File file;
                block4: {
                    file = files[i];
                    String name = file.getName();
                    try {
                        URL url = file.toURL();
                        if (!this.isDeployable(name, url)) break block4;
                        this.deployUrl(di, url, name);
                        break block5;
                    }
                    catch (MalformedURLException e) {
                        this.log.warn((Object)("File name invalid; ignoring: " + file), (Throwable)e);
                    }
                }
                if (file.isDirectory()) {
                    this.addDeployableFiles(di, file);
                }
            }
            ++i;
        }
    }

    protected void addDeployableJar(DeploymentInfo di, JarFile jarFile) throws DeploymentException {
        String urlPrefix = "jar:" + di.localUrl.toString() + "!/";
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String name = entry.getName();
            try {
                URL url = new URL(urlPrefix + name);
                if (!this.isDeployable(name, url)) continue;
                URL nestedURL = JarUtils.extractNestedJar((URL)url, (File)this.tempDeployDir);
                this.deployUrl(di, nestedURL, name);
            }
            catch (MalformedURLException mue) {
                this.log.warn((Object)("Jar entry invalid; ignoring: " + name), (Throwable)mue);
            }
            catch (IOException ex) {
                this.log.warn((Object)("Failed to extract nested jar; ignoring: " + name), (Throwable)ex);
            }
        }
    }

    protected void deployUrl(DeploymentInfo di, URL url, String name) throws DeploymentException {
        this.log.info((Object)("nested deployment: " + url));
        try {
            if (name.endsWith(nativeSuffix) && name.startsWith(nativePrefix)) {
                File destFile = new File(this.tempNativeDir, name);
                this.log.info((Object)("Loading native library: " + destFile.toString()));
                File parent = destFile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                InputStream in = url.openStream();
                FileOutputStream out = new FileOutputStream(destFile);
                Streams.copyb((InputStream)in, (OutputStream)out);
                out.flush();
                ((OutputStream)out).close();
                in.close();
                System.load(destFile.toString());
            } else {
                DeploymentInfo sub = new DeploymentInfo(url, di, this.getServer());
            }
        }
        catch (Exception ex) {
            throw new DeploymentException("Could not deploy sub deployment " + name + " of deployment " + di.url, ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CONFIGURATION = new ClassConfiguration();
        String token = CONFIGURATION.getNativeLibToken();
        String nativex = System.mapLibraryName(token);
        int xPos = nativex.indexOf(token);
        nativePrefix = nativex.substring(0, xPos);
        nativeSuffix = nativex.substring(xPos + 3);
    }

    protected static class ClassConfiguration
    extends PropertyContainer {
        private String nativeLibToken = "XxX";

        public ClassConfiguration() {
            super(class$org$jboss$deployment$SubDeployerSupport == null ? (class$org$jboss$deployment$SubDeployerSupport = SubDeployerSupport.class$("org.jboss.deployment.SubDeployerSupport")) : class$org$jboss$deployment$SubDeployerSupport);
            this.bindMethod("nativeLibToken");
        }

        public void setNativeLibToken(String token) {
            this.nativeLibToken = token;
        }

        public String getNativeLibToken() {
            return this.nativeLibToken;
        }
    }
}

