/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.log4j.NDC;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.DeploymentState;
import org.jboss.logging.Logger;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.Service;
import org.jboss.system.ServiceConfigurator;
import org.jboss.system.ServiceContext;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.system.ServiceCreator;
import org.jboss.system.ServiceFactory;
import org.w3c.dom.Element;

public class ServiceController
extends NotificationBroadcasterSupport
implements ServiceControllerMBean,
MBeanRegistration,
NotificationListener {
    public static final ObjectName DEFAULT_LOADER_REPOSITORY = ObjectNameFactory.create((String)"JMImplementation:service=LoaderRepository,name=Default");
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$system$ServiceController == null ? (class$org$jboss$system$ServiceController = ServiceController.class$("org.jboss.system.ServiceController")) : class$org$jboss$system$ServiceController));
    MBeanServer server;
    protected ServiceCreator creator;
    protected ServiceConfigurator configurator;
    protected Map nameToServiceMap = Collections.synchronizedMap(new HashMap());
    protected List installedServices = new LinkedList();
    private final Map classNameToMBeansMap = new HashMap();
    private Map waitingConfigs = new HashMap();
    private long sequenceNo;
    private final Object CLASSLOADER_ADDED_OBJECT = new Object();
    private final Object CLASS_REMOVED_OBJECT = new Object();
    private static HashMap serviceOpMap = new HashMap();
    static /* synthetic */ Class class$org$jboss$system$ServiceController;
    static /* synthetic */ Class class$org$jboss$system$Service;

    public List listDeployed() {
        return new ArrayList(this.installedServices);
    }

    public List listIncompletelyDeployed() {
        ArrayList<ServiceContext> id = new ArrayList<ServiceContext>();
        Iterator i = this.installedServices.iterator();
        while (i.hasNext()) {
            ServiceContext sc = (ServiceContext)i.next();
            if (sc.state == ServiceContext.RUNNING) continue;
            id.add(sc);
        }
        return id;
    }

    public List listDeployedNames() {
        ArrayList<ObjectName> names = new ArrayList<ObjectName>(this.installedServices.size());
        Iterator i = this.installedServices.iterator();
        while (i.hasNext()) {
            ServiceContext ctx = (ServiceContext)i.next();
            names.add(ctx.objectName);
        }
        return names;
    }

    public String listConfiguration(ObjectName[] objectNames) throws Exception {
        return this.configurator.getConfiguration(objectNames);
    }

    public List listWaitingMBeans() throws Exception {
        return new ArrayList(this.waitingConfigs.keySet());
    }

    public void validateDeploymentState(DeploymentInfo di, DeploymentState state) {
        ArrayList<ObjectName> mbeans = new ArrayList<ObjectName>(di.mbeans);
        if (di.deployedObject != null) {
            mbeans.add(di.deployedObject);
        }
        boolean mbeansStateIsValid = true;
        int m = 0;
        while (m < mbeans.size()) {
            ObjectName serviceName = (ObjectName)mbeans.get(m);
            ServiceContext ctx = this.getServiceContext(serviceName);
            if (ctx != null && state == DeploymentState.STARTED) {
                mbeansStateIsValid &= ctx.state == ServiceContext.RUNNING;
            }
            ++m;
        }
        if (mbeansStateIsValid) {
            di.state = state;
        }
    }

    public synchronized List install(Element config, ObjectName loaderName) throws DeploymentException {
        List mbeans = this.configurator.install(config, loaderName);
        Iterator i = mbeans.iterator();
        while (i.hasNext()) {
            ObjectName mbean = (ObjectName)i.next();
            this.installedServices.add(this.createServiceContext(mbean));
        }
        return mbeans;
    }

    public synchronized void create(ObjectName serviceName) throws Exception {
        this.create(serviceName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void create(ObjectName serviceName, Collection depends) throws Exception {
        block16: {
            block15: {
                block13: {
                    boolean debug = log.isDebugEnabled();
                    log.debug((Object)("Creating service " + serviceName));
                    ServiceContext ctx = this.createServiceContext(serviceName);
                    log.trace((Object)("Pushing NDC: " + ctx.objectName.toString()));
                    NDC.push((String)ctx.objectName.toString());
                    try {
                        block14: {
                            ServiceContext sc;
                            int state;
                            if (!this.installedServices.contains(ctx)) {
                                this.installedServices.add(ctx);
                            }
                            if (depends != null) {
                                log.debug((Object)("adding depends in ServiceController.create: " + depends));
                                Iterator i = depends.iterator();
                                while (i.hasNext()) {
                                    this.registerDependency(serviceName, (ObjectName)i.next());
                                }
                            }
                            ctx.proxy = this.getServiceProxy(ctx.objectName, null);
                            if (ctx.state == ServiceContext.CREATED || ctx.state == ServiceContext.RUNNING || ctx.state == ServiceContext.FAILED) {
                                log.debug((Object)("Ignoring create request for service: " + ctx.objectName));
                                Object var10_7 = null;
                                break block13;
                            }
                            int oldState = ctx.state;
                            ctx.state = ServiceContext.CREATED;
                            Iterator iterator = ctx.iDependOn.iterator();
                            do {
                                if (!iterator.hasNext()) {
                                    try {
                                        ctx.proxy.create();
                                        ++this.sequenceNo;
                                        Notification createMsg = new Notification(" org.jboss.system.ServiceMBean.create", this, this.sequenceNo);
                                        createMsg.setUserData(serviceName);
                                        this.sendNotification(createMsg);
                                        break block14;
                                    }
                                    catch (Throwable e) {
                                        ctx.state = ServiceContext.FAILED;
                                        ctx.problem = e;
                                        log.warn((Object)("Problem creating service " + serviceName), e);
                                        Object var10_9 = null;
                                        NDC.pop();
                                        NDC.remove();
                                        return;
                                    }
                                }
                                sc = (ServiceContext)iterator.next();
                            } while ((state = sc.state) == ServiceContext.CREATED || state == ServiceContext.RUNNING);
                            log.debug((Object)("waiting in create of " + serviceName + " waiting on " + sc.objectName));
                            ctx.state = oldState;
                            break block15;
                        }
                        log.debug((Object)("Creating dependent components for: " + serviceName + " dependents are: " + ctx.dependsOnMe));
                        Iterator iterator = ctx.dependsOnMe.iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                break block16;
                            }
                            ServiceContext ctx2 = (ServiceContext)iterator.next();
                            this.create(ctx2.objectName);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_11 = null;
                        NDC.pop();
                        NDC.remove();
                        throw throwable;
                    }
                }
                NDC.pop();
                NDC.remove();
                return;
            }
            Object var10_8 = null;
            NDC.pop();
            NDC.remove();
            return;
        }
        Object var10_10 = null;
        NDC.pop();
        NDC.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void start(ObjectName serviceName) throws Exception {
        block14: {
            block13: {
                block11: {
                    boolean debug = log.isDebugEnabled();
                    log.debug((Object)("starting service " + serviceName));
                    ServiceContext ctx = this.createServiceContext(serviceName);
                    NDC.push((String)ctx.objectName.toString());
                    try {
                        block12: {
                            ServiceContext sctx;
                            int state;
                            if (!this.installedServices.contains(ctx)) {
                                this.installedServices.add(ctx);
                            }
                            if (ctx.state == ServiceContext.RUNNING || ctx.state == ServiceContext.FAILED) {
                                log.debug((Object)("Ignoring start request for service: " + ctx.objectName));
                                Object var9_4 = null;
                                break block11;
                            }
                            int oldState = ctx.state;
                            ctx.state = ServiceContext.RUNNING;
                            Iterator iterator = ctx.iDependOn.iterator();
                            do {
                                if (!iterator.hasNext()) {
                                    try {
                                        ctx.proxy.start();
                                        break block12;
                                    }
                                    catch (Throwable e) {
                                        ctx.state = ServiceContext.FAILED;
                                        ctx.problem = e;
                                        log.warn((Object)("Problem starting service " + serviceName), e);
                                        Object var9_6 = null;
                                        NDC.pop();
                                        NDC.remove();
                                        return;
                                    }
                                }
                                sctx = (ServiceContext)iterator.next();
                            } while ((state = sctx.state) == ServiceContext.RUNNING);
                            log.debug((Object)("waiting in start " + serviceName + " on " + sctx.objectName));
                            ctx.state = oldState;
                            break block13;
                        }
                        log.debug((Object)("Starting dependent components for: " + serviceName + " dependent components: " + ctx.dependsOnMe));
                        Iterator iterator = ctx.dependsOnMe.iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                break block14;
                            }
                            ServiceContext ctx2 = (ServiceContext)iterator.next();
                            this.start(ctx2.objectName);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_8 = null;
                        NDC.pop();
                        NDC.remove();
                        throw throwable;
                    }
                }
                NDC.pop();
                NDC.remove();
                return;
            }
            Object var9_5 = null;
            NDC.pop();
            NDC.remove();
            return;
        }
        Object var9_7 = null;
        NDC.pop();
        NDC.remove();
    }

    public void stop(ObjectName serviceName) throws Exception {
        block7: {
            boolean debug = log.isDebugEnabled();
            ServiceContext ctx = (ServiceContext)this.nameToServiceMap.get(serviceName);
            if (debug) {
                log.debug((Object)("stopping service: " + serviceName));
            }
            if (ctx == null) {
                log.warn((Object)("Ignoring request to stop nonexistent service: " + serviceName));
                return;
            }
            if (ctx.state != ServiceContext.RUNNING) {
                return;
            }
            ctx.state = ServiceContext.STOPPED;
            if (debug) {
                log.debug((Object)("stopping dependent services for: " + serviceName + " dependent services are: " + ctx.dependsOnMe));
            }
            Iterator iterator = ctx.dependsOnMe.iterator();
            while (iterator.hasNext()) {
                ServiceContext ctx2 = (ServiceContext)iterator.next();
                ObjectName other = ctx2.objectName;
                this.stop(other);
            }
            if (ctx.proxy == null) break block7;
            try {
                ctx.proxy.stop();
            }
            catch (Throwable e) {
                ctx.state = ServiceContext.FAILED;
                ctx.problem = e;
                log.warn((Object)("Problem stopping service " + serviceName), e);
            }
        }
    }

    public void destroy(ObjectName serviceName) throws Exception {
        block7: {
            boolean debug = log.isDebugEnabled();
            ServiceContext ctx = (ServiceContext)this.nameToServiceMap.get(serviceName);
            if (debug) {
                log.debug((Object)("destroying service: " + serviceName));
            }
            if (ctx == null) {
                log.warn((Object)("Ignoring request to destroy nonexistent service: " + serviceName));
                return;
            }
            if (ctx.state == ServiceContext.DESTROYED || ctx.state == ServiceContext.NOTYETINSTALLED) {
                return;
            }
            ctx.state = ServiceContext.DESTROYED;
            if (debug) {
                log.debug((Object)("destroying dependent services for: " + serviceName + " depenent services are: " + ctx.dependsOnMe));
            }
            Iterator iterator = ctx.dependsOnMe.iterator();
            while (iterator.hasNext()) {
                ServiceContext ctx2 = (ServiceContext)iterator.next();
                ObjectName other = ctx2.objectName;
                this.destroy(other);
            }
            if (ctx.proxy == null) break block7;
            try {
                ctx.proxy.destroy();
                ++this.sequenceNo;
                Notification destroyMsg = new Notification(" org.jboss.system.ServiceMBean.destroy", this, this.sequenceNo);
                destroyMsg.setUserData(serviceName);
                this.sendNotification(destroyMsg);
            }
            catch (Throwable e) {
                ctx.state = ServiceContext.FAILED;
                ctx.problem = e;
                log.warn((Object)("Problem destroying service " + serviceName), e);
            }
        }
    }

    public void remove(ObjectName objectName) throws Exception {
        boolean debug = log.isDebugEnabled();
        ServiceContext ctx = (ServiceContext)this.nameToServiceMap.get(objectName);
        if (debug) {
            log.debug((Object)("removing service: " + objectName));
        }
        this.waitingConfigs.remove(objectName);
        if (ctx == null) {
            log.warn((Object)("Ignoring request to remove nonexistent service: " + objectName));
            return;
        }
        Iterator iterator = ctx.iDependOn.iterator();
        while (iterator.hasNext()) {
            ServiceContext iDependOnContext = (ServiceContext)iterator.next();
            iDependOnContext.dependsOnMe.remove(ctx);
            if (iDependOnContext.state != ServiceContext.NOTYETINSTALLED || iDependOnContext.dependsOnMe.size() != 0) continue;
            this.nameToServiceMap.remove(iDependOnContext.objectName);
            if (!debug) continue;
            log.debug((Object)("Removing context for nonexistent service it is no longer recording dependencies: " + iDependOnContext));
        }
        ctx.iDependOn.clear();
        if (this.server.isRegistered(objectName)) {
            log.debug((Object)("removing " + objectName + " from server"));
            if (ctx.dependsOnMe.size() == 0) {
                this.nameToServiceMap.remove(objectName);
            } else {
                log.debug((Object)("Context not removed, it is recording dependencies: " + ctx));
            }
            this.installedServices.remove(ctx);
            ObjectInstance oi = this.server.getObjectInstance(objectName);
            String className = oi.getClassName();
            Set mbeans = (Set)this.classNameToMBeansMap.get(className);
            if (mbeans != null) {
                mbeans.remove(objectName);
            }
            this.creator.remove(objectName);
        } else {
            log.debug((Object)("no need to remove " + objectName + " from server"));
        }
        ctx.state = ServiceContext.NOTYETINSTALLED;
    }

    public void shutdown() {
        log.info((Object)("Stopping " + this.nameToServiceMap.size() + " services"));
        ArrayList servicesCopy = new ArrayList(this.installedServices);
        int serviceCounter = 0;
        ObjectName name = null;
        ListIterator i = servicesCopy.listIterator(servicesCopy.size());
        while (i.hasPrevious()) {
            ServiceContext ctx = (ServiceContext)i.previous();
            name = ctx.objectName;
            try {
                this.remove(name);
                ++serviceCounter;
            }
            catch (Throwable e) {
                log.error((Object)("Could not remove " + name), e);
            }
        }
        log.info((Object)("Stopped " + serviceCounter + " services"));
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.creator = new ServiceCreator(server);
        this.configurator = new ServiceConfigurator(server, this, this.creator);
        NotificationFilterSupport removeFilter = new NotificationFilterSupport();
        removeFilter.enableType("jboss.mx.class.removed");
        server.addNotificationListener(DEFAULT_LOADER_REPOSITORY, this, (NotificationFilter)removeFilter, this.CLASS_REMOVED_OBJECT);
        NotificationFilterSupport addFilter = new NotificationFilterSupport();
        addFilter.enableType("jboss.mx.classloader.added");
        server.addNotificationListener(DEFAULT_LOADER_REPOSITORY, this, (NotificationFilter)addFilter, this.CLASSLOADER_ADDED_OBJECT);
        log.info((Object)"Controller MBean online");
        return name == null ? ServiceControllerMBean.OBJECT_NAME : name;
    }

    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            log.info((Object)"Registration of ServiceController failed");
        }
    }

    public void preDeregister() throws Exception {
        this.server.removeNotificationListener(DEFAULT_LOADER_REPOSITORY, this);
    }

    public void postDeregister() {
    }

    private Service getServiceProxy(ObjectName objectName, String serviceFactory) throws ClassNotFoundException, InstantiationException, IllegalAccessException, JMException {
        Service service = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (serviceFactory != null && serviceFactory.length() > 0) {
            Class<?> clazz = loader.loadClass(serviceFactory);
            ServiceFactory factory = (ServiceFactory)clazz.newInstance();
            service = factory.createService(this.server, objectName);
        } else {
            MBeanInfo info = this.server.getMBeanInfo(objectName);
            MBeanOperationInfo[] opInfo = info.getOperations();
            Class[] interfaces = new Class[]{class$org$jboss$system$Service == null ? (class$org$jboss$system$Service = ServiceController.class$("org.jboss.system.Service")) : class$org$jboss$system$Service};
            ServiceProxy handler = new ServiceProxy(objectName, opInfo);
            service = (Service)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)handler);
        }
        return service;
    }

    public ServiceContext getServiceContext(ObjectName serviceName) {
        ServiceContext ctx = (ServiceContext)this.nameToServiceMap.get(serviceName);
        return ctx;
    }

    public synchronized void registerMBeanClassName(ObjectInstance instance) {
        String className = instance.getClassName();
        HashSet<ObjectName> mbeans = (HashSet<ObjectName>)this.classNameToMBeansMap.get(className);
        if (mbeans == null) {
            mbeans = new HashSet<ObjectName>();
            this.classNameToMBeansMap.put(className, mbeans);
        }
        if (!mbeans.contains(instance.getObjectName())) {
            mbeans.add(instance.getObjectName());
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        if (handback == this.CLASSLOADER_ADDED_OBJECT) {
            this.newClassLoaderNotification();
        } else if (handback == this.CLASS_REMOVED_OBJECT) {
            String className = notification.getMessage();
            this.unregisterClassName(className);
        }
    }

    void unregisterClassName(String className) {
        Set mbeans = (Set)this.classNameToMBeansMap.remove(className);
        if (mbeans != null) {
            Iterator i = mbeans.iterator();
            while (i.hasNext()) {
                ObjectName mbeanName = (ObjectName)i.next();
                try {
                    Element mbeanConfig = this.configurator.getConfiguration(mbeanName);
                    this.stop(mbeanName);
                    this.destroy(mbeanName);
                    this.remove(mbeanName);
                    this.registerWaitingForClass(mbeanName, mbeanConfig);
                }
                catch (Exception e) {
                    log.info((Object)("Exception removing mbean: " + mbeanName), (Throwable)e);
                }
            }
        }
    }

    void registerWaitingForClass(ObjectName mbeanName, Element mbeanElement) {
        log.trace((Object)("registering waiting for class: " + mbeanName));
        this.waitingConfigs.put(mbeanName, mbeanElement);
    }

    synchronized ServiceContext createServiceContext(ObjectName objectName) {
        if (this.nameToServiceMap.containsKey(objectName)) {
            return (ServiceContext)this.nameToServiceMap.get(objectName);
        }
        ServiceContext ctx = new ServiceContext();
        ctx.objectName = objectName;
        this.nameToServiceMap.put(objectName, ctx);
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newClassLoaderNotification() {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Scanning for newly supplied classes for waiting mbeans");
        }
        Map waiting = null;
        ServiceController serviceController = this;
        synchronized (serviceController) {
            waiting = this.waitingConfigs;
            this.waitingConfigs = new HashMap();
        }
        Iterator i = waiting.values().iterator();
        while (i.hasNext()) {
            Element mbeanElement = (Element)i.next();
            try {
                if (trace) {
                    log.trace((Object)("trying to install mbean: " + mbeanElement));
                }
                List mbeans = this.configurator.install(mbeanElement, null);
                Iterator j = mbeans.iterator();
                while (j.hasNext()) {
                    ObjectName name = (ObjectName)j.next();
                    this.create(name);
                    this.start(name);
                }
            }
            catch (Exception e) {
                log.info((Object)("Exception when trying to deploy waiting mbean" + mbeanElement), (Throwable)e);
            }
        }
    }

    void registerDependency(ObjectName needs, ObjectName used) {
        log.debug((Object)("recording that " + needs + " depends on " + used));
        ServiceContext needsCtx = this.createServiceContext(needs);
        ServiceContext usedCtx = this.createServiceContext(used);
        if (!needsCtx.iDependOn.contains(usedCtx)) {
            needsCtx.iDependOn.add(usedCtx);
            usedCtx.dependsOnMe.add(needsCtx);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        serviceOpMap.put("create", new Integer(0));
        serviceOpMap.put("start", new Integer(1));
        serviceOpMap.put("destroy", new Integer(2));
        serviceOpMap.put("stop", new Integer(3));
    }

    public class ServiceProxy
    implements InvocationHandler {
        private boolean[] hasOp = new boolean[]{false, false, false, false};
        private ObjectName objectName;

        public ServiceProxy(ObjectName objectName, MBeanOperationInfo[] opInfo) {
            this.objectName = objectName;
            int op = 0;
            while (op < opInfo.length) {
                MBeanOperationInfo info = opInfo[op];
                String name = info.getName();
                Integer opID = (Integer)serviceOpMap.get(name);
                if (opID != null && info.getReturnType().equals("void") && info.getSignature().length == 0) {
                    this.hasOp[opID.intValue()] = true;
                }
                ++op;
            }
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            Integer opID = (Integer)serviceOpMap.get(name);
            if (opID != null && this.hasOp[opID]) {
                try {
                    String[] sig = new String[]{};
                    ServiceController.this.server.invoke(this.objectName, name, args, sig);
                }
                catch (Exception e) {
                    throw JMXExceptionDecoder.decode((Throwable)e);
                }
            }
            return null;
        }
    }
}

