/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import java.net.URL;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.system.ConfigurationException;
import org.jboss.util.Classes;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServiceCreator {
    private static final String XMBEAN_CODE = "org.jboss.mx.modelmbean.XMBean";
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$system$ServiceCreator == null ? (class$org$jboss$system$ServiceCreator = ServiceCreator.class$("org.jboss.system.ServiceCreator")) : class$org$jboss$system$ServiceCreator));
    private MBeanServer server;
    static /* synthetic */ Class class$org$jboss$system$ServiceCreator;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$lang$String;

    public ServiceCreator(MBeanServer server) {
        this.server = server;
    }

    public ObjectInstance install(ObjectName mbeanName, ObjectName loaderName, Element mbeanElement) throws Exception {
        if (this.server.isRegistered(mbeanName)) {
            throw new DeploymentException("Trying to install an already registered mbean: " + mbeanName);
        }
        String code = mbeanElement.getAttribute("code");
        if (code == null || "".equals(code)) {
            throw new ConfigurationException("missing 'code' attribute");
        }
        ConstructorInfo constructor = ConstructorInfo.create(mbeanElement);
        String xmbeandd = mbeanElement.getAttribute("xmbean-dd");
        try {
            if (xmbeandd == null || "".equals(xmbeandd)) {
                log.debug((Object)("About to create bean: " + mbeanName + " with code: " + code));
                ObjectInstance instance = this.server.createMBean(code, mbeanName, loaderName, constructor.params, constructor.signature);
                log.debug((Object)("Created bean: " + mbeanName));
                return instance;
            }
            log.debug((Object)("About to create xmbean object: " + mbeanName + " with code: " + code));
            Object resource = this.server.instantiate(code, loaderName, constructor.params, constructor.signature);
            URL xmbeanddUrl = null;
            try {
                xmbeanddUrl = resource.getClass().getClassLoader().getResource(xmbeandd);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (xmbeanddUrl == null) {
                xmbeanddUrl = new URL(xmbeandd);
            }
            ObjectInstance instance = this.server.createMBean(XMBEAN_CODE, mbeanName, loaderName, new Object[]{resource, xmbeanddUrl}, new String[]{(class$java$lang$Object == null ? (class$java$lang$Object = ServiceCreator.class$("java.lang.Object")) : class$java$lang$Object).getName(), (class$java$net$URL == null ? (class$java$net$URL = ServiceCreator.class$("java.net.URL")) : class$java$net$URL).getName()});
            log.debug((Object)("Created bean: " + mbeanName));
            return instance;
        }
        catch (Exception e) {
            Throwable newE = JMXExceptionDecoder.decode((Throwable)e);
            if (newE instanceof ClassNotFoundException) {
                log.debug((Object)("Class not found for mbean: " + mbeanName));
                throw (ClassNotFoundException)newE;
            }
            try {
                this.server.unregisterMBean(mbeanName);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (newE instanceof Exception) {
                throw (Exception)newE;
            }
            throw e;
        }
    }

    public void remove(ObjectName name) throws Exception {
        String domain = name.getDomain();
        if (domain == null || "".equals(domain)) {
            name = new ObjectName(this.server.getDefaultDomain() + name);
        }
        this.server.unregisterMBean(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ConstructorInfo {
        public static final Object[] EMPTY_PARAMS = new Object[0];
        public static final String[] EMPTY_SIGNATURE = new String[0];
        public String[] signature = EMPTY_SIGNATURE;
        public Object[] params = EMPTY_PARAMS;

        private ConstructorInfo() {
        }

        public static ConstructorInfo create(Element element) throws ConfigurationException {
            ConstructorInfo info = new ConstructorInfo();
            NodeList list = element.getElementsByTagName("constructor");
            if (list.getLength() > 1) {
                throw new ConfigurationException("only one <constructor> element may be defined");
            }
            if (list.getLength() == 1) {
                element = (Element)list.item(0);
                list = element.getElementsByTagName("arg");
                int length = list.getLength();
                info.params = new Object[length];
                info.signature = new String[length];
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                int j = 0;
                while (j < length) {
                    Element arg = (Element)list.item(j);
                    String signature = arg.getAttribute("type");
                    String value = arg.getAttribute("value");
                    Object realValue = value;
                    if (signature != null) {
                        PropertyEditor editor;
                        Class<?> typeClass = Classes.getPrimitiveTypeForName((String)signature);
                        if (typeClass == null) {
                            try {
                                typeClass = loader.loadClass(signature);
                            }
                            catch (ClassNotFoundException e) {
                                throw new ConfigurationException("Class not found for type: " + signature, e);
                            }
                        }
                        if ((editor = PropertyEditorManager.findEditor(typeClass)) == null) {
                            try {
                                Class[] sig = new Class[]{class$java$lang$String == null ? ServiceCreator.class$("java.lang.String") : class$java$lang$String};
                                Constructor<?> ctor = typeClass.getConstructor(sig);
                                Object[] args = new Object[]{value};
                                realValue = ctor.newInstance(args);
                            }
                            catch (Exception e) {
                                throw new ConfigurationException("No property editor for type: " + typeClass);
                            }
                        } else {
                            editor.setAsText(value);
                            realValue = editor.getValue();
                        }
                    }
                    info.signature[j] = signature;
                    info.params[j] = realValue;
                    ++j;
                }
            }
            return info;
        }
    }
}

