/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.deployment.Deployer;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.DeploymentInfoComparator;
import org.jboss.deployment.DeploymentSorter;
import org.jboss.deployment.DeploymentState;
import org.jboss.deployment.IncompleteDeploymentException;
import org.jboss.deployment.JARDeployer;
import org.jboss.deployment.MainDeployerMBean;
import org.jboss.deployment.SubDeployer;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.file.Files;
import org.jboss.util.file.JarUtils;
import org.jboss.util.stream.Streams;

public class MainDeployer
extends ServiceMBeanSupport
implements Deployer,
MainDeployerMBean {
    private ObjectName serviceController;
    private final LinkedList deployers = new LinkedList();
    private final Map deploymentMap = new HashMap();
    private final List deploymentList = new ArrayList();
    private final List waitingDeployments = new ArrayList();
    private final Comparator sorter = new DeploymentSorter();
    private final Comparator infoSorter = new DeploymentInfoComparator(this.sorter);
    private boolean copyFiles = true;
    private File tempDir;
    private String tempDirString;
    private String nativePrefix;
    private String nativeSuffix;

    public MainDeployer() {
        String localCopy = System.getProperty("jboss.deploy.localcopy");
        if (localCopy != null && (localCopy.equalsIgnoreCase("false") || localCopy.equalsIgnoreCase("no") || localCopy.equalsIgnoreCase("off"))) {
            this.log.debug((Object)"Disabling local copies of file: urls");
            this.copyFiles = false;
        }
    }

    public void setServiceController(ObjectName serviceController) {
        this.serviceController = serviceController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection listDeployed() {
        this.log.info((Object)("deployment list string: " + this.deploymentList));
        List list = this.deploymentList;
        synchronized (list) {
            return new ArrayList(this.deploymentList);
        }
    }

    public String listDeployedAsString() {
        return "<pre>" + this.listDeployed() + "</pre>";
    }

    public Collection listIncompletelyDeployed() {
        ArrayList<DeploymentInfo> id = new ArrayList<DeploymentInfo>();
        Iterator i = this.deploymentList.iterator();
        while (i.hasNext()) {
            DeploymentInfo di = (DeploymentInfo)i.next();
            if ("Deployed".equals(di.status) || "Starting".equals(di.status)) continue;
            id.add(di);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection listWaitingForDeployer() {
        List list = this.waitingDeployments;
        synchronized (list) {
            return new ArrayList(this.waitingDeployments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeployer(SubDeployer deployer) {
        this.log.info((Object)("Adding deployer: " + deployer));
        LinkedList linkedList = this.deployers;
        synchronized (linkedList) {
            this.deployers.addFirst(deployer);
        }
        Notification msg = new Notification("org.jboss.deployment.MainDeployer.addDeployer", this, this.getNextNotificationSequenceNumber());
        msg.setUserData(deployer.getServiceName());
        this.sendNotification(msg);
        List list = this.waitingDeployments;
        synchronized (list) {
            ArrayList copy = new ArrayList(this.waitingDeployments);
            this.waitingDeployments.clear();
            Iterator i = copy.iterator();
            while (i.hasNext()) {
                DeploymentInfo di = (DeploymentInfo)i.next();
                this.log.debug((Object)("trying to deploy with new deployer: " + di.shortName));
                try {
                    di.setServer(this.server);
                    this.deploy(di);
                }
                catch (DeploymentException e) {
                    this.log.error((Object)"DeploymentException while trying to deploy a package with a new deployer", (Throwable)((Object)e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeployer(SubDeployer deployer) {
        this.log.info((Object)("Removing deployer: " + deployer));
        boolean removed = false;
        LinkedList linkedList = this.deployers;
        synchronized (linkedList) {
            removed = this.deployers.remove(deployer);
        }
        if (removed) {
            Notification msg = new Notification("org.jboss.deployment.MainDeployer.removeDeployer", this, this.getNextNotificationSequenceNumber());
            msg.setUserData(deployer.getServiceName());
            this.sendNotification(msg);
        }
        ArrayList copy = null;
        List list = this.deploymentList;
        synchronized (list) {
            copy = new ArrayList(this.deploymentList);
        }
        Iterator i = copy.iterator();
        while (i.hasNext()) {
            DeploymentInfo di = (DeploymentInfo)i.next();
            if (di.deployer != deployer) continue;
            this.undeploy(di);
            di.deployer = null;
            List list2 = this.waitingDeployments;
            synchronized (list2) {
                this.waitingDeployments.add(di);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection listDeployers() {
        ArrayList<ObjectName> deployerNames = new ArrayList<ObjectName>();
        LinkedList linkedList = this.deployers;
        synchronized (linkedList) {
            int n = 0;
            while (n < this.deployers.size()) {
                SubDeployer deployer = (SubDeployer)this.deployers.get(n);
                ObjectName name = deployer.getServiceName();
                deployerNames.add(name);
                ++n;
            }
        }
        return deployerNames;
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? MainDeployerMBean.OBJECT_NAME : name;
    }

    protected void createService() throws Exception {
        ServerConfig config = ServerConfigLocator.locate();
        File basedir = config.getServerTempDir();
        this.tempDir = new File(basedir, "deploy");
        Files.delete((File)this.tempDir);
        this.tempDir.mkdirs();
        this.tempDirString = this.tempDir.toURL().toString();
    }

    public void shutdown() {
        int deployCounter = 0;
        ArrayList copyDeployments = new ArrayList(this.deploymentList);
        ListIterator i = copyDeployments.listIterator(copyDeployments.size());
        while (i.hasPrevious()) {
            try {
                this.undeploy((DeploymentInfo)i.previous(), true);
                ++deployCounter;
            }
            catch (Exception e) {
                this.log.info((Object)"exception trying to undeploy during shutdown", (Throwable)e);
            }
        }
        this.log.debug((Object)("Undeployed " + deployCounter + " deployed packages"));
    }

    public void redeploy(String urlspec) throws DeploymentException, MalformedURLException {
        this.redeploy(new URL(urlspec));
    }

    public void redeploy(URL url) throws DeploymentException {
        DeploymentInfo sdi = this.getDeployment(url);
        if (sdi != null) {
            this.redeploy(sdi);
        } else {
            this.deploy(url);
        }
    }

    public void redeploy(DeploymentInfo sdi) throws DeploymentException {
        try {
            this.undeploy(sdi);
        }
        catch (Throwable t) {
            this.log.info((Object)"Throwable from undeployment attempt: ", t);
        }
        sdi.setServer(this.server);
        this.deploy(sdi);
    }

    public void undeploy(URL url) throws DeploymentException {
        DeploymentInfo sdi = this.getDeployment(url);
        if (sdi != null) {
            this.undeploy(sdi);
        }
    }

    public void undeploy(String urlspec) throws DeploymentException, MalformedURLException {
        this.undeploy(new URL(urlspec));
    }

    public void undeploy(DeploymentInfo di) {
        this.undeploy(di, false);
    }

    protected void undeploy(DeploymentInfo di, boolean isShutdown) {
        this.log.debug((Object)("Undeploying " + di.url));
        this.stop(di);
        this.destroy(di);
    }

    private void stop(DeploymentInfo di) {
        try {
            if (di.deployer != null) {
                di.deployer.stop(di);
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Undeployment failed: " + di.url), t);
        }
        ArrayList reverseSortedSubs = new ArrayList(di.subDeployments);
        Collections.sort(reverseSortedSubs, this.infoSorter);
        Collections.reverse(reverseSortedSubs);
        Iterator subs = reverseSortedSubs.iterator();
        while (subs.hasNext()) {
            DeploymentInfo sub = (DeploymentInfo)subs.next();
            this.log.debug((Object)("Stopping sub deployment: " + sub.url));
            this.stop(sub);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy(DeploymentInfo di) {
        Object sub;
        try {
            if (di.deployer != null) {
                di.deployer.destroy(di);
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Undeployment failed: " + di.url), t);
        }
        ArrayList reverseSortedSubs = new ArrayList(di.subDeployments);
        Collections.sort(reverseSortedSubs, this.infoSorter);
        Collections.reverse(reverseSortedSubs);
        Iterator subs = reverseSortedSubs.iterator();
        while (subs.hasNext()) {
            sub = (DeploymentInfo)subs.next();
            this.log.debug((Object)("Destroying sub deployment: " + ((DeploymentInfo)sub).url));
            this.destroy((DeploymentInfo)sub);
        }
        try {
            sub = this.deploymentList;
            synchronized (sub) {
                this.deploymentMap.remove(di.url);
                if (this.deploymentList.lastIndexOf(di) != -1) {
                    this.deploymentList.remove(this.deploymentList.lastIndexOf(di));
                }
            }
            List list = this.waitingDeployments;
            synchronized (list) {
                this.waitingDeployments.remove(di);
            }
            di.cleanup();
            this.log.debug((Object)("Undeployed " + di.url));
        }
        catch (Throwable t) {
            this.log.error((Object)("Undeployment cleanup failed: " + di.url), t);
        }
    }

    public void deploy(String urlspec) throws DeploymentException, MalformedURLException {
        URL url;
        try {
            url = new URL(urlspec);
        }
        catch (MalformedURLException e) {
            File file = new File(urlspec);
            url = file.toURL();
        }
        this.deploy(url);
    }

    public void deploy(URL url) throws DeploymentException {
        DeploymentInfo sdi = this.getDeployment(url);
        if (sdi == null) {
            sdi = new DeploymentInfo(url, null, this.getServer());
            this.deploy(sdi);
        }
        if (sdi.state != DeploymentState.STARTED) {
            this.checkIncompleteDeployments();
        }
    }

    public void deploy(DeploymentInfo deployment) throws DeploymentException {
        if (this.isDeployed(deployment.url)) {
            this.log.info((Object)("Package: " + deployment.url + " is already deployed"));
            return;
        }
        this.log.info((Object)("Starting deployment of package: " + deployment.url));
        boolean inited = false;
        try {
            inited = this.init(deployment);
        }
        catch (Throwable t) {
            this.log.error((Object)("Could not initialise deloyment: " + deployment.url), t);
            DeploymentException.rethrowAsDeploymentException("Could not initialise deployment: " + deployment.url, t);
        }
        if (inited) {
            this.create(deployment);
            this.start(deployment);
            this.log.info((Object)("Deployed package: " + deployment.url));
        } else {
            this.log.info((Object)("Deployment of package: " + deployment.url + " is waiting for an appropriate deployer."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean init(DeploymentInfo deployment) throws DeploymentException {
        Object localCP;
        block38: {
            if (this.isDeployed(deployment.url)) {
                this.log.info((Object)("Package: " + deployment.url + " is already deployed"));
                return false;
            }
            this.log.debug((Object)("Starting deployment (init step) of package at: " + deployment.url));
            if (deployment.localUrl == null) {
                this.makeLocalCopy(deployment);
                localCP = new URL[]{deployment.localUrl};
                deployment.localCl = new URLClassLoader((URL[])localCP);
            }
            this.findDeployer(deployment);
            if (deployment.deployer != null) break block38;
            deployment.state = DeploymentState.INIT_WAITING_DEPLOYER;
            this.log.info((Object)("deployment waiting for deployer: " + deployment.url));
            localCP = this.waitingDeployments;
            synchronized (localCP) {
                this.waitingDeployments.add(deployment);
            }
            boolean bl = false;
            try {
                URL url = deployment.localUrl == null ? deployment.url : deployment.localUrl;
                long lastModified = -1L;
                lastModified = url.getProtocol().equals("file") ? new File(url.getFile()).lastModified() : url.openConnection().getLastModified();
                deployment.lastModified = lastModified;
                deployment.lastDeployed = System.currentTimeMillis();
            }
            catch (IOException ignore) {
                deployment.lastModified = System.currentTimeMillis();
                deployment.lastDeployed = System.currentTimeMillis();
            }
            List ignore = this.deploymentList;
            synchronized (ignore) {
                if (!this.inLocalCopyDir(deployment.url)) {
                    this.deploymentList.add(deployment);
                    this.log.debug((Object)("Watching new file: " + deployment.url));
                }
            }
            return bl;
        }
        deployment.state = DeploymentState.INIT_DEPLOYER;
        deployment.deployer.init(deployment);
        deployment.createClassLoaders();
        deployment.state = DeploymentState.INITIALIZED;
        localCP = this.deploymentList;
        synchronized (localCP) {
            this.deploymentMap.put(deployment.url, deployment);
        }
        this.parseManifestLibraries(deployment);
        this.log.debug((Object)("found " + deployment.subDeployments.size() + " subpackages of " + deployment.url));
        ArrayList sortedSubs = new ArrayList(deployment.subDeployments);
        Collections.sort(sortedSubs, this.infoSorter);
        ListIterator lt = sortedSubs.listIterator();
        while (lt.hasNext()) {
            this.init((DeploymentInfo)lt.next());
        }
        try {
            URL url = deployment.localUrl == null ? deployment.url : deployment.localUrl;
            long lastModified = -1L;
            lastModified = url.getProtocol().equals("file") ? new File(url.getFile()).lastModified() : url.openConnection().getLastModified();
            deployment.lastModified = lastModified;
            deployment.lastDeployed = System.currentTimeMillis();
        }
        catch (IOException ignore) {
            deployment.lastModified = System.currentTimeMillis();
            deployment.lastDeployed = System.currentTimeMillis();
        }
        List ignore = this.deploymentList;
        synchronized (ignore) {
            if (!this.inLocalCopyDir(deployment.url)) {
                this.deploymentList.add(deployment);
                this.log.debug((Object)("Watching new file: " + deployment.url));
            }
        }
        catch (Exception e) {
            try {
                deployment.state = DeploymentState.FAILED;
                DeploymentException.rethrowAsDeploymentException("exception in init of " + deployment.url, e);
            }
            catch (Throwable throwable) {
                try {
                    URL url = deployment.localUrl == null ? deployment.url : deployment.localUrl;
                    long lastModified = -1L;
                    lastModified = url.getProtocol().equals("file") ? new File(url.getFile()).lastModified() : url.openConnection().getLastModified();
                    deployment.lastModified = lastModified;
                    deployment.lastDeployed = System.currentTimeMillis();
                }
                catch (IOException ignore2) {
                    deployment.lastModified = System.currentTimeMillis();
                    deployment.lastDeployed = System.currentTimeMillis();
                }
                List list = this.deploymentList;
                synchronized (list) {
                    if (!this.inLocalCopyDir(deployment.url)) {
                        this.deploymentList.add(deployment);
                        this.log.debug((Object)("Watching new file: " + deployment.url));
                    }
                }
                throw throwable;
            }
            try {
                URL url = deployment.localUrl == null ? deployment.url : deployment.localUrl;
                long lastModified = -1L;
                lastModified = url.getProtocol().equals("file") ? new File(url.getFile()).lastModified() : url.openConnection().getLastModified();
                deployment.lastModified = lastModified;
                deployment.lastDeployed = System.currentTimeMillis();
            }
            catch (IOException ignore3) {
                deployment.lastModified = System.currentTimeMillis();
                deployment.lastDeployed = System.currentTimeMillis();
            }
            List list = this.deploymentList;
            synchronized (list) {
                if (!this.inLocalCopyDir(deployment.url)) {
                    this.deploymentList.add(deployment);
                    this.log.debug((Object)("Watching new file: " + deployment.url));
                }
            }
        }
        return true;
    }

    private void create(DeploymentInfo deployment) throws DeploymentException {
        block4: {
            this.log.debug((Object)("create step for deployment " + deployment.url));
            try {
                ArrayList sortedSubs = new ArrayList(deployment.subDeployments);
                Collections.sort(sortedSubs, this.infoSorter);
                ListIterator lt = sortedSubs.listIterator();
                while (lt.hasNext()) {
                    this.create((DeploymentInfo)lt.next());
                }
                deployment.state = DeploymentState.CREATE_SUBDEPLOYMENTS;
                if (deployment.deployer != null) {
                    deployment.state = DeploymentState.CREATE_DEPLOYER;
                    deployment.deployer.create(deployment);
                    deployment.state = DeploymentState.CREATED;
                    deployment.status = "Created";
                    this.log.debug((Object)("Done with create step of deploying " + deployment.shortName));
                    break block4;
                }
                this.log.debug((Object)("Still no deployer for package in create step: " + deployment.shortName));
            }
            catch (Throwable t) {
                this.log.error((Object)("could not create deployment: " + deployment.url), t);
                deployment.status = "Deployment FAILED reason: " + t.getMessage();
                deployment.state = DeploymentState.FAILED;
                DeploymentException.rethrowAsDeploymentException("Could not create deployment: " + deployment.url, t);
            }
        }
    }

    private void start(DeploymentInfo deployment) throws DeploymentException {
        block4: {
            deployment.status = "Starting";
            this.log.debug((Object)("Begin deployment start " + deployment.url));
            try {
                ArrayList sortedSubs = new ArrayList(deployment.subDeployments);
                Collections.sort(sortedSubs, this.infoSorter);
                ListIterator lt = sortedSubs.listIterator();
                while (lt.hasNext()) {
                    this.start((DeploymentInfo)lt.next());
                }
                deployment.state = DeploymentState.START_SUBDEPLOYMENTS;
                if (deployment.deployer != null) {
                    deployment.state = DeploymentState.START_DEPLOYER;
                    deployment.deployer.start(deployment);
                    Object[] args = new Object[]{deployment, DeploymentState.STARTED};
                    String[] sig = new String[]{"org.jboss.deployment.DeploymentInfo", "org.jboss.deployment.DeploymentState"};
                    this.server.invoke(this.serviceController, "validateDeploymentState", args, sig);
                    deployment.status = "Deployed";
                    this.log.debug((Object)("End deployment start on package: " + deployment.shortName));
                    break block4;
                }
                this.log.debug((Object)("Still no deployer for package in start step: " + deployment.shortName));
            }
            catch (Throwable t) {
                this.log.error((Object)("could not start deployment: " + deployment.url), t);
                deployment.state = DeploymentState.FAILED;
                deployment.status = "Deployment FAILED reason: " + t.getMessage();
                DeploymentException.rethrowAsDeploymentException("Could not create deployment: " + deployment.url, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findDeployer(DeploymentInfo sdi) {
        if (sdi.deployer != null) {
            this.log.debug((Object)("using existing deployer " + sdi.deployer));
            return;
        }
        LinkedList linkedList = this.deployers;
        synchronized (linkedList) {
            Iterator iterator = this.deployers.iterator();
            while (iterator.hasNext()) {
                SubDeployer deployer = (SubDeployer)iterator.next();
                if (!deployer.accepts(sdi)) continue;
                sdi.deployer = deployer;
                this.log.debug((Object)("using deployer " + deployer));
                return;
            }
        }
        this.log.debug((Object)("No deployer found for url: " + sdi.url));
    }

    private void parseManifestLibraries(DeploymentInfo sdi) {
        String classPath = null;
        Manifest mf = sdi.getManifest();
        if (mf != null) {
            Attributes mainAttributes = mf.getMainAttributes();
            classPath = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
        }
        if (classPath != null) {
            StringTokenizer st = new StringTokenizer(classPath);
            this.log.debug((Object)("resolveLibraries: " + classPath));
            while (st.hasMoreTokens()) {
                URL lib = null;
                String tk = st.nextToken();
                Object sub = null;
                this.log.debug((Object)("new manifest entry for sdi at " + sdi.shortName + " entry is " + tk));
                try {
                    if (sdi.isDirectory) {
                        File parentDir = new File(sdi.url.getPath()).getParentFile();
                        lib = new File(parentDir, tk).toURL();
                    } else {
                        lib = new URL(sdi.url, tk);
                    }
                    if (this.deploymentMap.containsKey(lib)) continue;
                    DeploymentInfo mfRef = new DeploymentInfo(lib, null, this.getServer());
                    this.makeLocalCopy(mfRef);
                    URL[] localURL = new URL[]{mfRef.localUrl};
                    mfRef.localCl = new URLClassLoader(localURL);
                    this.findDeployer(mfRef);
                    SubDeployer deployer = mfRef.deployer;
                    if (deployer instanceof JARDeployer || deployer == null) {
                        sdi.addLibraryJar(lib);
                        continue;
                    }
                    this.log.debug((Object)("Found non-jar deployer(" + sub.deployer + "), delaying deployment of: " + sub));
                }
                catch (Exception ignore) {
                    this.log.debug((Object)("The manifest entry in " + sdi.url + " references URL " + lib + " which could not be opened, entry ignored"));
                }
            }
        }
    }

    private void makeLocalCopy(DeploymentInfo sdi) {
        try {
            if (sdi.url.getProtocol().equals("file") && (!this.copyFiles || sdi.isDirectory)) {
                sdi.localUrl = sdi.url;
                return;
            }
            if (this.inLocalCopyDir(sdi.url)) {
                sdi.localUrl = sdi.url;
                return;
            }
            String shortName = sdi.shortName;
            File localFile = File.createTempFile("tmp", shortName, this.tempDir);
            sdi.localUrl = localFile.toURL();
            this.copy(sdi.url, localFile);
        }
        catch (Exception e) {
            this.log.error((Object)("Could not make local copy for " + sdi.url), (Throwable)e);
        }
    }

    private boolean inLocalCopyDir(URL url) {
        int i = 0;
        String urlTest = url.toString();
        if (urlTest.startsWith("jar:")) {
            i = 4;
        }
        return urlTest.startsWith(this.tempDirString, i);
    }

    protected void copy(URL src, File dest) throws IOException {
        File srcFile;
        boolean deleted;
        boolean created;
        File dir = dest.getParentFile();
        if (!dir.exists() && !(created = dir.mkdirs())) {
            throw new IOException("mkdirs failed for: " + dir.getAbsolutePath());
        }
        if (dest.exists() && !(deleted = Files.delete((File)dest))) {
            throw new IOException("delete of previous content failed for: " + dest.getAbsolutePath());
        }
        if (src.getProtocol().equals("file") && (srcFile = new File(src.getFile())).isDirectory()) {
            this.log.debug((Object)("Making zip copy of: " + srcFile));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
            JarUtils.jar((OutputStream)out, (File[])srcFile.listFiles());
            ((OutputStream)out).close();
            return;
        }
        BufferedInputStream in = new BufferedInputStream(src.openStream());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
        Streams.copy((InputStream)in, (OutputStream)out);
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        ((InputStream)in).close();
    }

    public boolean isDeployed(String url) throws MalformedURLException {
        return this.isDeployed(new URL(url));
    }

    public boolean isDeployed(URL url) {
        DeploymentInfo di = this.getDeployment(url);
        if (di == null) {
            return false;
        }
        return di.state == DeploymentState.STARTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentInfo getDeployment(URL url) {
        List list = this.deploymentList;
        synchronized (list) {
            return (DeploymentInfo)this.deploymentMap.get(url);
        }
    }

    public URL getWatchUrl(URL url) {
        DeploymentInfo info = this.getDeployment(url);
        return info == null ? null : info.watch;
    }

    public void checkIncompleteDeployments() throws DeploymentException {
        try {
            Collection waitingForClasses = (Collection)this.server.invoke(this.serviceController, "listWaitingMBeans", new Object[0], new String[0]);
            Collection waitingForDepends = (Collection)this.server.invoke(this.serviceController, "listIncompletelyDeployed", new Object[0], new String[0]);
            IncompleteDeploymentException ide = new IncompleteDeploymentException(waitingForClasses, waitingForDepends, this.listIncompletelyDeployed(), this.listWaitingForDeployer());
            if (!ide.isEmpty()) {
                throw ide;
            }
        }
        catch (JMException jme) {
            throw new DeploymentException(JMXExceptionDecoder.decode((Throwable)jme));
        }
    }
}

