/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.JBossEntityResolver;
import org.jboss.deployment.SARDeployerMBean;
import org.jboss.deployment.SubDeployer;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.net.protocol.URLLister;
import org.jboss.net.protocol.URLListerFactory;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.Strings;
import org.jboss.util.stream.Streams;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SARDeployer
extends SubDeployerSupport
implements SubDeployer,
SARDeployerMBean {
    private ServiceControllerMBean serviceController;
    private File dataDir;
    private URL serverHomeURL;
    static /* synthetic */ Class class$org$jboss$system$ServiceControllerMBean;

    public boolean accepts(DeploymentInfo di) {
        String urlStr = di.url.toString();
        return urlStr.endsWith("sar") || urlStr.endsWith("sar/") || urlStr.endsWith("service.xml");
    }

    public void init(DeploymentInfo di) throws DeploymentException {
        try {
            di.watch = di.url.getPath().endsWith("/") ? new URL(di.url, "META-INF/jboss-service.xml") : di.url;
            this.parseDocument(di);
            NodeList loaders = di.document.getElementsByTagName("loader-repository");
            if (loaders.getLength() > 0) {
                Element loader = (Element)loaders.item(0);
                LoaderRepositoryFactory.LoaderRepositoryConfig config = LoaderRepositoryFactory.parseRepositoryConfig((Element)loader);
                di.setRepositoryInfo(config);
            }
            this.parseXMLClasspath(di);
            NodeList lds = di.document.getElementsByTagName("local-directory");
            this.log.debug((Object)("about to copy " + lds.getLength() + " local directories"));
            int i = 0;
            while (i < lds.getLength()) {
                Element ld = (Element)lds.item(i);
                String path = ld.getAttribute("path");
                this.log.debug((Object)("about to copy local directory at " + path));
                this.log.debug((Object)("copying from " + di.localUrl + path + " -> " + this.dataDir));
                this.inflateJar(di.localUrl, this.dataDir, path);
                ++i;
            }
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
        super.init(di);
    }

    public void create(DeploymentInfo di) throws DeploymentException {
        try {
            this.log.debug((Object)("Deploying SAR, create step: url " + di.url));
            ObjectName uclName = di.ucl.getObjectName();
            if (!this.getServer().isRegistered(uclName)) {
                this.log.debug((Object)("Registering service UCL=" + uclName));
                this.getServer().registerMBean(di.ucl, uclName);
            }
            List mbeans = di.mbeans;
            mbeans.clear();
            List descriptorMbeans = this.serviceController.install(di.document.getDocumentElement(), uclName);
            mbeans.addAll(descriptorMbeans);
            Iterator iter = di.mbeans.iterator();
            while (iter.hasNext()) {
                ObjectName service = (ObjectName)iter.next();
                this.serviceController.create(service);
            }
            super.create(di);
        }
        catch (Exception e) {
            this.log.debug((Object)("create operation failed for package " + di.url), (Throwable)e);
            this.destroy(di);
            throw new DeploymentException("create operation failed for package " + di.url, e);
        }
    }

    public void start(DeploymentInfo di) throws DeploymentException {
        this.log.debug((Object)("Deploying SAR, start step: url " + di.url));
        try {
            Iterator iter = di.mbeans.iterator();
            while (iter.hasNext()) {
                ObjectName service = (ObjectName)iter.next();
                this.serviceController.start(service);
            }
            super.start(di);
        }
        catch (Exception e) {
            this.stop(di);
            this.destroy(di);
            throw new DeploymentException("start operation failed on package " + di.url, e);
        }
    }

    protected File[] listFiles(String urlspec) throws Exception {
        URL url = Strings.toURL((String)urlspec);
        File dir = new File(url.getFile());
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                String name = pathname.getName().toLowerCase();
                return name.endsWith(".jar") || name.endsWith(".zip");
            }
        });
        return files;
    }

    protected void parseXMLClasspath(DeploymentInfo di) throws Exception {
        ArrayList<URL> classpath = new ArrayList<URL>();
        URLListerFactory listerFactory = new URLListerFactory();
        NodeList children = di.document.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element classpathElement;
            if (children.item(i).getNodeType() == 1 && (classpathElement = (Element)children.item(i)).getTagName().equals("classpath")) {
                URL codebaseUrl;
                this.log.debug((Object)("Found classpath element: " + classpathElement));
                if (!classpathElement.hasAttribute("codebase")) {
                    throw new DeploymentException("Invalid classpath element missing codebase: " + classpathElement);
                }
                String codebase = classpathElement.getAttribute("codebase").trim();
                codebase = Strings.replaceProperties((String)codebase);
                String archives = null;
                if (classpathElement.hasAttribute("archives")) {
                    archives = classpathElement.getAttribute("archives").trim();
                    if ("".equals(archives = Strings.replaceProperties((String)archives))) {
                        archives = null;
                    }
                }
                if (".".equals(codebase)) {
                    codebaseUrl = new URL(di.url, "./");
                } else {
                    if (archives != null && !codebase.endsWith("/")) {
                        codebase = codebase + "/";
                    }
                    codebaseUrl = new URL(this.serverHomeURL, codebase);
                }
                this.log.debug((Object)("codebase URL is " + codebaseUrl));
                if (archives == null) {
                    classpath.add(codebaseUrl);
                    this.log.debug((Object)"added codebase to classpath");
                } else {
                    this.log.debug((Object)("listing codebase for archives matching " + archives));
                    URLLister lister = listerFactory.createURLLister(codebaseUrl);
                    this.log.debug((Object)("URLLister class is " + lister.getClass().getName()));
                    classpath.addAll(lister.listMembers(codebaseUrl, archives));
                }
            }
            ++i;
        }
        Iterator jars = classpath.iterator();
        while (jars.hasNext()) {
            URL neededURL = (URL)jars.next();
            di.addLibraryJar(neededURL);
            this.log.debug((Object)("deployed classes for " + neededURL));
        }
    }

    public void stop(DeploymentInfo di) {
        this.log.debug((Object)("undeploying document " + di.url));
        List services = di.mbeans;
        int lastService = services.size();
        ListIterator i = services.listIterator(lastService);
        while (i.hasPrevious()) {
            ObjectName name = (ObjectName)i.previous();
            this.log.debug((Object)("stopping mbean " + name));
            try {
                this.serviceController.stop(name);
            }
            catch (Exception e) {
                this.log.error((Object)("Could not stop mbean: " + name), (Throwable)e);
            }
        }
        try {
            super.stop(di);
        }
        catch (Exception ignore) {}
    }

    public void destroy(DeploymentInfo di) {
        List services = di.mbeans;
        int lastService = services.size();
        ListIterator i = services.listIterator(lastService);
        while (i.hasPrevious()) {
            ObjectName name = (ObjectName)i.previous();
            this.log.debug((Object)("destroying mbean " + name));
            try {
                this.serviceController.destroy(name);
            }
            catch (Exception e) {
                this.log.error((Object)("Could not destroy mbean: " + name), (Throwable)e);
            }
        }
        ListIterator i2 = services.listIterator(lastService);
        while (i2.hasPrevious()) {
            ObjectName name = (ObjectName)i2.previous();
            this.log.debug((Object)("removing mbean " + name));
            try {
                this.serviceController.remove(name);
            }
            catch (Exception e) {
                this.log.error((Object)("Could not remove mbean: " + name), (Throwable)e);
            }
        }
        try {
            ObjectName uclName = di.ucl.getObjectName();
            if (this.getServer().isRegistered(uclName)) {
                this.log.debug((Object)("Unregistering service UCL=" + uclName));
                this.getServer().unregisterMBean(uclName);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            super.destroy(di);
        }
        catch (Exception ignore) {}
    }

    protected void startService() throws Exception {
        super.startService();
        this.serviceController = (ServiceControllerMBean)MBeanProxyExt.create((Class)(class$org$jboss$system$ServiceControllerMBean == null ? (class$org$jboss$system$ServiceControllerMBean = SARDeployer.class$("org.jboss.system.ServiceControllerMBean")) : class$org$jboss$system$ServiceControllerMBean), (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)this.server);
        ServerConfig config = ServerConfigLocator.locate();
        this.dataDir = config.getServerDataDir();
        this.serverHomeURL = config.getServerHomeURL();
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? SARDeployerMBean.OBJECT_NAME : name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseDocument(DeploymentInfo di) throws Exception {
        InputStream stream = null;
        try {
            if (di.document == null) {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                URL docURL = di.localUrl;
                URLClassLoader localCL = di.localCl;
                if (!di.isXML) {
                    docURL = localCL.findResource("META-INF/jboss-service.xml");
                }
                if (docURL == null) {
                    throw new DeploymentException("Failed to find META-INF/jboss-service.xml");
                }
                stream = docURL.openStream();
                InputSource is = new InputSource(stream);
                is.setSystemId(docURL.toString());
                parser.setEntityResolver(new JBossEntityResolver());
                di.document = parser.parse(is);
            } else {
                this.log.debug((Object)"Using existing deployment.document");
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                stream.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (Exception ignore) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void inflateJar(URL url, File destDir, String path) throws DeploymentException, IOException {
        String filename = url.getFile();
        JarFile jarFile = new JarFile(filename);
        try {
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                File outFile;
                JarEntry entry = e.nextElement();
                String name = entry.getName();
                if (path != null && !name.startsWith(path) || (outFile = new File(destDir, name)).exists()) continue;
                if (entry.isDirectory()) {
                    outFile.mkdirs();
                    continue;
                }
                Streams.copyb((InputStream)jarFile.getInputStream(entry), (OutputStream)new FileOutputStream(outFile));
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            jarFile.close();
            throw throwable;
        }
        jarFile.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

