/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.ServiceContext;
import org.jboss.system.ServiceController;
import org.jboss.system.ServiceCreator;
import org.jboss.util.Classes;
import org.jboss.util.Strings;
import org.jboss.util.xml.DOMWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ServiceConfigurator {
    private final MBeanServer server;
    private final ServiceController serviceController;
    private final ServiceCreator serviceCreator;
    private final Logger log = Logger.getLogger(this.getClass());
    static /* synthetic */ Class class$org$jboss$util$propertyeditor$PropertyEditors;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    public ServiceConfigurator(MBeanServer server, ServiceController serviceController, ServiceCreator serviceCreator) {
        this.server = server;
        this.serviceController = serviceController;
        this.serviceCreator = serviceCreator;
    }

    /*
     * Unable to fully structure code
     */
    public List install(Element config, ObjectName loaderName) throws DeploymentException {
        mbeans = new ArrayList<E>();
        try {
            if (config.getTagName().equals("mbean")) {
                this.internalInstall(config, mbeans, loaderName);
            } else {
                nl = config.getChildNodes();
                i = 0;
                while (i < nl.getLength()) {
                    if (nl.item(i).getNodeType() == 1 && (element = (Element)nl.item(i)).getTagName().equals("mbean")) {
                        mbean = (Element)nl.item(i);
                        this.internalInstall(mbean, mbeans, loaderName);
                    }
                    ++i;
                }
            }
            return mbeans;
        }
        catch (Exception e) {
            li = mbeans.listIterator(mbeans.size());
            ** while (li.hasPrevious())
        }
lbl-1000:
        // 1 sources

        {
            mbean = (ObjectName)li.previous();
            try {
                this.serviceCreator.remove(mbean);
            }
            catch (Exception n) {
                this.log.error((Object)("exception removing mbean after failed deployment: " + mbean), (Throwable)n);
            }
            continue;
        }
lbl27:
        // 1 sources

        if (e instanceof DeploymentException) {
            throw (DeploymentException)e;
        }
        throw new DeploymentException(e);
    }

    private ObjectName internalInstall(Element mbeanElement, List mbeans, ObjectName loaderName) throws Exception {
        ObjectName mbeanName;
        block4: {
            ObjectInstance instance = null;
            mbeanName = this.parseObjectName(mbeanElement);
            try {
                instance = this.serviceCreator.install(mbeanName, loaderName, mbeanElement);
            }
            catch (ClassNotFoundException cnfe) {
                this.log.warn((Object)"Failed to complete install", (Throwable)cnfe);
                this.serviceController.registerWaitingForClass(mbeanName, mbeanElement);
                mbeans.add(mbeanName);
                return mbeanName;
            }
            this.serviceController.registerMBeanClassName(instance);
            mbeanName = instance.getObjectName();
            mbeans.add(mbeanName);
            if (mbeanName == null) break block4;
            ServiceContext ctx = this.serviceController.createServiceContext(mbeanName);
            try {
                this.configure(mbeanName, loaderName, mbeanElement, mbeans);
                ctx.state = ServiceContext.CONFIGURED;
                ctx.problem = null;
            }
            catch (Exception e) {
                ctx.state = ServiceContext.FAILED;
                ctx.problem = e;
                this.log.info((Object)("Problem configuring service " + mbeanName), (Throwable)e);
            }
        }
        return mbeanName;
    }

    protected void configure(ObjectName objectName, ObjectName loaderName, Element mbeanElement, List mbeans) throws Exception {
        MBeanInfo info;
        boolean debug = this.log.isDebugEnabled();
        try {
            info = this.server.getMBeanInfo(objectName);
        }
        catch (InstanceNotFoundException e) {
            throw new DeploymentException("trying to configure nonexistent mbean: " + objectName);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not get mbeanInfo", JMXExceptionDecoder.decode((Throwable)e));
        }
        if (info == null) {
            throw new DeploymentException("MBeanInfo is null for mbean: " + objectName);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        MBeanAttributeInfo[] attributes = info.getAttributes();
        NodeList attrs = mbeanElement.getChildNodes();
        int j = 0;
        while (j < attrs.getLength()) {
            block45: {
                if (attrs.item(j).getNodeType() == 1) {
                    Element element = (Element)attrs.item(j);
                    if (element.getTagName().equals("attribute")) {
                        String trimAttr;
                        String attributeName = element.getAttribute("name");
                        boolean replace = true;
                        boolean trim = true;
                        String replaceAttr = element.getAttribute("replace");
                        if (replaceAttr.length() > 0) {
                            replace = Boolean.valueOf(replaceAttr);
                        }
                        if ((trimAttr = element.getAttribute("trim")).length() > 0) {
                            trim = Boolean.valueOf(trimAttr);
                        }
                        if (element.hasChildNodes()) {
                            String attributeText = this.getElementContent(element, trim);
                            int k = 0;
                            while (k < attributes.length) {
                                if (attributeName.equals(attributes[k].getName())) {
                                    String typeName = attributes[k].getType();
                                    Class<?> typeClass = Classes.getPrimitiveTypeForName((String)typeName);
                                    if (typeClass == null) {
                                        try {
                                            typeClass = cl.loadClass(typeName);
                                        }
                                        catch (ClassNotFoundException e) {
                                            throw new DeploymentException("Class not found for attribute: " + attributeName, e);
                                        }
                                    }
                                    Object value = null;
                                    if (typeClass.equals(class$org$w3c$dom$Element == null ? ServiceConfigurator.class$("org.w3c.dom.Element") : class$org$w3c$dom$Element)) {
                                        NodeList nl = element.getChildNodes();
                                        int i = 0;
                                        while (i < nl.getLength()) {
                                            Node n = nl.item(i);
                                            if (n.getNodeType() == 1) {
                                                value = n;
                                                break;
                                            }
                                            ++i;
                                        }
                                    }
                                    if (value == null) {
                                        PropertyEditor editor = PropertyEditorManager.findEditor(typeClass);
                                        if (editor == null) {
                                            throw new DeploymentException("No property editor for attribute: " + attributeName + "; type=" + typeClass);
                                        }
                                        if (replace) {
                                            attributeText = Strings.replaceProperties((String)attributeText);
                                        }
                                        editor.setAsText(attributeText);
                                        value = editor.getValue();
                                    }
                                    this.log.debug((Object)(attributeName + " set to " + value + " in " + objectName));
                                    this.setAttribute(objectName, new Attribute(attributeName, value));
                                    break block45;
                                }
                                ++k;
                            }
                            throw new DeploymentException("No Attribute found with name: " + attributeName);
                        }
                    } else if (element.getTagName().equals("depends")) {
                        String proxyType;
                        if (!element.hasChildNodes()) {
                            throw new DeploymentException("No ObjectName supplied for depends in  " + objectName);
                        }
                        String mbeanRefName = element.getAttribute("optional-attribute-name");
                        if ("".equals(mbeanRefName)) {
                            mbeanRefName = null;
                        }
                        if ("".equals(proxyType = element.getAttribute("proxy-type"))) {
                            proxyType = null;
                        }
                        ObjectName dependsObjectName = this.processDependency(objectName, loaderName, element, mbeans);
                        if (debug) {
                            this.log.debug((Object)("considering " + (mbeanRefName == null ? "<anonymous>" : mbeanRefName.toString()) + " with object name " + dependsObjectName));
                        }
                        if (mbeanRefName != null) {
                            Object attribute = dependsObjectName;
                            if (proxyType != null) {
                                if (mbeanRefName == null) {
                                    throw new DeploymentException("You cannot use a proxy-type without an optional-attribute-name");
                                }
                                if (proxyType.equals("attribute")) {
                                    int k = 0;
                                    while (k < attributes.length) {
                                        if (mbeanRefName.equals(attributes[k].getName())) {
                                            proxyType = attributes[k].getType();
                                            break;
                                        }
                                        ++k;
                                    }
                                    if (proxyType.equals("attribute")) {
                                        throw new DeploymentException("Attribute not found :" + mbeanRefName);
                                    }
                                }
                                Class<?> proxyClass = cl.loadClass(proxyType);
                                attribute = MBeanProxyExt.create(proxyClass, (ObjectName)dependsObjectName, (MBeanServer)this.server);
                            }
                            this.setAttribute(objectName, new Attribute(mbeanRefName, attribute));
                        }
                    } else if (element.getTagName().equals("depends-list")) {
                        String dependsListName = element.getAttribute("optional-attribute-name");
                        if ("".equals(dependsListName)) {
                            dependsListName = null;
                        }
                        NodeList dependsList = element.getChildNodes();
                        ArrayList<ObjectName> dependsListNames = new ArrayList<ObjectName>();
                        int l = 0;
                        while (l < dependsList.getLength()) {
                            Element dependsElement;
                            if (dependsList.item(l).getNodeType() == 1 && (dependsElement = (Element)dependsList.item(l)).getTagName().equals("depends-list-element")) {
                                if (!dependsElement.hasChildNodes()) {
                                    throw new DeploymentException("Empty depends-list-element!");
                                }
                                ObjectName dependsObjectName = this.processDependency(objectName, loaderName, dependsElement, mbeans);
                                if (!dependsListNames.contains(dependsObjectName)) {
                                    dependsListNames.add(dependsObjectName);
                                }
                            }
                            ++l;
                        }
                        if (dependsListName != null) {
                            this.setAttribute(objectName, new Attribute(dependsListName, dependsListNames));
                        }
                    }
                }
            }
            ++j;
        }
        try {
            ObjectName serviceBindingMgr = new ObjectName("jboss.system:service=ServiceBindingManager");
            Object[] args = new Object[]{objectName};
            String[] sig = new String[]{"javax.management.ObjectName"};
            this.server.invoke(serviceBindingMgr, "applyServiceConfig", args, sig);
        }
        catch (InstanceNotFoundException ignore) {
        }
        catch (Exception e) {
            Throwable t = JMXExceptionDecoder.decode((Throwable)e);
            this.log.warn((Object)"Failed to apply service binding override", t);
        }
    }

    private ObjectName processDependency(ObjectName container, ObjectName loaderName, Element element, List mbeans) throws Exception {
        ObjectName dependsObjectName = null;
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node childNode = nl.item(i);
            if (childNode.getNodeType() == 1) {
                Element child = (Element)childNode;
                if (child.getTagName().equals("mbean")) {
                    dependsObjectName = this.internalInstall(child, mbeans, loaderName);
                    break;
                }
                throw new DeploymentException("Non mbean child element in depends tag: " + child);
            }
            ++i;
        }
        if (dependsObjectName == null) {
            String name = this.getElementContent(element, true);
            dependsObjectName = ObjectNameFactory.create((String)name);
        }
        if (dependsObjectName == null) {
            throw new DeploymentException("No object name found for attribute!");
        }
        this.serviceController.registerDependency(container, dependsObjectName);
        return dependsObjectName;
    }

    private void setAttribute(ObjectName name, Attribute attr) throws Exception {
        try {
            this.server.setAttribute(name, attr);
        }
        catch (Exception e) {
            throw new DeploymentException("Exception setting attribute " + attr + " on mbean " + name, JMXExceptionDecoder.decode((Throwable)e));
        }
    }

    public String getConfiguration(ObjectName[] objectNames) throws Exception {
        StringWriter out = new StringWriter();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element serverElement = doc.createElement("server");
        int j = 0;
        while (j < objectNames.length) {
            Element mbeanElement = this.internalGetConfiguration(doc, objectNames[j]);
            serverElement.appendChild(mbeanElement);
            ++j;
        }
        doc.appendChild(serverElement);
        new DOMWriter((Writer)out, false).print((Node)doc, true);
        ((Writer)out).close();
        return ((Object)out).toString();
    }

    Element getConfiguration(ObjectName name) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        return this.internalGetConfiguration(doc, name);
    }

    private Element internalGetConfiguration(Document doc, ObjectName name) throws Exception {
        Element mbeanElement = doc.createElement("mbean");
        mbeanElement.setAttribute("name", name.toString());
        MBeanInfo info = this.server.getMBeanInfo(name);
        mbeanElement.setAttribute("code", info.getClassName());
        MBeanAttributeInfo[] attributes = info.getAttributes();
        boolean trace = this.log.isTraceEnabled();
        int i = 0;
        while (i < attributes.length) {
            if (trace) {
                this.log.trace((Object)("considering attribute: " + attributes[i]));
            }
            if (attributes[i].isReadable() && attributes[i].isWritable()) {
                Element attributeElement = null;
                if (attributes[i].getType().equals("javax.management.ObjectName")) {
                    attributeElement = doc.createElement("depends");
                    attributeElement.setAttribute("optional-attribute-name", attributes[i].getName());
                } else {
                    attributeElement = doc.createElement("attribute");
                    attributeElement.setAttribute("name", attributes[i].getName());
                }
                Object value = this.server.getAttribute(name, attributes[i].getName());
                if (value != null) {
                    if (value instanceof Element) {
                        attributeElement.appendChild(doc.importNode((Element)value, true));
                    } else {
                        attributeElement.appendChild(doc.createTextNode(value.toString()));
                    }
                }
                mbeanElement.appendChild(attributeElement);
            }
            ++i;
        }
        ServiceContext sc = this.serviceController.getServiceContext(name);
        Iterator i2 = sc.iDependOn.iterator();
        while (i2.hasNext()) {
            ServiceContext needs = (ServiceContext)i2.next();
            Element dependsElement = doc.createElement("depends");
            dependsElement.appendChild(doc.createTextNode(needs.objectName.toString()));
            mbeanElement.appendChild(dependsElement);
        }
        return mbeanElement;
    }

    private ObjectName parseObjectName(Element element) throws Exception {
        String name = element.getAttribute("name");
        if (name == null || name.trim().equals("")) {
            throw new DeploymentException("MBean attribute 'name' must be given.");
        }
        return new ObjectName(name);
    }

    private String getElementContent(Element element, boolean trim) throws Exception {
        NodeList nl = element.getChildNodes();
        String attributeText = "";
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n instanceof Text) {
                attributeText = attributeText + ((Text)n).getData();
            }
            ++i;
        }
        if (trim) {
            attributeText = attributeText.trim();
        }
        return attributeText;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Class clazz = class$org$jboss$util$propertyeditor$PropertyEditors == null ? (class$org$jboss$util$propertyeditor$PropertyEditors = ServiceConfigurator.class$("org.jboss.util.propertyeditor.PropertyEditors")) : class$org$jboss$util$propertyeditor$PropertyEditors;
    }
}

