/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.log4j.NDC;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBean;
import org.jboss.util.Classes;

public class ServiceMBeanSupport
extends NotificationBroadcasterSupport
implements ServiceMBean,
MBeanRegistration {
    protected Logger log;
    protected MBeanServer server;
    protected ObjectName serviceName;
    private int state = 7;
    private SynchronizedLong sequenceNumber = new SynchronizedLong(0L);

    public ServiceMBeanSupport() {
        this.log = Logger.getLogger((String)this.getClass().getName());
        this.log.trace((Object)"Constructing");
    }

    public ServiceMBeanSupport(Class type) {
        this(type.getName());
    }

    public ServiceMBeanSupport(String category) {
        this(Logger.getLogger((String)category));
    }

    public ServiceMBeanSupport(Logger log) {
        this.log = log;
        log.trace((Object)"Constructing");
    }

    public String getName() {
        return Classes.stripPackageName((String)this.log.getName());
    }

    public ObjectName getServiceName() {
        return this.serviceName;
    }

    public MBeanServer getServer() {
        return this.server;
    }

    public int getState() {
        return this.state;
    }

    public String getStateString() {
        return ServiceMBean.states[this.state];
    }

    public Logger getLog() {
        return this.log;
    }

    public void create() throws Exception {
        NDC.push((String)this.getName());
        this.log.debug((Object)"Creating");
        try {
            try {
                this.createService();
                this.state = 6;
            }
            catch (Exception e) {
                this.log.error((Object)"Initialization failed", (Throwable)e);
                throw e;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            NDC.pop();
            NDC.remove();
            throw throwable;
        }
        NDC.pop();
        NDC.remove();
        this.log.debug((Object)"Created");
    }

    public void start() throws Exception {
        if (this.state == 2 || this.state == 3) {
            return;
        }
        this.state = 2;
        long now = System.currentTimeMillis();
        AttributeChangeNotification stateChange = new AttributeChangeNotification(this, this.getNextNotificationSequenceNumber(), now, this.getName() + " starting", "State", "java.lang.Integer", new Integer(0), new Integer(2));
        this.sendNotification(stateChange);
        this.log.debug((Object)"Starting");
        NDC.push((String)this.getName());
        try {
            try {
                this.startService();
            }
            catch (Exception e) {
                this.state = 4;
                now = System.currentTimeMillis();
                stateChange = new AttributeChangeNotification(this, this.getNextNotificationSequenceNumber(), now, this.getName() + " failed", "State", "java.lang.Integer", new Integer(2), new Integer(4));
                stateChange.setUserData(e);
                this.sendNotification(stateChange);
                this.log.error((Object)"Starting failed", (Throwable)e);
                throw e;
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            NDC.pop();
            NDC.remove();
            throw throwable;
        }
        NDC.pop();
        NDC.remove();
        this.state = 3;
        now = System.currentTimeMillis();
        stateChange = new AttributeChangeNotification(this, this.getNextNotificationSequenceNumber(), now, this.getName() + " started", "State", "java.lang.Integer", new Integer(2), new Integer(3));
        this.sendNotification(stateChange);
        this.log.info((Object)("Started " + this.getServiceName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.state != 3) {
            return;
        }
        this.state = 1;
        long now = System.currentTimeMillis();
        AttributeChangeNotification stateChange = new AttributeChangeNotification(this, this.getNextNotificationSequenceNumber(), now, this.getName() + " stopping", "State", "java.lang.Integer", new Integer(3), new Integer(1));
        this.sendNotification(stateChange);
        this.log.info((Object)("Stopping " + this.getServiceName()));
        NDC.push((String)this.getName());
        try {
            try {
                this.stopService();
            }
            catch (Throwable e) {
                this.state = 4;
                now = System.currentTimeMillis();
                stateChange = new AttributeChangeNotification(this, this.getNextNotificationSequenceNumber(), now, this.getName() + " failed", "State", "java.lang.Integer", new Integer(1), new Integer(4));
                stateChange.setUserData(e);
                this.sendNotification(stateChange);
                this.log.error((Object)"Stopping failed", e);
                Object var6_4 = null;
                NDC.pop();
                NDC.remove();
                return;
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            NDC.pop();
            NDC.remove();
            throw throwable;
        }
        NDC.pop();
        NDC.remove();
        this.state = 0;
        now = System.currentTimeMillis();
        stateChange = new AttributeChangeNotification(this, this.getNextNotificationSequenceNumber(), now, this.getName() + " stopped", "State", "java.lang.Integer", new Integer(1), new Integer(0));
        this.sendNotification(stateChange);
        this.log.debug((Object)"Stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroy() {
        block6: {
            if (this.state == 5) {
                return;
            }
            if (this.state != 0) {
                this.stop();
            }
            this.log.debug((Object)"Destroying");
            NDC.push((String)this.getName());
            try {
                try {
                    this.destroyService();
                }
                catch (Throwable t) {
                    this.log.error((Object)"Destroying failed", t);
                    Object var3_2 = null;
                    NDC.pop();
                    NDC.remove();
                    break block6;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                NDC.pop();
                NDC.remove();
                throw throwable;
            }
            NDC.pop();
            NDC.remove();
        }
        this.state = 5;
        this.log.debug((Object)"Destroyed");
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.serviceName = this.getObjectName(server, name);
        return this.serviceName;
    }

    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            this.log.info((Object)"Registration is not done -> stop");
            this.stop();
        } else {
            this.state = 8;
        }
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        this.stop();
        this.server = null;
        this.serviceName = null;
        this.state = 7;
    }

    protected long getNextNotificationSequenceNumber() {
        return this.sequenceNumber.increment();
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name;
    }

    protected void createService() throws Exception {
    }

    protected void startService() throws Exception {
    }

    protected void stopService() throws Exception {
    }

    protected void destroyService() throws Exception {
    }
}

