/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class ServerConfigUtil {
    private static final String ANY = "0.0.0.0";

    public static String getDefaultBindAddress() {
        return System.getProperty("jboss.bind.address");
    }

    public static String getSpecificBindAddress() {
        String address = System.getProperty("jboss.bind.address");
        if (address == null || address.equals(ANY)) {
            return null;
        }
        return address;
    }

    public static InetAddress fixRemoteAddress(InetAddress address) {
        try {
            if (address == null || InetAddress.getByName(ANY).equals(address)) {
                return InetAddress.getLocalHost();
            }
        }
        catch (UnknownHostException ignored) {}
        return address;
    }

    public static String fixRemoteAddress(String address) {
        try {
            if (address == null || ANY.equals(address)) {
                return InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException ignored) {}
        return address;
    }
}

