/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.Version;
import org.jboss.deployment.IncompleteDeploymentException;
import org.jboss.deployment.MainDeployerMBean;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.net.protocol.URLStreamHandlerFactory;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.system.server.Server;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigImpl;
import org.jboss.system.server.ServerConfigImplMBean;
import org.jboss.system.server.ServerImplMBean;
import org.jboss.util.StopWatch;
import org.jboss.util.UnexpectedThrowable;
import org.jboss.util.file.FileSuffixFilter;
import org.jboss.util.file.Files;

public class ServerImpl
implements Server,
ServerImplMBean,
NotificationBroadcaster {
    private static final ObjectName DEFAULT_LOADER_NAME = ObjectNameFactory.create((String)"JMImplementation:service=LoaderRepository,name=Default");
    private Logger log;
    private final Version version = Version.getInstance();
    private final Package jbossPackage = Package.getPackage("org.jboss");
    private ServerConfigImpl config;
    private MBeanServer server;
    private Date startDate;
    private boolean started;
    private ShutdownHook shutdownHook;
    private LifeThread lifeThread;
    private NotificationBroadcasterSupport broadcasterSupport;
    static /* synthetic */ Class class$org$jboss$system$server$Server;
    static /* synthetic */ Class class$org$jboss$deployment$MainDeployerMBean;
    static /* synthetic */ Class class$javax$management$ObjectName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Properties props) throws IllegalStateException, Exception {
        if (props == null) {
            throw new IllegalArgumentException("props is null");
        }
        if (this.config != null) {
            throw new IllegalStateException("already initialized");
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.doInit(props);
            Object var4_3 = null;
            Thread.currentThread().setContextClassLoader(oldCL);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Thread.currentThread().setContextClassLoader(oldCL);
            throw throwable;
        }
    }

    private void doInit(Properties props) throws Exception {
        this.config = new ServerConfigImpl(props);
        this.broadcasterSupport = new NotificationBroadcasterSupport();
        boolean overrideTmpDir = Boolean.getBoolean("jboss.server.temp.dir.overrideJavaTmpDir");
        if (overrideTmpDir) {
            File serverTmpDir = this.config.getServerTempDir();
            System.setProperty("java.io.tmpdir", serverTmpDir.getCanonicalPath());
        }
        this.log = Logger.getLogger((Class)(class$org$jboss$system$server$Server == null ? (class$org$jboss$system$server$Server = ServerImpl.class$("org.jboss.system.server.Server")) : class$org$jboss$system$server$Server));
        this.initURLHandlers();
        this.config.initURLs();
        this.log.info((Object)"Starting JBoss (MX MicroKernel)...");
        this.log.info((Object)("Release ID: " + this.jbossPackage.getImplementationTitle() + " " + this.jbossPackage.getImplementationVersion()));
        this.log.debug((Object)("Using config: " + this.config));
        this.log.debug((Object)("Server type: " + this.getClass()));
        this.log.info((Object)("Home Dir: " + this.config.getHomeDir()));
        this.log.info((Object)("Home URL: " + this.config.getHomeURL()));
        this.log.info((Object)("Library URL: " + this.config.getLibraryURL()));
        this.log.info((Object)("Patch URL: " + this.config.getPatchURL()));
        this.log.info((Object)("Server Name: " + this.config.getServerName()));
        this.log.info((Object)("Server Home Dir: " + this.config.getServerHomeDir()));
        this.log.info((Object)("Server Home URL: " + this.config.getServerHomeURL()));
        this.log.info((Object)("Server Data Dir: " + this.config.getServerDataDir()));
        this.log.info((Object)("Server Temp Dir: " + this.config.getServerTempDir()));
        this.log.info((Object)("Server Config URL: " + this.config.getServerConfigURL()));
        this.log.info((Object)("Server Library URL: " + this.config.getServerLibraryURL()));
        this.log.info((Object)("Root Deployment Filename: " + this.config.getRootDeploymentFilename()));
    }

    private void initURLHandlers() {
        if (this.config.getRequireJBossURLStreamHandlerFactory()) {
            this.internalInitURLHandlers();
        } else {
            try {
                this.internalInitURLHandlers();
            }
            catch (SecurityException e) {
                this.log.warn((Object)"You do not have permissions to set URLStreamHandlerFactory", (Throwable)e);
            }
            catch (Error e) {
                this.log.warn((Object)"URLStreamHandlerFactory already set", (Throwable)e);
            }
        }
    }

    private void internalInitURLHandlers() {
        URL.setURLStreamHandlerFactory((java.net.URLStreamHandlerFactory)new URLStreamHandlerFactory());
        URLStreamHandlerFactory.preload();
        String handlerPkgs = System.getProperty("java.protocol.handler.pkgs");
        handlerPkgs = handlerPkgs != null ? handlerPkgs + "|org.jboss.net.protocol" : "org.jboss.net.protocol";
        System.setProperty("java.protocol.handler.pkgs", handlerPkgs);
    }

    public ServerConfig getConfig() throws IllegalStateException {
        if (this.config == null) {
            throw new IllegalStateException("not initialized");
        }
        return this.config;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() throws IllegalStateException, Exception {
        this.getConfig();
        if (this.started) {
            throw new IllegalStateException("already started");
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                try {
                    this.doStart();
                }
                catch (Exception e) {
                    JMXExceptionDecoder.rethrow((Exception)e);
                }
                Object var4_4 = null;
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            catch (Throwable t) {
                this.log.debug((Object)"Failed to start", t);
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new UnexpectedThrowable(t);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            Thread.currentThread().setContextClassLoader(oldCL);
            throw throwable;
        }
    }

    private void doStart() throws Exception {
        StopWatch watch = new StopWatch(true);
        this.startDate = new Date();
        this.log.info((Object)"Starting General Purpose Architecture (GPA)...");
        this.server = MBeanServerFactory.createMBeanServer("jboss");
        this.log.debug((Object)("Created MBeanServer: " + this.server));
        this.server.registerMBean(this, ServerImplMBean.OBJECT_NAME);
        this.server.registerMBean(this.config, ServerConfigImplMBean.OBJECT_NAME);
        UnifiedClassLoader ucl = this.initBootLibraries();
        Thread.currentThread().setContextClassLoader((ClassLoader)ucl);
        this.createMBean("org.jboss.system.server.ServerInfo");
        ObjectName controller = this.createMBean("org.jboss.system.ServiceController");
        ObjectName mainDeployer = this.startBootService(controller, "org.jboss.deployment.MainDeployer");
        this.server.setAttribute(mainDeployer, new Attribute("ServiceController", controller));
        this.shutdownHook = new ShutdownHook(controller, mainDeployer);
        this.shutdownHook.setDaemon(true);
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            this.log.debug((Object)"Shutdown hook added");
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to add shutdown hook; ignoring", (Throwable)e);
        }
        this.startBootService(controller, "org.jboss.deployment.JARDeployer");
        this.startBootService(controller, "org.jboss.deployment.SARDeployer");
        this.log.info((Object)"Core system initialized");
        MainDeployerMBean md = (MainDeployerMBean)MBeanProxyExt.create((Class)(class$org$jboss$deployment$MainDeployerMBean == null ? (class$org$jboss$deployment$MainDeployerMBean = ServerImpl.class$("org.jboss.deployment.MainDeployerMBean")) : class$org$jboss$deployment$MainDeployerMBean), (ObjectName)mainDeployer, (MBeanServer)this.server);
        try {
            md.deploy(this.config.getServerConfigURL() + this.config.getRootDeploymentFilename());
        }
        catch (IncompleteDeploymentException e) {
            this.log.error((Object)"Root deployment has missing dependencies; continuing", (Throwable)((Object)e));
        }
        this.lifeThread = new LifeThread();
        this.lifeThread.start();
        watch.stop();
        this.log.info((Object)("JBoss (MX MicroKernel) [" + this.jbossPackage.getImplementationVersion() + "] Started in " + watch));
        this.started = true;
        Notification msg = new Notification("org.jboss.system.server.started", this, 1L);
        msg.setUserData(new Long(watch.getLapTime()));
        this.sendNotification(msg);
    }

    private ObjectName createMBean(String classname) throws Exception {
        ObjectName name = this.server.createMBean(classname, null).getObjectName();
        this.log.debug((Object)("Created system MBean: " + name));
        return name;
    }

    private ObjectName startBootService(ObjectName controllerName, String classname) throws Exception {
        ObjectName name = this.createMBean(classname);
        Object[] args = new Object[]{name};
        String[] sig = new String[]{(class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = ServerImpl.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName()};
        this.server.invoke(controllerName, "create", args, sig);
        this.server.invoke(controllerName, "start", args, sig);
        return name;
    }

    private UnifiedClassLoader initBootLibraries() throws Exception {
        boolean debug = this.log.isDebugEnabled();
        ArrayList<URL> list = new ArrayList<URL>();
        URL patchURL = this.config.getPatchURL();
        if (patchURL != null) {
            if (patchURL.getProtocol().equals("file")) {
                File dir = new File(patchURL.getFile());
                if (dir.exists()) {
                    list.add(dir.toURL());
                    File[] jars = dir.listFiles((FileFilter)new FileSuffixFilter(new String[]{".jar", ".zip"}, true));
                    int j = 0;
                    while (jars != null && j < jars.length) {
                        list.add(jars[j].getCanonicalFile().toURL());
                        ++j;
                    }
                }
            } else {
                list.add(patchURL);
            }
        }
        list.add(this.config.getServerConfigURL());
        this.log.debug((Object)("Boot url list: " + list));
        UnifiedClassLoader loader = null;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            URL url = (URL)iter.next();
            if (debug) {
                this.log.debug((Object)("Creating loader for URL: " + url));
            }
            Object[] args = new Object[]{url, Boolean.TRUE};
            String[] sig = new String[]{"java.net.URL", "boolean"};
            loader = (UnifiedClassLoader)this.server.invoke(DEFAULT_LOADER_NAME, "newClassLoader", args, sig);
        }
        return loader;
    }

    public void shutdown() throws IllegalStateException {
        if (!this.started) {
            throw new IllegalStateException("not started");
        }
        ServerImpl server = this;
        this.log.info((Object)"Shutting down");
        boolean exitOnShutdown = this.config.getExitOnShutdown();
        boolean blockingShutdown = this.config.getBlockingShutdown();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("exitOnShutdown: " + exitOnShutdown));
            this.log.debug((Object)("blockingShutdown: " + blockingShutdown));
        }
        this.lifeThread.interrupt();
        if (exitOnShutdown) {
            server.exit(0);
        } else if (blockingShutdown) {
            this.shutdownHook.shutdown();
        } else {
            new Thread(){

                public void run() {
                    ServerImpl.this.shutdownHook.shutdown();
                }
            }.start();
        }
    }

    public void exit(final int exitcode) {
        new Thread(){

            public void run() {
                ServerImpl.this.log.info((Object)"Shutting down the JVM now!");
                Runtime.getRuntime().exit(exitcode);
            }
        }.start();
    }

    public void exit() {
        this.exit(1);
    }

    public void halt(final int exitcode) {
        Notification msg = new Notification("org.jboss.system.server.stopped", this, 2L);
        this.sendNotification(msg);
        new Thread(){

            public void run() {
                System.err.println("Halting the system now!");
                Runtime.getRuntime().halt(exitcode);
            }
        }.start();
    }

    public void halt() {
        this.halt(1);
    }

    private void logMemoryUsage(Runtime rt) {
        this.log.info((Object)("Total/free memory: " + rt.totalMemory() + "/" + rt.freeMemory()));
    }

    public void runGarbageCollector() {
        Runtime rt = Runtime.getRuntime();
        this.logMemoryUsage(rt);
        rt.gc();
        this.log.info((Object)"Hinted to the JVM to run garbage collection");
        this.logMemoryUsage(rt);
    }

    public void runFinalization() {
        Runtime.getRuntime().runFinalization();
        this.log.info((Object)"Hinted to the JVM to run any pending object finalizations");
    }

    public void traceMethodCalls(Boolean flag) {
        Runtime.getRuntime().traceMethodCalls(flag);
    }

    public void traceInstructions(Boolean flag) {
        Runtime.getRuntime().traceInstructions(flag);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public String getVersion() {
        return this.version.toString();
    }

    public String getVersionName() {
        return this.version.getName();
    }

    public String getBuildNumber() {
        return this.version.getBuildNumber();
    }

    public String getBuildID() {
        return this.version.getBuildID();
    }

    public String getBuildDate() {
        return this.version.getBuildDate();
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.broadcasterSupport.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcasterSupport.removeNotificationListener(listener);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.broadcasterSupport.getNotificationInfo();
    }

    public void sendNotification(Notification notification) {
        this.broadcasterSupport.sendNotification(notification);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ShutdownHook
    extends Thread {
        private ObjectName controller;
        private ObjectName mainDeployer;
        private boolean forceHalt = true;

        public ShutdownHook(ObjectName controller, ObjectName mainDeployer) {
            super("JBoss Shutdown Hook");
            this.controller = controller;
            this.mainDeployer = mainDeployer;
            String value = System.getProperty("jboss.shutdown.forceHalt", null);
            if (value != null) {
                this.forceHalt = new Boolean(value);
            }
        }

        public void run() {
            this.shutdown();
            if (this.forceHalt) {
                System.out.println("Halting VM");
                Runtime.getRuntime().halt(0);
            }
        }

        public void shutdown() {
            ServerImpl.this.log.info((Object)"JBoss SHUTDOWN: Undeploying all packages");
            this.shutdownDeployments();
            ServerImpl.this.log.info((Object)"Shutting down all services");
            System.out.println("Shutting down");
            this.shutdownServices();
            this.removeMBeans();
            ServerImpl.this.log.debug((Object)"Deleting server tmp/deploy directory");
            File tmp = ServerImpl.this.config.getServerTempDir();
            File tmpDeploy = new File(tmp, "deploy");
            Files.delete((File)tmpDeploy);
            ServerImpl.this.log.info((Object)"Shutdown complete");
            System.out.println("Shutdown complete");
        }

        protected void shutdownDeployments() {
            try {
                ServerImpl.this.server.invoke(this.mainDeployer, "shutdown", new Object[0], new String[0]);
            }
            catch (Exception e) {
                Throwable t = JMXExceptionDecoder.decode((Throwable)e);
                ServerImpl.this.log.error((Object)"Failed to shutdown deployer", t);
            }
        }

        protected void shutdownServices() {
            try {
                ServerImpl.this.server.invoke(this.controller, "shutdown", new Object[0], new String[0]);
            }
            catch (Exception e) {
                Throwable t = JMXExceptionDecoder.decode((Throwable)e);
                ServerImpl.this.log.error((Object)"Failed to shutdown services", t);
            }
        }

        protected void removeMBeans() {
            Throwable t;
            try {
                ServerImpl.this.server.unregisterMBean(ServiceControllerMBean.OBJECT_NAME);
                ServerImpl.this.server.unregisterMBean(ServerConfigImplMBean.OBJECT_NAME);
                ServerImpl.this.server.unregisterMBean(ServerImplMBean.OBJECT_NAME);
            }
            catch (Exception e) {
                t = JMXExceptionDecoder.decode((Throwable)e);
                ServerImpl.this.log.error((Object)"Failed to unregister mbeans", t);
            }
            try {
                MBeanServerFactory.releaseMBeanServer(ServerImpl.this.server);
            }
            catch (Exception e) {
                t = JMXExceptionDecoder.decode((Throwable)e);
                ServerImpl.this.log.error((Object)"Failed to release mbean server", t);
            }
        }
    }

    private class LifeThread
    extends Thread {
        Object lock = new Object();

        private LifeThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            ServerImpl.this.log.info((Object)"LifeThread.run exits!");
        }
    }
}

