/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.tm.GlobalId;
import org.jboss.tm.JBossRollbackException;
import org.jboss.tm.TransactionLocal;
import org.jboss.tm.TransactionManagerService;
import org.jboss.tm.TxManager;
import org.jboss.tm.XidFactory;
import org.jboss.tm.XidFactoryMBean;
import org.jboss.util.timeout.Timeout;
import org.jboss.util.timeout.TimeoutFactory;
import org.jboss.util.timeout.TimeoutTarget;

class TransactionImpl
implements Transaction,
TimeoutTarget {
    private static final int HEUR_NONE = 4;
    private static final int RS_NEW = 0;
    private static final int RS_ENLISTED = 1;
    private static final int RS_SUSPENDED = 2;
    private static final int RS_ENDED = 3;
    private static final int RS_VOTE_READONLY = 4;
    private static final int RS_VOTE_OK = 5;
    private static final int RS_FORGOT = 6;
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$tm$TransactionImpl == null ? (class$org$jboss$tm$TransactionImpl = TransactionImpl.class$("org.jboss.tm.TransactionImpl")) : class$org$jboss$tm$TransactionImpl));
    private boolean trace = log.isTraceEnabled();
    private Xid xid;
    private ArrayList threads = new ArrayList(1);
    private HashMap transactionLocalMap = new HashMap();
    private Throwable cause;
    private GlobalId globalId;
    private Synchronization[] sync = new Synchronization[3];
    private int syncAllocSize = 3;
    private int syncCount = 0;
    private XAResource[] resources = new XAResource[3];
    private int[] resourceState = new int[3];
    private int[] resourceSameRM = new int[3];
    private Xid[] resourceXids = new Xid[3];
    private int resourceAllocSize = 3;
    private int resourceCount = 0;
    private boolean resourcesEnded = false;
    private long lastBranchId = 0L;
    private int status = 0;
    private int heuristicCode = 4;
    private long start;
    private Timeout timeout;
    private long timeoutPeriod;
    private boolean locked = false;
    private boolean done = false;
    static XidFactoryMBean xidFactory;
    static TransactionManagerService txManagerService;
    static /* synthetic */ Class class$org$jboss$tm$TransactionImpl;

    static void defaultXidFactory() {
        if (xidFactory == null) {
            xidFactory = new XidFactory();
        }
    }

    TransactionImpl(long timeout) {
        this.xid = xidFactory.newXid();
        this.globalId = new GlobalId(this.xid);
        this.start = System.currentTimeMillis();
        this.timeout = TimeoutFactory.createTimeout((long)(this.start + timeout), (TimeoutTarget)this);
        this.timeoutPeriod = timeout;
        if (this.trace) {
            log.trace((Object)("Created new instance for tx=" + this.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void timedOut(Timeout timeout) {
        block16: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                try {
                                    this.lock();
                                    log.warn((Object)("Transaction " + this.toString() + " timed out." + " status=" + this.getStringStatus(this.status)));
                                    if (this.timeout == null) {
                                        Object var3_2 = null;
                                        this.unlock();
                                        return;
                                    }
                                    this.timeout = null;
                                    switch (this.status) {
                                        case 3: 
                                        case 4: 
                                        case 6: {
                                            break block11;
                                        }
                                        case 9: {
                                            break block12;
                                        }
                                        case 8: {
                                            this.gotHeuristic(-1, 5);
                                            this.status = 1;
                                            break block13;
                                        }
                                        case 0: 
                                        case 2: {
                                            this.status = 1;
                                        }
                                        case 1: {
                                            this.interruptThreads();
                                            break block14;
                                        }
                                        case 7: {
                                            this.status = 1;
                                            break block15;
                                        }
                                        default: {
                                            log.warn((Object)("Unknown status at timeout, tx=" + this.toString()));
                                            break;
                                        }
                                    }
                                    break block16;
                                }
                                catch (Throwable throwable) {
                                    Object var3_9 = null;
                                    this.unlock();
                                    throw throwable;
                                }
                            }
                            Object var3_3 = null;
                            this.unlock();
                            return;
                        }
                        Object var3_4 = null;
                        this.unlock();
                        return;
                    }
                    Object var3_5 = null;
                    this.unlock();
                    return;
                }
                Object var3_6 = null;
                this.unlock();
                return;
            }
            Object var3_7 = null;
            this.unlock();
            return;
        }
        Object var3_8 = null;
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        try {
            this.lock();
            if (this.trace) {
                log.trace((Object)("Committing, tx=" + this + ", status=" + this.getStringStatus(this.status)));
            }
            switch (this.status) {
                case 7: {
                    throw new IllegalStateException("Already started preparing.");
                }
                case 2: {
                    throw new IllegalStateException("Already prepared.");
                }
                case 9: {
                    throw new IllegalStateException("Already started rolling back.");
                }
                case 4: {
                    this.instanceDone();
                    this.checkHeuristics();
                    throw new IllegalStateException("Already rolled back.");
                }
                case 8: {
                    throw new IllegalStateException("Already started committing.");
                }
                case 3: {
                    this.instanceDone();
                    this.checkHeuristics();
                    throw new IllegalStateException("Already committed.");
                }
                case 6: {
                    throw new IllegalStateException("No transaction.");
                }
                case 5: {
                    throw new IllegalStateException("Unknown state");
                }
                case 1: {
                    this.doBeforeCompletion();
                    this.endResources();
                    this.rollbackResources();
                    this.doAfterCompletion();
                    this.cancelTimeout();
                    this.instanceDone();
                    this.checkHeuristics();
                    throw new RollbackException("Already marked for rollback");
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal status: " + this.status);
                }
            }
            this.doBeforeCompletion();
            if (this.trace) {
                log.trace((Object)("Before completion done, tx=" + this + ", status=" + this.getStringStatus(this.status)));
            }
            this.endResources();
            if (this.status == 0) {
                if (this.resourceCount == 0) {
                    if (this.trace) {
                        log.trace((Object)"Zero phase commit: No resources.");
                    }
                    this.status = 3;
                } else if (this.isOneResource()) {
                    if (this.trace) {
                        log.trace((Object)"One phase commit: One resource.");
                    }
                    this.commitResources(true);
                } else {
                    if (this.trace) {
                        log.trace((Object)"Two phase commit: Many resources.");
                    }
                    if (!this.prepareResources()) {
                        boolean commitDecision;
                        boolean bl = commitDecision = this.status == 2 && (this.heuristicCode == 4 || this.heuristicCode == 7);
                        if (commitDecision) {
                            this.commitResources(false);
                        }
                    } else {
                        this.status = 3;
                    }
                }
            }
            if (this.status != 3) {
                this.rollbackResources();
                this.doAfterCompletion();
                this.cancelTimeout();
                Throwable causedByThrowable = this.cause;
                this.instanceDone();
                throw new JBossRollbackException("Unable to commit, tx=" + this.toString() + " status=" + this.getStringStatus(this.status), causedByThrowable);
            }
            this.cancelTimeout();
            this.doAfterCompletion();
            this.instanceDone();
            this.checkHeuristics();
            if (this.trace) {
                log.trace((Object)("Committed OK, tx=" + this));
            }
            Object var3_3 = null;
            this.transactionLocalMap.clear();
            this.threads.clear();
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.transactionLocalMap.clear();
            this.threads.clear();
            this.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        block9: {
            try {
                this.lock();
                if (this.trace) {
                    log.trace((Object)("rollback(): Entered, tx=" + this.toString() + " status=" + this.getStringStatus(this.status)));
                }
                switch (this.status) {
                    case 0: {
                        this.status = 1;
                    }
                    case 1: {
                        this.doBeforeCompletion();
                        this.endResources();
                        this.rollbackResources();
                        this.cancelTimeout();
                        this.doAfterCompletion();
                        this.instanceDone();
                        this.heuristicCode = 4;
                        Object var2_1 = null;
                        this.transactionLocalMap.clear();
                        this.threads.clear();
                        break;
                    }
                    case 7: {
                        this.status = 1;
                        break block9;
                    }
                    default: {
                        throw new IllegalStateException("Cannot rollback(), tx=" + this.toString() + " status=" + this.getStringStatus(this.status));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.transactionLocalMap.clear();
                this.threads.clear();
                Thread.interrupted();
                this.unlock();
                throw throwable;
            }
            Thread.interrupted();
            this.unlock();
            return;
        }
        Object var2_2 = null;
        this.transactionLocalMap.clear();
        this.threads.clear();
        Thread.interrupted();
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        if (xaRes == null) {
            throw new IllegalArgumentException("null xaRes");
        }
        if (flag != 0x4000000 && flag != 0x2000000 && flag != 0x20000000) {
            throw new IllegalArgumentException("Bad flag: " + flag);
        }
        try {
            int idx;
            block20: {
                boolean bl;
                this.lock();
                if (this.trace) {
                    log.trace((Object)("delistResource(): Entered, tx=" + this.toString() + " status=" + this.getStringStatus(this.status)));
                }
                if ((idx = this.findResource(xaRes)) == -1) {
                    throw new IllegalArgumentException("xaRes not enlisted");
                }
                switch (this.status) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 7: {
                        throw new IllegalStateException("Already started preparing.");
                    }
                    case 9: {
                        throw new IllegalStateException("Already started rolling back.");
                    }
                    case 2: {
                        throw new IllegalStateException("Already prepared.");
                    }
                    case 8: {
                        throw new IllegalStateException("Already started committing.");
                    }
                    case 3: {
                        throw new IllegalStateException("Already committed.");
                    }
                    case 4: {
                        throw new IllegalStateException("Already rolled back.");
                    }
                    case 6: {
                        throw new IllegalStateException("No transaction.");
                    }
                    case 5: {
                        throw new IllegalStateException("Unknown state");
                    }
                    default: {
                        throw new IllegalStateException("Illegal status: " + this.status);
                    }
                }
                try {
                    if (this.resourceState[idx] != 3 || this.resources[idx].isSameRM(xaRes)) break block20;
                    log.warn((Object)("Resource already delisted.  tx=" + this.toString()));
                    bl = false;
                }
                catch (XAException xae) {
                    this.logXAException(xae);
                    this.status = 1;
                    this.cause = xae;
                    boolean bl2 = false;
                    Object var7_9 = null;
                    this.unlock();
                    return bl2;
                }
                Object var7_7 = null;
                this.unlock();
                return bl;
            }
            this.endResource(idx, flag);
            boolean bl = true;
            Object var7_8 = null;
            this.unlock();
            return bl;
        }
        catch (Throwable throwable2) {
            Object var7_10 = null;
            this.unlock();
            throw throwable2;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 22[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getStatus() throws SystemException {
        if (this.done) {
            return 6;
        }
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSynchronization(Synchronization s) throws RollbackException, IllegalStateException, SystemException {
        if (s == null) {
            throw new IllegalArgumentException("Null synchronization");
        }
        try {
            this.lock();
            if (this.trace) {
                log.trace((Object)("registerSynchronization(): Entered, tx=" + this.toString() + " status=" + this.getStringStatus(this.status)));
            }
            switch (this.status) {
                case 0: 
                case 7: {
                    break;
                }
                case 2: {
                    throw new IllegalStateException("Already prepared.");
                }
                case 8: {
                    throw new IllegalStateException("Already started committing.");
                }
                case 3: {
                    throw new IllegalStateException("Already committed.");
                }
                case 1: {
                    throw new RollbackException("Already marked for rollback");
                }
                case 9: {
                    throw new RollbackException("Already started rolling back.");
                }
                case 4: {
                    throw new RollbackException("Already rolled back.");
                }
                case 6: {
                    throw new IllegalStateException("No transaction.");
                }
                case 5: {
                    throw new IllegalStateException("Unknown state");
                }
                default: {
                    throw new IllegalStateException("Illegal status: " + this.status);
                }
            }
            if (this.syncCount == this.syncAllocSize) {
                this.syncAllocSize = 2 * this.syncAllocSize;
                Synchronization[] sy = new Synchronization[this.syncAllocSize];
                System.arraycopy(this.sync, 0, sy, 0, this.syncCount);
                this.sync = sy;
            }
            this.sync[this.syncCount++] = s;
            Object var4_3 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        try {
            this.lock();
            if (this.trace) {
                log.trace((Object)("setRollbackOnly(): Entered, tx=" + this.toString() + " status=" + this.getStringStatus(this.status)));
            }
            switch (this.status) {
                case 0: 
                case 2: 
                case 7: {
                    this.status = 1;
                }
                case 1: 
                case 9: {
                    Object var2_1 = null;
                    this.unlock();
                    return;
                }
                case 8: {
                    throw new IllegalStateException("Already started committing.");
                }
                case 3: {
                    throw new IllegalStateException("Already committed.");
                }
                case 4: {
                    throw new IllegalStateException("Already rolled back.");
                }
                case 6: {
                    throw new IllegalStateException("No transaction.");
                }
                case 5: {
                    throw new IllegalStateException("Unknown state");
                }
            }
            throw new IllegalStateException("Illegal status: " + this.status);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.unlock();
            throw throwable;
        }
    }

    public void associateCurrentThread() {
        this.threads.add(Thread.currentThread());
    }

    public void disassociateCurrentThread() {
        this.threads.remove(Thread.currentThread());
        Thread.interrupted();
    }

    public void clearThreads() {
        int i = 0;
        while (i < this.threads.size()) {
            Thread thread = (Thread)this.threads.get(i);
            ++i;
        }
    }

    public int hashCode() {
        return this.globalId.hashCode();
    }

    public String toString() {
        return "TransactionImpl:" + xidFactory.toString(this.xid);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof TransactionImpl) {
            return this.globalId.equals(((TransactionImpl)obj).globalId);
        }
        return false;
    }

    boolean isDone() {
        return this.done;
    }

    GlobalId getGlobalId() {
        return this.globalId;
    }

    private void interruptThreads() {
        Iterator it = this.threads.iterator();
        while (it.hasNext()) {
            Thread thread = (Thread)it.next();
            try {
                thread.interrupt();
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        this.threads.clear();
    }

    private String getStringStatus(int status) {
        switch (status) {
            case 7: {
                return "STATUS_PREPARING";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 8: {
                return "STATUS_COMMITING";
            }
            case 3: {
                return "STATUS_COMMITED";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
            case 0: {
                return "STATUS_ACTIVE";
            }
        }
        return "STATUS_UNKNOWN(" + status + ")";
    }

    private String getStringXAErrorCode(int errorCode) {
        switch (errorCode) {
            case 7: {
                return "XA_HEURCOM";
            }
            case 8: {
                return "XA_HEURHAZ";
            }
            case 5: {
                return "XA_HEURMIX";
            }
            case 6: {
                return "XA_HEURRB";
            }
            case 9: {
                return "XA_NOMIGRATE";
            }
            case 101: {
                return "XA_RBCOMMFAIL";
            }
            case 102: {
                return "XA_RBDEADLOCK";
            }
            case 103: {
                return "XA_RBINTEGRITY";
            }
            case 104: {
                return "XA_RBOTHER";
            }
            case 105: {
                return "XA_RBPROTO";
            }
            case 100: {
                return "XA_RBROLLBACK";
            }
            case 106: {
                return "XA_RBTIMEOUT";
            }
            case 107: {
                return "XA_RBTRANSIENT";
            }
            case 3: {
                return "XA_RDONLY";
            }
            case 4: {
                return "XA_RETRY";
            }
            case -2: {
                return "XAER_ASYNC";
            }
            case -8: {
                return "XAER_DUPID";
            }
            case -5: {
                return "XAER_INVAL";
            }
            case -4: {
                return "XAER_NOTA";
            }
            case -9: {
                return "XAER_OUTSIDE";
            }
            case -6: {
                return "XAER_PROTO";
            }
            case -3: {
                return "XAER_RMERR";
            }
            case -7: {
                return "XAER_RMFAIL";
            }
        }
        return "XA_UNKNOWN(" + errorCode + ")";
    }

    private void logXAException(XAException xae) {
        log.warn((Object)("XAException: tx=" + this.toString() + " errorCode=" + this.getStringXAErrorCode(xae.errorCode)), (Throwable)xae);
        if (txManagerService != null) {
            txManagerService.formatXAException(xae, log);
        }
    }

    private synchronized void lock() {
        if (this.done) {
            throw new IllegalStateException("Transaction has terminated");
        }
        if (this.locked) {
            log.warn((Object)("Lock contention, tx=" + this.toString()));
            while (this.locked) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if (!this.done) continue;
                throw new IllegalStateException("Transaction has now terminated");
            }
        }
        this.locked = true;
    }

    private synchronized void unlock() {
        if (!this.locked) {
            log.warn((Object)("Unlocking, but not locked, tx=" + this.toString()), new Throwable("[Stack trace]"));
        }
        this.locked = false;
        this.notify();
    }

    private synchronized void instanceDone() {
        TxManager manager = TxManager.getInstance();
        if (this.status == 3) {
            manager.incCommitCount();
        } else {
            manager.incRollbackCount();
        }
        manager.releaseTransactionImpl(this);
        this.status = 6;
        this.sync = null;
        this.resources = null;
        this.notifyAll();
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTimeout() {
        if (this.timeout != null) {
            this.unlock();
            try {
                try {
                    this.timeout.cancel();
                }
                catch (Exception e) {
                    if (this.trace) {
                        log.trace((Object)"failed to cancel timeout", (Throwable)e);
                    }
                    Object var3_2 = null;
                    this.lock();
                }
                Object var3_1 = null;
                this.lock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.lock();
                throw throwable;
            }
            this.timeout = null;
        }
    }

    private int findResource(XAResource xaRes) {
        int idx = this.resourceCount - 1;
        while (idx >= 0) {
            if (xaRes == this.resources[idx]) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    private int addResource(XAResource xaRes, Xid branchXid, int idxSameRM) {
        if (this.resourceCount == this.resourceAllocSize) {
            this.resourceAllocSize = 2 * this.resourceAllocSize;
            XAResource[] res = new XAResource[this.resourceAllocSize];
            System.arraycopy(this.resources, 0, res, 0, this.resourceCount);
            this.resources = res;
            int[] stat = new int[this.resourceAllocSize];
            System.arraycopy(this.resourceState, 0, stat, 0, this.resourceCount);
            this.resourceState = stat;
            Xid[] xids = new Xid[this.resourceAllocSize];
            System.arraycopy(this.resourceXids, 0, xids, 0, this.resourceCount);
            this.resourceXids = xids;
            int[] sameRM = new int[this.resourceAllocSize];
            System.arraycopy(this.resourceSameRM, 0, sameRM, 0, this.resourceCount);
            this.resourceSameRM = sameRM;
        }
        this.resources[this.resourceCount] = xaRes;
        this.resourceState[this.resourceCount] = 0;
        this.resourceXids[this.resourceCount] = branchXid;
        this.resourceSameRM[this.resourceCount] = idxSameRM;
        return this.resourceCount++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startResource(int idx) throws XAException {
        int flags = 0x200000;
        if (this.resourceSameRM[idx] == -1) {
            switch (this.resourceState[idx]) {
                case 0: {
                    flags = 0;
                    break;
                }
                case 2: {
                    flags = 0x8000000;
                    break;
                }
                default: {
                    if (!this.trace) break;
                    log.trace((Object)("Unhandled resource state: " + this.resourceState[idx] + " (not RS_NEW or RS_SUSPENDED, using TMJOIN flags)"));
                }
            }
        }
        if (this.trace) {
            log.trace((Object)("startResource(" + xidFactory.toString(this.resourceXids[idx]) + ") entered: " + this.resources[idx].toString() + " flags=" + flags));
        }
        this.unlock();
        try {
            try {
                this.resources[idx].start(this.resourceXids[idx], flags);
            }
            catch (XAException e) {
                throw e;
            }
            catch (Throwable t) {
                if (this.trace) {
                    log.trace((Object)"unhandled throwable error in startResource", t);
                }
                this.status = 1;
                this.lock();
                if (this.trace) {
                    log.trace((Object)("startResource(" + xidFactory.toString(this.resourceXids[idx]) + ") leaving: " + this.resources[idx].toString() + " flags=" + flags));
                }
                return;
            }
            this.resourceState[idx] = 1;
        }
        finally {
            this.lock();
            if (this.trace) {
                log.trace((Object)("startResource(" + xidFactory.toString(this.resourceXids[idx]) + ") leaving: " + this.resources[idx].toString() + " flags=" + flags));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endResource(int idx, int flag) throws XAException {
        if (this.trace) {
            log.trace((Object)("endResource(" + xidFactory.toString(this.resourceXids[idx]) + ") entered: " + this.resources[idx].toString() + " flag=" + flag));
        }
        this.unlock();
        try {
            try {
                this.resources[idx].end(this.resourceXids[idx], flag);
            }
            catch (XAException e) {
                throw e;
            }
            catch (Throwable t) {
                if (this.trace) {
                    log.trace((Object)"unhandled throwable error in endResource", t);
                }
                this.status = 1;
                this.resourceState[idx] = 3;
                this.lock();
                if (this.trace) {
                    log.trace((Object)("endResource(" + xidFactory.toString(this.resourceXids[idx]) + ") leaving: " + this.resources[idx].toString() + " flag=" + flag));
                }
                return;
            }
            if (flag == 0x2000000) {
                this.resourceState[idx] = 2;
            } else {
                if (flag == 0x20000000) {
                    this.status = 1;
                }
                this.resourceState[idx] = 3;
            }
        }
        finally {
            this.lock();
            if (this.trace) {
                log.trace((Object)("endResource(" + xidFactory.toString(this.resourceXids[idx]) + ") leaving: " + this.resources[idx].toString() + " flag=" + flag));
            }
        }
    }

    private void endResources() {
        int idx = 0;
        while (idx < this.resourceCount) {
            try {
                if (this.resourceState[idx] == 1 || this.resourceState[idx] == 2) {
                    if (this.trace) {
                        log.trace((Object)("endresources(" + idx + "): state=" + this.resourceState[idx]));
                    }
                    this.endResource(idx, 0x4000000);
                }
            }
            catch (XAException xae) {
                this.logXAException(xae);
                this.status = 1;
                this.cause = xae;
            }
            ++idx;
        }
        this.resourcesEnded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBeforeCompletion() {
        this.unlock();
        try {
            int i = 0;
            while (i < this.syncCount) {
                try {
                    if (this.trace) {
                        log.trace((Object)("calling sync " + i + ", " + this.sync[i]));
                    }
                    this.sync[i].beforeCompletion();
                }
                catch (Throwable t) {
                    if (this.trace) {
                        log.trace((Object)"failed before completion", t);
                    }
                    this.status = 1;
                    this.cause = t;
                    break;
                }
                ++i;
            }
            Object var4_3 = null;
            this.lock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAfterCompletion() {
        this.unlock();
        try {
            int i = 0;
            while (i < this.syncCount) {
                block5: {
                    try {
                        this.sync[i].afterCompletion(this.status);
                    }
                    catch (Throwable t) {
                        if (!this.trace) break block5;
                        log.trace((Object)"failed after completion", t);
                    }
                }
                ++i;
            }
            Object var4_3 = null;
            this.lock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gotHeuristic(int resIdx, int code) {
        switch (code) {
            case 5: {
                this.heuristicCode = 5;
                break;
            }
            case 6: {
                if (this.heuristicCode == 4) {
                    this.heuristicCode = 6;
                    break;
                }
                if (this.heuristicCode != 7 && this.heuristicCode != 8) break;
                this.heuristicCode = 5;
                break;
            }
            case 7: {
                if (this.heuristicCode == 4) {
                    this.heuristicCode = 7;
                    break;
                }
                if (this.heuristicCode != 6 && this.heuristicCode != 8) break;
                this.heuristicCode = 5;
                break;
            }
            case 8: {
                if (this.heuristicCode == 4) {
                    this.heuristicCode = 8;
                    break;
                }
                if (this.heuristicCode != 7 && this.heuristicCode != 6) break;
                this.heuristicCode = 5;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (resIdx != -1) {
            try {
                try {
                    this.unlock();
                    this.resources[resIdx].forget(this.resourceXids[resIdx]);
                }
                catch (XAException xae) {
                    this.logXAException(xae);
                    this.cause = xae;
                    Object var5_4 = null;
                    this.lock();
                }
                Object var5_3 = null;
                this.lock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.lock();
                throw throwable;
            }
            this.resourceState[resIdx] = 6;
        }
    }

    private void checkHeuristics() throws HeuristicMixedException, HeuristicRollbackException {
        switch (this.heuristicCode) {
            case 5: 
            case 8: {
                this.heuristicCode = 4;
                if (this.trace) {
                    log.trace((Object)("Throwing HeuristicMixedException, status=" + this.getStringStatus(this.status)));
                }
                throw new HeuristicMixedException();
            }
            case 6: {
                this.heuristicCode = 4;
                if (this.trace) {
                    log.trace((Object)("Throwing HeuristicRollbackException, status=" + this.getStringStatus(this.status)));
                }
                throw new HeuristicRollbackException();
            }
            case 7: {
                this.heuristicCode = 4;
                if (this.trace) {
                    log.trace((Object)("NOT Throwing HeuristicCommitException, status=" + this.getStringStatus(this.status)));
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareResources() {
        boolean readOnly = true;
        this.status = 7;
        int i = 0;
        while (i < this.resourceCount) {
            block20: {
                if (this.status != 7) {
                    return false;
                }
                if (this.resourceSameRM[i] == -1) {
                    XAResource resource = this.resources[i];
                    try {
                        Object var6_8;
                        int vote;
                        this.unlock();
                        try {
                            vote = this.resources[i].prepare(this.resourceXids[i]);
                            var6_8 = null;
                            this.lock();
                        }
                        catch (Throwable throwable) {
                            var6_8 = null;
                            this.lock();
                            throw throwable;
                        }
                        if (vote == 0) {
                            readOnly = false;
                            this.resourceState[i] = 5;
                            break block20;
                        }
                        if (vote == 3) {
                            this.resourceState[i] = 4;
                            break block20;
                        }
                        if (this.trace) {
                            log.trace((Object)"illegal vote in prepare resources", (Throwable)new Exception());
                        }
                        this.status = 1;
                        return false;
                    }
                    catch (XAException e) {
                        readOnly = false;
                        this.logXAException(e);
                        switch (e.errorCode) {
                            case 7: {
                                this.gotHeuristic(i, e.errorCode);
                                break;
                            }
                            case 5: 
                            case 6: 
                            case 8: {
                                this.gotHeuristic(i, e.errorCode);
                                if (this.status == 7) {
                                    this.status = 1;
                                    break;
                                }
                            }
                            default: {
                                this.cause = e;
                                if (this.status == 7) {
                                    this.status = 1;
                                    break;
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        if (this.trace) {
                            log.trace((Object)"unhandled throwable in prepareResources", t);
                        }
                        if (this.status == 7) {
                            this.status = 1;
                        }
                        this.cause = t;
                    }
                }
            }
            ++i;
        }
        if (this.status == 7) {
            this.status = 2;
        }
        return readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitResources(boolean onePhase) {
        this.status = 8;
        int i = 0;
        while (i < this.resourceCount) {
            block15: {
                if (this.trace) {
                    log.trace((Object)("Committing resources, resourceStates[" + i + "]=" + this.resourceState[i]));
                }
                if ((onePhase || this.resourceState[i] == 5) && this.resourceSameRM[i] == -1) {
                    if (this.status != 8) {
                        return;
                    }
                    try {
                        Object var4_5;
                        this.unlock();
                        try {
                            this.resources[i].commit(this.resourceXids[i], onePhase);
                            var4_5 = null;
                            this.lock();
                        }
                        catch (Throwable throwable) {
                            var4_5 = null;
                            this.lock();
                            throw throwable;
                        }
                    }
                    catch (XAException e) {
                        this.logXAException(e);
                        switch (e.errorCode) {
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: {
                                this.gotHeuristic(i, e.errorCode);
                                if (onePhase) {
                                    this.status = 1;
                                    break;
                                }
                            }
                            default: {
                                this.cause = e;
                                if (onePhase) {
                                    this.status = 1;
                                    break;
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        if (!this.trace) break block15;
                        log.trace((Object)"unhandled throwable in commitResources", t);
                    }
                }
            }
            ++i;
        }
        if (this.status == 8) {
            this.status = 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackResources() {
        this.status = 9;
        int i = 0;
        while (i < this.resourceCount) {
            block11: {
                if (this.resourceState[i] != 4 && this.resourceState[i] != 6 && this.resourceSameRM[i] == -1) {
                    try {
                        Object var3_4;
                        this.unlock();
                        try {
                            this.resources[i].rollback(this.resourceXids[i]);
                            var3_4 = null;
                            this.lock();
                        }
                        catch (Throwable throwable) {
                            var3_4 = null;
                            this.lock();
                            throw throwable;
                        }
                    }
                    catch (XAException e) {
                        this.logXAException(e);
                        switch (e.errorCode) {
                            case 6: {
                                this.gotHeuristic(i, e.errorCode);
                                break;
                            }
                            case 5: 
                            case 7: 
                            case 8: {
                                this.gotHeuristic(i, e.errorCode);
                                break;
                            }
                            default: {
                                this.cause = e;
                                break;
                            }
                        }
                    }
                    catch (Throwable t) {
                        if (!this.trace) break block11;
                        log.trace((Object)"unhandled throwable in rollbackResources", t);
                    }
                }
            }
            ++i;
        }
        this.status = 4;
    }

    private Xid createXidBranch() {
        long branchId = ++this.lastBranchId;
        return xidFactory.newBranch(this.xid, branchId);
    }

    private boolean isOneResource() {
        if (this.resourceCount == 1) {
            return true;
        }
        int i = 1;
        while (i < this.resourceCount) {
            if (this.resourceSameRM[i] == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public long getTimeLeftBeforeTimeout() {
        return this.start + this.timeoutPeriod - System.currentTimeMillis();
    }

    Object getTransactionLocalValue(TransactionLocal tlocal) {
        return this.transactionLocalMap.get(tlocal);
    }

    void putTransactionLocalValue(TransactionLocal tlocal, Object value) {
        this.transactionLocalMap.put(tlocal, value);
    }

    boolean containsTransactionLocal(TransactionLocal tlocal) {
        return this.transactionLocalMap.containsKey(tlocal);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

