/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanParameterInfo;

public class MBeanConstructorInfo
extends MBeanFeatureInfo
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4433990064191844427L;
    protected MBeanParameterInfo[] signature = null;
    private transient String cacheString;
    private transient int cacheHashCode;

    public MBeanConstructorInfo(String description, Constructor constructor) {
        super(constructor.getName(), description);
        Class<?>[] sign = constructor.getParameterTypes();
        this.signature = new MBeanParameterInfo[sign.length];
        for (int i = 0; i < sign.length; ++i) {
            String name = sign[i].getName();
            this.signature[i] = new MBeanParameterInfo(name, name, "MBean Constructor Parameter.");
        }
    }

    public MBeanConstructorInfo(String name, String description, MBeanParameterInfo[] signature) {
        super(name, description);
        this.signature = null == signature ? new MBeanParameterInfo[]{} : (MBeanParameterInfo[])signature.clone();
    }

    public boolean equals(Object object) {
        MBeanParameterInfo[] otherParams;
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof MBeanConstructorInfo)) {
            return false;
        }
        MBeanConstructorInfo other = (MBeanConstructorInfo)object;
        if (!super.equals(other)) {
            return false;
        }
        MBeanParameterInfo[] thisParams = this.getSignature();
        if (thisParams.length != (otherParams = other.getSignature()).length) {
            return false;
        }
        for (int i = 0; i < thisParams.length; ++i) {
            if (thisParams[i].equals(otherParams[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.cacheHashCode == 0) {
            this.cacheHashCode = super.hashCode();
        }
        return this.cacheHashCode;
    }

    public String toString() {
        if (this.cacheString == null) {
            StringBuffer buffer = new StringBuffer(100);
            buffer.append(this.getClass().getName()).append(":");
            buffer.append(" name=").append(this.getName());
            buffer.append(" description=").append(this.getDescription());
            buffer.append(" signature=").append(Arrays.asList(this.signature));
            this.cacheString = buffer.toString();
        }
        return this.cacheString;
    }

    public MBeanParameterInfo[] getSignature() {
        return (MBeanParameterInfo[])this.signature.clone();
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        MBeanConstructorInfo clone = (MBeanConstructorInfo)super.clone();
        clone.signature = (MBeanParameterInfo[])this.signature.clone();
        return clone;
    }
}

