/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerPermission;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.loading.ClassLoaderRepository;
import javax.management.loading.DefaultLoaderRepository;

public class MBeanServerFactory {
    private static final MBeanServerPermission CREATE = new MBeanServerPermission("createMBeanServer", null);
    private static final MBeanServerPermission FIND = new MBeanServerPermission("findMBeanServer", null);
    private static final MBeanServerPermission NEW = new MBeanServerPermission("newMBeanServer", null);
    private static final MBeanServerPermission RELEASE = new MBeanServerPermission("releaseMBeanServer", null);
    private static Map serverMap = new HashMap();

    public static void releaseMBeanServer(MBeanServer mbeanServer) {
        MBeanServerFactory.checkPermission(RELEASE);
        try {
            String agentID = (String)mbeanServer.getAttribute(new ObjectName("JMImplementation:type=MBeanServerDelegate"), "MBeanServerId");
            Object server = serverMap.remove(agentID);
            try {
                Method m = server.getClass().getMethod("releaseServer", null);
                m.invoke(server, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (server == null) {
                throw new IllegalArgumentException("MBean server reference not found.");
            }
        }
        catch (MalformedObjectNameException e) {
            throw new Error(e.toString());
        }
        catch (JMException e) {
            throw new Error("Cannot retrieve AgentID: " + e.toString());
        }
    }

    public static MBeanServer createMBeanServer() {
        MBeanServerFactory.checkPermission(CREATE);
        return MBeanServerFactory.createMBeanServer("DefaultDomain");
    }

    public static MBeanServer createMBeanServer(String domain) {
        MBeanServerFactory.checkPermission(CREATE);
        return MBeanServerFactory.createMBeanServer(domain, true);
    }

    public static MBeanServer newMBeanServer() {
        MBeanServerFactory.checkPermission(NEW);
        return MBeanServerFactory.newMBeanServer("DefaultDomain");
    }

    public static MBeanServer newMBeanServer(String domain) {
        MBeanServerFactory.checkPermission(NEW);
        return MBeanServerFactory.createMBeanServer(domain, false);
    }

    public static ArrayList findMBeanServer(String agentId) {
        MBeanServerFactory.checkPermission(FIND);
        if (agentId != null) {
            ArrayList list = new ArrayList(1);
            Object server = serverMap.get(agentId);
            if (server != null) {
                list.add(server);
            }
            return list;
        }
        return new ArrayList(serverMap.values());
    }

    public static ClassLoaderRepository getClassLoaderRepository(MBeanServer server) {
        return new DefaultLoaderRepositoryWrapper();
    }

    private static MBeanServer createMBeanServer(String defaultDomain, boolean registerServer) {
        String builderClass = System.getProperty("javax.management.builder.initial", "org.jboss.mx.server.MBeanServerBuilderImpl");
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = cl.loadClass(builderClass);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            MBeanServerBuilder builder = (MBeanServerBuilder)constructor.newInstance(new Object[0]);
            MBeanServerDelegate delegate = builder.newMBeanServerDelegate();
            MBeanServer server = builder.newMBeanServer(defaultDomain, null, delegate);
            if (registerServer) {
                String agentID = delegate.getMBeanServerId();
                serverMap.put(agentID, server);
            }
            return server;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("The MBean server builder implementation class " + builderClass + " was not found: " + e.toString());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The MBean server builder implementation class " + builderClass + " must contain a default constructor.");
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot instantiate class " + builderClass + ": " + e.toString());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unable to create the MBean server builder instance. Illegal access to class " + builderClass + " constructor: " + e.toString());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Unable to create the MBean server builder instance. Class " + builderClass + " has raised an exception in constructor: " + e.getTargetException().toString());
        }
    }

    private static void checkPermission(MBeanServerPermission permission) {
        SecurityManager security = System.getSecurityManager();
        if (security == null) {
            return;
        }
        security.checkPermission(permission);
    }

    private static class DefaultLoaderRepositoryWrapper
    implements ClassLoaderRepository {
        private DefaultLoaderRepositoryWrapper() {
        }

        public Class loadClass(String className) throws ClassNotFoundException {
            return DefaultLoaderRepository.loadClass(className);
        }

        public Class loadClassWithout(ClassLoader loader, String className) throws ClassNotFoundException {
            return DefaultLoaderRepository.loadClassWithout(loader, className);
        }

        public Class loadClassBefore(ClassLoader stop, String className) throws ClassNotFoundException {
            throw new Error("NYI");
        }
    }
}

