/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.interceptor;

import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.PersistentMBean;
import javax.management.modelmbean.ModelMBeanInfo;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.modelmbean.ModelMBeanConstants;
import org.jboss.mx.server.Invocation;
import org.jboss.mx.server.InvocationException;
import org.jboss.mx.server.MBeanInvoker;
import org.jboss.mx.service.ServiceConstants;

public class PersistenceInterceptor
extends AbstractInterceptor
implements ModelMBeanConstants,
ServiceConstants {
    private HashMap attrPersistencePolicies = new HashMap();
    private HashMap timerTaskMap = new HashMap();
    private String mbeanPersistencePolicy;
    private PersistentMBean callback;

    public PersistenceInterceptor() {
        super("Default Persistence Interceptor");
    }

    public Object invoke(Invocation invocation) throws InvocationException {
        PersistenceTimerTask task;
        if (this.callback == null) {
            try {
                this.lazyInit(invocation);
            }
            catch (MBeanException e) {
                throw new InvocationException(e, "Failed to init persistence policy");
            }
        }
        Object returnValue = invocation.nextInterceptor().invoke(invocation);
        String type = invocation.getType();
        if (type != "setAttribute") {
            return returnValue;
        }
        String attrName = invocation.getName();
        String policy = (String)this.attrPersistencePolicies.get(attrName);
        if (policy == null) {
            policy = this.mbeanPersistencePolicy;
        }
        if (policy.equalsIgnoreCase("onupdate")) {
            try {
                MBeanInvoker invoker = invocation.getInvoker();
                Descriptor attrDesc = invocation.getDescriptor();
                invoker.updateAttributeInfo(attrDesc);
                this.callback.store();
            }
            catch (Throwable t) {
                throw new InvocationException(t, "Cannot persist the MBean data.");
            }
        } else if (policy.equalsIgnoreCase("nomoreoftenthan") && (task = (PersistenceTimerTask)this.timerTaskMap.get(attrName)) != null) {
            task.setHasUpdated(true);
        }
        return returnValue;
    }

    private synchronized void lazyInit(Invocation invocation) throws MBeanException {
        MBeanInvoker invoker = invocation.getInvoker();
        this.callback = (PersistentMBean)((Object)invocation.getInvoker());
        ModelMBeanInfo info = (ModelMBeanInfo)((Object)invoker.getMetaData());
        Descriptor mbeanDesc = info.getMBeanDescriptor();
        String policy = (String)mbeanDesc.getFieldValue("persistPolicy");
        String persistPeriod = (String)mbeanDesc.getFieldValue("persistPeriod");
        this.mbeanPersistencePolicy = "never";
        if (policy != null) {
            this.mbeanPersistencePolicy = policy;
            if (this.mbeanPersistencePolicy.equalsIgnoreCase("ontimer") || this.mbeanPersistencePolicy.equalsIgnoreCase("nomoreoftenthan")) {
                boolean isNoMoreOftenThan = this.mbeanPersistencePolicy.equalsIgnoreCase("nomoreoftenthan");
                this.schedulePersistenceNotifications(Long.parseLong(persistPeriod), "MBean", isNoMoreOftenThan);
            }
        }
        Descriptor[] attrDescs = info.getDescriptors("attribute");
        for (int i = 0; i < attrDescs.length; ++i) {
            policy = (String)attrDescs[i].getFieldValue("persistPolicy");
            persistPeriod = (String)attrDescs[i].getFieldValue("persistPeriod");
            if (policy == null) continue;
            String name = (String)attrDescs[i].getFieldValue("name");
            this.attrPersistencePolicies.put(name, policy);
            if (!policy.equalsIgnoreCase("ontimer") && !policy.equalsIgnoreCase("nomoreoftenthan")) continue;
            boolean isNoMoreOftenThan = policy.equalsIgnoreCase("nomoreoftenthan");
            this.schedulePersistenceNotifications(Long.parseLong(persistPeriod), name, isNoMoreOftenThan);
        }
    }

    private void schedulePersistenceNotifications(long persistPeriod, String name, boolean isNoMoreOftenThan) {
        PersistenceTimerTask task = new PersistenceTimerTask(name, isNoMoreOftenThan);
        Timer timer = new Timer(true);
        timer.scheduleAtFixedRate((TimerTask)task, 0L, persistPeriod);
        this.timerTaskMap.put(name, task);
    }

    private class PersistenceTimerTask
    extends TimerTask {
        boolean noMoreOftenThan;
        boolean hasUpdated;
        String name;

        PersistenceTimerTask(String name, boolean noMoreOftenThan) {
            this.name = name;
            this.noMoreOftenThan = noMoreOftenThan;
        }

        synchronized void setHasUpdated(boolean flag) {
            this.hasUpdated = flag;
        }

        public void run() {
            try {
                boolean doStore;
                boolean bl = doStore = this.noMoreOftenThan && this.hasUpdated || !this.noMoreOftenThan;
                if (doStore) {
                    PersistenceInterceptor.this.callback.store();
                    this.setHasUpdated(false);
                }
            }
            catch (MBeanException e) {
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                // empty catch block
            }
        }
    }
}

