/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.ClassLoadingTask;
import org.jboss.mx.loading.LoadMgr4;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.jboss.mx.loading.UnifiedClassLoader3MBean;
import org.jboss.mx.loading.UnifiedLoaderRepository4;

public class UnifiedClassLoader4
extends UnifiedClassLoader
implements UnifiedClassLoader3MBean {
    private static final Logger log = Logger.getLogger(class$org$jboss$mx$loading$UnifiedClassLoader4 == null ? (class$org$jboss$mx$loading$UnifiedClassLoader4 = UnifiedClassLoader4.class$("org.jboss.mx.loading.UnifiedClassLoader4")) : class$org$jboss$mx$loading$UnifiedClassLoader4);
    protected ReentrantLock loadLock = new ReentrantLock();
    private int loadClassDepth;
    private int addedOrder;
    static /* synthetic */ Class class$org$jboss$mx$loading$UnifiedClassLoader4;

    public UnifiedClassLoader4(URL url) {
        this(url, (URL)null);
    }

    public UnifiedClassLoader4(URL url, URL origURL) {
        super(url, origURL);
    }

    public UnifiedClassLoader4(URL url, URL origURL, LoaderRepository repository) {
        this(url, origURL);
        this.repository = repository;
    }

    public UnifiedClassLoader4(URL url, URL origURL, ClassLoader parent, LoaderRepository repository) {
        super(url, origURL, parent);
        this.repository = repository;
    }

    public void unregister() {
        this.repository.removeClassLoader(this);
    }

    public int getAddedOrder() {
        return this.addedOrder;
    }

    public void setAddedOrder(int addedOrder) {
        this.addedOrder = addedOrder;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer(super.toString());
        tmp.setCharAt(tmp.length() - 1, ',');
        tmp.append("addedOrder=");
        tmp.append(this.addedOrder);
        tmp.append('}');
        return tmp.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ClassLoadingTask task;
        block16: {
            ++this.loadClassDepth;
            boolean trace = log.isTraceEnabled();
            boolean acquired = this.attempt(1L);
            while (!acquired) {
                try {
                    if (trace) {
                        log.trace("Waiting for loadClass lock");
                    }
                    this.wait();
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                acquired = this.attempt(1L);
            }
            task = null;
            try {
                UnifiedLoaderRepository4 ulr4;
                Thread t = Thread.currentThread();
                if (this.loadLock.holds() == 1L) {
                    LoadMgr4.registerLoaderThread(this, t);
                }
                if (!LoadMgr4.beginLoadTask(task = new ClassLoadingTask(name, this, t), ulr4 = (UnifiedLoaderRepository4)this.repository)) {
                    while (task.threadTaskCount != 0) {
                        try {
                            LoadMgr4.nextTask(t, task, ulr4);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
                Object var10_10 = null;
                if (this.loadLock.holds() != 1L) break block16;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (this.loadLock.holds() == 1L) {
                    LoadMgr4.endLoadTask(task);
                }
                this.release();
                this.notifyAll();
                --this.loadClassDepth;
                throw throwable;
            }
            LoadMgr4.endLoadTask(task);
        }
        this.release();
        this.notifyAll();
        --this.loadClassDepth;
        {
        }
        if (task.loadedClass == null) {
            if (task.loadException instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)task.loadException;
            }
            if (task.loadException != null) {
                if (log.isTraceEnabled()) {
                    log.trace("Unexpected error during load of:" + name, task.loadException);
                }
                String msg = "Unexpected error during load of: " + name + ", msg=" + task.loadException.getMessage();
                throw new ClassNotFoundException(msg);
            }
            throw new IllegalStateException("ClassLoadingTask.loadedTask is null, name: " + name);
        }
        return task.loadedClass;
    }

    public URL getResource(String name) {
        URL u = this.repository.getResource(name, this);
        return u;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean attempt(long waitMS) {
        boolean acquired = false;
        boolean trace = log.isTraceEnabled();
        Thread.currentThread();
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            acquired = this.loadLock.attempt(waitMS);
        }
        catch (InterruptedException e) {
        }
        finally {
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
        if (trace) {
            log.trace("attempt(" + this.loadLock.holds() + ") was: " + acquired + " for :" + this);
        }
        return acquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquire() {
        Thread.currentThread();
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            this.loadLock.acquire();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("acquired(" + this.loadLock.holds() + ") for :" + this);
        }
    }

    protected void release() {
        if (log.isTraceEnabled()) {
            log.trace("release(" + this.loadLock.holds() + ") for :" + this);
        }
        this.loadLock.release();
        if (log.isTraceEnabled()) {
            log.trace("released, holds: " + this.loadLock.holds());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

