/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.ClassLoaderUtils;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.jboss.mx.loading.UnifiedLoaderRepositoryMBean;
import org.jboss.mx.util.JBossNotificationBroadcasterSupport;

public class UnifiedLoaderRepository
extends LoaderRepository
implements NotificationBroadcaster,
UnifiedLoaderRepositoryMBean {
    private HashSet classLoaders = new HashSet();
    private HashSet classLoaderURLs = new HashSet();
    private HashMap classes = new HashMap();
    private HashMap loaderToClassesMap = new HashMap();
    private HashMap loaderToResourcesMap = new HashMap();
    private HashMap packagesMap = new HashMap();
    private HashMap loaderToPackagesMap = new HashMap();
    private long sequenceNumber = 0L;
    private final JBossNotificationBroadcasterSupport broadcaster = new JBossNotificationBroadcasterSupport();
    private MBeanNotificationInfo[] info;
    private Thread currentThread;
    private ReentrantLock reentrantLock = new ReentrantLock();
    private Object lock = new Object();
    private int threadsCount;
    private static final Logger log = Logger.getLogger(class$org$jboss$mx$loading$UnifiedLoaderRepository == null ? (class$org$jboss$mx$loading$UnifiedLoaderRepository = UnifiedLoaderRepository.class$("org.jboss.mx.loading.UnifiedLoaderRepository")) : class$org$jboss$mx$loading$UnifiedLoaderRepository);
    static /* synthetic */ Class class$org$jboss$mx$loading$UnifiedLoaderRepository;

    public UnifiedClassLoader newClassLoader(URL url, boolean addToRepository) throws Exception {
        UnifiedClassLoader ucl = new UnifiedClassLoader(url);
        if (addToRepository) {
            this.addClassLoader(ucl);
        }
        return ucl;
    }

    public UnifiedClassLoader newClassLoader(URL url, URL origURL, boolean addToRepository) throws Exception {
        UnifiedClassLoader ucl = new UnifiedClassLoader(url, origURL);
        if (addToRepository) {
            this.addClassLoader(ucl);
        }
        return ucl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Class loadClass(String name, boolean resolve, ClassLoader cl) throws ClassNotFoundException {
        try {
            Class cls;
            block17: {
                Class clazz;
                try {
                    this.synchronize(cl);
                    UnifiedLoaderRepository unifiedLoaderRepository = this;
                    // MONITORENTER : unifiedLoaderRepository
                    cls = this.loadClassFromCache(name, cl);
                    if (cls != null) {
                        Class clazz2 = cls;
                        // MONITOREXIT : unifiedLoaderRepository
                        this.unsynchronize(cl);
                        return clazz2;
                    }
                    cls = this.loadClassFromClassLoader(name, resolve, cl);
                    if (cls == null) break block17;
                    clazz = cls;
                }
                catch (Throwable throwable) {
                    this.unsynchronize(cl);
                    throw throwable;
                }
                this.unsynchronize(cl);
                return clazz;
            }
            cls = this.loadClassFromRepository(name, resolve, cl);
            if (cls != null) {
                Class clazz = cls;
                // MONITOREXIT : unifiedLoaderRepository
                this.unsynchronize(cl);
                return clazz;
            }
            throw new ClassNotFoundException(name);
        }
        catch (ClassCircularityError x) {
            String circularityClassName = x.getMessage();
            circularityClassName = circularityClassName.replace('/', '.');
            Class cls = null;
            while (cls == null) {
                try {
                    Thread.sleep(137L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                UnifiedLoaderRepository unifiedLoaderRepository = this;
                // MONITORENTER : unifiedLoaderRepository
                cls = this.loadClassFromCache(circularityClassName, cl);
                // MONITOREXIT : unifiedLoaderRepository
            }
            return cls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void synchronize(ClassLoader cl) {
        Thread.currentThread();
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            try {
                this.reentrantLock.acquire();
                while (!this.isThreadAllowed(Thread.currentThread())) {
                    this.reentrantLock.release();
                    ClassLoader classLoader = cl;
                    synchronized (classLoader) {
                        try {
                            cl.wait(137L);
                        }
                        catch (InterruptedException ignored) {
                            // empty catch block
                        }
                    }
                    try {
                        this.reentrantLock.acquire();
                    }
                    catch (InterruptedException ignored) {}
                }
                Object var7_7 = null;
                this.increaseThreadsCount();
            }
            catch (InterruptedException interruptedException) {
                Object var7_8 = null;
                this.increaseThreadsCount();
                this.reentrantLock.release();
                if (!threadWasInterrupted) return;
                Thread.currentThread().interrupt();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.increaseThreadsCount();
            this.reentrantLock.release();
            if (!threadWasInterrupted) throw throwable;
            Thread.currentThread().interrupt();
            throw throwable;
        }
        this.reentrantLock.release();
        if (!threadWasInterrupted) return;
        Thread.currentThread().interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unsynchronize(ClassLoader cl) {
        Thread.currentThread();
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            block8: {
                try {
                    this.reentrantLock.acquire();
                    if (this.decreaseThreadsCount() != 0) break block8;
                    this.setCurrentThread(null);
                }
                catch (InterruptedException interruptedException) {
                    Object var5_4 = null;
                    this.reentrantLock.release();
                    ClassLoader classLoader3 = cl;
                    synchronized (classLoader3) {
                        cl.notifyAll();
                    }
                    if (!threadWasInterrupted) return;
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            Object var5_3 = null;
            this.reentrantLock.release();
            ClassLoader classLoader = cl;
            synchronized (classLoader) {
                cl.notifyAll();
            }
            if (!threadWasInterrupted) return;
            Thread.currentThread().interrupt();
            return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.reentrantLock.release();
            ClassLoader classLoader2 = cl;
            synchronized (classLoader2) {
                cl.notifyAll();
            }
            if (!threadWasInterrupted) throw throwable;
            Thread.currentThread().interrupt();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isThreadAllowed(Thread thread) {
        Object object = this.lock;
        synchronized (object) {
            Thread current = this.getCurrentThread();
            if (current == null) {
                this.setCurrentThread(thread);
                return true;
            }
            return current == thread;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentThread(Thread t) {
        Object object = this.lock;
        synchronized (object) {
            this.currentThread = t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread getCurrentThread() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int increaseThreadsCount() {
        Object object = this.lock;
        synchronized (object) {
            ++this.threadsCount;
            return this.getThreadsCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int decreaseThreadsCount() {
        Object object = this.lock;
        synchronized (object) {
            --this.threadsCount;
            return this.getThreadsCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getThreadsCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.threadsCount;
        }
    }

    private String getPackageName(String className) {
        int index = className.lastIndexOf(46);
        String pkgName = className;
        if (index > 0) {
            pkgName = className.substring(0, index);
        }
        return pkgName;
    }

    private String getResourcePackageName(String rsrcName) {
        int index = rsrcName.lastIndexOf(47);
        String pkgName = rsrcName;
        if (index > 0) {
            pkgName = rsrcName.substring(0, index);
        }
        return pkgName.replace('/', '.');
    }

    private boolean containsClassPackage(String className) {
        return this.packagesMap.containsKey(this.getPackageName(className));
    }

    private Class loadClassFromCache(String name, ClassLoader cl) {
        Class cls = (Class)this.classes.get(name);
        return cls;
    }

    void cacheLoadedClass(String name, Class cls, ClassLoader cl) {
        this.classes.put(name, cls);
        HashSet<String> classes = (HashSet<String>)this.loaderToClassesMap.get(cl);
        if (classes == null) {
            classes = new HashSet<String>();
            this.loaderToClassesMap.put(cl, classes);
        }
        classes.add(name);
    }

    private Class loadClassFromClassLoader(String name, boolean resolve, ClassLoader cl) {
        if (cl instanceof UnifiedClassLoader) {
            try {
                Class cls = ((UnifiedClassLoader)cl).loadClassLocally(name, resolve);
                this.cacheLoadedClass(name, cls, cl);
                return cls;
            }
            catch (ClassNotFoundException x) {
                // empty catch block
            }
        }
        return null;
    }

    private Class loadClassFromRepository(String name, boolean resolve, ClassLoader cl) {
        String pkgName = this.getPackageName(name);
        HashSet pkgSet = (HashSet)this.packagesMap.get(pkgName);
        if (pkgSet == null) {
            return null;
        }
        Iterator i = pkgSet.iterator();
        while (i.hasNext()) {
            ClassLoader classloader = (ClassLoader)i.next();
            if (classloader.equals(cl) || !(classloader instanceof UnifiedClassLoader)) continue;
            try {
                UnifiedClassLoader ucl = (UnifiedClassLoader)classloader;
                Class cls = ucl.loadClassLocally(name, resolve);
                this.cacheLoadedClass(name, cls, classloader);
                return cls;
            }
            catch (ClassNotFoundException ignored) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public URL getResource(String name, ClassLoader cl) {
        URL resource;
        block10: {
            URL uRL;
            try {
                this.synchronize(cl);
                UnifiedLoaderRepository unifiedLoaderRepository = this;
                // MONITORENTER : unifiedLoaderRepository
                resource = this.getResourceFromCache(name, cl);
                if (resource != null) {
                    URL uRL2 = resource;
                    // MONITOREXIT : unifiedLoaderRepository
                    this.unsynchronize(cl);
                    return uRL2;
                }
                resource = this.getResourceFromClassLoader(name, cl);
                if (resource == null) break block10;
                uRL = resource;
            }
            catch (Throwable throwable) {
                this.unsynchronize(cl);
                throw throwable;
            }
            this.unsynchronize(cl);
            return uRL;
        }
        resource = this.getResourceFromRepository(name, cl);
        if (resource != null) {
            URL uRL = resource;
            // MONITOREXIT : unifiedLoaderRepository
            this.unsynchronize(cl);
            return uRL;
        }
        this.unsynchronize(cl);
        return null;
    }

    public void getResources(String name, ClassLoader cl, List urls) {
    }

    private URL getResourceFromCache(String name, ClassLoader cl) {
        if (this.loaderToResourcesMap.containsKey(cl)) {
            HashMap resources = (HashMap)this.loaderToResourcesMap.get(cl);
            return (URL)resources.get(name);
        }
        return null;
    }

    private URL getResourceFromClassLoader(String name, ClassLoader cl) {
        if (cl instanceof UnifiedClassLoader) {
            URL url = ((UnifiedClassLoader)cl).getResourceLocally(name);
            this.cacheLoadedResource(name, url, cl);
            return url;
        }
        return null;
    }

    private URL getResourceFromRepository(String name, ClassLoader cl) {
        String pkgName = this.getResourcePackageName(name);
        HashSet pkgSet = (HashSet)this.packagesMap.get(pkgName);
        Iterator i = pkgSet != null ? pkgSet.iterator() : this.classLoaders.iterator();
        while (i.hasNext()) {
            URL url;
            ClassLoader classloader = (ClassLoader)i.next();
            if (classloader.equals(cl) || !(classloader instanceof UnifiedClassLoader) || (url = ((UnifiedClassLoader)classloader).getResourceLocally(name)) == null) continue;
            this.cacheLoadedResource(name, url, classloader);
            return url;
        }
        return null;
    }

    private void cacheLoadedResource(String name, URL url, ClassLoader cl) {
        HashMap<String, URL> resources = (HashMap<String, URL>)this.loaderToResourcesMap.get(cl);
        if (resources == null) {
            resources = new HashMap<String, URL>();
            this.loaderToResourcesMap.put(cl, resources);
        }
        resources.put(name, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class findClass(String name) {
        String classRsrcName = name.replace('.', '/') + ".class";
        UnifiedLoaderRepository unifiedLoaderRepository = this;
        synchronized (unifiedLoaderRepository) {
            Iterator iter = this.classLoaders.iterator();
            while (iter.hasNext()) {
                ClassLoader cl = (ClassLoader)iter.next();
                URL classURL = cl.getResource(classRsrcName);
                if (classURL == null) continue;
                try {
                    Class<?> cls = cl.loadClass(name);
                    return cls;
                }
                catch (ClassNotFoundException e) {
                    log.debug("Failed to load class: " + name, e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getURLs() {
        HashSet<URL> classpath = new HashSet<URL>();
        UnifiedLoaderRepository unifiedLoaderRepository = this;
        synchronized (unifiedLoaderRepository) {
            Iterator iter = this.classLoaders.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof UnifiedClassLoader)) continue;
                UnifiedClassLoader cl = (UnifiedClassLoader)obj;
                URL[] urls = cl.getClasspath();
                int length = urls != null ? urls.length : 0;
                for (int u = 0; u < length; ++u) {
                    URL path = urls[u];
                    classpath.add(path);
                }
            }
        }
        return classpath.toArray(new URL[classpath.size()]);
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        ClassLoader scl = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = null;
        try {
            clazz = this.loadClass(className, false, scl);
        }
        catch (ClassNotFoundException e) {
            if (!(scl instanceof UnifiedClassLoader)) {
                clazz = scl.loadClass(className);
            }
            throw e;
        }
        return clazz;
    }

    public Class loadClassWithout(ClassLoader loader, String className) throws ClassNotFoundException {
        throw new Error("NYI");
    }

    public void addClassLoader(ClassLoader loader) {
        if (loader instanceof UnifiedClassLoader) {
            this.addUnifiedClassLoader((UnifiedClassLoader)loader);
        } else if (loader instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)loader;
            URL[] urls = ucl.getURLs();
            for (int i = 0; i < urls.length; ++i) {
                this.addUnifiedClassLoader(new UnifiedClassLoader(urls[i], this));
            }
        } else {
            log.warn("Tried to add non- URLClassLoader.  Ignored");
        }
    }

    public boolean addClassLoaderURL(ClassLoader cl, URL url) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUnifiedClassLoader(UnifiedClassLoader cl) {
        try {
            this.synchronize(cl);
            UnifiedLoaderRepository unifiedLoaderRepository = this;
            synchronized (unifiedLoaderRepository) {
                cl.setRepository(this);
                URL url = cl.getURL();
                boolean exists = this.classLoaderURLs.contains(url);
                boolean added = false;
                if (!exists) {
                    added = this.classLoaders.add(cl);
                    this.classLoaderURLs.add(url);
                }
                if (added) {
                    log.debug("Adding " + cl);
                    this.updatePackageMap(cl);
                } else {
                    log.debug("Skipping duplicate " + cl);
                }
            }
        }
        finally {
            this.unsynchronize(cl);
        }
    }

    private void updatePackageMap(UnifiedClassLoader cl) {
        try {
            String[] pkgNames = ClassLoaderUtils.updatePackageMap(cl, this.packagesMap);
            this.loaderToPackagesMap.put(cl, pkgNames);
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace("Failed to update pkgs for cl=" + cl, e);
            }
            log.debug("Failed to update pkgs for cl=" + cl, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClassLoader(ClassLoader cl) {
        try {
            this.synchronize(cl);
            UnifiedLoaderRepository unifiedLoaderRepository = this;
            synchronized (unifiedLoaderRepository) {
                String[] pkgNames;
                HashSet loaded;
                if (cl instanceof UnifiedClassLoader) {
                    UnifiedClassLoader ucl = (UnifiedClassLoader)cl;
                    if (this.getTranslator() != null) {
                        this.getTranslator().unregisterClassLoader(ucl);
                    }
                    URL url = ucl.getURL();
                    this.classLoaderURLs.remove(url);
                }
                boolean removed = this.classLoaders.remove(cl);
                log.debug("UnifiedLoaderRepository removed(" + removed + ") " + cl);
                if (this.loaderToClassesMap.containsKey(cl) && (loaded = (HashSet)this.loaderToClassesMap.remove(cl)) != null) {
                    Iterator iter = loaded.iterator();
                    while (iter.hasNext()) {
                        this.broadcaster.sendNotification(new Notification("jboss.mx.class.removed", (Object)this, this.getNextSequenceNumber(), (String)iter.next()));
                    }
                    Iterator i = loaded.iterator();
                    while (i.hasNext()) {
                        String cls = (String)i.next();
                        this.classes.remove(cls);
                    }
                }
                if (this.loaderToResourcesMap.containsKey(cl)) {
                    HashMap resources = (HashMap)this.loaderToResourcesMap.remove(cl);
                }
                int length = (pkgNames = (String[])this.loaderToPackagesMap.get(cl)) != null ? pkgNames.length : 0;
                for (int p = 0; p < length; ++p) {
                    String pkgName = pkgNames[p];
                    HashSet pkgSet = (HashSet)this.packagesMap.get(pkgName);
                    if (pkgSet == null) continue;
                    pkgSet.remove(cl);
                    if (!pkgSet.isEmpty()) continue;
                    this.packagesMap.remove(pkgName);
                }
            }
        }
        finally {
            this.unsynchronize(cl);
        }
    }

    public LoaderRepository registerClassLoader(UnifiedClassLoader ucl) {
        this.addClassLoader(ucl);
        Notification msg = new Notification("jboss.mx.classloader.added", this, this.getNextSequenceNumber());
        msg.setUserData(ucl);
        this.broadcaster.sendNotification(msg);
        return this;
    }

    public LoaderRepository getInstance() {
        return this;
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.info == null) {
            this.info = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"CLASSLOADER_ADDED"}, "javax.management.Notification", "Notification that a classloader has been added to the extensible classloader"), new MBeanNotificationInfo(new String[]{"CLASS_REMOVED"}, "javax.management.Notification", "Notification that a class has been removed from the extensible classloader")};
        }
        return this.info;
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    private synchronized long getNextSequenceNumber() {
        return this.sequenceNumber++;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ReentrantLock {
        private int holds;
        private Thread owner;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread caller = Thread.currentThread();
            ReentrantLock reentrantLock = this;
            synchronized (reentrantLock) {
                if (caller == this.owner) {
                    ++this.holds;
                } else {
                    try {
                        while (this.owner != null) {
                            this.wait();
                        }
                        this.owner = caller;
                        this.holds = 1;
                    }
                    catch (InterruptedException ex) {
                        this.notify();
                        throw ex;
                    }
                }
            }
        }

        public synchronized void release() {
            Thread t = Thread.currentThread();
            if (t != this.owner) {
                throw new Error("Illegal Lock usage, t=" + t + ", owner=" + this.owner);
            }
            if (--this.holds == 0) {
                this.owner = null;
                this.notify();
            }
        }

        public synchronized int holds() {
            if (Thread.currentThread() != this.owner) {
                return 0;
            }
            return this.holds;
        }
    }
}

