/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.ClassLoaderUtils;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.ResourceInfo;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.jboss.mx.loading.UnifiedClassLoader4;
import org.jboss.mx.loading.UnifiedLoaderRepository4MBean;
import org.jboss.mx.util.JBossNotificationBroadcasterSupport;

public class UnifiedLoaderRepository4
extends LoaderRepository
implements NotificationBroadcaster,
UnifiedLoaderRepository4MBean {
    private static final Logger log = Logger.getLogger(class$org$jboss$mx$loading$UnifiedLoaderRepository4 == null ? (class$org$jboss$mx$loading$UnifiedLoaderRepository4 = UnifiedLoaderRepository4.class$("org.jboss.mx.loading.UnifiedLoaderRepository4")) : class$org$jboss$mx$loading$UnifiedLoaderRepository4);
    private static int addedCount;
    private HashSet classLoaders = new HashSet();
    private HashSet classLoaderURLs = new HashSet();
    private HashMap classes = new HashMap();
    private HashMap loaderToClassesMap = new HashMap();
    private HashMap loaderToResourcesMap = new HashMap();
    private HashMap globalResources = new HashMap();
    private HashMap classNamesMap = new HashMap();
    private HashMap loaderToClassNamesMap = new HashMap();
    private long sequenceNumber = 0L;
    private final JBossNotificationBroadcasterSupport broadcaster = new JBossNotificationBroadcasterSupport();
    private MBeanNotificationInfo[] info;
    static /* synthetic */ Class class$org$jboss$mx$loading$UnifiedLoaderRepository4;

    public UnifiedClassLoader newClassLoader(URL url, boolean addToRepository) throws Exception {
        UnifiedClassLoader4 ucl = new UnifiedClassLoader4(url, null, this);
        if (addToRepository) {
            this.registerClassLoader(ucl);
        }
        return ucl;
    }

    public UnifiedClassLoader newClassLoader(URL url, URL origURL, boolean addToRepository) throws Exception {
        UnifiedClassLoader4 ucl = new UnifiedClassLoader4(url, origURL, this);
        if (addToRepository) {
            this.registerClassLoader(ucl);
        }
        return ucl;
    }

    public HashSet getClassLoaders() {
        return this.classLoaders;
    }

    public HashMap getClasses() {
        return this.classes;
    }

    public HashMap getClassNamesMap() {
        return this.classNamesMap;
    }

    public HashMap getLoaderToClassesMap() {
        return this.loaderToClassesMap;
    }

    public int getCacheSize() {
        return this.classes.size();
    }

    public int getClassLoadersSize() {
        return this.classLoaders.size();
    }

    public int getClassIndexSize() {
        return this.classNamesMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        HashMap hashMap = this.classes;
        synchronized (hashMap) {
            this.classes.clear();
        }
    }

    public Class loadClass(String name, boolean resolve, ClassLoader cl) throws ClassNotFoundException {
        UnifiedClassLoader4 ucl = (UnifiedClassLoader4)cl;
        return ucl.loadClass(name, resolve);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList getClassLoaders(String className) {
        String jarClassName = ClassLoaderUtils.getJarClassName(className);
        LinkedList ucls = null;
        HashMap hashMap = this.classNamesMap;
        synchronized (hashMap) {
            ucls = (LinkedList)this.classNamesMap.get(jarClassName);
        }
        return ucls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnifiedClassLoader4 getClassLoader(String className) {
        String jarClassName = ClassLoaderUtils.getJarClassName(className);
        UnifiedClassLoader4 ucl = null;
        HashMap hashMap = this.classNamesMap;
        synchronized (hashMap) {
            LinkedList ucls = (LinkedList)this.classNamesMap.get(jarClassName);
            if (ucls != null) {
                ucl = (UnifiedClassLoader4)ucls.get(0);
            }
        }
        return ucl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClassFromCache(String name) {
        Class cls = null;
        HashMap hashMap = this.classes;
        synchronized (hashMap) {
            cls = (Class)this.classes.get(name);
        }
        return cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheLoadedClass(String name, Class cls, ClassLoader cl) {
        HashMap hashMap = this.classes;
        synchronized (hashMap) {
            this.classes.put(name, cls);
            HashSet<String> clClasses = (HashSet<String>)this.loaderToClassesMap.get(cl);
            if (clClasses == null) {
                clClasses = new HashSet<String>();
                this.loaderToClassesMap.put(cl, clClasses);
            }
            clClasses.add(name);
        }
    }

    public Class loadClassFromClassLoader(String name, boolean resolve, UnifiedClassLoader cl) {
        if (cl instanceof UnifiedClassLoader) {
            try {
                Class cls = cl.loadClassLocally(name, resolve);
                this.cacheLoadedClass(name, cls, cl);
                return cls;
            }
            catch (ClassNotFoundException x) {
                // empty catch block
            }
        }
        return null;
    }

    public URL getResource(String name, ClassLoader cl) {
        URL resource = this.getResourceFromCache(name, cl);
        if (resource != null) {
            return resource;
        }
        resource = this.getResourceFromClassLoader(name, cl);
        if (resource != null) {
            return resource;
        }
        resource = this.getResourceFromGlobalCache(name);
        if (resource != null) {
            return resource;
        }
        resource = this.getResourceFromRepository(name, cl);
        if (resource != null) {
            return resource;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getResources(String name, ClassLoader cl, List urls) {
        HashSet tmpClassLoaders;
        HashSet hashSet = this.classLoaders;
        synchronized (hashSet) {
            tmpClassLoaders = new HashSet(this.classLoaders);
        }
        Iterator iter = tmpClassLoaders.iterator();
        while (iter.hasNext()) {
            ClassLoader nextCL = (ClassLoader)iter.next();
            if (!(nextCL instanceof UnifiedClassLoader)) continue;
            UnifiedClassLoader ucl = (UnifiedClassLoader)nextCL;
            try {
                Enumeration resURLs = ucl.findResourcesLocally(name);
                while (resURLs.hasMoreElements()) {
                    Object res = resURLs.nextElement();
                    urls.add(res);
                }
            }
            catch (IOException ignore) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getResourceFromCache(String name, ClassLoader cl) {
        URL resource = null;
        HashMap hashMap = this.loaderToResourcesMap;
        synchronized (hashMap) {
            if (this.loaderToResourcesMap.containsKey(cl)) {
                HashMap resources = (HashMap)this.loaderToResourcesMap.get(cl);
                resource = (URL)resources.get(name);
            }
        }
        return resource;
    }

    private URL getResourceFromClassLoader(String name, ClassLoader cl) {
        URL resource = null;
        if (cl instanceof UnifiedClassLoader) {
            UnifiedClassLoader ucl = (UnifiedClassLoader)cl;
            resource = ucl.getResourceLocally(name);
            this.cacheLoadedResource(name, resource, cl);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getResourceFromGlobalCache(String name) {
        ResourceInfo ri = null;
        HashMap hashMap = this.loaderToResourcesMap;
        synchronized (hashMap) {
            ri = (ResourceInfo)this.globalResources.get(name);
        }
        URL resource = null;
        if (ri != null) {
            resource = ri.url;
        }
        return resource;
    }

    private URL getResourceFromRepository(String name, ClassLoader cl) {
        Iterator i = this.classLoaders.iterator();
        URL url = null;
        while (i.hasNext()) {
            ClassLoader classloader = (ClassLoader)i.next();
            if (classloader.equals(cl) || !(classloader instanceof UnifiedClassLoader) || (url = ((UnifiedClassLoader)classloader).getResourceLocally(name)) == null) continue;
            this.cacheLoadedResource(name, url, classloader);
            this.cacheGlobalResource(name, url, classloader);
            break;
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheLoadedResource(String name, URL url, ClassLoader cl) {
        HashMap hashMap = this.loaderToResourcesMap;
        synchronized (hashMap) {
            HashMap<String, URL> resources = (HashMap<String, URL>)this.loaderToResourcesMap.get(cl);
            if (resources == null) {
                resources = new HashMap<String, URL>();
                this.loaderToResourcesMap.put(cl, resources);
            }
            resources.put(name, url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheGlobalResource(String name, URL url, ClassLoader cl) {
        HashMap hashMap = this.loaderToResourcesMap;
        synchronized (hashMap) {
            this.globalResources.put(name, new ResourceInfo(url, cl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getURLs() {
        HashSet<URL> classpath = new HashSet<URL>();
        HashSet tmp = null;
        HashSet hashSet = this.classLoaders;
        synchronized (hashSet) {
            tmp = (HashSet)this.classLoaders.clone();
        }
        Iterator iter = tmp.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof UnifiedClassLoader)) continue;
            UnifiedClassLoader cl = (UnifiedClassLoader)obj;
            URL[] urls = cl.getClasspath();
            int length = urls != null ? urls.length : 0;
            for (int u = 0; u < length; ++u) {
                URL path = urls[u];
                classpath.add(path);
            }
        }
        URL[] cp = new URL[classpath.size()];
        classpath.toArray(cp);
        return cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String displayClassInfo(String className) {
        String classRsrcName = className.replace('.', '/') + ".class";
        int count = 0;
        Class loadedClass = this.loadClassFromCache(className);
        StringBuffer results = new StringBuffer(className + " Information\n");
        if (loadedClass != null) {
            results.append("Repository cache version:");
            ClassLoaderUtils.displayClassInfo(loadedClass, results);
        } else {
            results.append("Not loaded in repository cache\n");
        }
        HashSet tmp = null;
        HashSet hashSet = this.classLoaders;
        synchronized (hashSet) {
            tmp = (HashSet)this.classLoaders.clone();
        }
        Iterator iter = tmp.iterator();
        while (iter.hasNext()) {
            URLClassLoader cl = (URLClassLoader)iter.next();
            URL classURL = cl.findResource(classRsrcName);
            if (classURL == null) continue;
            results.append("\n\n### Instance" + count + " found in UCL: " + cl + "\n");
            ++count;
        }
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        URLClassLoader[] stack = ClassLoaderUtils.getClassLoaderStack(tcl);
        for (int s = 0; s < stack.length; ++s) {
            URLClassLoader cl = stack[s];
            URL classURL = cl.findResource(classRsrcName);
            if (classURL == null) continue;
            results.append("\n\n### Instance" + count + " via UCL: " + cl + "\n");
            ++count;
        }
        return results.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String className) throws ClassNotFoundException {
        ClassLoader scl = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = null;
        try {
            clazz = scl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            if (!(scl instanceof UnifiedClassLoader4)) {
                HashSet hashSet = this.classLoaders;
                synchronized (hashSet) {
                    if (this.classLoaders.size() > 0) {
                        UnifiedClassLoader4 ucl = (UnifiedClassLoader4)this.classLoaders.iterator().next();
                        clazz = ucl.loadClass(className);
                    }
                }
            }
            throw e;
        }
        return clazz;
    }

    public Class loadClassWithout(ClassLoader loader, String className) throws ClassNotFoundException {
        throw new ClassNotFoundException("NYI");
    }

    public void addClassLoader(ClassLoader loader) {
        if (loader instanceof UnifiedClassLoader) {
            this.addUnifiedClassLoader((UnifiedClassLoader4)loader);
        } else if (loader instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)loader;
            URL[] urls = ucl.getURLs();
            for (int i = 0; i < urls.length; ++i) {
                UnifiedClassLoader4 ucl3 = new UnifiedClassLoader4(urls[i], urls[i], this);
                this.addUnifiedClassLoader(ucl3);
            }
        } else {
            log.warn("Tried to add non-URLClassLoader.  Ignored");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addClassLoaderURL(ClassLoader cl, URL url) {
        UnifiedClassLoader ucl = (UnifiedClassLoader)cl;
        boolean added = false;
        HashSet hashSet = this.classLoaders;
        synchronized (hashSet) {
            if (!this.classLoaderURLs.contains(url)) {
                this.updateClassNamesMap(ucl, url);
                this.classLoaderURLs.add(url);
                added = true;
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUnifiedClassLoader(UnifiedClassLoader4 cl) {
        cl.setRepository(this);
        URL url = cl.getURL();
        boolean added = false;
        HashSet hashSet = this.classLoaders;
        synchronized (hashSet) {
            boolean exists = this.classLoaderURLs.contains(url);
            if (!exists) {
                this.classLoaderURLs.add(url);
                added = this.classLoaders.add(cl);
            }
            if (added) {
                log.debug("Adding " + cl);
                cl.setAddedOrder(++addedCount);
                this.updateClassNamesMap(cl);
            } else {
                log.debug("Skipping duplicate " + cl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClassNamesMap(UnifiedClassLoader cl) {
        try {
            HashMap hashMap = this.classNamesMap;
            synchronized (hashMap) {
                String[] classNames = ClassLoaderUtils.updateClassNamesMap(cl, this.classNamesMap);
                this.loaderToClassNamesMap.put(cl, classNames);
            }
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace("Failed to update classes for cl=" + cl, e);
            }
            log.debug("Failed to update classes for cl=" + cl, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClassNamesMap(UnifiedClassLoader cl, URL url) {
        try {
            HashMap hashMap = this.classNamesMap;
            synchronized (hashMap) {
                String[] prevClassNames = (String[])this.loaderToClassNamesMap.get(cl);
                String[] classNames = ClassLoaderUtils.updateClassNamesMap(cl, this.classNamesMap, url, prevClassNames);
                this.loaderToClassNamesMap.put(cl, classNames);
            }
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace("Failed to update classes for cl=" + cl, e);
            }
            log.debug("Failed to update classes for cl=" + cl, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClassLoader(ClassLoader cl) {
        ArrayList<Notification> removeNotifications = new ArrayList<Notification>();
        HashSet hashSet = this.classLoaders;
        synchronized (hashSet) {
            Iterator<Object> i;
            if (cl instanceof UnifiedClassLoader) {
                UnifiedClassLoader ucl = (UnifiedClassLoader)cl;
                URL[] urls = ucl.getClasspath();
                for (int u = 0; u < urls.length; ++u) {
                    this.classLoaderURLs.remove(urls[u]);
                }
            }
            boolean removed = this.classLoaders.remove(cl);
            log.debug("UnifiedLoaderRepository removed(" + removed + ") " + cl);
            HashSet loadedClasses = null;
            boolean hasLoadedClasses = false;
            HashMap hashMap = this.classes;
            synchronized (hashMap) {
                ClassLoader theCL = cl;
                hasLoadedClasses = this.loaderToClassesMap.containsKey(theCL);
                while (!hasLoadedClasses && theCL.getParent() != null) {
                    ClassLoader parentCL = theCL.getParent();
                    if (parentCL != null) {
                        theCL = parentCL;
                    }
                    hasLoadedClasses = this.loaderToClassesMap.containsKey(theCL);
                }
                if (hasLoadedClasses) {
                    loadedClasses = (HashSet)this.loaderToClassesMap.remove(theCL);
                }
                if (loadedClasses != null) {
                    String className;
                    Iterator iter = loadedClasses.iterator();
                    while (iter.hasNext()) {
                        className = (String)iter.next();
                        Notification n = new Notification("jboss.mx.class.removed", (Object)this, this.getNextSequenceNumber(), className);
                        removeNotifications.add(n);
                    }
                    i = loadedClasses.iterator();
                    while (i.hasNext()) {
                        className = (String)i.next();
                        this.classes.remove(className);
                    }
                }
            }
            hashMap = this.loaderToResourcesMap;
            synchronized (hashMap) {
                HashMap resources;
                if (this.loaderToResourcesMap.containsKey(cl) && (resources = (HashMap)this.loaderToResourcesMap.remove(cl)) != null) {
                    i = resources.keySet().iterator();
                    while (i.hasNext()) {
                        String name = (String)i.next();
                        ResourceInfo ri = (ResourceInfo)this.globalResources.get(name);
                        if (ri == null || ri.cl != cl) continue;
                        this.globalResources.remove(name);
                    }
                }
            }
            hashMap = this.classNamesMap;
            synchronized (hashMap) {
                String[] classNames = (String[])this.loaderToClassNamesMap.remove(cl);
                int length = classNames != null ? classNames.length : 0;
                for (int c = 0; c < length; ++c) {
                    String jarClassName = classNames[c];
                    LinkedList ucls = (LinkedList)this.classNamesMap.get(jarClassName);
                    if (ucls == null) continue;
                    ucls.remove(cl);
                    if (!ucls.isEmpty()) continue;
                    this.classNamesMap.remove(jarClassName);
                }
            }
        }
        for (int n = 0; n < removeNotifications.size(); ++n) {
            Notification msg = (Notification)removeNotifications.get(n);
            this.broadcaster.sendNotification(msg);
        }
        Notification msg = new Notification("jboss.mx.classloader.removed", this, this.getNextSequenceNumber());
        msg.setUserData(cl);
        this.broadcaster.sendNotification(msg);
    }

    public LoaderRepository registerClassLoader(UnifiedClassLoader ucl) {
        this.addClassLoader(ucl);
        Notification msg = new Notification("jboss.mx.classloader.added", this, this.getNextSequenceNumber());
        msg.setUserData(ucl);
        this.broadcaster.sendNotification(msg);
        return this;
    }

    public LoaderRepository getInstance() {
        return this;
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.info == null) {
            this.info = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"CLASSLOADER_ADDED"}, "javax.management.Notification", "Notification that a classloader has been added to the extensible classloader"), new MBeanNotificationInfo(new String[]{"CLASS_REMOVED"}, "javax.management.Notification", "Notification that a class has been removed from the extensible classloader")};
        }
        return this.info;
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    private synchronized long getNextSequenceNumber() {
        return this.sequenceNumber++;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

