/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.jmx.server;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.jboss.axis.AxisFault;
import org.jboss.axis.Constants;
import org.jboss.axis.Message;
import org.jboss.axis.MessageContext;
import org.jboss.axis.description.OperationDesc;
import org.jboss.axis.description.ParameterDesc;
import org.jboss.axis.description.ServiceDesc;
import org.jboss.axis.encoding.TypeMapping;
import org.jboss.axis.handlers.soap.SOAPService;
import org.jboss.axis.message.RPCElement;
import org.jboss.axis.message.RPCParam;
import org.jboss.axis.message.SOAPBodyElementAxisImpl;
import org.jboss.axis.message.SOAPEnvelopeAxisImpl;
import org.jboss.axis.providers.BasicProvider;
import org.jboss.axis.utils.JavaUtils;
import org.jboss.axis.utils.Messages;
import org.jboss.axis.wsdl.fromJava.Emitter;
import org.jboss.axis.wsdl.fromJava.Types;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.util.Classes;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class MBeanProvider
extends BasicProvider {
    private static Logger log = Logger.getLogger(class$org$jboss$net$jmx$server$MBeanProvider == null ? (class$org$jboss$net$jmx$server$MBeanProvider = MBeanProvider.class$("org.jboss.net.jmx.server.MBeanProvider")) : class$org$jboss$net$jmx$server$MBeanProvider);
    protected MBeanServer server;
    protected ObjectName name;
    protected Map attributeData = new HashMap();
    protected Map methodData = new HashMap();
    protected String allowedMethodsOption = "allowedMethods";
    protected String allowedReadAttributesOption = "allowedReadAttributes";
    protected String allowedWriteAttributesOption = "allowedWriteAttributes";
    static /* synthetic */ Class class$org$jboss$net$jmx$server$MBeanProvider;
    static /* synthetic */ Class class$org$jboss$axis$description$ServiceDesc;
    static /* synthetic */ Class class$org$jboss$axis$wsdl$fromJava$Emitter;

    public void initServiceDesc(SOAPService service, MessageContext msgCtx) throws AxisFault {
        try {
            String allowedMethods = (String)service.getOption(this.allowedMethodsOption);
            String allowedReadAttributes = (String)service.getOption(this.allowedReadAttributesOption);
            String allowedWriteAttributes = (String)service.getOption(this.allowedWriteAttributesOption);
            String objectName = (String)service.getOption("ObjectName");
            String serverId = (String)service.getOption("MBeanServerId");
            try {
                this.server = MBeanServerLocator.locateJBoss();
            }
            catch (IllegalStateException e) {
                throw new AxisFault("Could not find the associated MBeanServer.");
            }
            this.name = new ObjectName(objectName);
            MBeanInfo info = this.server.getMBeanInfo(this.name);
            ServiceDesc serviceDesc = service.getServiceDescription();
            Field completeField = (class$org$jboss$axis$description$ServiceDesc == null ? (class$org$jboss$axis$description$ServiceDesc = MBeanProvider.class$("org.jboss.axis.description.ServiceDesc")) : class$org$jboss$axis$description$ServiceDesc).getDeclaredField("introspectionComplete");
            completeField.setAccessible(true);
            completeField.set(serviceDesc, Boolean.TRUE);
            Class implClass = Classes.loadClass(info.getClassName(), msgCtx.getClassLoader());
            serviceDesc.setImplClass(implClass);
            serviceDesc.setTypeMapping((TypeMapping)service.getTypeMappingRegistry().getTypeMapping(Constants.URI_DEFAULT_SOAP_ENC));
            MBeanOperationInfo[] operations = info.getOperations();
            for (int count = 0; count < operations.length; ++count) {
                String operationName = operations[count].getName();
                if ((allowedMethods == null || !allowedMethods.equals("*")) && allowedMethods.indexOf(operationName + " ") == -1 && allowedMethods.indexOf(" " + operationName) == -1 && !allowedMethods.equals(operationName)) continue;
                OperationDesc opDesc = new OperationDesc();
                if (this.methodData.containsKey(operationName)) {
                    operationName = operationName + count;
                }
                opDesc.setName(operationName);
                opDesc.setElementQName(new QName("", operationName));
                this.methodData.put(operationName, operations[count]);
                MBeanParameterInfo[] parameters = operations[count].getSignature();
                Class[] parameterTypes = new Class[parameters.length];
                for (int count2 = 0; count2 < parameters.length; ++count2) {
                    ParameterDesc param = new ParameterDesc();
                    param.setName("arg" + count2);
                    parameterTypes[count2] = this.forName(parameters[count2].getType(), msgCtx.getClassLoader());
                    param.setJavaType(parameterTypes[count2]);
                    param.setTypeQName(this.forName(parameterTypes[count2], serviceDesc.getTypeMapping()));
                    opDesc.addParameter(param);
                }
                opDesc.setReturnClass(this.forName(operations[count].getReturnType(), msgCtx.getClassLoader()));
                opDesc.setReturnType(this.forName(opDesc.getReturnClass(), serviceDesc.getTypeMapping()));
                serviceDesc.addOperationDesc(opDesc);
            }
            MBeanAttributeInfo[] attributes = info.getAttributes();
            for (int count = 0; count < attributes.length; ++count) {
                OperationDesc opDesc;
                String attributeName = attributes[count].getName();
                if (attributes[count].isReadable() && allowedReadAttributes != null && (allowedReadAttributes.equals("*") || allowedReadAttributes.indexOf(attributeName + " ") != -1 || allowedReadAttributes.indexOf(" " + attributeName) != -1 || allowedReadAttributes.equals(attributeName))) {
                    opDesc = new OperationDesc();
                    if (attributes[count].getType().equals("boolean")) {
                        opDesc.setName("is" + attributeName);
                    } else {
                        opDesc.setName("get" + attributeName);
                    }
                    if (this.methodData.containsKey(opDesc.getName())) {
                        opDesc.setName(opDesc.getName() + count + "A");
                    }
                    opDesc.setElementQName(new QName("", opDesc.getName()));
                    this.attributeData.put(opDesc.getName(), attributes[count]);
                    opDesc.setReturnClass(this.forName(attributes[count].getType(), msgCtx.getClassLoader()));
                    opDesc.setReturnType(this.forName(opDesc.getReturnClass(), serviceDesc.getTypeMapping()));
                    serviceDesc.addOperationDesc(opDesc);
                }
                if (!attributes[count].isWritable() || allowedWriteAttributes == null || !allowedWriteAttributes.equals("*") && allowedWriteAttributes.indexOf(attributeName + " ") == -1 && allowedWriteAttributes.indexOf(" " + attributeName) == -1 && !allowedWriteAttributes.equals(attributeName)) continue;
                opDesc = new OperationDesc();
                opDesc.setName("set" + attributeName);
                if (this.methodData.containsKey(opDesc.getName())) {
                    opDesc.setName(opDesc.getName() + count + "A");
                }
                opDesc.setElementQName(new QName("", opDesc.getName()));
                this.attributeData.put(opDesc.getName(), attributes[count]);
                ParameterDesc p = new ParameterDesc();
                p.setName("arg0");
                p.setJavaType(this.forName(attributes[count].getType(), msgCtx.getClassLoader()));
                p.setTypeQName(this.forName(p.getJavaType(), serviceDesc.getTypeMapping()));
                opDesc.addParameter(p);
                opDesc.setReturnType(null);
                serviceDesc.addOperationDesc(opDesc);
            }
        }
        catch (InstanceNotFoundException e) {
            throw new AxisFault("Could not find MBean instance.", (Throwable)e);
        }
        catch (IntrospectionException e) {
            throw new AxisFault("Could not introspect mbean.", (Throwable)e);
        }
        catch (ReflectionException e) {
            throw new AxisFault("Could not introspect mbean.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new AxisFault("Could not introspect mbean.", (Throwable)e);
        }
        catch (MalformedObjectNameException e) {
            throw new AxisFault("ObjectName could not be converted to a javax.management.ObjectName.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new AxisFault("Could not introspect mbean.", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            throw new AxisFault("Could not introspect mbean.", (Throwable)e);
        }
    }

    protected Class forName(String string, ClassLoader loader) throws ClassNotFoundException {
        if ("void".equals(string)) {
            return Void.TYPE;
        }
        if ("boolean".equals(string)) {
            return Boolean.TYPE;
        }
        if ("float".equals(string)) {
            return Float.TYPE;
        }
        if ("double".equals(string)) {
            return Double.TYPE;
        }
        if ("int".equals(string)) {
            return Integer.TYPE;
        }
        if ("long".equals(string)) {
            return Long.TYPE;
        }
        if ("short".equals(string)) {
            return Short.TYPE;
        }
        if ("byte".equals(string)) {
            return Byte.TYPE;
        }
        if ("char".equals(string)) {
            return Character.TYPE;
        }
        return Classes.loadClass(string, loader);
    }

    protected QName forName(Class clazz, TypeMapping tm) throws ClassNotFoundException {
        if (Void.TYPE.equals(clazz)) {
            return null;
        }
        return tm.getTypeQName(clazz);
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        SOAPEnvelopeAxisImpl resEnv;
        String serviceName = msgContext.getTargetService();
        Message reqMsg = msgContext.getRequestMessage();
        SOAPEnvelopeAxisImpl reqEnv = reqMsg.getSOAPEnvelope();
        Message resMsg = msgContext.getResponseMessage();
        SOAPEnvelopeAxisImpl sOAPEnvelopeAxisImpl = resEnv = resMsg == null ? new SOAPEnvelopeAxisImpl() : resMsg.getSOAPEnvelope();
        if (msgContext.getResponseMessage() == null) {
            resMsg = new Message((Object)resEnv);
            msgContext.setResponseMessage(resMsg);
        }
        Iterator allBodies = reqEnv.getBodyElements().iterator();
        while (allBodies.hasNext()) {
            Object nextBody = allBodies.next();
            if (!(nextBody instanceof RPCElement)) continue;
            RPCElement body = (RPCElement)nextBody;
            String mName = body.getMethodName();
            Vector args = null;
            try {
                args = body.getParams();
            }
            catch (SAXException e) {
                throw new AxisFault("Exception occurred in the target MBean method.", (Throwable)e);
            }
            Object result = null;
            try {
                MBeanAttributeInfo attr = (MBeanAttributeInfo)this.attributeData.get(mName);
                if (attr != null) {
                    if (mName.startsWith("get") || mName.startsWith("is")) {
                        result = this.server.getAttribute(this.name, attr.getName());
                    } else {
                        RPCParam p = (RPCParam)args.get(0);
                        Object arg = JavaUtils.convert((Object)p.getValue(), (Class)this.forName(attr.getType(), msgContext.getClassLoader()));
                        this.server.setAttribute(this.name, new Attribute(attr.getName(), arg));
                        result = null;
                    }
                } else {
                    MBeanOperationInfo meth = (MBeanOperationInfo)this.methodData.get(mName);
                    MBeanParameterInfo[] params = meth.getSignature();
                    Object[] arguments = new Object[params.length];
                    String[] classNames = new String[params.length];
                    for (int count2 = 0; count2 < params.length; ++count2) {
                        classNames[count2] = params[count2].getType();
                        if (args.size() > count2) {
                            RPCParam param = (RPCParam)args.get(count2);
                            arguments[count2] = JavaUtils.convert((Object)param.getValue(), (Class)this.forName(classNames[count2], msgContext.getClassLoader()));
                            continue;
                        }
                        arguments[count2] = null;
                    }
                    result = this.server.invoke(this.name, meth.getName(), arguments, classNames);
                }
                RPCElement resBody = new RPCElement(mName + "Response");
                resBody.setPrefix(body.getPrefix());
                resBody.setNamespaceURI(body.getNamespaceURI());
                RPCParam param = new RPCParam(mName + "Result", result);
                resBody.addParam(param);
                resEnv.addBodyElement((SOAPBodyElementAxisImpl)resBody);
                resEnv.setEncodingStyle(Constants.URI_DEFAULT_SOAP_ENC);
            }
            catch (InstanceNotFoundException e) {
                throw new AxisFault("Could not find MBean instance.", (Throwable)e);
            }
            catch (AttributeNotFoundException e) {
                throw new AxisFault("Could not find MBean attribute.", (Throwable)e);
            }
            catch (InvalidAttributeValueException e) {
                throw new AxisFault("Invalid Argument.", (Throwable)e);
            }
            catch (MBeanException e) {
                throw new AxisFault("Problems while interfacing JMX.", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new AxisFault("Could not find Java class.", (Throwable)e);
            }
            catch (ReflectionException e) {
                throw new AxisFault("Exception occurred in the target MBean method.", (Throwable)e.getTargetException());
            }
            catch (SOAPException e) {
                throw new AxisFault("Exception occurred in the target MBean method.", (Throwable)e);
            }
        }
    }

    public void generateWSDL(MessageContext msgCtx) throws AxisFault {
        SOAPService service = msgCtx.getService();
        ServiceDesc serviceDesc = service.getInitializedServiceDesc(msgCtx);
        if (msgCtx != null) {
            boolean isSoapAction = msgCtx.getProperty("org.jboss.net.axis.server.ACTION_HANDLER_PRESENT") == Boolean.TRUE;
            Iterator alloperations = serviceDesc.getOperations().iterator();
            while (alloperations.hasNext()) {
                OperationDesc opDesc = (OperationDesc)alloperations.next();
                opDesc.setSoapAction(isSoapAction ? service.getName() : null);
            }
        }
        try {
            String interfaceNamespace;
            String locationUrl = msgCtx.getStrProp("axis.wsdlgen.serv.loc.url");
            if (locationUrl == null) {
                locationUrl = serviceDesc.getEndpointURL();
            }
            if (locationUrl == null) {
                locationUrl = msgCtx.getStrProp("transport.url");
            }
            if ((interfaceNamespace = msgCtx.getStrProp("axis.wsdlgen.intfnamespace")) == null) {
                interfaceNamespace = serviceDesc.getDefaultNamespace();
            }
            if (interfaceNamespace == null) {
                interfaceNamespace = locationUrl;
            }
            Emitter emitter = new Emitter();
            String alias = (String)service.getOption("alias");
            if (alias != null) {
                emitter.setServiceElementName(alias);
            }
            emitter.setCls(serviceDesc.getImplClass());
            String targetNamespace = (String)service.getOption("wsdlTargetNamespace");
            if (targetNamespace == null || targetNamespace.length() == 0) {
                targetNamespace = interfaceNamespace;
            }
            emitter.setIntfNamespace(targetNamespace);
            emitter.setLocationUrl(locationUrl);
            emitter.setServiceDesc(serviceDesc);
            emitter.setTypeMapping((TypeMapping)service.getTypeMappingRegistry().getTypeMapping(Constants.URI_DEFAULT_SOAP_ENC));
            emitter.setDefaultTypeMapping((TypeMapping)msgCtx.getTypeMappingRegistry().getDefaultTypeMapping());
            String wsdlPortType = (String)service.getOption("wsdlPortType");
            String wsdlServiceElement = (String)service.getOption("wsdlServiceElement");
            String wsdlServicePort = (String)service.getOption("wsdlServicePort");
            if (wsdlPortType != null && wsdlPortType.length() > 0) {
                emitter.setPortTypeName(wsdlPortType);
            }
            if (wsdlServiceElement != null && wsdlServiceElement.length() > 0) {
                emitter.setServiceElementName(wsdlServiceElement);
            }
            if (wsdlServicePort != null && wsdlServicePort.length() > 0) {
                emitter.setServicePortName(wsdlServicePort);
            }
            Definition def = emitter.getWSDL();
            def.addNamespace("xsd99", "http://www.w3.org/1999/XMLSchema");
            def.addNamespace("xsd00", "http://www.w3.org/2000/10/XMLSchema");
            def.addNamespace("axis", "http://xml.apache.org/axis/");
            Document doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(def);
            Field field = (class$org$jboss$axis$wsdl$fromJava$Emitter == null ? (class$org$jboss$axis$wsdl$fromJava$Emitter = MBeanProvider.class$("org.jboss.axis.wsdl.fromJava.Emitter")) : class$org$jboss$axis$wsdl$fromJava$Emitter).getDeclaredField("types");
            field.setAccessible(true);
            ((Types)field.get(emitter)).insertTypesFragment(doc);
            msgCtx.setProperty("WSDL", (Object)doc);
        }
        catch (NoClassDefFoundError e) {
            log.info(Messages.getMessage((String)"toAxisFault00"), e);
            throw new AxisFault(e.toString(), (Throwable)e);
        }
        catch (Exception e) {
            log.info(Messages.getMessage((String)"toAxisFault00"), e);
            throw AxisFault.makeFault((Exception)e);
        }
    }

    public void undo(MessageContext msgContext) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

