/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import org.jboss.security.SecurityAssociation;

interface SecurityActions {
    public static final SecurityActions NON_PRIVILEGED = new SecurityActions(){

        public Principal getPrincipal() {
            return SecurityAssociation.getPrincipal();
        }

        public Object getCredential() {
            return SecurityAssociation.getCredential();
        }

        public String getProperty(String name, String defaultValue) {
            String prop = System.getProperty(name, defaultValue);
            return prop;
        }
    };
    public static final SecurityActions PRIVILEGED = new SecurityActions(){
        private final PrivilegedAction getPrincipalAction = new PrivilegedAction(this){
            private final /* synthetic */ 2 this$0;
            {
                this.this$0 = this$0;
            }

            public Object run() {
                return SecurityAssociation.getPrincipal();
            }
        };
        private final PrivilegedAction getCredentialAction = new PrivilegedAction(this){
            private final /* synthetic */ 2 this$0;
            {
                this.this$0 = this$0;
            }

            public Object run() {
                return SecurityAssociation.getCredential();
            }
        };

        public Principal getPrincipal() {
            return (Principal)AccessController.doPrivileged(this.getPrincipalAction);
        }

        public Object getCredential() {
            return AccessController.doPrivileged(this.getCredentialAction);
        }

        public String getProperty(String name, String defaultValue) {
            String prop = (String)AccessController.doPrivileged(new PrivilegedAction(this, name, defaultValue){
                private final /* synthetic */ String val$name;
                private final /* synthetic */ String val$defaultValue;
                private final /* synthetic */ 2 this$0;
                {
                    this.this$0 = this$0;
                    this.val$name = val$name;
                    this.val$defaultValue = val$defaultValue;
                }

                public Object run() {
                    String p = System.getProperty(this.val$name, this.val$defaultValue);
                    return p;
                }
            });
            return prop;
        }
    };

    public Principal getPrincipal();

    public Object getCredential();

    public String getProperty(String var1, String var2);

    public static class UTIL {
        static SecurityActions getSecurityActions() {
            return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
        }
    }
}

