/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.util.Iterator;
import java.util.Map;
import javax.security.auth.AuthPermission;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;

public class AuthenticationInfo {
    public static final AuthPermission GET_CONFIG_ENTRY_PERM = new AuthPermission("getLoginConfiguration");
    public static final AuthPermission SET_CONFIG_ENTRY_PERM = new AuthPermission("setLoginConfiguration");
    private AppConfigurationEntry[] loginModules;
    private CallbackHandler callbackHandler;

    public AppConfigurationEntry[] copyAppConfigurationEntry() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONFIG_ENTRY_PERM);
        }
        AppConfigurationEntry[] copy = new AppConfigurationEntry[this.loginModules.length];
        for (int i = 0; i < this.loginModules.length; ++i) {
            AppConfigurationEntry entry = this.loginModules[i];
            copy[i] = new AppConfigurationEntry(entry.getLoginModuleName(), entry.getControlFlag(), entry.getOptions());
        }
        return copy;
    }

    public AppConfigurationEntry[] getAppConfigurationEntry() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONFIG_ENTRY_PERM);
        }
        return this.loginModules;
    }

    public void setAppConfigurationEntry(AppConfigurationEntry[] loginModules) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONFIG_ENTRY_PERM);
        }
        this.loginModules = loginModules;
    }

    public CallbackHandler getAppCallbackHandler() {
        return this.callbackHandler;
    }

    public void setAppCallbackHandler(CallbackHandler handler) {
        this.callbackHandler = handler;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("AppConfigurationEntry[]:\n");
        for (int i = 0; i < this.loginModules.length; ++i) {
            AppConfigurationEntry entry = this.loginModules[i];
            buffer.append("[" + i + "]");
            buffer.append("\nLoginModule Class: " + entry.getLoginModuleName());
            buffer.append("\nControlFlag: " + entry.getControlFlag());
            buffer.append("\nOptions:");
            Map<String, ?> options = entry.getOptions();
            Iterator<Map.Entry<String, ?>> iter = options.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, ?> e = iter.next();
                buffer.append("name=" + e.getKey());
                buffer.append(", value=" + e.getValue());
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }
}

