/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.ssl;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.logging.Logger;

public class ClientSocketFactory
extends SocketFactory
implements HandshakeCompletedListener,
Serializable {
    static /* synthetic */ Class class$org$jboss$security$ssl$ClientSocketFactory;

    public Socket createSocket(String serverHost, int serverPort) throws IOException, UnknownHostException {
        InetAddress serverAddr = InetAddress.getByName(serverHost);
        return this.createSocket(serverAddr, serverPort);
    }

    public Socket createSocket(String serverHost, int serverPort, InetAddress clientAddr, int clientPort) throws IOException, UnknownHostException {
        InetAddress serverAddr = InetAddress.getByName(serverHost);
        return this.createSocket(serverAddr, serverPort, clientAddr, clientPort);
    }

    public Socket createSocket(InetAddress serverAddr, int serverPort) throws IOException {
        return this.createSocket(serverAddr, serverPort, null, 0);
    }

    public Socket createSocket(InetAddress serverAddr, int serverPort, InetAddress clientAddr, int clientPort) throws IOException {
        SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket socket = (SSLSocket)factory.createSocket(serverAddr, serverPort, clientAddr, clientPort);
        socket.addHandshakeCompletedListener(this);
        return socket;
    }

    public boolean equals(Object obj) {
        return obj instanceof ClientSocketFactory;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
        Logger log = Logger.getLogger(class$org$jboss$security$ssl$ClientSocketFactory == null ? (class$org$jboss$security$ssl$ClientSocketFactory = ClientSocketFactory.class$("org.jboss.security.ssl.ClientSocketFactory")) : class$org$jboss$security$ssl$ClientSocketFactory);
        if (log.isTraceEnabled()) {
            String cipher = handshakeCompletedEvent.getCipherSuite();
            SSLSession session = handshakeCompletedEvent.getSession();
            String peerHost = session.getPeerHost();
            log.debug("SSL handshakeCompleted, cipher=" + cipher + ", peerHost=" + peerHost);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

