/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.tm.GlobalId;
import org.jboss.tm.JBossRollbackException;
import org.jboss.tm.TransactionLocal;
import org.jboss.tm.TransactionManagerService;
import org.jboss.tm.TxManager;
import org.jboss.tm.TxUtils;
import org.jboss.tm.XidFactory;
import org.jboss.tm.XidFactoryMBean;
import org.jboss.util.timeout.Timeout;
import org.jboss.util.timeout.TimeoutFactory;
import org.jboss.util.timeout.TimeoutTarget;

class TransactionImpl
implements Transaction,
TimeoutTarget {
    private static final int HEUR_NONE = 4;
    private static final int RS_NEW = 0;
    private static final int RS_ENLISTED = 1;
    private static final int RS_SUSPENDED = 2;
    private static final int RS_ENDED = 3;
    private static final int RS_VOTE_READONLY = 4;
    private static final int RS_VOTE_OK = 5;
    private static final int RS_FORGOT = 6;
    private static Logger log = Logger.getLogger(class$org$jboss$tm$TransactionImpl == null ? (class$org$jboss$tm$TransactionImpl = TransactionImpl.class$("org.jboss.tm.TransactionImpl")) : class$org$jboss$tm$TransactionImpl);
    private boolean trace = log.isTraceEnabled();
    private Xid xid;
    private HashSet threads = new HashSet(1);
    private HashMap transactionLocalMap = new HashMap();
    private Throwable cause;
    private GlobalId globalId;
    private Synchronization[] sync = new Synchronization[3];
    private int syncAllocSize = 3;
    private int syncCount = 0;
    private XAResource[] resources = new XAResource[3];
    private int[] resourceState = new int[3];
    private int[] resourceSameRM = new int[3];
    private Xid[] resourceXids = new Xid[3];
    private int resourceAllocSize = 3;
    private int resourceCount = 0;
    private boolean resourcesEnded = false;
    private long lastBranchId = 0L;
    private int status = 0;
    private int heuristicCode = 4;
    private long start;
    private Timeout timeout;
    private long timeoutPeriod;
    private boolean locked = false;
    private boolean done = false;
    static XidFactoryMBean xidFactory;
    static TransactionManagerService txManagerService;
    static /* synthetic */ Class class$org$jboss$tm$TransactionImpl;

    static void defaultXidFactory() {
        if (xidFactory == null) {
            xidFactory = new XidFactory();
        }
    }

    TransactionImpl(long timeout) {
        this.xid = xidFactory.newXid();
        this.globalId = new GlobalId(this.xid);
        this.start = System.currentTimeMillis();
        this.timeout = TimeoutFactory.createTimeout(this.start + timeout, this);
        this.timeoutPeriod = timeout;
        if (this.trace) {
            log.trace("Created new instance for tx=" + this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timedOut(Timeout timeout) {
        this.lock();
        try {
            log.warn("Transaction " + this.toString() + " timed out." + " status=" + this.getStringStatus(this.status));
            if (this.timeout == null) {
                return;
            }
            this.timeout = null;
            switch (this.status) {
                case 3: 
                case 4: 
                case 6: {
                    return;
                }
                case 9: {
                    return;
                }
                case 8: {
                    this.gotHeuristic(-1, 5);
                    this.status = 1;
                    return;
                }
                case 0: 
                case 2: {
                    this.status = 1;
                }
                case 1: {
                    this.interruptThreads();
                    return;
                }
                case 7: {
                    this.status = 1;
                    return;
                }
            }
            log.warn("Unknown status at timeout, tx=" + this.toString());
            return;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.lock();
        try {
            if (this.trace) {
                log.trace("Committing, tx=" + this + ", status=" + this.getStringStatus(this.status));
            }
            switch (this.status) {
                case 7: {
                    throw new IllegalStateException("Already started preparing.");
                }
                case 2: {
                    throw new IllegalStateException("Already prepared.");
                }
                case 9: {
                    throw new IllegalStateException("Already started rolling back.");
                }
                case 4: {
                    this.instanceDone();
                    this.checkHeuristics();
                    throw new IllegalStateException("Already rolled back.");
                }
                case 8: {
                    throw new IllegalStateException("Already started committing.");
                }
                case 3: {
                    this.instanceDone();
                    this.checkHeuristics();
                    throw new IllegalStateException("Already committed.");
                }
                case 6: {
                    throw new IllegalStateException("No transaction.");
                }
                case 5: {
                    throw new IllegalStateException("Unknown state");
                }
                case 1: {
                    this.endResources();
                    this.rollbackResources();
                    this.doAfterCompletion();
                    this.cancelTimeout();
                    this.instanceDone();
                    this.checkHeuristics();
                    throw new RollbackException("Already marked for rollback");
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal status: " + this.status);
                }
            }
            this.doBeforeCompletion();
            if (this.trace) {
                log.trace("Before completion done, tx=" + this + ", status=" + this.getStringStatus(this.status));
            }
            this.endResources();
            if (this.status == 0) {
                if (this.resourceCount == 0) {
                    if (this.trace) {
                        log.trace("Zero phase commit: No resources.");
                    }
                    this.status = 3;
                } else if (this.isOneResource()) {
                    if (this.trace) {
                        log.trace("One phase commit: One resource.");
                    }
                    this.commitResources(true);
                } else {
                    if (this.trace) {
                        log.trace("Two phase commit: Many resources.");
                    }
                    if (!this.prepareResources()) {
                        boolean commitDecision;
                        boolean bl = commitDecision = this.status == 2 && (this.heuristicCode == 4 || this.heuristicCode == 7);
                        if (commitDecision) {
                            this.commitResources(false);
                        }
                    } else {
                        this.status = 3;
                    }
                }
            }
            if (this.status != 3) {
                this.rollbackResources();
                this.doAfterCompletion();
                this.cancelTimeout();
                Throwable causedByThrowable = this.cause;
                this.instanceDone();
                throw new JBossRollbackException("Unable to commit, tx=" + this.toString() + " status=" + this.getStringStatus(this.status), causedByThrowable);
            }
            this.cancelTimeout();
            this.doAfterCompletion();
            this.instanceDone();
            this.checkHeuristics();
            if (this.trace) {
                log.trace("Committed OK, tx=" + this);
            }
        }
        finally {
            this.transactionLocalMap.clear();
            this.threads.clear();
            this.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        block9: {
            this.lock();
            try {
                if (this.trace) {
                    log.trace("rollback(): Entered, tx=" + this.toString() + " status=" + this.getStringStatus(this.status));
                }
                switch (this.status) {
                    case 0: {
                        this.status = 1;
                    }
                    case 1: {
                        this.endResources();
                        this.rollbackResources();
                        this.cancelTimeout();
                        this.doAfterCompletion();
                        this.instanceDone();
                        this.heuristicCode = 4;
                        Object var2_1 = null;
                        this.transactionLocalMap.clear();
                        this.threads.clear();
                        break;
                    }
                    case 7: {
                        this.status = 1;
                        break block9;
                    }
                    default: {
                        throw new IllegalStateException("Cannot rollback(), tx=" + this.toString() + " status=" + this.getStringStatus(this.status));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.transactionLocalMap.clear();
                this.threads.clear();
                Thread.interrupted();
                this.unlock();
                throw throwable;
            }
            Thread.interrupted();
            this.unlock();
            return;
        }
        Object var2_2 = null;
        this.transactionLocalMap.clear();
        this.threads.clear();
        Thread.interrupted();
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        if (xaRes == null) {
            throw new IllegalArgumentException("null xaRes");
        }
        if (flag != 0x4000000 && flag != 0x2000000 && flag != 0x20000000) {
            throw new IllegalArgumentException("Bad flag: " + flag);
        }
        this.lock();
        try {
            int idx;
            block22: {
                if (this.trace) {
                    log.trace("delistResource(): Entered, tx=" + this.toString() + " status=" + this.getStringStatus(this.status));
                }
                if ((idx = this.findResource(xaRes)) == -1) {
                    throw new IllegalArgumentException("xaRes not enlisted");
                }
                switch (this.status) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 7: {
                        throw new IllegalStateException("Already started preparing.");
                    }
                    case 9: {
                        throw new IllegalStateException("Already started rolling back.");
                    }
                    case 2: {
                        throw new IllegalStateException("Already prepared.");
                    }
                    case 8: {
                        throw new IllegalStateException("Already started committing.");
                    }
                    case 3: {
                        throw new IllegalStateException("Already committed.");
                    }
                    case 4: {
                        throw new IllegalStateException("Already rolled back.");
                    }
                    case 6: {
                        throw new IllegalStateException("No transaction.");
                    }
                    case 5: {
                        throw new IllegalStateException("Unknown state");
                    }
                    default: {
                        throw new IllegalStateException("Illegal status: " + this.status);
                    }
                }
                try {
                    if (this.resourceState[idx] != 3 || this.resources[idx].isSameRM(xaRes)) break block22;
                    log.warn("Resource already delisted.  tx=" + this.toString());
                    boolean bl = false;
                    return bl;
                }
                catch (XAException xae) {
                    this.logXAException(xae);
                    this.status = 1;
                    this.cause = xae;
                    boolean bl = false;
                    return bl;
                }
            }
            this.endResource(idx, flag);
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        if (xaRes == null) {
            throw new IllegalArgumentException("null xaRes");
        }
        this.lock();
        try {
            boolean bl;
            block26: {
                int idx;
                block27: {
                    if (this.trace) {
                        log.trace("enlistResource(): Entered, tx=" + this.toString() + " status=" + this.getStringStatus(this.status));
                    }
                    switch (this.status) {
                        case 0: 
                        case 7: {
                            break;
                        }
                        case 2: {
                            throw new IllegalStateException("Already prepared.");
                        }
                        case 8: {
                            throw new IllegalStateException("Already started committing.");
                        }
                        case 3: {
                            throw new IllegalStateException("Already committed.");
                        }
                        case 1: {
                            throw new RollbackException("Already marked for rollback");
                        }
                        case 9: {
                            throw new RollbackException("Already started rolling back.");
                        }
                        case 4: {
                            throw new RollbackException("Already rolled back.");
                        }
                        case 6: {
                            throw new IllegalStateException("No transaction.");
                        }
                        case 5: {
                            throw new IllegalStateException("Unknown state");
                        }
                        default: {
                            throw new IllegalStateException("Illegal status: " + this.status);
                        }
                    }
                    if (this.resourcesEnded) {
                        throw new IllegalStateException("Too late to enlist resources");
                    }
                    try {
                        idx = this.findResource(xaRes);
                        if (idx == -1) break block26;
                        if (this.resourceState[idx] != 1) break block27;
                        boolean bl2 = false;
                        return bl2;
                    }
                    catch (XAException xae) {
                        this.logXAException(xae);
                        this.cause = xae;
                        bl = false;
                        return bl;
                    }
                }
                if (this.resourceState[idx] == 3 && !this.resources[idx].isSameRM(xaRes)) {
                    idx = -1;
                } else {
                    this.startResource(idx);
                    boolean bl3 = true;
                    return bl3;
                }
            }
            for (int i = 0; i < this.resourceCount; ++i) {
                if (this.resourceSameRM[i] != -1 || !xaRes.isSameRM(this.resources[i])) continue;
                this.startResource(this.addResource(xaRes, this.resourceXids[i], i));
                boolean bl4 = true;
                return bl4;
            }
            this.startResource(this.addResource(xaRes, this.createXidBranch(), -1));
            bl = true;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public int getStatus() throws SystemException {
        if (this.done) {
            return 6;
        }
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSynchronization(Synchronization s) throws RollbackException, IllegalStateException, SystemException {
        if (s == null) {
            throw new IllegalArgumentException("Null synchronization");
        }
        this.lock();
        try {
            if (this.trace) {
                log.trace("registerSynchronization(): Entered, tx=" + this.toString() + " status=" + this.getStringStatus(this.status));
            }
            switch (this.status) {
                case 0: 
                case 7: {
                    break;
                }
                case 2: {
                    throw new IllegalStateException("Already prepared.");
                }
                case 8: {
                    throw new IllegalStateException("Already started committing.");
                }
                case 3: {
                    throw new IllegalStateException("Already committed.");
                }
                case 1: {
                    throw new RollbackException("Already marked for rollback");
                }
                case 9: {
                    throw new RollbackException("Already started rolling back.");
                }
                case 4: {
                    throw new RollbackException("Already rolled back.");
                }
                case 6: {
                    throw new IllegalStateException("No transaction.");
                }
                case 5: {
                    throw new IllegalStateException("Unknown state");
                }
                default: {
                    throw new IllegalStateException("Illegal status: " + this.status);
                }
            }
            if (this.syncCount == this.syncAllocSize) {
                this.syncAllocSize = 2 * this.syncAllocSize;
                Synchronization[] sy = new Synchronization[this.syncAllocSize];
                System.arraycopy(this.sync, 0, sy, 0, this.syncCount);
                this.sync = sy;
            }
            this.sync[this.syncCount++] = s;
        }
        finally {
            this.unlock();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.lock();
        try {
            if (this.trace) {
                log.trace("setRollbackOnly(): Entered, tx=" + this.toString() + " status=" + this.getStringStatus(this.status));
            }
            switch (this.status) {
                case 0: 
                case 2: 
                case 7: {
                    this.status = 1;
                }
                case 1: 
                case 9: {
                    return;
                }
                case 8: {
                    throw new IllegalStateException("Already started committing.");
                }
                case 3: {
                    throw new IllegalStateException("Already committed.");
                }
                case 4: {
                    throw new IllegalStateException("Already rolled back.");
                }
                case 6: {
                    throw new IllegalStateException("No transaction.");
                }
                case 5: {
                    throw new IllegalStateException("Unknown state");
                }
            }
            throw new IllegalStateException("Illegal status: " + this.status);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateCurrentThread() {
        Thread.interrupted();
        this.lock();
        try {
            this.threads.add(Thread.currentThread());
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disassociateCurrentThread() {
        if (this.done) {
            this.threads.remove(Thread.currentThread());
        } else {
            this.lock();
            try {
                this.threads.remove(Thread.currentThread());
            }
            finally {
                this.unlock();
            }
        }
        Thread.interrupted();
    }

    public int hashCode() {
        return this.globalId.hashCode();
    }

    public String toString() {
        return "TransactionImpl:" + xidFactory.toString(this.xid);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof TransactionImpl) {
            return this.globalId.equals(((TransactionImpl)obj).globalId);
        }
        return false;
    }

    boolean isDone() {
        return this.done;
    }

    GlobalId getGlobalId() {
        return this.globalId;
    }

    private void interruptThreads() {
        HashSet clone = (HashSet)this.threads.clone();
        this.threads.clear();
        Iterator i = clone.iterator();
        while (i.hasNext()) {
            Thread thread = (Thread)i.next();
            try {
                thread.interrupt();
            }
            catch (Throwable ignored) {
                log.trace("Ignored error interrupting thread " + thread, ignored);
            }
        }
    }

    private String getStringStatus(int status) {
        switch (status) {
            case 7: {
                return "STATUS_PREPARING";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 8: {
                return "STATUS_COMMITING";
            }
            case 3: {
                return "STATUS_COMMITED";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
            case 0: {
                return "STATUS_ACTIVE";
            }
        }
        return "STATUS_UNKNOWN(" + status + ")";
    }

    private String getStringXAErrorCode(int errorCode) {
        switch (errorCode) {
            case 7: {
                return "XA_HEURCOM";
            }
            case 8: {
                return "XA_HEURHAZ";
            }
            case 5: {
                return "XA_HEURMIX";
            }
            case 6: {
                return "XA_HEURRB";
            }
            case 9: {
                return "XA_NOMIGRATE";
            }
            case 101: {
                return "XA_RBCOMMFAIL";
            }
            case 102: {
                return "XA_RBDEADLOCK";
            }
            case 103: {
                return "XA_RBINTEGRITY";
            }
            case 104: {
                return "XA_RBOTHER";
            }
            case 105: {
                return "XA_RBPROTO";
            }
            case 100: {
                return "XA_RBROLLBACK";
            }
            case 106: {
                return "XA_RBTIMEOUT";
            }
            case 107: {
                return "XA_RBTRANSIENT";
            }
            case 3: {
                return "XA_RDONLY";
            }
            case 4: {
                return "XA_RETRY";
            }
            case -2: {
                return "XAER_ASYNC";
            }
            case -8: {
                return "XAER_DUPID";
            }
            case -5: {
                return "XAER_INVAL";
            }
            case -4: {
                return "XAER_NOTA";
            }
            case -9: {
                return "XAER_OUTSIDE";
            }
            case -6: {
                return "XAER_PROTO";
            }
            case -3: {
                return "XAER_RMERR";
            }
            case -7: {
                return "XAER_RMFAIL";
            }
        }
        return "XA_UNKNOWN(" + errorCode + ")";
    }

    private void logXAException(XAException xae) {
        log.warn("XAException: tx=" + this.toString() + " errorCode=" + this.getStringXAErrorCode(xae.errorCode), xae);
        if (txManagerService != null) {
            txManagerService.formatXAException(xae, log);
        }
    }

    private synchronized void lock() {
        if (this.done) {
            throw new IllegalStateException("Transaction has terminated");
        }
        if (this.locked) {
            log.warn("Lock contention, tx=" + this.toString());
            while (this.locked) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.done) continue;
                throw new IllegalStateException("Transaction has now terminated");
            }
        }
        this.locked = true;
    }

    private synchronized void unlock() {
        if (!this.locked) {
            log.warn("Unlocking, but not locked, tx=" + this.toString(), new Throwable("[Stack trace]"));
        }
        this.locked = false;
        this.notify();
    }

    private synchronized void instanceDone() {
        TxManager manager = TxManager.getInstance();
        if (this.status == 3) {
            manager.incCommitCount();
        } else {
            manager.incRollbackCount();
        }
        manager.releaseTransactionImpl(this);
        this.status = 6;
        this.sync = null;
        this.resources = null;
        this.notifyAll();
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTimeout() {
        if (this.timeout != null) {
            this.unlock();
            try {
                this.timeout.cancel();
            }
            catch (Exception e) {
                if (this.trace) {
                    log.trace("failed to cancel timeout", e);
                }
            }
            finally {
                this.lock();
            }
            this.timeout = null;
        }
    }

    private int findResource(XAResource xaRes) {
        for (int idx = this.resourceCount - 1; idx >= 0; --idx) {
            if (xaRes != this.resources[idx]) continue;
            return idx;
        }
        return -1;
    }

    private int addResource(XAResource xaRes, Xid branchXid, int idxSameRM) {
        if (this.resourceCount == this.resourceAllocSize) {
            this.resourceAllocSize = 2 * this.resourceAllocSize;
            XAResource[] res = new XAResource[this.resourceAllocSize];
            System.arraycopy(this.resources, 0, res, 0, this.resourceCount);
            this.resources = res;
            int[] stat = new int[this.resourceAllocSize];
            System.arraycopy(this.resourceState, 0, stat, 0, this.resourceCount);
            this.resourceState = stat;
            Xid[] xids = new Xid[this.resourceAllocSize];
            System.arraycopy(this.resourceXids, 0, xids, 0, this.resourceCount);
            this.resourceXids = xids;
            int[] sameRM = new int[this.resourceAllocSize];
            System.arraycopy(this.resourceSameRM, 0, sameRM, 0, this.resourceCount);
            this.resourceSameRM = sameRM;
        }
        this.resources[this.resourceCount] = xaRes;
        this.resourceState[this.resourceCount] = 0;
        this.resourceXids[this.resourceCount] = branchXid;
        this.resourceSameRM[this.resourceCount] = idxSameRM;
        return this.resourceCount++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startResource(int idx) throws XAException {
        int flags = 0x200000;
        if (this.resourceSameRM[idx] == -1) {
            switch (this.resourceState[idx]) {
                case 0: {
                    flags = 0;
                    break;
                }
                case 2: {
                    flags = 0x8000000;
                    break;
                }
                default: {
                    if (!this.trace) break;
                    log.trace("Unhandled resource state: " + this.resourceState[idx] + " (not RS_NEW or RS_SUSPENDED, using TMJOIN flags)");
                }
            }
        }
        if (this.trace) {
            log.trace("startResource(" + xidFactory.toString(this.resourceXids[idx]) + ") entered: " + this.resources[idx].toString() + " flags=" + flags);
        }
        this.unlock();
        try {
            try {
                this.resources[idx].start(this.resourceXids[idx], flags);
            }
            catch (XAException e) {
                throw e;
            }
            catch (Throwable t) {
                if (this.trace) {
                    log.trace("unhandled throwable error in startResource", t);
                }
                this.status = 1;
                Object var5_5 = null;
                this.lock();
                if (this.trace) {
                    log.trace("startResource(" + xidFactory.toString(this.resourceXids[idx]) + ") leaving: " + this.resources[idx].toString() + " flags=" + flags);
                }
                return;
            }
            this.resourceState[idx] = 1;
            Object var5_6 = null;
            this.lock();
            if (this.trace) {
                log.trace("startResource(" + xidFactory.toString(this.resourceXids[idx]) + ") leaving: " + this.resources[idx].toString() + " flags=" + flags);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.lock();
            if (this.trace) {
                log.trace("startResource(" + xidFactory.toString(this.resourceXids[idx]) + ") leaving: " + this.resources[idx].toString() + " flags=" + flags);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endResource(int idx, int flag) throws XAException {
        if (this.trace) {
            log.trace("endResource(" + xidFactory.toString(this.resourceXids[idx]) + ") entered: " + this.resources[idx].toString() + " flag=" + flag);
        }
        this.unlock();
        try {
            try {
                this.resources[idx].end(this.resourceXids[idx], flag);
            }
            catch (XAException e) {
                throw e;
            }
            catch (Throwable t) {
                if (this.trace) {
                    log.trace("unhandled throwable error in endResource", t);
                }
                this.status = 1;
                this.resourceState[idx] = 3;
                Object var5_5 = null;
                this.lock();
                if (this.trace) {
                    log.trace("endResource(" + xidFactory.toString(this.resourceXids[idx]) + ") leaving: " + this.resources[idx].toString() + " flag=" + flag);
                }
                return;
            }
            if (flag == 0x2000000) {
                this.resourceState[idx] = 2;
            } else {
                if (flag == 0x20000000) {
                    this.status = 1;
                }
                this.resourceState[idx] = 3;
            }
            Object var5_6 = null;
            this.lock();
            if (this.trace) {
                log.trace("endResource(" + xidFactory.toString(this.resourceXids[idx]) + ") leaving: " + this.resources[idx].toString() + " flag=" + flag);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.lock();
            if (this.trace) {
                log.trace("endResource(" + xidFactory.toString(this.resourceXids[idx]) + ") leaving: " + this.resources[idx].toString() + " flag=" + flag);
            }
            throw throwable;
        }
    }

    private void endResources() {
        for (int idx = 0; idx < this.resourceCount; ++idx) {
            try {
                if (this.resourceState[idx] != 1 && this.resourceState[idx] != 2) continue;
                if (this.trace) {
                    log.trace("endresources(" + idx + "): state=" + this.resourceState[idx]);
                }
                this.endResource(idx, 0x4000000);
                continue;
            }
            catch (XAException xae) {
                this.logXAException(xae);
                this.status = 1;
                this.cause = xae;
            }
        }
        this.resourcesEnded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBeforeCompletion() {
        this.unlock();
        try {
            for (int i = 0; i < this.syncCount; ++i) {
                try {
                    if (this.trace) {
                        log.trace("calling sync " + i + ", " + this.sync[i]);
                    }
                    this.sync[i].beforeCompletion();
                    continue;
                }
                catch (Throwable t) {
                    if (this.trace) {
                        log.trace("failed before completion", t);
                    }
                    this.status = 1;
                    this.cause = t;
                    break;
                }
            }
        }
        finally {
            this.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAfterCompletion() {
        this.unlock();
        try {
            for (int i = 0; i < this.syncCount; ++i) {
                try {
                    this.sync[i].afterCompletion(this.status);
                    continue;
                }
                catch (Throwable t) {
                    if (!this.trace) continue;
                    log.trace("failed after completion", t);
                }
            }
        }
        finally {
            this.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gotHeuristic(int resIdx, int code) {
        switch (code) {
            case 5: {
                this.heuristicCode = 5;
                break;
            }
            case 6: {
                if (this.heuristicCode == 4) {
                    this.heuristicCode = 6;
                    break;
                }
                if (this.heuristicCode != 7 && this.heuristicCode != 8) break;
                this.heuristicCode = 5;
                break;
            }
            case 7: {
                if (this.heuristicCode == 4) {
                    this.heuristicCode = 7;
                    break;
                }
                if (this.heuristicCode != 6 && this.heuristicCode != 8) break;
                this.heuristicCode = 5;
                break;
            }
            case 8: {
                if (this.heuristicCode == 4) {
                    this.heuristicCode = 8;
                    break;
                }
                if (this.heuristicCode != 7 && this.heuristicCode != 6) break;
                this.heuristicCode = 5;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (resIdx != -1) {
            try {
                this.unlock();
                this.resources[resIdx].forget(this.resourceXids[resIdx]);
            }
            catch (XAException xae) {
                this.logXAException(xae);
                this.cause = xae;
            }
            finally {
                this.lock();
            }
            this.resourceState[resIdx] = 6;
        }
    }

    private void checkHeuristics() throws HeuristicMixedException, HeuristicRollbackException {
        switch (this.heuristicCode) {
            case 5: 
            case 8: {
                this.heuristicCode = 4;
                if (this.trace) {
                    log.trace("Throwing HeuristicMixedException, status=" + this.getStringStatus(this.status));
                }
                throw new HeuristicMixedException();
            }
            case 6: {
                this.heuristicCode = 4;
                if (this.trace) {
                    log.trace("Throwing HeuristicRollbackException, status=" + this.getStringStatus(this.status));
                }
                throw new HeuristicRollbackException();
            }
            case 7: {
                this.heuristicCode = 4;
                if (this.trace) {
                    log.trace("NOT Throwing HeuristicCommitException, status=" + this.getStringStatus(this.status));
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareResources() {
        boolean readOnly = true;
        this.status = 7;
        block10: for (int i = 0; i < this.resourceCount; ++i) {
            if (this.status != 7) {
                return false;
            }
            if (this.resourceSameRM[i] != -1) continue;
            XAResource resource = this.resources[i];
            try {
                int vote;
                this.unlock();
                try {
                    vote = resource.prepare(this.resourceXids[i]);
                }
                finally {
                    this.lock();
                }
                if (vote == 0) {
                    readOnly = false;
                    this.resourceState[i] = 5;
                    continue;
                }
                if (vote == 3) {
                    this.resourceState[i] = 4;
                    continue;
                }
                if (this.trace) {
                    log.trace("illegal vote in prepare resources", new Exception());
                }
                this.status = 1;
                return false;
            }
            catch (XAException e) {
                readOnly = false;
                this.logXAException(e);
                switch (e.errorCode) {
                    case 7: {
                        this.gotHeuristic(i, e.errorCode);
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 8: {
                        this.gotHeuristic(i, e.errorCode);
                        if (this.status != 7) continue block10;
                        this.status = 1;
                        break;
                    }
                    default: {
                        this.cause = e;
                        if (this.status != 7) continue block10;
                        this.status = 1;
                        break;
                    }
                }
                continue;
            }
            catch (Throwable t) {
                if (this.trace) {
                    log.trace("unhandled throwable in prepareResources", t);
                }
                if (this.status == 7) {
                    this.status = 1;
                }
                this.cause = t;
            }
        }
        if (this.status == 7) {
            this.status = 2;
        }
        return readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitResources(boolean onePhase) {
        this.status = 8;
        block9: for (int i = 0; i < this.resourceCount; ++i) {
            if (this.trace) {
                log.trace("Committing resources, resourceStates[" + i + "]=" + this.resourceState[i]);
            }
            if (!onePhase && this.resourceState[i] != 5 || this.resourceSameRM[i] != -1) continue;
            if (this.status != 8) {
                return;
            }
            try {
                this.unlock();
                try {
                    this.resources[i].commit(this.resourceXids[i], onePhase);
                    continue;
                }
                finally {
                    this.lock();
                }
            }
            catch (XAException e) {
                this.logXAException(e);
                switch (e.errorCode) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.gotHeuristic(i, e.errorCode);
                        if (!onePhase) continue block9;
                        this.status = 1;
                        break;
                    }
                    default: {
                        this.cause = e;
                        if (!onePhase) continue block9;
                        this.status = 1;
                        break;
                    }
                }
                continue;
            }
            catch (Throwable t) {
                if (!this.trace) continue;
                log.trace("unhandled throwable in commitResources", t);
            }
        }
        if (this.status == 8) {
            this.status = 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackResources() {
        this.status = 9;
        for (int i = 0; i < this.resourceCount; ++i) {
            if (this.resourceState[i] == 4 || this.resourceState[i] == 6 || this.resourceSameRM[i] != -1) continue;
            try {
                this.unlock();
                try {
                    this.resources[i].rollback(this.resourceXids[i]);
                    continue;
                }
                finally {
                    this.lock();
                }
            }
            catch (XAException e) {
                this.logXAException(e);
                switch (e.errorCode) {
                    case 6: {
                        this.gotHeuristic(i, e.errorCode);
                        break;
                    }
                    case 5: 
                    case 7: 
                    case 8: {
                        this.gotHeuristic(i, e.errorCode);
                        break;
                    }
                    default: {
                        this.cause = e;
                        break;
                    }
                }
                continue;
            }
            catch (Throwable t) {
                if (!this.trace) continue;
                log.trace("unhandled throwable in rollbackResources", t);
            }
        }
        this.status = 4;
    }

    private Xid createXidBranch() {
        long branchId = ++this.lastBranchId;
        return xidFactory.newBranch(this.xid, branchId);
    }

    private boolean isOneResource() {
        if (this.resourceCount == 1) {
            return true;
        }
        for (int i = 1; i < this.resourceCount; ++i) {
            if (this.resourceSameRM[i] != -1) continue;
            return false;
        }
        return true;
    }

    public long getTimeLeftBeforeTimeout() {
        return this.start + this.timeoutPeriod - System.currentTimeMillis();
    }

    public long getTimeLeftBeforeTimeout(boolean errorRollback) throws RollbackException {
        if (errorRollback && this.status != 0) {
            throw new RollbackException("Transaction is not active: " + TxUtils.getStatusAsString(this.status));
        }
        return this.start + this.timeoutPeriod - System.currentTimeMillis();
    }

    Object getTransactionLocalValue(TransactionLocal tlocal) {
        return this.transactionLocalMap.get(tlocal);
    }

    void putTransactionLocalValue(TransactionLocal tlocal, Object value) {
        this.transactionLocalMap.put(tlocal, value);
    }

    boolean containsTransactionLocal(TransactionLocal tlocal) {
        return this.transactionLocalMap.containsKey(tlocal);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

