/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.util.EmptyStringException;
import org.jboss.util.NullArgumentException;
import org.jboss.util.ThrowableHandler;
import org.jboss.util.UnreachableStatementException;

public final class Classes {
    public static final String PACKAGE_SEPARATOR = ".";
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final String DEFAULT_PACKAGE_NAME = "<default>";
    private static final Map PRIMITIVE_NAME_TYPE_MAP = new HashMap();
    private static final Class[] PRIMITIVE_WRAPPER_MAP;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public static String stripPackageName(String classname) {
        int idx = classname.lastIndexOf(PACKAGE_SEPARATOR);
        if (idx != -1) {
            return classname.substring(idx + 1, classname.length());
        }
        return classname;
    }

    public static String stripPackageName(Class type) {
        return Classes.stripPackageName(type.getName());
    }

    public static String getPackageName(String classname) {
        if (classname.length() == 0) {
            throw new EmptyStringException();
        }
        int index = classname.lastIndexOf(PACKAGE_SEPARATOR);
        if (index != -1) {
            return classname.substring(0, index);
        }
        return "";
    }

    public static String getPackageName(Class type) {
        return Classes.getPackageName(type.getName());
    }

    public static void forceLoad(Class type) {
        if (type == null) {
            throw new NullArgumentException("type");
        }
        if (type.isPrimitive()) {
            return;
        }
        String packageName = Classes.getPackageName(type);
        if (packageName.startsWith("java.") || packageName.startsWith("javax.")) {
            return;
        }
        try {
            Method[] methods = type.getDeclaredMethods();
            Method method = null;
            for (int i = 0; i < methods.length; ++i) {
                int modifiers = methods[i].getModifiers();
                if (!Modifier.isStatic(modifiers)) continue;
                method = methods[i];
                break;
            }
            if (method != null) {
                method.invoke(null, null);
            } else {
                type.newInstance();
            }
        }
        catch (Exception ignore) {
            ThrowableHandler.add(ignore);
        }
    }

    public static Class getPrimitiveTypeForName(String name) {
        return (Class)PRIMITIVE_NAME_TYPE_MAP.get(name);
    }

    public static Class getPrimitiveWrapper(Class type) {
        if (!type.isPrimitive()) {
            throw new IllegalArgumentException("type is not a primitive class");
        }
        for (int i = 0; i < PRIMITIVE_WRAPPER_MAP.length; i += 2) {
            if (!type.equals(PRIMITIVE_WRAPPER_MAP[i])) continue;
            return PRIMITIVE_WRAPPER_MAP[i + 1];
        }
        throw new UnreachableStatementException();
    }

    public static boolean isPrimitiveWrapper(Class type) {
        for (int i = 0; i < PRIMITIVE_WRAPPER_MAP.length; i += 2) {
            if (!type.equals(PRIMITIVE_WRAPPER_MAP[i + 1])) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitive(Class type) {
        return type.isPrimitive() || Classes.isPrimitiveWrapper(type);
    }

    public static boolean isPrimitive(String type) {
        return PRIMITIVE_NAME_TYPE_MAP.containsKey(type);
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        return Classes.loadClass(className, Thread.currentThread().getContextClassLoader());
    }

    public static Class loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (className.length() == 1) {
            char type = className.charAt(0);
            if (type == 'B') {
                return Byte.TYPE;
            }
            if (type == 'C') {
                return Character.TYPE;
            }
            if (type == 'D') {
                return Double.TYPE;
            }
            if (type == 'F') {
                return Float.TYPE;
            }
            if (type == 'I') {
                return Integer.TYPE;
            }
            if (type == 'J') {
                return Long.TYPE;
            }
            if (type == 'S') {
                return Short.TYPE;
            }
            if (type == 'Z') {
                return Boolean.TYPE;
            }
            if (type == 'V') {
                return Void.TYPE;
            }
            throw new ClassNotFoundException(className);
        }
        if (Classes.isPrimitive(className)) {
            return (Class)PRIMITIVE_NAME_TYPE_MAP.get(className);
        }
        if (className.charAt(0) == 'L' && className.charAt(className.length() - 1) == ';') {
            return classLoader.loadClass(className.substring(1, className.length() - 1));
        }
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            if (className.charAt(0) != '[') {
                throw e;
            }
            int arrayDimension = 0;
            while (className.charAt(arrayDimension) == '[') {
                ++arrayDimension;
            }
            Class componentType = Classes.loadClass(className.substring(arrayDimension), classLoader);
            return Array.newInstance(componentType, new int[arrayDimension]).getClass();
        }
    }

    public static final Class[] convertToJavaClasses(Iterator it, ClassLoader cl) throws ClassNotFoundException {
        ArrayList<Class> classes = new ArrayList<Class>();
        while (it.hasNext()) {
            classes.add(Classes.convertToJavaClass((String)it.next(), cl));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public static final Method getAttributeGetter(Class cls, String attr) throws NoSuchMethodException {
        String getterName = "get" + Character.toUpperCase(attr.charAt(0)) + attr.substring(1);
        return cls.getMethod(getterName, null);
    }

    public static final Method getAttributeSetter(Class cls, String attr, Class type) throws NoSuchMethodException {
        String setterName = "set" + Character.toUpperCase(attr.charAt(0)) + attr.substring(1);
        return cls.getMethod(setterName, type);
    }

    private static final Class convertToJavaClass(String name, ClassLoader cl) throws ClassNotFoundException {
        int arraySize = 0;
        while (name.endsWith("[]")) {
            name = name.substring(0, name.length() - 2);
            ++arraySize;
        }
        Class<?> c = (Class<?>)PRIMITIVE_NAME_TYPE_MAP.get(name);
        if (c == null) {
            try {
                c = cl.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ClassNotFoundException("Parameter class not found: " + name);
            }
        }
        if (arraySize > 0) {
            int[] dims = new int[arraySize];
            for (int i = 0; i < arraySize; ++i) {
                dims[i] = 1;
            }
            c = Array.newInstance(c, dims).getClass();
        }
        return c;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PRIMITIVE_NAME_TYPE_MAP.put("boolean", Boolean.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("byte", Byte.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("char", Character.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("short", Short.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("int", Integer.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("long", Long.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("float", Float.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("double", Double.TYPE);
        PRIMITIVE_WRAPPER_MAP = new Class[]{Boolean.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = Classes.class$("java.lang.Boolean")) : class$java$lang$Boolean, Byte.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = Classes.class$("java.lang.Byte")) : class$java$lang$Byte, Character.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = Classes.class$("java.lang.Character")) : class$java$lang$Character, Double.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = Classes.class$("java.lang.Double")) : class$java$lang$Double, Float.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = Classes.class$("java.lang.Float")) : class$java$lang$Float, Integer.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = Classes.class$("java.lang.Integer")) : class$java$lang$Integer, Long.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = Classes.class$("java.lang.Long")) : class$java$lang$Long, Short.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = Classes.class$("java.lang.Short")) : class$java$lang$Short};
    }
}

