/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ws.jaxme.xs.XSAttributable;
import org.apache.ws.jaxme.xs.XSAttribute;
import org.apache.ws.jaxme.xs.XSComplexType;
import org.apache.ws.jaxme.xs.XSElement;
import org.apache.ws.jaxme.xs.XSGroup;
import org.apache.ws.jaxme.xs.XSParser;
import org.apache.ws.jaxme.xs.XSParticle;
import org.apache.ws.jaxme.xs.XSSchema;
import org.apache.ws.jaxme.xs.XSSimpleType;
import org.apache.ws.jaxme.xs.XSType;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.jboss.logging.Logger;
import org.jboss.xml.binding.AbstractMarshaller;
import org.jboss.xml.binding.AttributesImpl;
import org.jboss.xml.binding.Content;
import org.jboss.xml.binding.ContentWriter;
import org.jboss.xml.binding.DelegatingObjectModelProvider;
import org.jboss.xml.binding.GenericObjectModelProvider;
import org.jboss.xml.binding.ObjectModelProvider;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XsMarshaller
extends AbstractMarshaller {
    private static final Logger log = Logger.getLogger(class$org$jboss$xml$binding$XsMarshaller == null ? (class$org$jboss$xml$binding$XsMarshaller = XsMarshaller.class$("org.jboss.xml.binding.XsMarshaller")) : class$org$jboss$xml$binding$XsMarshaller);
    private AbstractMarshaller.Stack stack = new AbstractMarshaller.StackImpl();
    private GenericObjectModelProvider provider;
    private Content content = new Content();
    private AttributesImpl addedAttributes = new AttributesImpl(10);
    private final Map uriByNsName = new HashMap();
    private Object root;
    static /* synthetic */ Class class$org$jboss$xml$binding$XsMarshaller;

    public void marshal(Reader schema, ObjectModelProvider provider, Object root, Writer writer) throws IOException, SAXException, ParserConfigurationException {
        InputSource source = new InputSource(schema);
        XSParser xsParser = new XSParser();
        xsParser.setValidating(false);
        XSSchema xsSchema = xsParser.parse(source);
        this.provider = provider instanceof GenericObjectModelProvider ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider);
        this.root = root;
        this.content.startDocument();
        for (int i = 0; i < this.rootQNames.size(); ++i) {
            AbstractMarshaller.QName qName = (AbstractMarshaller.QName)this.rootQNames.get(i);
            XsQName rootName = new XsQName(qName.namespaceUri, qName.name, qName.prefix);
            XSElement xsRoot = xsSchema.getElement(rootName);
            if (xsRoot == null) {
                throw new IllegalStateException("Root element not found: " + rootName);
            }
            this.processElement(xsRoot, this.addedAttributes);
        }
        this.content.endDocument();
        writer.write("<?xml version=\"");
        writer.write(this.version);
        writer.write("\" encoding=\"");
        writer.write(this.encoding);
        writer.write("\"?>\n");
        ContentWriter contentWriter = new ContentWriter(writer);
        this.content.handleContent(contentWriter);
    }

    public void declareNamespace(String name, String uri) {
        boolean nonEmptyName = name != null && name.length() > 0;
        String localName = nonEmptyName ? name : "xmlns";
        String qName = nonEmptyName ? XsMarshaller.getQName("xmlns", localName) : localName;
        String prev = this.uriByNsName.put(localName, uri);
        if (prev == null) {
            this.addedAttributes.add(null, localName, qName, "string", uri);
        }
    }

    public void addAttribute(String prefix, String localName, String type, String value) {
        String uri;
        if (prefix != null && prefix.length() > 0) {
            uri = (String)this.uriByNsName.get(prefix);
            if (uri == null) {
                throw new IllegalStateException("Namespace prefix " + prefix + " is not declared. Use declareNamespace().");
            }
        } else {
            uri = null;
        }
        String qName = XsMarshaller.getQName(prefix, localName);
        this.addedAttributes.add(uri, prefix, qName, type, value);
    }

    public void addAttribute(String namespaceUri, String prefix, String localName, String type, String value) {
        this.declareNamespace(prefix, namespaceUri);
        this.addAttribute(prefix, localName, type, value);
    }

    private final void processElement(XSElement element, AttributesImpl attrs) throws SAXException {
        XSType type = element.getType();
        this.processType(element, type, attrs);
    }

    private final void processType(XSElement element, XSType type, AttributesImpl attrs) throws SAXException {
        if (type.isSimple()) {
            XSSimpleType simpleType = type.getSimpleType();
            this.processSimpleType(element, simpleType, null);
        } else {
            XSComplexType complexType = type.getComplexType();
            this.processComplexType(element, complexType, attrs);
        }
    }

    private final void processSimpleType(XSElement element, XSSimpleType type, Attributes attrs) {
        XsQName name;
        String prefix;
        if (type.isAtomic()) {
            if (log.isTraceEnabled()) {
                log.trace("atomic simple type");
            }
        } else if (type.isList()) {
            if (log.isTraceEnabled()) {
                log.trace("list of types");
            }
        } else if (type.isRestriction()) {
            if (log.isTraceEnabled()) {
                log.trace("restricted type");
            }
        } else if (type.isUnion()) {
            if (log.isTraceEnabled()) {
                log.trace("union of types");
            }
        } else {
            throw new IllegalStateException("Simple type is not atomic, list, restriction or union!");
        }
        String qName = (prefix = (name = element.getName()).getPrefix()) == null || prefix.length() == 0 ? name.getLocalName() : prefix + ':' + name.getLocalName();
        Object parent = this.stack.isEmpty() ? this.provider.getRoot(this.root, name.getNamespaceURI(), name.getLocalName()) : this.stack.peek();
        Object value = this.provider.getElementValue(parent, name.getNamespaceURI(), name.getLocalName());
        if (value != null) {
            char[] ch = value.toString().toCharArray();
            this.content.startElement(name.getNamespaceURI(), name.getLocalName(), qName, attrs);
            this.content.characters(ch, 0, ch.length);
            this.content.endElement(name.getNamespaceURI(), name.getLocalName(), qName);
        }
    }

    private final void processComplexType(XSElement element, XSComplexType type, AttributesImpl addedAttrs) throws SAXException {
        Object parent;
        XsQName xsName = element.getName();
        boolean popRoot = false;
        if (this.stack.isEmpty()) {
            parent = this.provider.getRoot(this.root, xsName.getNamespaceURI(), xsName.getLocalName());
            this.stack.push(parent);
            popRoot = true;
        } else {
            parent = this.stack.peek();
        }
        Object children = this.provider.getChildren(parent, xsName.getNamespaceURI(), xsName.getLocalName());
        if (children != null) {
            this.handleChildren(element, type, children, addedAttrs);
        } else if (type.hasSimpleContent()) {
            this.processSimpleType(element, type.getSimpleContent().getType().getSimpleType(), null);
        } else if (type.isEmpty()) {
            XsQName name = element.getName();
            Object value = this.provider.getElementValue(parent, name.getNamespaceURI(), name.getLocalName());
            if (Boolean.TRUE.equals(value)) {
                String prefix = name.getPrefix();
                String qName = prefix == null || prefix.length() == 0 ? name.getLocalName() : prefix + ':' + name.getLocalName();
                AttributesImpl ownAttrs = this.provideAttributes(type.getAttributes(), parent);
                if (ownAttrs != null) {
                    if (addedAttrs != null) {
                        ownAttrs.addAll(ownAttrs);
                    }
                } else {
                    ownAttrs = addedAttrs;
                }
                this.content.startElement(name.getNamespaceURI(), name.getLocalName(), qName, ownAttrs);
                this.content.endElement(name.getNamespaceURI(), name.getLocalName(), qName);
            }
        } else {
            XSParticle particle = type.getParticle();
            if (particle != null) {
                this.processParticle(particle);
            }
        }
        if (popRoot) {
            this.stack.pop();
        }
    }

    private void handleChildren(XSElement parent, XSComplexType type, Object children, AttributesImpl addedAttrs) throws SAXException {
        if (children != null) {
            if (children instanceof List) {
                this.handleChildrenList(parent, type, (List)children, addedAttrs);
            } else if (children instanceof Collection) {
                this.handleChildrenIterator(parent, type, ((Collection)children).iterator(), addedAttrs);
            } else if (children instanceof Iterator) {
                this.handleChildrenIterator(parent, type, (Iterator)children, addedAttrs);
            } else if (children.getClass().isArray()) {
                this.handleChildrenArray(parent, type, (Object[])children, addedAttrs);
            } else {
                this.handleChild(parent, type, children, addedAttrs);
            }
        }
    }

    private AttributesImpl provideAttributes(XSAttributable[] xsAttrs, Object container) {
        AttributesImpl attrs = new AttributesImpl(xsAttrs.length);
        for (int i = 0; i < xsAttrs.length; ++i) {
            XSAttribute attr;
            XsQName attrQName;
            Object attrValue;
            XSAttributable attributable = xsAttrs[i];
            if (!(attributable instanceof XSAttribute) || (attrValue = this.provider.getAttributeValue(container, (attrQName = (attr = (XSAttribute)attributable).getName()).getNamespaceURI(), attrQName.getLocalName())) == null) continue;
            String prefix = attrQName.getPrefix();
            String qName = prefix == null || prefix.length() == 0 ? attrQName.getLocalName() : attrQName.getPrefix() + ':' + attrQName.getLocalName();
            attrs.add(attrQName.getNamespaceURI(), attrQName.getLocalName(), qName, attr.getType().getName().getLocalName(), attrValue.toString());
        }
        return attrs;
    }

    private final void processParticle(XSParticle particle) throws SAXException {
        if (particle.isElement()) {
            XSElement element = particle.getElement();
            this.processElement(element, null);
        } else if (particle.isGroup()) {
            XSGroup group = particle.getGroup();
            this.processGroup(group);
        } else if (particle.isWildcard()) {
            if (log.isTraceEnabled()) {
                log.trace("any");
            }
        } else {
            throw new IllegalStateException("Particle is not an element, group or wildcard!");
        }
    }

    private final void processGroup(XSGroup group) throws SAXException {
        if (!(group.isSequence() || group.isChoice() || group.isAll())) {
            throw new IllegalStateException("Group is not a sequence, choice or all!");
        }
        XSParticle[] particles = group.getParticles();
        for (int i = 0; i < particles.length; ++i) {
            XSParticle particle = particles[i];
            this.processParticle(particle);
        }
    }

    private void handleChildrenList(XSElement parent, XSComplexType type, List children, AttributesImpl addedAttrs) throws SAXException {
        for (int i = 0; i < children.size(); ++i) {
            this.handleChild(parent, type, children.get(i), addedAttrs);
        }
    }

    private void handleChildrenIterator(XSElement parent, XSComplexType type, Iterator children, AttributesImpl addedAttrs) throws SAXException {
        while (children.hasNext()) {
            this.handleChild(parent, type, children.next(), addedAttrs);
        }
    }

    private void handleChildrenArray(XSElement parent, XSComplexType type, Object[] children, AttributesImpl addedAttrs) throws SAXException {
        for (int i = 0; i < children.length; ++i) {
            this.handleChild(parent, type, children[i], addedAttrs);
        }
    }

    private void handleChild(XSElement parent, XSComplexType type, Object child, AttributesImpl addedAttrs) throws SAXException {
        AttributesImpl ownAttrs;
        this.stack.push(child);
        XsQName name = parent.getName();
        String prefix = name.getPrefix();
        String qName = prefix == null || prefix.length() == 0 ? name.getLocalName() : prefix + ':' + name.getLocalName();
        XSAttributable[] xsAttrs = type.getAttributes();
        AttributesImpl attributesImpl = ownAttrs = xsAttrs == null ? null : this.provideAttributes(xsAttrs, child);
        if (ownAttrs != null) {
            if (addedAttrs != null) {
                ownAttrs.addAll(addedAttrs);
            }
        } else {
            ownAttrs = addedAttrs;
        }
        if (type.hasSimpleContent()) {
            this.processSimpleType(parent, type.getSimpleContent().getType().getSimpleType(), ownAttrs);
        } else {
            this.content.startElement(name.getNamespaceURI(), name.getLocalName(), qName, ownAttrs);
            if (!type.isEmpty() && type.getParticle() != null) {
                this.processParticle(type.getParticle());
            } else {
                XSSchema xsSchema;
                AbstractMarshaller.ClassMapping mapping = this.getClassMapping(child.getClass());
                InputSource source = new InputSource(mapping.schemaReader);
                XSParser xsParser = new XSParser();
                xsParser.setValidating(false);
                try {
                    xsSchema = xsParser.parse(source);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalStateException(e.getMessage());
                }
                XsQName rootName = new XsQName(mapping.namespaceUri, mapping.root);
                XSElement root = xsSchema.getElement(rootName);
                rootName = root.getName();
                String rootPrefix = rootName.getPrefix();
                String rootQName = rootPrefix == null || rootPrefix.length() == 0 ? rootName.getLocalName() : rootPrefix + ':' + rootName.getLocalName();
                AbstractMarshaller.Stack oldStack = this.stack;
                this.stack = new AbstractMarshaller.StackImpl();
                Object oldRoot = this.root;
                this.root = child;
                GenericObjectModelProvider oldProvider = this.provider;
                this.provider = mapping.provider;
                this.content.startElement(rootName.getNamespaceURI(), rootName.getLocalName(), rootQName, addedAttrs);
                this.processElement(root, addedAttrs);
                this.content.endElement(rootName.getNamespaceURI(), rootName.getLocalName(), rootQName);
                this.root = oldRoot;
                this.stack = oldStack;
                this.provider = oldProvider;
            }
            this.content.endElement(name.getNamespaceURI(), name.getLocalName(), qName);
        }
        this.stack.pop();
    }

    private static String getQName(String prefix, String localName) {
        return prefix == null || prefix.length() == 0 ? localName : prefix + ':' + localName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

