/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;
import org.jboss.mq.MessagePool;
import org.jboss.mq.SpyMessage;
import org.jboss.util.Classes;

public class SpyObjectMessage
extends SpyMessage
implements ObjectMessage,
Externalizable {
    private static final long serialVersionUID = 8809953915407712952L;
    boolean isByteArray = false;
    byte[] objectBytes = null;

    public void setObject(Serializable object) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("setObject");
        }
        if (object == null) {
            this.objectBytes = null;
            return;
        }
        try {
            if (object instanceof byte[]) {
                this.isByteArray = true;
                this.objectBytes = new byte[((byte[])object).length];
                System.arraycopy(object, 0, this.objectBytes, 0, this.objectBytes.length);
            } else {
                this.isByteArray = false;
                ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
                ObjectOutputStream objectOut = new ObjectOutputStream(byteArray);
                objectOut.writeObject(object);
                this.objectBytes = byteArray.toByteArray();
                objectOut.close();
            }
        }
        catch (IOException e) {
            MessageFormatException mfe = new MessageFormatException("Object cannot be serialized: " + e.getMessage());
            mfe.setLinkedException(e);
            throw mfe;
        }
    }

    public Serializable getObject() throws JMSException {
        Object retVal = null;
        try {
            if (null != this.objectBytes) {
                if (this.isByteArray) {
                    retVal = new byte[this.objectBytes.length];
                    System.arraycopy(this.objectBytes, 0, retVal, 0, this.objectBytes.length);
                } else {
                    class ObjectInputStreamExt
                    extends ObjectInputStream {
                        ObjectInputStreamExt(InputStream is) throws IOException {
                            super(is);
                        }

                        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
                            return Classes.loadClass(v.getName());
                        }
                    }
                    ObjectInputStreamExt input = new ObjectInputStreamExt(new ByteArrayInputStream(this.objectBytes));
                    retVal = (Serializable)input.readObject();
                    input.close();
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new MessageFormatException("ClassNotFoundException: " + e.getMessage());
        }
        catch (IOException e) {
            throw new MessageFormatException("IOException: " + e.getMessage());
        }
        return retVal;
    }

    public void clearBody() throws JMSException {
        this.objectBytes = null;
        super.clearBody();
    }

    public SpyMessage myClone() throws JMSException {
        SpyObjectMessage result = MessagePool.getObjectMessage();
        result.copyProps(this);
        result.isByteArray = this.isByteArray;
        if (this.objectBytes != null) {
            result.objectBytes = new byte[this.objectBytes.length];
            System.arraycopy(this.objectBytes, 0, result.objectBytes, 0, this.objectBytes.length);
        }
        return result;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.isByteArray);
        if (this.objectBytes == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.objectBytes.length);
            out.write(this.objectBytes);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.isByteArray = in.readBoolean();
        int length = in.readInt();
        if (length < 0) {
            this.objectBytes = null;
        } else {
            this.objectBytes = new byte[length];
            in.readFully(this.objectBytes);
        }
    }
}

