/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.invalidation.bridges;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.naming.InitialContext;
import org.jboss.cache.invalidation.BatchInvalidation;
import org.jboss.cache.invalidation.BridgeInvalidationSubscription;
import org.jboss.cache.invalidation.InvalidationBridgeListener;
import org.jboss.cache.invalidation.InvalidationGroup;
import org.jboss.cache.invalidation.InvalidationManagerMBean;
import org.jboss.cache.invalidation.bridges.JGCacheInvalidationBridgeMBean;
import org.jboss.cache.invalidation.bridges.NodeInfo;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.system.Registry;
import org.jboss.system.ServiceMBeanSupport;

public class JGCacheInvalidationBridge
extends ServiceMBeanSupport
implements JGCacheInvalidationBridgeMBean,
DistributedState.DSListenerEx,
InvalidationBridgeListener,
DistributedReplicantManager.ReplicantListener {
    protected String partitionName = "DefaultPartition";
    protected String invalidationManagerName = "jboss.cache:service=InvalidationManager";
    protected String bridgeName = "DefaultJGCacheIB";
    protected HAPartition partition = null;
    protected DistributedState ds = null;
    protected DistributedReplicantManager drm = null;
    protected String RPC_HANLE_NAME = null;
    protected String nodeName = null;
    protected InvalidationManagerMBean invalMgr = null;
    protected BridgeInvalidationSubscription invalidationSubscription = null;
    protected Collection localGroups = null;
    protected Vector bridgedGroups = new Vector();

    public String getInvalidationManager() {
        return this.invalidationManagerName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setInvalidationManager(String objectName) {
        this.invalidationManagerName = objectName;
    }

    public void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    public String getBridgeName() {
        return this.bridgeName;
    }

    public void setBridgeName(String name) {
        this.bridgeName = name;
    }

    public void replicantsChanged(String key, List newReplicants, int newReplicantsViewId) {
        if (key.equals(this.RPC_HANLE_NAME) && this.drm.isMasterReplica(this.RPC_HANLE_NAME)) {
            this.log.debug((Object)"The list of replicant for the JG bridge has changed, computing and updating local info...");
            Collection coll = this.ds.getAllKeys(this.RPC_HANLE_NAME);
            if (coll == null) {
                this.log.debug((Object)"... No bridge info was associated to this node");
                return;
            }
            ArrayList collCopy = new ArrayList(coll);
            List newReplicantsNodeNames = this.drm.lookupReplicantsNodeNames(this.RPC_HANLE_NAME);
            int i = 0;
            while (i < collCopy.size()) {
                String nodeEntry = (String)collCopy.get(i);
                if (!newReplicantsNodeNames.contains(nodeEntry)) {
                    try {
                        this.log.debug((Object)"removing bridge information associated to this node from the DS");
                        this.ds.remove(this.RPC_HANLE_NAME, (Serializable)((Object)nodeEntry), true);
                    }
                    catch (Exception e) {
                        this.log.info((Object)"Unable to remove a node entry from the distributed cache", (Throwable)e);
                    }
                }
                ++i;
            }
        }
    }

    public void valueHasChanged(String category, Serializable key, Serializable value, boolean locallyModified) {
        this.updatedBridgedInvalidationGroupsInfo();
    }

    public void keyHasBeenRemoved(String category, Serializable key, Serializable previousContent, boolean locallyModified) {
        this.updatedBridgedInvalidationGroupsInfo();
    }

    public void batchInvalidate(BatchInvalidation[] invalidations, boolean asynchronous) {
        if (invalidations == null) {
            return;
        }
        ArrayList<BatchInvalidation> acceptedGroups = new ArrayList<BatchInvalidation>();
        int i = 0;
        while (i < invalidations.length) {
            BatchInvalidation currBI = invalidations[i];
            if (this.groupExistsRemotely(currBI.getInvalidationGroupName())) {
                acceptedGroups.add(currBI);
            }
            ++i;
        }
        if (acceptedGroups.size() > 0) {
            BatchInvalidation[] result = new BatchInvalidation[acceptedGroups.size()];
            result = acceptedGroups.toArray(result);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Transmitting batch invalidation: " + result));
            }
            this._do_rpc_batchInvalidate(result, asynchronous);
        }
    }

    public void invalidate(String invalidationGroupName, Serializable[] keys, boolean asynchronous) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Transmitting invalidations for group: " + invalidationGroupName));
        }
        if (this.groupExistsRemotely(invalidationGroupName)) {
            this._do_rpc_invalidates(invalidationGroupName, keys, asynchronous);
        }
    }

    public void invalidate(String invalidationGroupName, Serializable key, boolean asynchronous) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Transmitting invalidation for group: " + invalidationGroupName));
        }
        if (this.groupExistsRemotely(invalidationGroupName)) {
            this._do_rpc_invalidate(invalidationGroupName, key, asynchronous);
        }
    }

    public void newGroupCreated(String groupInvalidationName) {
        try {
            this.publishLocalInvalidationGroups();
        }
        catch (Exception e) {
            this.log.info((Object)"Problem while registering a new invalidation group over the cluster", (Throwable)e);
        }
    }

    public void groupIsDropped(String groupInvalidationName) {
        try {
            this.publishLocalInvalidationGroups();
        }
        catch (Exception e) {
            this.log.info((Object)"Problem while un-registering a new invalidation group over the cluster", (Throwable)e);
        }
    }

    public void startService() throws Exception {
        this.RPC_HANLE_NAME = "DCacheBridge-" + this.bridgeName;
        InitialContext ctx = new InitialContext();
        this.partition = (HAPartition)ctx.lookup("/HAPartition/" + this.partitionName);
        this.ds = this.partition.getDistributedStateService();
        this.drm = this.partition.getDistributedReplicantManager();
        this.nodeName = this.partition.getNodeName();
        this.drm.add(this.RPC_HANLE_NAME, (Serializable)((Object)""));
        this.drm.registerListener(this.RPC_HANLE_NAME, this);
        this.ds.registerDSListenerEx(this.RPC_HANLE_NAME, this);
        this.partition.registerRPCHandler(this.RPC_HANLE_NAME, this);
        this.invalMgr = (InvalidationManagerMBean)Registry.lookup((Object)this.invalidationManagerName);
        this.publishLocalInvalidationGroups();
        this.updatedBridgedInvalidationGroupsInfo();
        this.invalidationSubscription = this.invalMgr.registerBridgeListener((InvalidationBridgeListener)this);
    }

    public void stopService() {
        try {
            this.partition.unregisterRPCHandler(this.RPC_HANLE_NAME, this);
            this.ds.unregisterDSListenerEx(this.RPC_HANLE_NAME, this);
            this.drm.unregisterListener(this.RPC_HANLE_NAME, this);
            this.drm.remove(this.RPC_HANLE_NAME);
            this.invalidationSubscription.unregister();
            this.ds.remove(this.RPC_HANLE_NAME, (Serializable)((Object)this.nodeName), true);
            this.invalMgr = null;
            this.partition = null;
            this.drm = null;
            this.ds = null;
            this.invalidationSubscription = null;
            this.RPC_HANLE_NAME = null;
            this.nodeName = null;
            this.localGroups = null;
            this.bridgedGroups = new Vector();
        }
        catch (Exception e) {
            this.log.info((Object)"Problem while shuting down invalidation cache bridge", (Throwable)e);
        }
    }

    public void _rpc_invalidate(String invalidationGroupName, Serializable key) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Received remote invalidation for group: " + invalidationGroupName));
        }
        this.invalidationSubscription.invalidate(invalidationGroupName, key);
    }

    public void _rpc_invalidates(String invalidationGroupName, Serializable[] keys) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Received remote invalidations for group: " + invalidationGroupName));
        }
        this.invalidationSubscription.invalidate(invalidationGroupName, keys);
    }

    public void _rpc_batchInvalidate(BatchInvalidation[] invalidations) {
        if (this.log.isTraceEnabled() && invalidations != null) {
            this.log.trace((Object)("Received remote batch invalidation for this number of groups: " + invalidations.length));
        }
        this.invalidationSubscription.batchInvalidate(invalidations);
    }

    protected void _do_rpc_invalidate(String invalidationGroupName, Serializable key, boolean asynch) {
        block3: {
            Object[] params = new Object[]{invalidationGroupName, key};
            try {
                if (asynch) {
                    this.partition.callAsynchMethodOnCluster(this.RPC_HANLE_NAME, "_rpc_invalidate", params, true);
                    break block3;
                }
                this.partition.callMethodOnCluster(this.RPC_HANLE_NAME, "_rpc_invalidate", params, true);
            }
            catch (Exception e) {
                this.log.debug((Object)("Distributed invalidation (1) has failed for group " + invalidationGroupName + " (Bridge: " + this.bridgeName + ")"));
            }
        }
    }

    protected void _do_rpc_invalidates(String invalidationGroupName, Serializable[] keys, boolean asynch) {
        block3: {
            Object[] params = new Object[]{invalidationGroupName, keys};
            try {
                if (asynch) {
                    this.partition.callAsynchMethodOnCluster(this.RPC_HANLE_NAME, "_rpc_invalidates", params, true);
                    break block3;
                }
                this.partition.callMethodOnCluster(this.RPC_HANLE_NAME, "_rpc_invalidates", params, true);
            }
            catch (Exception e) {
                this.log.debug((Object)("Distributed invalidation (2) has failed for group " + invalidationGroupName + " (Bridge: " + this.bridgeName + ")"));
            }
        }
    }

    protected void _do_rpc_batchInvalidate(BatchInvalidation[] invalidations, boolean asynch) {
        block3: {
            Object[] params = new Object[]{invalidations};
            try {
                if (asynch) {
                    this.partition.callAsynchMethodOnCluster(this.RPC_HANLE_NAME, "_rpc_batchInvalidate", params, true);
                    break block3;
                }
                this.partition.callMethodOnCluster(this.RPC_HANLE_NAME, "_rpc_batchInvalidate", params, true);
            }
            catch (Exception e) {
                this.log.debug((Object)("Distributed invalidation (3) has failed (Bridge: " + this.bridgeName + ")"));
            }
        }
    }

    protected synchronized void publishLocalInvalidationGroups() throws Exception {
        this.localGroups = this.invalMgr.getInvalidationGroups();
        this.log.debug((Object)("Publishing locally available invalidation groups: " + this.localGroups));
        ArrayList content = new ArrayList(this.localGroups);
        ArrayList<String> result = new ArrayList<String>(content.size());
        int i = 0;
        while (i < content.size()) {
            String aGroup = ((InvalidationGroup)content.get(i)).getGroupName();
            result.add(aGroup);
            ++i;
        }
        if (result.size() > 0) {
            NodeInfo info = new NodeInfo(result, this.nodeName);
            this.ds.set(this.RPC_HANLE_NAME, (Serializable)((Object)this.nodeName), info, true);
        } else {
            this.ds.remove(this.RPC_HANLE_NAME, (Serializable)((Object)this.nodeName), true);
        }
    }

    protected void updatedBridgedInvalidationGroupsInfo() {
        Collection bridgedByNode = this.ds.getAllValues(this.RPC_HANLE_NAME);
        this.log.debug((Object)"Updating list of invalidation groups that are bridged...");
        if (bridgedByNode != null) {
            ArrayList copy = new ArrayList(bridgedByNode);
            Vector<String> result = new Vector<String>();
            int i = 0;
            while (i < copy.size()) {
                NodeInfo infoForNode = (NodeInfo)copy.get(i);
                this.log.trace((Object)("InfoForNode: " + infoForNode));
                if (infoForNode != null && !infoForNode.groupName.equals(this.nodeName)) {
                    ArrayList groupsForNode = infoForNode.groups;
                    this.log.trace((Object)("Groups for node: " + groupsForNode));
                    int j = 0;
                    while (j < groupsForNode.size()) {
                        String aGroup = (String)groupsForNode.get(j);
                        if (!result.contains(aGroup)) {
                            this.log.trace((Object)("Adding: " + aGroup));
                            result.add(aGroup);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.bridgedGroups = result;
            this.log.debug((Object)("... computed list of bridged groups: " + result));
        } else {
            this.log.debug((Object)"... nothing needs to be bridged.");
        }
    }

    protected boolean groupExistsRemotely(String groupName) {
        return this.bridgedGroups.contains(groupName);
    }
}

