/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.ejb.FinderException;
import javax.ejb.Handle;
import javax.ejb.RemoveException;
import org.jboss.ejb.Container;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.EntityPersistenceStore;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.ClusterConfigMetaData;
import org.jboss.metadata.EntityMetaData;
import org.jboss.system.Registry;

public class CMPClusteredInMemoryPersistenceManager
implements EntityPersistenceStore {
    protected EntityContainer con = null;
    protected Field idField = null;
    protected DistributedState ds = null;
    protected String DS_CATEGORY = null;
    protected Method isModified = null;
    protected Method useAsyncReplication = null;

    public void setContainer(Container con) {
        this.con = (EntityContainer)con;
    }

    public void create() throws Exception {
        BeanMetaData bmd = this.con.getBeanMetaData();
        ClusterConfigMetaData ccmd = bmd.getClusterConfigMetaData();
        String partitionName = ccmd.getPartitionName();
        String name = "jboss:service=DistributedState,partitionName=" + partitionName;
        this.ds = (DistributedState)Registry.lookup((Object)name);
        String ejbName = bmd.getEjbName();
        this.DS_CATEGORY = "CMPClusteredInMemoryPersistenceManager-" + ejbName;
        this.idField = this.con.getBeanClass().getField("id");
        try {
            this.isModified = this.con.getBeanClass().getMethod("isModified", new Class[0]);
            if (!this.isModified.getReturnType().equals(Boolean.TYPE)) {
                this.isModified = null;
            }
        }
        catch (NoSuchMethodException ignored) {
            // empty catch block
        }
        try {
            this.useAsyncReplication = this.con.getBeanClass().getMethod("useAsyncReplication", new Class[0]);
            if (!this.useAsyncReplication.getReturnType().equals(Boolean.TYPE)) {
                this.useAsyncReplication = null;
            }
        }
        catch (NoSuchMethodException ignored) {}
    }

    public void start() throws Exception {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public Object createBeanClassInstance() throws Exception {
        return this.con.getBeanClass().newInstance();
    }

    public void initEntity(EntityEnterpriseContext ctx) {
        Object instance = ctx.getInstance();
        Class<?> ejbClass = instance.getClass();
        EntityMetaData metaData = (EntityMetaData)this.con.getBeanMetaData();
        Iterator i = metaData.getCMPFields();
        while (i.hasNext()) {
            try {
                try {
                    Field cmpField = ejbClass.getField((String)i.next());
                    Class<?> cmpFieldType = cmpField.getType();
                    if (cmpFieldType.equals(Boolean.TYPE)) {
                        cmpField.setBoolean(instance, false);
                        continue;
                    }
                    if (cmpFieldType.equals(Byte.TYPE)) {
                        cmpField.setByte(instance, (byte)0);
                        continue;
                    }
                    if (cmpFieldType.equals(Integer.TYPE)) {
                        cmpField.setInt(instance, 0);
                        continue;
                    }
                    if (cmpFieldType.equals(Long.TYPE)) {
                        cmpField.setLong(instance, 0L);
                        continue;
                    }
                    if (cmpFieldType.equals(Short.TYPE)) {
                        cmpField.setShort(instance, (short)0);
                        continue;
                    }
                    if (cmpFieldType.equals(Character.TYPE)) {
                        cmpField.setChar(instance, '\u0000');
                        continue;
                    }
                    if (cmpFieldType.equals(Double.TYPE)) {
                        cmpField.setDouble(instance, 0.0);
                        continue;
                    }
                    if (cmpFieldType.equals(Float.TYPE)) {
                        cmpField.setFloat(instance, 0.0f);
                        continue;
                    }
                    cmpField.set(instance, null);
                }
                catch (NoSuchFieldException e) {}
            }
            catch (Exception e) {
                throw new EJBException(e);
            }
        }
    }

    public Object createEntity(Method m, Object[] args, EntityEnterpriseContext ctx) throws Exception {
        try {
            Object id = this.idField.get(ctx.getInstance());
            if (this.ds.get(this.DS_CATEGORY, (Serializable)((Object)id.toString())) != null) {
                throw new DuplicateKeyException("Already exists:" + id);
            }
            this.storeEntity(id, ctx.getInstance(), this.useAsyncReplication(ctx));
            return id;
        }
        catch (IllegalAccessException e) {
            throw new CreateException("Could not create entity:" + e);
        }
    }

    public Object postCreateEntity(Method m, Object[] args, EntityEnterpriseContext ctx) throws Exception {
        return null;
    }

    public Object findEntity(Method finderMethod, Object[] args, EntityEnterpriseContext instance) throws Exception {
        if (finderMethod.getName().equals("findByPrimaryKey")) {
            if (this.ds.get(this.DS_CATEGORY, (Serializable)((Object)args[0].toString())) == null) {
                throw new FinderException(args[0] + " does not exist");
            }
            return args[0];
        }
        return null;
    }

    public Collection findEntities(Method finderMethod, Object[] args, EntityEnterpriseContext instance) throws Exception {
        Collection tmpColl;
        ArrayList results = Collections.EMPTY_LIST;
        if (finderMethod.getName().equals("findAll") && (tmpColl = this.ds.getAllKeys(this.DS_CATEGORY)) != null) {
            results = new ArrayList(tmpColl);
        }
        return results;
    }

    public void activateEntity(EntityEnterpriseContext instance) {
    }

    public void loadEntity(EntityEnterpriseContext ctx) {
        try {
            byte[] content = (byte[])this.ds.get(this.DS_CATEGORY, (Serializable)((Object)ctx.getId().toString()));
            if (content == null) {
                throw new EJBException("No entry exists (any more?) with this id: " + ctx.getId());
            }
            CMPObjectInputStream in = new CMPObjectInputStream(new ByteArrayInputStream(content));
            Object obj = ctx.getInstance();
            Field[] f = obj.getClass().getFields();
            int i = 0;
            while (i < f.length) {
                f[i].set(obj, in.readObject());
                ++i;
            }
            in.close();
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("Load failed", e);
        }
    }

    public boolean isModified(EntityEnterpriseContext ctx) throws Exception {
        if (this.isModified == null) {
            return true;
        }
        Object[] args = new Object[]{};
        Boolean modified = (Boolean)this.isModified.invoke(ctx.getInstance(), args);
        return modified;
    }

    public boolean useAsyncReplication(EntityEnterpriseContext ctx) throws Exception {
        if (this.useAsyncReplication == null) {
            return false;
        }
        Object[] args = new Object[]{};
        Boolean async = (Boolean)this.useAsyncReplication.invoke(ctx.getInstance(), args);
        return async;
    }

    public void storeEntity(EntityEnterpriseContext ctx) throws RemoteException {
        try {
            this.storeEntity(ctx.getId(), ctx.getInstance(), this.useAsyncReplication(ctx));
        }
        catch (Exception e) {
            throw new RemoteException(e.toString());
        }
    }

    public void passivateEntity(EntityEnterpriseContext instance) {
    }

    public void removeEntity(EntityEnterpriseContext ctx) throws RemoveException {
        try {
            if (this.ds.remove(this.DS_CATEGORY, (Serializable)((Object)ctx.getId().toString()), this.useAsyncReplication(ctx)) == null) {
                throw new RemoveException("Could not remove bean:" + ctx.getId());
            }
        }
        catch (Exception e) {
            throw new RemoveException(e.toString());
        }
    }

    protected void storeEntity(Object id, Object obj, boolean async) throws Exception {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CMPObjectOutputStream out = new CMPObjectOutputStream(baos);
            Field[] f = obj.getClass().getFields();
            int i = 0;
            while (i < f.length) {
                out.writeObject(f[i].get(obj));
                ++i;
            }
            out.close();
            this.ds.set(this.DS_CATEGORY, (Serializable)((Object)id.toString()), (Serializable)baos.toByteArray(), async);
        }
        catch (Exception e) {
            throw new EJBException("Store failed", e);
        }
    }

    static class CMPObjectInputStream
    extends ObjectInputStream {
        public CMPObjectInputStream(InputStream in) throws IOException {
            super(in);
            this.enableResolveObject(true);
        }

        protected Object resolveObject(Object obj) throws IOException {
            if (obj instanceof Handle) {
                return ((Handle)obj).getEJBObject();
            }
            return obj;
        }
    }

    static class CMPObjectOutputStream
    extends ObjectOutputStream {
        public CMPObjectOutputStream(OutputStream out) throws IOException {
            super(out);
            this.enableReplaceObject(true);
        }

        protected Object replaceObject(Object obj) throws IOException {
            if (obj instanceof EJBObject) {
                return ((EJBObject)obj).getHandle();
            }
            return obj;
        }
    }
}

