/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import org.jboss.ejb.Container;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.StatefulSessionContainer;
import org.jboss.ejb.StatefulSessionEnterpriseContext;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ejb.plugins.HAPersistentManager;
import org.jboss.invocation.Invocation;

public class StatefulHASessionSynchronisationInterceptor
extends AbstractInterceptor {
    protected StatefulSessionContainer container;
    protected Method isModified = null;

    public void start() throws Exception {
        block3: {
            try {
                this.isModified = this.container.getBeanClass().getMethod("isModified", new Class[0]);
                if (!this.isModified.getReturnType().equals(Boolean.TYPE)) {
                    this.isModified = null;
                    this.log.warn((Object)"Found isModified method, but return type is not boolean; ignoring");
                    break block3;
                }
                this.log.debug((Object)("Using isModified method: " + this.isModified));
            }
            catch (NoSuchMethodException ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeHome(Invocation mi) throws Exception {
        EnterpriseContext ctx = (EnterpriseContext)mi.getEnterpriseContext();
        try {
            Object object = this.getNext().invokeHome(mi);
            return object;
        }
        finally {
            if (ctx != null && ctx.getId() != null) {
                this.synchronizeState(ctx);
            }
        }
    }

    public Object invoke(Invocation mi) throws Exception {
        EnterpriseContext ctx = (EnterpriseContext)mi.getEnterpriseContext();
        try {
            Object object = this.getNext().invoke(mi);
            return object;
        }
        catch (RemoteException e) {
            ctx = null;
            throw e;
        }
        catch (RuntimeException e) {
            ctx = null;
            throw e;
        }
        catch (Error e) {
            ctx = null;
            throw e;
        }
        finally {
            if (ctx != null && ctx.getId() != null) {
                if (this.isModified == null) {
                    this.synchronizeState(ctx);
                } else {
                    Boolean modified = (Boolean)this.isModified.invoke(ctx.getInstance(), new Object[0]);
                    if (modified.booleanValue()) {
                        this.synchronizeState(ctx);
                    }
                }
            }
        }
    }

    protected void synchronizeState(EnterpriseContext ctx) throws Exception {
        ((HAPersistentManager)this.container.getPersistenceManager()).synchroSession((StatefulSessionEnterpriseContext)ctx);
    }

    public void setContainer(Container container) {
        this.container = (StatefulSessionContainer)container;
    }

    public Container getContainer() {
        return this.container;
    }
}

