/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.dgc.VMID;
import java.rmi.server.UID;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.ClusterPartitionMBean;
import org.jboss.ha.framework.server.HAPartitionImpl;
import org.jboss.logging.util.LoggerWriter;
import org.jboss.naming.NamingServiceMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.log.Trace;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClusterPartition
extends ServiceMBeanSupport
implements ClusterPartitionMBean {
    protected String partitionName = "DefaultPartition";
    protected String jgProps = "UDP(mcast_addr=228.1.2.3;mcast_port=45566;ip_ttl=64;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD:VERIFY_SUSPECT(timeout=1500):pbcast.STABLE(desired_avg_gossip=20000):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=5000):FRAG(down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):pbcast.STATE_TRANSFER";
    protected HAPartitionImpl partition;
    protected boolean deadlock_detection = false;
    protected JChannel channel;
    protected String nodeName = null;

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String newName) {
        this.partitionName = newName;
    }

    public String getPartitionProperties() {
        return this.jgProps;
    }

    public void setPartitionProperties(String newProps) {
        this.jgProps = newProps;
    }

    public void setPartitionConfig(Element config) {
        StringBuffer buffer = new StringBuffer();
        NodeList stack = config.getChildNodes();
        int length = stack.getLength();
        int s = 0;
        while (s < length) {
            Node node = stack.item(s);
            if (node.getNodeType() == 1) {
                Element tag = (Element)node;
                String protocol = tag.getTagName();
                buffer.append(protocol);
                NamedNodeMap attrs = tag.getAttributes();
                int attrLength = attrs.getLength();
                if (attrLength > 0) {
                    buffer.append('(');
                }
                int a = 0;
                while (a < attrLength) {
                    Attr attr = (Attr)attrs.item(a);
                    String name = attr.getName();
                    String value = attr.getValue();
                    buffer.append(name);
                    buffer.append('=');
                    buffer.append(value);
                    if (a < attrLength - 1) {
                        buffer.append(';');
                    }
                    ++a;
                }
                if (attrLength > 0) {
                    buffer.append(')');
                }
                buffer.append(':');
            }
            ++s;
        }
        buffer.setLength(buffer.length() - 1);
        this.jgProps = buffer.toString();
        this.log.debug((Object)("Setting JGProps from xml to: " + this.jgProps));
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String node) throws Exception {
        if (this.getState() == 6 || this.getState() == 3 || this.getState() == 2) {
            throw new Exception("Node name cannot be changed once the partition has been started");
        }
        this.nodeName = node;
    }

    public boolean getDeadlockDetection() {
        return this.deadlock_detection;
    }

    public void setDeadlockDetection(boolean doit) {
        this.deadlock_detection = doit;
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? ClusterPartitionMBean.OBJECT_NAME : name;
    }

    public HAPartition getHAPartition() {
        return this.partition;
    }

    public Vector getCurrentView() {
        return this.partition.getCurrentView();
    }

    public String getName() {
        return this.partitionName;
    }

    protected void createService() throws Exception {
        this.log.debug((Object)"Creating JGroups JChannel");
        this.channel = new JChannel((Object)this.jgProps);
        this.channel.setOpt(4, (Object)new Boolean(true));
        this.channel.setOpt(5, (Object)new Boolean(true));
        this.channel.setOpt(6, (Object)new Boolean(true));
        Logger category = Logger.getLogger((String)("org.javagroups." + this.partitionName));
        Level priority = category.getEffectiveLevel();
        int traceLevel = 2;
        if (priority.toInt() < Level.DEBUG.toInt()) {
            traceLevel = 0;
        } else if (priority == Level.DEBUG) {
            traceLevel = 4;
        } else if (priority == Level.INFO) {
            traceLevel = 4;
        } else if (priority == Level.ERROR) {
            traceLevel = 4;
        } else if (priority == Level.WARN) {
            traceLevel = 3;
        } else if (priority == Level.FATAL) {
            traceLevel = 5;
        }
        LoggerWriter log4jWriter = new LoggerWriter(category, priority);
        Trace.setDefaultOutput((int)traceLevel, (PrintWriter)log4jWriter);
        this.log.info((Object)("Set the JGroups logging to log4j with category:" + category + ", priority: " + priority + ", JGroupsLevel: " + traceLevel));
        this.log.debug((Object)"Creating HAPartition");
        this.partition = new HAPartitionImpl(this.partitionName, this.channel, this.deadlock_detection, this.getServer());
        this.log.debug((Object)("Initing HAPartition: " + this.partition));
        this.partition.init();
        this.log.debug((Object)"HAPartition initialized");
    }

    protected void startService() throws Exception {
        if (this.nodeName == null || "".equals(this.nodeName)) {
            this.nodeName = this.generateUniqueNodeName();
        }
        HashMap<String, byte[]> staticNodeName = new HashMap<String, byte[]>();
        staticNodeName.put("additional_data", this.nodeName.getBytes());
        this.channel.down(new Event(56, staticNodeName));
        this.channel.getProtocolStack().flushEvents();
        this.log.debug((Object)("Starting ClusterPartition: " + this.partitionName));
        this.channel.connect(this.partitionName);
        this.log.info((Object)"Starting channel");
        this.partition.startPartition();
        this.log.info((Object)("Started ClusterPartition: " + this.partitionName));
    }

    protected void stopService() throws Exception {
        this.log.debug((Object)("Stopping ClusterPartition: " + this.partitionName));
        this.partition.closePartition();
        this.log.info((Object)("Stopped ClusterPartition: " + this.partitionName));
    }

    protected String generateUniqueNodeName() throws Exception {
        String hostIP = null;
        try {
            hostIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            this.log.debug((Object)"unable to create a GUID for this cluster, check network configuration is correctly setup (getLocalHost has returned an exception)");
            this.log.debug((Object)"using a full GUID strategy");
            return new VMID().toString();
        }
        try {
            AttributeList al = this.server.getAttributes(NamingServiceMBean.OBJECT_NAME, new String[]{"State", "Port"});
            int status = (Integer)((Attribute)al.get(0)).getValue();
            if (status == 3) {
                int port = (Integer)((Attribute)al.get(1)).getValue();
                return hostIP + ":" + port;
            }
            this.log.debug((Object)"JNDI has been found but the service wasn't started so we cannot be entirely sure we are the only one that wants to use this PORT as a GUID on this host.");
        }
        catch (InstanceNotFoundException e) {
            this.log.debug((Object)"JNDI not running here, cannot use this strategy to find a node GUID for the cluster");
        }
        catch (ReflectionException e) {
            this.log.debug((Object)"JNDI querying has returned an exception, cannot use this strategy to find a node GUID for the cluster");
        }
        String uid = new UID().toString();
        return hostIP + ":" + uid;
    }

    public String showHistory() {
        StringBuffer buff = new StringBuffer();
        Vector data = new Vector(this.partition.history);
        Iterator row = data.iterator();
        while (row.hasNext()) {
            String info = (String)row.next();
            buff.append(info).append("\n");
        }
        return buff.toString();
    }

    public String showHistoryAsXML() {
        StringBuffer buff = new StringBuffer();
        buff.append("<events>\n");
        Vector data = new Vector(this.partition.history);
        Iterator row = data.iterator();
        while (row.hasNext()) {
            buff.append("   <event>\n      ");
            String info = (String)row.next();
            buff.append(info);
            buff.append("\n   </event>\n");
        }
        buff.append("</events>\n");
        return buff.toString();
    }
}

