/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.DistributedReplicantManagerImpl;
import org.jboss.ha.framework.server.DistributedStateImpl;
import org.jboss.invocation.MarshalledValueInputStream;
import org.jboss.invocation.MarshalledValueOutputStream;
import org.jboss.logging.Logger;
import org.jboss.naming.NonSerializableFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.MethodLookupClos;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class HAPartitionImpl
extends RpcDispatcher
implements MessageListener,
MembershipListener,
HAPartition {
    final MethodLookup method_lookup_clos = new MethodLookupClos();
    protected HashMap rpcHandlers = new HashMap();
    protected HashMap stateHandlers = new HashMap();
    protected ArrayList listeners = new ArrayList();
    protected ArrayList asynchListeners = new ArrayList();
    protected LinkedQueue asynchViewChanges = new LinkedQueue();
    protected Thread asynchNotifyThread;
    protected Vector members = null;
    protected Vector jgmembers = null;
    public Vector history = null;
    protected Vector otherMembers = null;
    protected Vector jgotherMembers = null;
    protected String partitionName;
    protected IpAddress localJGAddress = null;
    protected String nodeName;
    protected ClusterNode me = null;
    protected int timeout = 60000;
    protected JChannel channel;
    protected DistributedReplicantManagerImpl replicantManager;
    protected DistributedStateImpl dsManager;
    protected Logger log;
    protected Logger clusterLifeCycleLog;
    protected long currentViewId = -1L;
    protected MBeanServer server;
    static /* synthetic */ Class class$org$jboss$ha$framework$interfaces$HAPartition;
    static /* synthetic */ Class class$org$jboss$ha$framework$server$HAPartitionImpl;
    static /* synthetic */ Class class$org$jboss$naming$NonSerializableFactory;

    public static Object objectFromByteBuffer(byte[] buffer) throws Exception {
        if (buffer == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
        MarshalledValueInputStream mvis = new MarshalledValueInputStream((InputStream)bais);
        return mvis.readObject();
    }

    public static byte[] objectToByteBuffer(Object obj) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MarshalledValueOutputStream mvos = new MarshalledValueOutputStream((OutputStream)baos);
        mvos.writeObject(obj);
        mvos.flush();
        return baos.toByteArray();
    }

    public HAPartitionImpl(String partitionName, JChannel channel, boolean deadlock_detection, MBeanServer server) throws Exception {
        this(partitionName, channel, deadlock_detection);
        this.server = server;
    }

    public HAPartitionImpl(String partitionName, JChannel channel, boolean deadlock_detection) throws Exception {
        super((Channel)channel, null, null, new Object(), false);
        this.log = Logger.getLogger((String)((class$org$jboss$ha$framework$interfaces$HAPartition == null ? (class$org$jboss$ha$framework$interfaces$HAPartition = HAPartitionImpl.class$("org.jboss.ha.framework.interfaces.HAPartition")) : class$org$jboss$ha$framework$interfaces$HAPartition).getName() + "." + partitionName));
        this.clusterLifeCycleLog = Logger.getLogger((String)((class$org$jboss$ha$framework$interfaces$HAPartition == null ? (class$org$jboss$ha$framework$interfaces$HAPartition = HAPartitionImpl.class$("org.jboss.ha.framework.interfaces.HAPartition")) : class$org$jboss$ha$framework$interfaces$HAPartition).getName() + ".lifecycle." + partitionName));
        this.channel = channel;
        this.partitionName = partitionName;
        this.history = new Vector();
        this.logHistory("Partition object created");
    }

    public void init() throws Exception {
        this.log.info((Object)"Initializing");
        this.logHistory("Initializing partition");
        this.log.debug((Object)"setMembershipListener");
        this.setMembershipListener(this);
        this.log.debug((Object)"setMessageListener");
        this.setMessageListener(this);
        this.log.debug((Object)"create replicant manager");
        this.replicantManager = new DistributedReplicantManagerImpl(this, this.server);
        this.log.debug((Object)"init replicant manager");
        this.replicantManager.init();
        this.log.debug((Object)"bind replicant manager");
        this.log.debug((Object)"create distributed state");
        this.dsManager = new DistributedStateImpl(this, this.server);
        this.log.debug((Object)"init distributed state service");
        this.dsManager.init();
        this.log.debug((Object)"bind distributed state service");
        InitialContext ctx = new InitialContext();
        this.bind("/HAPartition/" + this.partitionName, this, class$org$jboss$ha$framework$server$HAPartitionImpl == null ? (class$org$jboss$ha$framework$server$HAPartitionImpl = HAPartitionImpl.class$("org.jboss.ha.framework.server.HAPartitionImpl")) : class$org$jboss$ha$framework$server$HAPartitionImpl, ctx);
        this.log.debug((Object)"done initing.");
    }

    public void startPartition() throws Exception {
        this.logHistory("Starting partition");
        this.log.debug((Object)"get nodeName");
        this.localJGAddress = (IpAddress)this.channel.getLocalAddress();
        this.me = new ClusterNode(this.localJGAddress);
        this.nodeName = this.me.getName();
        this.log.debug((Object)"Get current members");
        View view = this.channel.getView();
        this.jgmembers = (Vector)view.getMembers().clone();
        this.members = this.translateAddresses(this.jgmembers);
        this.log.info((Object)("Number of cluster members: " + this.members.size()));
        int m = 0;
        while (m > this.members.size()) {
            Object node = this.members.get(m);
            this.log.debug(node);
            ++m;
        }
        this.jgotherMembers = (Vector)view.getMembers().clone();
        this.jgotherMembers.remove(this.channel.getLocalAddress());
        this.otherMembers = this.translateAddresses(this.jgotherMembers);
        this.log.info((Object)("Other members: " + this.otherMembers.size()));
        this.verifyNodeIsUnique(view.getMembers());
        this.currentViewId = view.getVid().getId();
        boolean rc = this.channel.getState(null, 8000L);
        if (rc) {
            this.log.debug((Object)"State was retrieved successfully");
        } else {
            this.log.debug((Object)"State could not be retrieved, (must be first member of group)");
        }
        this.replicantManager.start();
        this.dsManager.start();
        AsynchViewChangeHandler asynchHandler = new AsynchViewChangeHandler();
        this.asynchNotifyThread = new Thread((Runnable)asynchHandler, "AsynchHAMembershipListener Thread");
        this.asynchNotifyThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePartition() throws Exception {
        this.logHistory("Closing partition");
        this.log.info((Object)("Closing partition " + this.partitionName));
        try {
            this.asynchNotifyThread.interrupt();
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to interrupte asynchNotifyThread", (Throwable)e);
        }
        try {
            this.replicantManager.stop();
        }
        catch (Exception e) {
            this.log.error((Object)"operation failed", (Throwable)e);
        }
        try {
            this.dsManager.stop();
        }
        catch (Exception e) {
            this.log.error((Object)"operation failed", (Throwable)e);
        }
        try {
            this.channel.close();
        }
        catch (Exception e) {
            this.log.error((Object)"operation failed", (Throwable)e);
        }
        String boundName = "/HAPartition/" + this.partitionName;
        InitialContext ctx = new InitialContext();
        try {
            ctx.unbind(boundName);
            Object var4_7 = null;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            ctx.close();
            throw throwable;
        }
        ctx.close();
        NonSerializableFactory.unbind((String)boundName);
        this.log.info((Object)("Partition " + this.partitionName + " closed."));
    }

    public byte[] getState() {
        this.logHistory("GetState called on partition");
        boolean debug = this.log.isDebugEnabled();
        this.log.debug((Object)"getState called.");
        try {
            HashMap<String, Serializable> state = new HashMap<String, Serializable>();
            Iterator keys = this.stateHandlers.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                HAPartition.HAPartitionStateTransfer subscriber = (HAPartition.HAPartitionStateTransfer)this.stateHandlers.get(key);
                if (debug) {
                    this.log.debug((Object)("getState for " + key));
                }
                state.put(key, subscriber.getCurrentState());
            }
            return HAPartitionImpl.objectToByteBuffer(state);
        }
        catch (Exception ex) {
            this.log.error((Object)"GetState failed", (Throwable)ex);
            return null;
        }
    }

    public void setState(byte[] obj) {
        this.logHistory("SetState called on partition");
        try {
            this.log.debug((Object)"setState called");
            if (obj == null) {
                this.log.debug((Object)"state is null");
                return;
            }
            HashMap state = (HashMap)HAPartitionImpl.objectFromByteBuffer(obj);
            Iterator keys = state.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.log.debug((Object)("setState for " + key));
                Object someState = state.get(key);
                HAPartition.HAPartitionStateTransfer subscriber = (HAPartition.HAPartitionStateTransfer)this.stateHandlers.get(key);
                if (subscriber != null) {
                    subscriber.setCurrentState((Serializable)someState);
                    continue;
                }
                this.log.debug((Object)("There is no stateHandler for: " + key));
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"setState failed", (Throwable)ex);
        }
    }

    public void receive(Message msg) {
    }

    public void suspect(Address suspected_mbr) {
        this.logHistory("Node suspected: " + (suspected_mbr == null ? "null" : suspected_mbr.toString()));
        if (this.isCurrentNodeCoordinator()) {
            this.clusterLifeCycleLog.info((Object)("Suspected member: " + suspected_mbr));
        } else {
            this.log.info((Object)("Suspected member: " + suspected_mbr));
        }
    }

    public void block() {
    }

    public void viewAccepted(View newView) {
        try {
            this.currentViewId = newView.getVid().getId();
            this.jgotherMembers = (Vector)newView.getMembers().clone();
            this.jgotherMembers.remove(this.channel.getLocalAddress());
            this.otherMembers = this.translateAddresses(this.jgotherMembers);
            Vector translatedNewView = this.translateAddresses((Vector)newView.getMembers().clone());
            this.logHistory("New view: " + translatedNewView + " with viewId: " + this.currentViewId + " (old view: " + this.members + " )");
            Vector oldMembers = this.members;
            Vector newjgMembers = (Vector)newView.getMembers().clone();
            Vector newMembers = this.translateAddresses(newjgMembers);
            if (this.members == null) {
                this.members = newMembers;
                this.jgmembers = newjgMembers;
                this.log.debug((Object)"ViewAccepted: initial members set");
                return;
            }
            this.members = newMembers;
            this.jgmembers = newjgMembers;
            int difference = 0;
            difference = oldMembers == null ? newMembers.size() - 1 : newMembers.size() - oldMembers.size();
            if (this.isCurrentNodeCoordinator()) {
                this.clusterLifeCycleLog.info((Object)("New cluster view (id: " + this.currentViewId + ", delta: " + difference + ") : " + this.members));
            } else {
                this.log.info((Object)("New cluster view: " + this.currentViewId + " (" + this.members + " delta: " + difference + ")"));
            }
            ViewChangeEvent event = new ViewChangeEvent();
            event.viewId = this.currentViewId;
            event.allMembers = translatedNewView;
            event.deadMembers = this.getDeadMembers(oldMembers, event.allMembers);
            event.newMembers = this.getNewMembers(oldMembers, event.allMembers);
            event.originatingGroups = null;
            if (newView instanceof MergeView) {
                MergeView mergeView = (MergeView)newView;
                event.originatingGroups = mergeView.getSubgroups();
            }
            this.log.debug((Object)("membership changed from " + this.members.size() + " to " + event.allMembers.size()));
            this.asynchViewChanges.put((Object)event);
            this.notifyListeners(this.listeners, event.viewId, event.allMembers, event.deadMembers, event.newMembers, event.originatingGroups);
        }
        catch (Exception ex) {
            this.log.error((Object)"ViewAccepted failed", (Throwable)ex);
        }
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public DistributedReplicantManager getDistributedReplicantManager() {
        return this.replicantManager;
    }

    public DistributedState getDistributedStateService() {
        return this.dsManager;
    }

    public long getCurrentViewId() {
        return this.currentViewId;
    }

    public Vector getCurrentView() {
        Vector<String> result = new Vector<String>(this.members.size());
        int i = 0;
        while (i < this.members.size()) {
            result.add(((ClusterNode)this.members.elementAt(i)).getName());
            ++i;
        }
        return result;
    }

    public ClusterNode[] getClusterNodes() {
        ClusterNode[] nodes = new ClusterNode[this.members.size()];
        this.members.toArray(nodes);
        return nodes;
    }

    public boolean isCurrentNodeCoordinator() {
        return this.members.elementAt(0).equals(this.me);
    }

    public void registerRPCHandler(String objName, Object subscriber) {
        this.rpcHandlers.put(objName, subscriber);
    }

    public void unregisterRPCHandler(String objName, Object subscriber) {
        this.rpcHandlers.remove(objName);
    }

    public ArrayList callMethodOnCluster(String objName, String methodName, Object[] args, boolean excludeSelf) throws Exception {
        ArrayList<Object> rtn = new ArrayList<Object>();
        MethodCall m = new MethodCall(objName + "." + methodName, args);
        RspList rsp = null;
        rsp = excludeSelf ? this.callRemoteMethods(this.jgotherMembers, m, 2, this.timeout) : this.callRemoteMethods(null, m, 2, this.timeout);
        if (rsp != null) {
            int i = 0;
            while (i < rsp.size()) {
                Object item = rsp.elementAt(i);
                if (item instanceof Rsp) {
                    Rsp response = (Rsp)item;
                    boolean wasReceived = response.wasReceived();
                    if (wasReceived) {
                        item = response.getValue();
                        if (!(item instanceof NoHandlerForRPC)) {
                            rtn.add(item);
                        }
                    } else if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Ignoring non-received response: " + response));
                    }
                } else if (!(item instanceof NoHandlerForRPC)) {
                    rtn.add(item);
                }
                ++i;
            }
        }
        return rtn;
    }

    public void callAsynchMethodOnCluster(String objName, String methodName, Object[] args, boolean excludeSelf) throws Exception {
        MethodCall m = new MethodCall(objName + "." + methodName, args);
        if (excludeSelf) {
            this.callRemoteMethods(this.jgotherMembers, m, 6, this.timeout);
        } else {
            this.callRemoteMethods(null, m, 6, this.timeout);
        }
    }

    public void subscribeToStateTransferEvents(String objectName, HAPartition.HAPartitionStateTransfer subscriber) {
        this.stateHandlers.put(objectName, subscriber);
    }

    public void unsubscribeFromStateTransferEvents(String objectName, HAPartition.HAPartitionStateTransfer subscriber) {
        this.stateHandlers.remove(objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMembershipListener(HAPartition.HAMembershipListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMembershipListener(HAPartition.HAMembershipListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    public Object handle(Message req) {
        Object body = null;
        Object retval = null;
        MethodCall method_call = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Partition " + this.partitionName + " received msg"));
        }
        if (req == null || req.getBuffer() == null) {
            this.log.warn((Object)"RpcProtocol.Handle(): message or message buffer is null !");
            return null;
        }
        try {
            body = Util.objectFromByteBuffer((byte[])req.getBuffer());
        }
        catch (Exception e) {
            this.log.warn((Object)("RpcProtocol.Handle(): " + e));
            return null;
        }
        if (body == null || !(body instanceof MethodCall)) {
            this.log.warn((Object)"RpcProtocol.Handle(): message does not contain a MethodCall object !");
            return null;
        }
        method_call = (MethodCall)body;
        String methodName = method_call.getName();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("pre methodName: " + methodName));
        }
        int idx = methodName.lastIndexOf(46);
        String handlerName = methodName.substring(0, idx);
        String newMethodName = methodName.substring(idx + 1);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("handlerName: " + handlerName + " methodName: " + newMethodName));
            this.log.debug((Object)("Handle: " + methodName));
        }
        method_call.setName(newMethodName);
        Object handler = this.rpcHandlers.get(handlerName);
        if (handler == null) {
            return new NoHandlerForRPC();
        }
        try {
            retval = method_call.invoke(handler, this.method_lookup_clos);
        }
        catch (Error er) {
            this.log.warn((Object)er);
            throw er;
        }
        catch (RuntimeException re) {
            this.log.warn((Object)re);
            throw re;
        }
        catch (Exception ex) {
            this.log.warn((Object)ex);
        }
        catch (Throwable t) {
            this.log.info((Object)t);
        }
        return retval;
    }

    protected void verifyNodeIsUnique(Vector javaGroupIpAddresses) throws Exception {
        byte[] localUniqueName = this.localJGAddress.getAdditionalData();
        if (localUniqueName == null) {
            this.log.warn((Object)"No additional information has been found in the JavaGroup address: make sure you are running with a correct version of JGroups and that the protocol  you are using supports the 'additionalData' behaviour");
        }
        int i = 0;
        while (i < javaGroupIpAddresses.size()) {
            IpAddress address = (IpAddress)javaGroupIpAddresses.elementAt(i);
            if (!address.equals((Object)this.localJGAddress) && localUniqueName.equals(address.getAdditionalData())) {
                throw new Exception("Local node removed from cluster (" + this.localJGAddress + "): another node (" + address + ") publicizing the same name was already there");
            }
            ++i;
        }
    }

    protected void bind(String jndiName, Object who, Class classType, Context ctx) throws Exception {
        NonSerializableFactory.bind((String)jndiName, (Object)who);
        Name n = ctx.getNameParser("").parse(jndiName);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException e) {
                this.log.debug((Object)("creating Subcontext" + ctxName));
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        StringRefAddr addr = new StringRefAddr("nns", jndiName);
        Reference ref = new Reference(classType.getName(), addr, (class$org$jboss$naming$NonSerializableFactory == null ? (class$org$jboss$naming$NonSerializableFactory = HAPartitionImpl.class$("org.jboss.naming.NonSerializableFactory")) : class$org$jboss$naming$NonSerializableFactory).getName(), null);
        ctx.rebind(n.get(0), (Object)ref);
    }

    protected Vector getDeadMembers(Vector oldMembers, Vector newMembers) {
        boolean debug = this.log.isDebugEnabled();
        Vector dead = new Vector();
        int i = 0;
        while (i < oldMembers.size()) {
            if (debug) {
                this.log.debug((Object)("is node " + oldMembers.elementAt(i).toString() + "dead?"));
            }
            if (!newMembers.contains(oldMembers.elementAt(i))) {
                if (debug) {
                    this.log.debug((Object)("node " + oldMembers.elementAt(i).toString() + "is dead"));
                }
                dead.add(oldMembers.elementAt(i));
            } else if (debug) {
                this.log.debug((Object)("node " + oldMembers.elementAt(i).toString() + "is NOT dead"));
            }
            ++i;
        }
        return dead;
    }

    protected Vector getNewMembers(Vector oldMembers, Vector allMembers) {
        Vector newMembers = new Vector();
        int i = 0;
        while (i < allMembers.size()) {
            if (!oldMembers.contains(allMembers.elementAt(i))) {
                newMembers.add(allMembers.elementAt(i));
            }
            ++i;
        }
        return newMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(ArrayList theListeners, long viewID, Vector allMembers, Vector deadMembers, Vector newMembers, Vector originatingGroups) {
        this.log.debug((Object)("Begin notifyListeners, viewID: " + viewID));
        ArrayList arrayList = theListeners;
        synchronized (arrayList) {
            int i = 0;
            while (i < theListeners.size()) {
                HAPartition.HAMembershipListener aListener = null;
                try {
                    aListener = (HAPartition.HAMembershipListener)theListeners.get(i);
                    if (originatingGroups != null && aListener instanceof HAPartition.HAMembershipExtendedListener) {
                        HAPartition.HAMembershipExtendedListener exListener = (HAPartition.HAMembershipExtendedListener)aListener;
                        exListener.membershipChangedDuringMerge(deadMembers, newMembers, allMembers, originatingGroups);
                    } else {
                        aListener.membershipChanged(deadMembers, newMembers, allMembers);
                    }
                }
                catch (Throwable e) {
                    this.log.warn((Object)("HAMembershipListener callback failure: " + aListener), e);
                }
                ++i;
            }
        }
        this.log.debug((Object)("End notifyListeners, viewID: " + viewID));
    }

    protected Vector translateAddresses(Vector jgAddresses) {
        if (jgAddresses == null) {
            return null;
        }
        Vector<ClusterNode> result = new Vector<ClusterNode>(jgAddresses.size());
        int i = 0;
        while (i < jgAddresses.size()) {
            IpAddress addr = (IpAddress)jgAddresses.elementAt(i);
            result.add(new ClusterNode(addr));
            ++i;
        }
        return result;
    }

    public void logHistory(String message) {
        try {
            this.history.add(new SimpleDateFormat().format(new Date()) + " : " + message);
        }
        catch (Exception ignored) {}
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class AsynchViewChangeHandler
    implements Runnable {
        private AsynchViewChangeHandler() {
        }

        public void run() {
            HAPartitionImpl.this.log.debug((Object)"Begin AsynchViewChangeHandler");
            while (true) {
                try {
                    ViewChangeEvent event = (ViewChangeEvent)HAPartitionImpl.this.asynchViewChanges.take();
                    HAPartitionImpl.this.notifyListeners(HAPartitionImpl.this.asynchListeners, event.viewId, event.allMembers, event.deadMembers, event.newMembers, event.originatingGroups);
                }
                catch (InterruptedException e) {
                    HAPartitionImpl.this.log.debug((Object)"AsynchViewChangeHandler interrupted", (Throwable)e);
                    HAPartitionImpl.this.log.debug((Object)"End AsynchViewChangeHandler");
                    return;
                }
            }
        }
    }

    private static class ViewChangeEvent {
        long viewId;
        Vector deadMembers;
        Vector newMembers;
        Vector allMembers;
        Vector originatingGroups;

        private ViewChangeEvent() {
        }
    }

    private static class NoHandlerForRPC
    implements Serializable {
        private NoHandlerForRPC() {
        }
    }
}

