/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.HARMIClient;
import org.jboss.ha.framework.interfaces.HARMIProxyCallback;
import org.jboss.ha.framework.interfaces.HARMIResponse;
import org.jboss.ha.framework.interfaces.HARMIServer;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.logging.Logger;
import org.jboss.net.sockets.DefaultSocketFactory;

public class HARMIServerImpl
implements HARMIServer {
    protected Object handler;
    protected Map invokerMap = new HashMap();
    protected Logger log;
    protected RemoteStub rmistub;
    protected Object stub;
    protected String key;
    protected Class intf;
    protected RefreshProxiesHATarget target;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$jboss$ha$framework$interfaces$HARMIProxy;

    public HARMIServerImpl(HAPartition partition, String replicantName, Class intf, Object handler, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws Exception {
        this(partition, replicantName, intf, handler, port, csf, ssf, null, null);
    }

    public HARMIServerImpl(HAPartition partition, String replicantName, Class intf, Object handler, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, InetAddress bindAddress) throws Exception {
        this(partition, replicantName, intf, handler, port, csf, ssf, bindAddress, null);
    }

    public HARMIServerImpl(HAPartition partition, String replicantName, Class intf, Object handler, int port, RMIClientSocketFactory clientSocketFactory, RMIServerSocketFactory serverSocketFactory, InetAddress bindAddress, HARMIProxyCallback callbackEvents) throws Exception {
        this.handler = handler;
        this.log = Logger.getLogger(this.getClass());
        this.intf = intf;
        this.key = partition.getPartitionName() + "/" + replicantName;
        Method[] methods = handler.getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            Long methodkey = new Long(MarshalledInvocation.calculateHash((Method)methods[i]));
            this.invokerMap.put(methodkey, methods[i]);
            ++i;
        }
        if (bindAddress != null) {
            if (serverSocketFactory == null) {
                serverSocketFactory = new DefaultSocketFactory(bindAddress);
            } else {
                try {
                    Class[] parameterTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = HARMIServerImpl.class$("java.lang.String")) : class$java$lang$String};
                    Class<?> ssfClass = serverSocketFactory.getClass();
                    Method m = ssfClass.getMethod("setBindAddress", parameterTypes);
                    Object[] args = new Object[]{bindAddress.getHostAddress()};
                    m.invoke((Object)serverSocketFactory, args);
                }
                catch (NoSuchMethodException e) {
                    this.log.warn((Object)"Socket factory does not support setBindAddress(String)");
                }
                catch (Exception e) {
                    this.log.warn((Object)("Failed to setBindAddress=" + bindAddress + " on socket factory"), (Throwable)e);
                }
            }
        }
        this.rmistub = (RemoteStub)UnicastRemoteObject.exportObject(this, port, clientSocketFactory, serverSocketFactory);
        this.target = new RefreshProxiesHATarget(partition, replicantName, this.rmistub, 2, callbackEvents);
        HARMIServer.rmiServers.put(this.key, this);
    }

    public HARMIServerImpl(HAPartition partition, String replicantName, Class intf, Object handler) throws Exception {
        this(partition, replicantName, intf, handler, 0, null, null);
    }

    public Object createHAStub(LoadBalancePolicy policy) {
        HARMIClient client = new HARMIClient(this.target.getReplicants(), this.target.getCurrentViewId(), policy, this.key, this.handler);
        this.target.addProxy(client);
        return Proxy.newProxyInstance(this.intf.getClassLoader(), new Class[]{this.intf, class$org$jboss$ha$framework$interfaces$HARMIProxy == null ? (class$org$jboss$ha$framework$interfaces$HARMIProxy = HARMIServerImpl.class$("org.jboss.ha.framework.interfaces.HARMIProxy")) : class$org$jboss$ha$framework$interfaces$HARMIProxy}, (InvocationHandler)client);
    }

    public void destroy() {
        try {
            this.target.destroy();
            HARMIServer.rmiServers.remove(this.key);
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (Exception e) {
            this.log.error((Object)"failed to destroy", (Throwable)e);
        }
    }

    public HARMIResponse invoke(long clientViewId, MarshalledInvocation mi) throws Exception {
        mi.setMethodMap(this.invokerMap);
        Method method = mi.getMethod();
        try {
            HARMIResponse rsp = new HARMIResponse();
            if (clientViewId != this.target.getCurrentViewId()) {
                rsp.newReplicants = new ArrayList(this.target.getReplicants());
                rsp.currentViewId = this.target.getCurrentViewId();
            }
            rsp.response = method.invoke(this.handler, mi.getArguments());
            return rsp;
        }
        catch (IllegalAccessException iae) {
            throw iae;
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (InvocationTargetException ite) {
            throw (Exception)ite.getTargetException();
        }
    }

    public List getReplicants() throws Exception {
        return this.target.getReplicants();
    }

    public Object getLocal() throws Exception {
        return this.handler;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class RefreshProxiesHATarget
    extends HATarget {
        protected ArrayList generatedProxies;
        protected HARMIProxyCallback callback = null;

        public RefreshProxiesHATarget(HAPartition partition, String replicantName, Serializable target, int allowInvocations) throws Exception {
            super(partition, replicantName, target, allowInvocations);
        }

        public RefreshProxiesHATarget(HAPartition partition, String replicantName, Serializable target, int allowInvocations, HARMIProxyCallback callbackEvents) throws Exception {
            super(partition, replicantName, target, allowInvocations);
            this.callback = callbackEvents;
        }

        public void init() throws Exception {
            super.init();
            this.generatedProxies = new ArrayList();
        }

        public synchronized void addProxy(HARMIClient client) {
            SoftReference<HARMIClient> ref = new SoftReference<HARMIClient>(client);
            this.generatedProxies.add(ref);
        }

        public synchronized void replicantsChanged(String key, List newReplicants, int newReplicantsViewId) {
            block6: {
                super.replicantsChanged(key, newReplicants, newReplicantsViewId);
                int max = this.generatedProxies.size();
                ArrayList<SoftReference> trash = new ArrayList<SoftReference>();
                int i = 0;
                while (i < max) {
                    SoftReference ref = (SoftReference)this.generatedProxies.get(i);
                    HARMIClient proxy = (HARMIClient)ref.get();
                    if (proxy == null) {
                        trash.add(ref);
                    } else {
                        proxy.updateClusterInfo(this.replicants, this.clusterViewId);
                    }
                    ++i;
                }
                if (trash.size() > 0) {
                    this.generatedProxies.removeAll(trash);
                }
                if (this.callback == null) break block6;
                try {
                    this.callback.proxyUpdated();
                }
                catch (Throwable notOurBusiness) {}
            }
        }
    }
}

