/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server.util;

import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.ha.framework.server.util.PingJndiMBean;
import org.jboss.ha.framework.server.util.TopologyMonitorService;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;

public class PingJndi
extends ServiceMBeanSupport
implements PingJndiMBean {
    private String urlPrefix;
    private String urlSuffix;
    private String urlPattern;
    private String[] lookupNames;

    public String[] getLookupNames() {
        return this.lookupNames;
    }

    public void setLookupNames(String[] names) {
        this.lookupNames = names;
    }

    public String getProviderURLPattern() {
        return this.urlPattern;
    }

    public void setProviderURLPattern(String regex) {
        this.urlPattern = regex;
        this.urlPrefix = regex;
        this.urlSuffix = "";
        String hostExp = "{host}";
        int hostIndex = regex.indexOf(hostExp);
        if (hostIndex >= 0) {
            this.urlPrefix = regex.substring(0, hostIndex);
            int endIndex = hostIndex + hostExp.length();
            this.urlSuffix = regex.substring(endIndex);
        }
    }

    public void membershipChanged(ArrayList removed, ArrayList added, ArrayList members, String logCategoryName) {
        this.log.debug((Object)"membershipChanged");
        Logger tmsLog = Logger.getLogger((String)logCategoryName);
        Hashtable<?, ?> localEnv = null;
        try {
            InitialContext localCtx = new InitialContext();
            localEnv = localCtx.getEnvironment();
        }
        catch (NamingException e) {
            tmsLog.error((Object)"Failed to obtain InitialContext env", (Throwable)e);
            return;
        }
        tmsLog.info((Object)"Checking removed hosts JNDI binding");
        this.doLookups(localEnv, tmsLog, removed);
        tmsLog.info((Object)"Checking added hosts JNDI binding");
        this.doLookups(localEnv, tmsLog, added);
        tmsLog.info((Object)"Checking members hosts JNDI binding");
        this.doLookups(localEnv, tmsLog, members);
    }

    private void doLookups(Hashtable localEnv, Logger tmsLog, ArrayList nodes) {
        int n = 0;
        while (n < nodes.size()) {
            TopologyMonitorService.AddressPort addrInfo = (TopologyMonitorService.AddressPort)nodes.get(n);
            String providerURL = this.urlPrefix + addrInfo.getHostName() + this.urlSuffix;
            Hashtable<String, String> env = new Hashtable<String, String>(localEnv);
            env.put("java.naming.provider.url", providerURL);
            tmsLog.info((Object)("Checking names on: " + addrInfo));
            try {
                InitialContext ctx = new InitialContext(env);
                int s = 0;
                while (s < this.lookupNames.length) {
                    String name = this.lookupNames[s];
                    Object value = ctx.lookup(name);
                    tmsLog.info((Object)("lookup(" + name + "): " + value));
                    ++s;
                }
            }
            catch (Exception e) {
                tmsLog.error((Object)("Failed lookups on: " + addrInfo), (Throwable)e);
            }
            ++n;
        }
    }
}

