/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.jmx;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.ClusterPartitionMBean;
import org.jboss.ha.jmx.HAServiceMBean;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.system.ServiceMBeanSupport;

public class HAServiceMBeanSupport
extends ServiceMBeanSupport
implements HAServiceMBean {
    private HAPartition partition_;
    private String partitionName = "DefaultPartition";
    private DistributedReplicantManager.ReplicantListener drmListener = null;
    private String REPLICANT_TOKEN = "";
    static /* synthetic */ Class class$org$jboss$ha$framework$server$ClusterPartition;
    static /* synthetic */ Class class$org$jboss$ha$framework$server$ClusterPartitionMBean;

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String newPartitionName) {
        if (this.getState() != 3 && this.getState() != 2) {
            this.partitionName = newPartitionName;
        }
    }

    public void setDistributedState(String key, Serializable value) throws Exception {
        DistributedState ds = this.getPartition().getDistributedStateService();
        ds.set(this.getServiceHAName(), (Serializable)((Object)key), value);
    }

    public Serializable getDistributedState(String key) {
        DistributedState ds = this.getPartition().getDistributedStateService();
        return ds.get(this.getServiceHAName(), (Serializable)((Object)key));
    }

    protected void startService() throws Exception {
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            this.log.debug((Object)"start HASingletonController");
        }
        this.setupPartition();
        this.registerRPCHandler();
        this.registerDRMListener();
    }

    protected void stopService() throws Exception {
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            this.log.debug((Object)"stop HASingletonController");
        }
        this.unregisterDRMListener();
        this.unregisterRPCHandler();
    }

    protected void setupPartition() throws Exception {
        String pName = this.getPartitionName();
        this.partition_ = this.findHAPartitionWithName(pName);
    }

    protected void registerRPCHandler() {
        this.partition_.registerRPCHandler(this.getServiceHAName(), this);
    }

    protected void unregisterRPCHandler() {
        this.partition_.unregisterRPCHandler(this.getServiceHAName(), this);
    }

    protected void registerDRMListener() throws Exception {
        DistributedReplicantManager drm = this.partition_.getDistributedReplicantManager();
        this.drmListener = new DistributedReplicantManager.ReplicantListener(){

            public void replicantsChanged(String key, List newReplicants, int newReplicantsViewId) {
                if (key.equals(HAServiceMBeanSupport.this.getServiceHAName())) {
                    HAServiceMBeanSupport.this.partitionTopologyChanged(newReplicants, newReplicantsViewId);
                }
            }
        };
        drm.registerListener(this.getServiceHAName(), this.drmListener);
        drm.add(this.getServiceHAName(), (Serializable)((Object)this.REPLICANT_TOKEN));
    }

    protected void unregisterDRMListener() throws Exception {
        DistributedReplicantManager drm = this.partition_.getDistributedReplicantManager();
        drm.remove(this.getServiceHAName());
        drm.unregisterListener(this.getServiceHAName(), this.drmListener);
    }

    public void partitionTopologyChanged(List newReplicants, int newReplicantsViewId) {
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            this.log.debug((Object)("partitionTopologyChanged(). cluster view id: " + newReplicantsViewId));
        }
    }

    protected boolean isDRMMasterReplica() {
        DistributedReplicantManager drm = this.getPartition().getDistributedReplicantManager();
        return drm.isMasterReplica(this.getServiceHAName());
    }

    public HAPartition getPartition() {
        return this.partition_;
    }

    public void callMethodOnPartition(String methodName, Object[] args) throws Exception {
        this.getPartition().callMethodOnCluster(this.getServiceHAName(), methodName, args, true);
    }

    public void sendNotification(Notification notification) {
        block2: {
            try {
                notification.setSource(this.getServiceName());
                this.sendNotificationRemote(notification);
            }
            catch (Throwable th) {
                boolean debug = this.log.isDebugEnabled();
                if (!debug) break block2;
                this.log.debug((Object)("sendNotificationRemote( " + notification + " ) failed "), th);
            }
        }
        this.sendNotificationToLocalListeners(notification);
    }

    protected void sendNotificationToLocalListeners(Notification notification) {
        super.sendNotification(notification);
    }

    protected void callAsyncMethodOnPartition(String methodName, Object[] args) throws Exception {
        HAPartition partition = this.getPartition();
        if (partition != null) {
            this.getPartition().callMethodOnCluster(this.getServiceHAName(), methodName, args, true);
        }
    }

    protected void sendNotificationRemote(Notification notification) throws Exception {
        this.callAsyncMethodOnPartition("_receiveRemoteNotification", new Object[]{notification});
    }

    public void _receiveRemoteNotification(Notification notification) {
        super.sendNotification(notification);
    }

    public String getServiceHAName() {
        return this.getServiceName().getCanonicalName();
    }

    protected HAPartition findHAPartitionWithName(String name) throws Exception {
        HAPartition result = null;
        QueryExp exp = Query.and(Query.eq(Query.classattr(), Query.value((class$org$jboss$ha$framework$server$ClusterPartition == null ? (class$org$jboss$ha$framework$server$ClusterPartition = HAServiceMBeanSupport.class$("org.jboss.ha.framework.server.ClusterPartition")) : class$org$jboss$ha$framework$server$ClusterPartition).getName())), Query.match(Query.attr("PartitionName"), Query.value(name)));
        Set<ObjectInstance> mbeans = this.getServer().queryMBeans(null, exp);
        if (mbeans != null && mbeans.size() > 0) {
            ObjectInstance inst = mbeans.iterator().next();
            ClusterPartitionMBean cp = (ClusterPartitionMBean)MBeanProxy.get((Class)(class$org$jboss$ha$framework$server$ClusterPartitionMBean == null ? (class$org$jboss$ha$framework$server$ClusterPartitionMBean = HAServiceMBeanSupport.class$("org.jboss.ha.framework.server.ClusterPartitionMBean")) : class$org$jboss$ha$framework$server$ClusterPartitionMBean), (ObjectName)inst.getObjectName(), (MBeanServer)this.getServer());
            result = cp.getHAPartition();
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

