/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.jndi;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.MarshalledObject;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.RoundRobin;
import org.jboss.ha.framework.server.ClusterPartitionMBean;
import org.jboss.ha.framework.server.HARMIServerImpl;
import org.jboss.ha.jndi.HAJNDI;
import org.jboss.ha.jndi.HANamingServiceMBean;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.system.ServiceMBeanSupport;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingContext;

public class HANamingService
extends ServiceMBeanSupport
implements Runnable,
HANamingServiceMBean {
    protected HAJNDI theServer;
    protected ServerSocket serverSocket;
    protected RMIClientSocketFactory clientSocketFactory;
    protected RMIServerSocketFactory serverSocketFactory;
    protected String clientSocketFactoryName;
    protected String serverSocketFactoryName;
    protected InetAddress bindAddress;
    protected int backlog = 50;
    protected int port = 1100;
    protected int rmiPort = 0;
    protected Map marshalledInvocationMapping;
    protected HARMIServerImpl rmiserver;
    protected Naming stub;
    protected HAPartition partition;
    protected String partitionName = "DefaultPartition";
    protected AutomaticDiscovery autoDiscovery = null;
    protected String adGroupAddress = "230.0.0.4";
    protected int adGroupPort = 1102;
    static /* synthetic */ Class class$org$jnp$interfaces$Naming;
    static /* synthetic */ Class class$org$jboss$ha$framework$server$ClusterPartition;
    static /* synthetic */ Class class$org$jboss$ha$framework$server$ClusterPartitionMBean;
    static /* synthetic */ Class class$org$jboss$ha$jndi$HANamingService$AutomaticDiscovery;

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? HANamingServiceMBean.OBJECT_NAME : name;
    }

    public Map getMethodMap() {
        return this.marshalledInvocationMapping;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    public void setRmiPort(int p) {
        this.rmiPort = p;
    }

    public int getRmiPort() {
        return this.rmiPort;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public int getPort() {
        return this.port;
    }

    public String getBindAddress() {
        String address = null;
        if (this.bindAddress != null) {
            address = this.bindAddress.getHostAddress();
        }
        return address;
    }

    public void setBindAddress(String host) throws UnknownHostException {
        this.bindAddress = InetAddress.getByName(host);
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        if (backlog <= 0) {
            backlog = 50;
        }
        this.backlog = backlog;
    }

    public String getAutoDiscoveryAddress() {
        return this.adGroupAddress;
    }

    public void setAutoDiscoveryAddress(String adAddress) {
        this.adGroupAddress = adAddress;
    }

    public int getAutoDiscoveryGroup() {
        return this.adGroupPort;
    }

    public void setAutoDiscoveryGroup(int adGroup) {
        this.adGroupPort = adGroup;
    }

    public String getClientSocketFactory() {
        return this.serverSocketFactoryName;
    }

    public void setClientSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.clientSocketFactoryName = factoryClassName;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = loader.loadClass(this.clientSocketFactoryName);
        this.clientSocketFactory = (RMIClientSocketFactory)clazz.newInstance();
    }

    public String getServerSocketFactory() {
        return this.serverSocketFactoryName;
    }

    public void setServerSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.serverSocketFactoryName = factoryClassName;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = loader.loadClass(this.serverSocketFactoryName);
        this.serverSocketFactory = (RMIServerSocketFactory)clazz.newInstance();
    }

    public void startService(HAPartition haPartition) throws Exception {
        this.partition = haPartition;
        this.startService();
    }

    protected void startService() throws Exception {
        this.log.debug((Object)"Create HARMIServer proxy");
        this.rmiserver = new HARMIServerImpl(this.partition, "HAJNDI", class$org$jnp$interfaces$Naming == null ? (class$org$jnp$interfaces$Naming = HANamingService.class$("org.jnp.interfaces.Naming")) : class$org$jnp$interfaces$Naming, this.theServer, this.rmiPort, this.clientSocketFactory, this.serverSocketFactory, this.bindAddress);
        this.stub = (Naming)this.rmiserver.createHAStub(new RoundRobin());
        this.theServer.setHAStub(this.stub);
        this.log.debug((Object)"Starting listener");
        try {
            this.serverSocket = new ServerSocket(this.port, this.backlog, this.bindAddress);
            if (this.port == 0) {
                this.port = this.serverSocket.getLocalPort();
            }
            this.listen();
            this.log.info((Object)("Listening on " + this.serverSocket.getInetAddress() + ":" + this.serverSocket.getLocalPort()));
        }
        catch (IOException e) {
            this.log.error((Object)("Could not start on port " + this.port), (Throwable)e);
        }
        try {
            this.autoDiscovery = new AutomaticDiscovery();
            this.autoDiscovery.start();
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to start AutomaticDiscovery", (Throwable)e);
        }
    }

    protected void createService() throws Exception {
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            this.log.debug((Object)("Initializing HAJNDI server on partition: " + this.partitionName));
        }
        this.partition = this.findHAPartitionWithName(this.partitionName);
        this.log.debug((Object)"Create remote object");
        this.theServer = new HAJNDI(this.partition);
        this.log.debug((Object)"initialize HAJNDI");
        this.theServer.init();
        HashMap<Long, Method> tmpMap = new HashMap<Long, Method>(13);
        Method[] methods = (class$org$jnp$interfaces$Naming == null ? (class$org$jnp$interfaces$Naming = HANamingService.class$("org.jnp.interfaces.Naming")) : class$org$jnp$interfaces$Naming).getMethods();
        int m = 0;
        while (m < methods.length) {
            Method method = methods[m];
            Long hash = new Long(MarshalledInvocation.calculateHash((Method)method));
            tmpMap.put(hash, method);
            ++m;
        }
        this.marshalledInvocationMapping = Collections.unmodifiableMap(tmpMap);
        NamingContext.setHANamingServerForPartition((String)this.partitionName, (Naming)this.theServer);
    }

    protected void stopService() throws Exception {
        boolean debug = this.log.isDebugEnabled();
        NamingContext.removeHANamingServerForPartition((String)this.partitionName);
        if (debug) {
            this.log.debug((Object)"destroy ha rmiserver");
        }
        this.rmiserver.destroy();
        this.theServer.stop();
        ServerSocket s = this.serverSocket;
        this.serverSocket = null;
        if (debug) {
            this.log.debug((Object)"closing socket");
        }
        s.close();
        if (debug) {
            this.log.debug((Object)"Stopping AutomaticDiscovery");
        }
        if (this.autoDiscovery != null) {
            this.autoDiscovery.stop();
        }
    }

    public Object invoke(Invocation invocation) throws Exception {
        if (invocation instanceof MarshalledInvocation) {
            MarshalledInvocation mi = (MarshalledInvocation)invocation;
            mi.setMethodMap(this.marshalledInvocationMapping);
        }
        Method method = invocation.getMethod();
        Object[] args = invocation.getArguments();
        Object value = null;
        try {
            value = method.invoke((Object)this.theServer, args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new UndeclaredThrowableException(t, method.toString());
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block16: {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
            }
            catch (IOException e) {
                if (this.serverSocket == null) {
                    return;
                }
                this.log.error((Object)"Naming stopped", (Throwable)e);
                this.log.info((Object)"Restarting naming");
                try {
                    this.start();
                }
                catch (Exception ex) {
                    this.log.error((Object)"Restart failed", (Throwable)ex);
                    return;
                }
            }
            this.listen();
            ObjectOutputStream out = new ObjectOutputStream(socket.getOutputStream());
            Naming naming = this.stub;
            synchronized (naming) {
                out.writeObject(new MarshalledObject<Naming>(this.stub));
            }
            Object var6_8 = null;
            try {
                socket.close();
            }
            catch (IOException e) {}
            break block16;
            {
                catch (IOException ex) {
                    this.log.error((Object)"Error writing response", (Throwable)ex);
                    Object var6_9 = null;
                    try {
                        socket.close();
                    }
                    catch (IOException e) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {
                    socket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected void listen() {
        Thread t = new Thread((Runnable)this, "HAJNDI-Listener");
        t.start();
    }

    protected HAPartition findHAPartitionWithName(String name) throws Exception {
        HAPartition result = null;
        QueryExp exp = Query.and(Query.eq(Query.classattr(), Query.value((class$org$jboss$ha$framework$server$ClusterPartition == null ? (class$org$jboss$ha$framework$server$ClusterPartition = HANamingService.class$("org.jboss.ha.framework.server.ClusterPartition")) : class$org$jboss$ha$framework$server$ClusterPartition).getName())), Query.match(Query.attr("PartitionName"), Query.value(name)));
        Set<ObjectInstance> mbeans = this.getServer().queryMBeans(null, exp);
        if (mbeans != null && mbeans.size() > 0) {
            ObjectInstance inst = mbeans.iterator().next();
            ClusterPartitionMBean cp = (ClusterPartitionMBean)MBeanProxy.get((Class)(class$org$jboss$ha$framework$server$ClusterPartitionMBean == null ? (class$org$jboss$ha$framework$server$ClusterPartitionMBean = HANamingService.class$("org.jboss.ha.framework.server.ClusterPartitionMBean")) : class$org$jboss$ha$framework$server$ClusterPartitionMBean), (ObjectName)inst.getObjectName(), (MBeanServer)this.getServer());
            result = cp.getHAPartition();
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class AutomaticDiscovery
    implements Runnable {
        protected Logger log = Logger.getLogger((Class)(class$org$jboss$ha$jndi$HANamingService$AutomaticDiscovery == null ? (class$org$jboss$ha$jndi$HANamingService$AutomaticDiscovery = HANamingService.class$("org.jboss.ha.jndi.HANamingService$AutomaticDiscovery")) : class$org$jboss$ha$jndi$HANamingService$AutomaticDiscovery));
        protected MulticastSocket socket = null;
        protected byte[] ipAddress = null;
        protected InetAddress group = null;
        protected boolean stopping = false;

        public void start() throws Exception {
            this.stopping = false;
            this.socket = new MulticastSocket(HANamingService.this.adGroupPort);
            if (HANamingService.this.bindAddress != null) {
                this.socket.setInterface(HANamingService.this.bindAddress);
            }
            this.group = InetAddress.getByName(HANamingService.this.adGroupAddress);
            this.socket.joinGroup(this.group);
            String address = HANamingService.this.getBindAddress();
            this.ipAddress = address == null ? (InetAddress.getLocalHost().getHostAddress() + ":" + HANamingService.this.port).getBytes() : (address + ":" + HANamingService.this.port).getBytes();
            this.log.info((Object)("Listening on " + this.socket.getInterface() + ":" + this.socket.getLocalPort() + ", group=" + HANamingService.this.adGroupAddress));
            this.listen();
        }

        public void stop() {
            try {
                this.stopping = true;
                this.socket.leaveGroup(this.group);
                this.socket.close();
            }
            catch (Exception ex) {
                this.log.error((Object)"Stopping AutomaticDiscovery failed", (Throwable)ex);
            }
        }

        public void run() {
            boolean trace = this.log.isTraceEnabled();
            byte[] buf = new byte[256];
            DatagramPacket packet = new DatagramPacket(buf, buf.length);
            try {
                if (trace) {
                    this.log.trace((Object)"HA-JNDI AutomaticDiscovery waiting for queries...");
                }
                this.socket.receive(packet);
                if (trace) {
                    this.log.trace((Object)"HA-JNDI AutomaticDiscovery Packet received.");
                }
            }
            catch (IOException e) {
                if (this.stopping) {
                    return;
                }
                this.log.error((Object)"Auto-discovery stopped", (Throwable)e);
                this.log.info((Object)"Restarting auto-discovery");
                try {
                    this.start();
                }
                catch (Exception ex) {
                    this.log.error((Object)"Restart failed: auto-discovery is now disabled!!!", (Throwable)ex);
                    return;
                }
            }
            this.listen();
            try {
                String requestData = new String(packet.getData());
                int colon = requestData.indexOf(58);
                if (colon > 0) {
                    String name = requestData.substring(colon + 1);
                    if (!(name = name.trim()).equals(HANamingService.this.partitionName)) {
                        this.log.debug((Object)("Ignoring discovery request for partition: " + name));
                        return;
                    }
                }
                DatagramPacket p = new DatagramPacket(this.ipAddress, this.ipAddress.length, packet.getAddress(), packet.getPort());
                if (trace) {
                    this.log.trace((Object)("Sending AutomaticDiscovery answer: " + new String(this.ipAddress)));
                }
                this.socket.send(p);
                if (trace) {
                    this.log.trace((Object)"AutomaticDiscovery answer sent.");
                }
            }
            catch (IOException ex) {
                this.log.error((Object)"Error writing response", (Throwable)ex);
            }
        }

        protected void listen() {
            Thread t = new Thread((Runnable)this, "HAJNDI-AutomaticDiscovery");
            t.start();
        }
    }
}

