/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.singleton;

import java.util.List;
import org.jboss.ha.jmx.HAServiceMBeanSupport;
import org.jboss.ha.singleton.HASingleton;
import org.jboss.ha.singleton.HASingletonMBean;

public class HASingletonSupport
extends HAServiceMBeanSupport
implements HASingletonMBean,
HASingleton {
    private boolean isMasterNode = false;

    public boolean isMasterNode() {
        return this.isMasterNode;
    }

    public void startSingleton() {
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            this.log.debug((Object)"startSingleton() : elected for master singleton node");
        }
    }

    public void stopSingleton() {
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            this.log.debug((Object)"stopSingleton() : another node in the partition (if any) is elected for master ");
        }
    }

    public void partitionTopologyChanged(List newReplicants, int newViewID) {
        boolean debug = this.log.isDebugEnabled();
        boolean isElectedNewMaster = this.isDRMMasterReplica();
        if (debug) {
            this.log.debug((Object)("partitionTopologyChanged, isElectedNewMaster=" + isElectedNewMaster + ", isMasterNode=" + this.isMasterNode + ", viewID=" + newViewID));
        }
        if (isElectedNewMaster && this.isMasterNode) {
            return;
        }
        if (isElectedNewMaster && !this.isMasterNode) {
            this.makeThisNodeMaster();
        } else if (this.isMasterNode) {
            this._stopOldMaster();
        }
    }

    protected void makeThisNodeMaster() {
        try {
            this.callMethodOnPartition("_stopOldMaster", new Object[0]);
            this.isMasterNode = true;
            this.startSingleton();
        }
        catch (Exception ex) {
            this.log.error((Object)"_stopOldMaster failed. New master singleton will not start.", (Throwable)ex);
        }
    }

    public void _stopOldMaster() {
        this.log.debug((Object)("_stopOldMaster, isMasterNode=" + this.isMasterNode));
        if (this.isMasterNode) {
            this.isMasterNode = false;
            this.stopSingleton();
        }
    }
}

