/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.pooled.server;

import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.ha.framework.interfaces.GenericClusteringException;
import org.jboss.ha.framework.interfaces.HARMIResponse;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.InvokerHA;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.invocation.jrmp.interfaces.JRMPInvokerProxyHA;
import org.jboss.invocation.pooled.interfaces.PooledInvokerProxy;
import org.jboss.invocation.pooled.interfaces.ServerAddress;
import org.jboss.invocation.pooled.server.PooledInvoker;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.system.Registry;
import org.jboss.util.UnreachableStatementException;

public final class PooledInvokerHA
extends PooledInvoker
implements InvokerHA {
    protected HashMap beanMap = new HashMap();

    protected void jmxBind() {
        Registry.bind((Object)this.getServiceName(), (Object)this);
    }

    public Serializable getStub() {
        ServerAddress sa = new ServerAddress(this.clientConnectAddress, this.clientConnectPort, this.enableTcpNoDelay, this.timeout);
        return new PooledInvokerProxy(sa, this.clientMaxPoolSize);
    }

    public void registerBean(ObjectName beanName, HATarget target) throws Exception {
        Integer hash = new Integer(beanName.hashCode());
        PooledInvoker.log.debug((Object)("registerBean: " + beanName));
        if (this.beanMap.containsKey(hash)) {
            throw new IllegalStateException("Trying to register bean with the existing hashCode");
        }
        this.beanMap.put(hash, target);
    }

    public Invoker createProxy(ObjectName beanName, LoadBalancePolicy policy, String proxyFamilyName) throws Exception {
        Integer hash = new Integer(beanName.hashCode());
        HATarget target = (HATarget)this.beanMap.get(hash);
        if (target == null) {
            throw new IllegalStateException("The bean hashCode not found");
        }
        String familyName = proxyFamilyName;
        if (familyName == null) {
            familyName = target.getAssociatedPartition().getPartitionName() + "/" + beanName;
        }
        JRMPInvokerProxyHA proxy = new JRMPInvokerProxyHA(target.getReplicants(), policy, familyName, target.getCurrentViewId());
        return proxy;
    }

    public void unregisterBean(ObjectName beanName) throws Exception {
        Integer hash = new Integer(beanName.hashCode());
        this.beanMap.remove(hash);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Invocation invocation) throws Exception {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            try {
                invocation.setTransaction(this.importTPC(((MarshalledInvocation)invocation).getTransactionPropagationContext()));
                ObjectName mbean = (ObjectName)Registry.lookup((Object)invocation.getObjectName());
                long clientViewId = (Long)invocation.getValue((Object)"CLUSTER_VIEW_ID");
                HATarget target = (HATarget)this.beanMap.get(invocation.getObjectName());
                if (target == null) {
                    throw new GenericClusteringException(1, "target is not/no more registered on this node");
                }
                if (!target.invocationsAllowed()) {
                    throw new GenericClusteringException(1, "invocations are currently not allowed on this target");
                }
                Object rtn = this.getServer().invoke(mbean, "invoke", new Object[]{invocation}, Invocation.INVOKE_SIGNATURE);
                HARMIResponse rsp = new HARMIResponse();
                if (clientViewId != target.getCurrentViewId()) {
                    rsp.newReplicants = new ArrayList(target.getReplicants());
                    rsp.currentViewId = target.getCurrentViewId();
                }
                rsp.response = rtn;
                MarshalledObject<HARMIResponse> marshalledObject = new MarshalledObject<HARMIResponse>(rsp);
                Object var11_11 = null;
                Thread.currentThread().setContextClassLoader(oldCl);
                return marshalledObject;
            }
            catch (InstanceNotFoundException e) {
                throw new GenericClusteringException(1, e);
            }
            catch (ReflectionException e) {
                throw new GenericClusteringException(1, e);
            }
            catch (Exception e) {
                JMXExceptionDecoder.rethrow((Exception)e);
                throw new UnreachableStatementException();
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            Thread.currentThread().setContextClassLoader(oldCl);
            throw throwable;
        }
    }
}

