/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.ha.framework.interfaces.ClusteringTargetsRepository;
import org.jboss.ha.framework.interfaces.FamilyClusterInfo;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationContext;
import org.jboss.invocation.PayloadKey;
import org.jboss.invocation.ServiceUnavailableException;
import org.jboss.invocation.jrmp.interfaces.JRMPInvokerProxyHA;
import org.jboss.proxy.Interceptor;

public class ServiceUnavailableClientInterceptor
extends Interceptor {
    private static final long serialVersionUID = 8830272856328720750L;
    private String proxyFamilyName;

    public Object invoke(Invocation mi) throws Throwable {
        Object data = mi.getValue((Object)"DO_FAIL_DURING_NEXT_CALL");
        if (data != null && data instanceof Boolean && data.equals(Boolean.TRUE)) {
            mi.setValue((Object)"DO_FAIL_DURING_NEXT_CALL", (Object)Boolean.FALSE, PayloadKey.AS_IS);
            if (this.proxyFamilyName == null) {
                this.proxyFamilyName = ServiceUnavailableClientInterceptor.getProxyFamilyName(mi);
            }
            FamilyClusterInfo info = ClusteringTargetsRepository.getFamilyClusterInfo(this.proxyFamilyName);
            ArrayList targets = info.getTargets();
            Iterator it = targets.iterator();
            while (it.hasNext()) {
                info.removeDeadTarget(it.next());
            }
            throw new ServiceUnavailableException("Service unavailable", (Throwable)new Exception("Test"));
        }
        return this.getNext().invoke(mi);
    }

    static String getProxyFamilyName(Invocation invocation) throws Exception {
        InvocationContext ctx = invocation.invocationContext;
        JRMPInvokerProxyHA invoker = (JRMPInvokerProxyHA)ctx.getInvoker();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        invoker.writeExternal(oos);
        oos.close();
        byte[] bytes = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object targets = ois.readObject();
        Object loadBalancePolicy = ois.readObject();
        String proxyFamilyName = (String)ois.readObject();
        ois.close();
        return proxyFamilyName;
    }
}

