/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Serializable;
import java.util.Properties;
import javax.jms.JMSException;
import org.jboss.logging.Logger;
import org.jboss.mq.Connection;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.il.ClientILService;
import org.jboss.mq.il.ServerIL;
import org.jboss.mq.il.ServerILFactory;

public class GenericConnectionFactory
implements Serializable {
    static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$GenericConnectionFactory == null ? (class$org$jboss$mq$GenericConnectionFactory = GenericConnectionFactory.class$("org.jboss.mq.GenericConnectionFactory")) : class$org$jboss$mq$GenericConnectionFactory));
    private ServerIL server;
    private Properties connectionProperties;
    static /* synthetic */ Class class$org$jboss$mq$GenericConnectionFactory;

    public GenericConnectionFactory(ServerIL server, Properties props) {
        this.server = server;
        this.connectionProperties = props;
    }

    public ClientILService createClientILService(Connection connection) throws Exception {
        String pingPeriod = this.connectionProperties.getProperty("PingPeriod", "" + connection.pingPeriod);
        connection.pingPeriod = Long.parseLong(pingPeriod);
        String clientILServiceCN = this.connectionProperties.getProperty("ClientILService");
        ClientILService service = (ClientILService)Class.forName(clientILServiceCN).newInstance();
        service.init(connection, this.connectionProperties);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Handing out ClientIL: " + clientILServiceCN));
        }
        return service;
    }

    public ServerIL createServerIL() throws JMSException {
        try {
            if (this.server == null) {
                String className = this.connectionProperties.getProperty("ServerILFactory");
                ServerILFactory factory = (ServerILFactory)Class.forName(className).newInstance();
                factory.init(this.connectionProperties);
                this.server = factory.getServerIL();
            }
            return this.server.cloneServerIL();
        }
        catch (Exception e) {
            log.error((Object)"Could not connect to the server", (Throwable)e);
            throw new SpyJMSException("Could not connect to the server", e);
        }
    }

    public String toString() {
        return "GenericConnectionFactory:[server=" + this.server + ",connectionProperties=" + this.connectionProperties + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

