/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.util.ArrayList;
import javax.jms.JMSException;
import org.jboss.mq.SpyBytesMessage;
import org.jboss.mq.SpyEncapsulatedMessage;
import org.jboss.mq.SpyMapMessage;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyObjectMessage;
import org.jboss.mq.SpyStreamMessage;
import org.jboss.mq.SpyTextMessage;

public class MessagePool {
    public static final boolean POOL = true;
    public static final int MAX_POOL_SIZE = 10000;
    protected static ArrayList messagePool = new ArrayList();
    protected static ArrayList bytesPool = new ArrayList();
    protected static ArrayList mapPool = new ArrayList();
    protected static ArrayList streamPool = new ArrayList();
    protected static ArrayList objectPool = new ArrayList();
    protected static ArrayList textPool = new ArrayList();
    protected static ArrayList encapPool = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpyMessage getMessage() {
        ArrayList arrayList = messagePool;
        synchronized (arrayList) {
            if (!messagePool.isEmpty()) {
                return (SpyMessage)messagePool.remove(messagePool.size() - 1);
            }
        }
        return new SpyMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpyBytesMessage getBytesMessage() {
        ArrayList arrayList = bytesPool;
        synchronized (arrayList) {
            if (!bytesPool.isEmpty()) {
                return (SpyBytesMessage)bytesPool.remove(bytesPool.size() - 1);
            }
        }
        return new SpyBytesMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpyMapMessage getMapMessage() {
        ArrayList arrayList = mapPool;
        synchronized (arrayList) {
            if (!mapPool.isEmpty()) {
                return (SpyMapMessage)mapPool.remove(mapPool.size() - 1);
            }
        }
        return new SpyMapMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpyStreamMessage getStreamMessage() {
        ArrayList arrayList = streamPool;
        synchronized (arrayList) {
            if (!streamPool.isEmpty()) {
                return (SpyStreamMessage)streamPool.remove(streamPool.size() - 1);
            }
        }
        return new SpyStreamMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpyObjectMessage getObjectMessage() {
        ArrayList arrayList = objectPool;
        synchronized (arrayList) {
            if (!objectPool.isEmpty()) {
                return (SpyObjectMessage)objectPool.remove(objectPool.size() - 1);
            }
        }
        return new SpyObjectMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpyTextMessage getTextMessage() {
        ArrayList arrayList = textPool;
        synchronized (arrayList) {
            if (!textPool.isEmpty()) {
                return (SpyTextMessage)textPool.remove(textPool.size() - 1);
            }
        }
        return new SpyTextMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpyEncapsulatedMessage getEncapsulatedMessage() {
        ArrayList arrayList = encapPool;
        synchronized (arrayList) {
            if (!encapPool.isEmpty()) {
                return (SpyEncapsulatedMessage)encapPool.remove(encapPool.size() - 1);
            }
        }
        return new SpyEncapsulatedMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseMessage(SpyMessage message) {
        if (message == null) {
            return;
        }
        try {
            message.clearMessage();
        }
        catch (JMSException e) {
            return;
        }
        if (message instanceof SpyTextMessage) {
            ArrayList arrayList = textPool;
            synchronized (arrayList) {
                if (textPool.size() < 10000) {
                    textPool.add(message);
                }
            }
        }
        if (message instanceof SpyEncapsulatedMessage) {
            ArrayList arrayList = encapPool;
            synchronized (arrayList) {
                if (encapPool.size() < 10000) {
                    encapPool.add(message);
                }
            }
        }
        if (message instanceof SpyObjectMessage) {
            ArrayList arrayList = objectPool;
            synchronized (arrayList) {
                if (objectPool.size() < 10000) {
                    objectPool.add(message);
                }
            }
        }
        if (message instanceof SpyBytesMessage) {
            ArrayList arrayList = bytesPool;
            synchronized (arrayList) {
                if (bytesPool.size() < 10000) {
                    bytesPool.add(message);
                }
            }
        }
        if (message instanceof SpyMapMessage) {
            ArrayList arrayList = mapPool;
            synchronized (arrayList) {
                if (mapPool.size() < 10000) {
                    mapPool.add(message);
                }
            }
        }
        if (message instanceof SpyStreamMessage) {
            ArrayList arrayList = streamPool;
            synchronized (arrayList) {
                if (streamPool.size() < 10000) {
                    streamPool.add(message);
                }
            }
        }
        ArrayList arrayList = messagePool;
        synchronized (arrayList) {
            if (messagePool.size() < 10000) {
                messagePool.add(message);
            }
        }
    }
}

